/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.IBasedataField;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class BaseDataUtils {
    private static Log log = LogFactory.getLog(BaseDataUtils.class);

    public static List<Long> getParamUseOrgId(IDataModel model, IBasedataField basedataField) {
        ArrayList<Long> useOrgIds = new ArrayList<Long>(10);
        long orgId = 0L;
        try (EntityTraceSpan span = EntityTracer.create((String)"BasedataUserOrgUtil", (String)"getParamUseOrgId");){
            span.addLocaleTag("orgProp", (Object)basedataField.getOrgProp());
            if (StringUtils.isNotEmpty((CharSequence)basedataField.getOrgProp())) {
                Object value = model.getValue(basedataField.getOrgProp() + "_id");
                if (value != null) {
                    orgId = (Long)value;
                }
            } else {
                Object value;
                String dataDimensionField;
                String dimension;
                String mainOrg = model.getDataEntityType().getMainOrg();
                orgId = StringUtils.isNotBlank((CharSequence)mainOrg) ? BaseDataUtils.getMainOrgId(model, mainOrg) : 0L;
                MainEntityType dataEntityType = model.getDataEntityType();
                PermissionControlType pct = dataEntityType.getPermissionControlType();
                if (pct != null && !"DIM_NULL".equals(dimension = pct.getDimension()) && !"DIM_ORG".equals(dimension) && StringUtils.isNotBlank((CharSequence)(dataDimensionField = pct.getDataDimensionField())) && (value = model.getValue(dataDimensionField + "_id")) != null) {
                    orgId = (Long)value;
                }
            }
            span.addLocaleTag("orgId", (Object)orgId);
        }
        catch (Exception e) {
            log.error("getParamUseOrgId", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(useOrgIds) || !useOrgIds.contains(orgId)) {
            useOrgIds.add(orgId);
        }
        return useOrgIds;
    }

    private static long getMainOrgId(IDataModel model, String mainOrg) {
        long orgId = 0L;
        DynamicObject dataEntity = model.getDataEntity();
        Object orgObj = dataEntity.get(mainOrg);
        if (orgObj == null) {
            return orgId;
        }
        if (orgObj instanceof DynamicObject) {
            orgId = Long.parseLong(String.valueOf(((DynamicObject)orgObj).getPkValue()));
        } else if (orgObj instanceof Long) {
            orgId = (Long)orgObj;
        }
        return orgId;
    }
}

