/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.BaseDataColumnDesc;
import kd.bos.entity.list.column.BaseDataRefColumnDesc;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class BillTypeProp
extends BasedataProp {
    private static final long serialVersionUID = 1555602902115059869L;

    @Override
    public AbstractColumnDesc getListColumnDesc(ListField col) {
        BaseDataColumnDesc desc;
        String[] keys = col.getKey().split("\\.");
        BasedataProp basedataProp = (BasedataProp)col.getFieldProp();
        if (keys.length == 1) {
            IDataEntityProperty prop = (IDataEntityProperty)basedataProp.getComplexType().getProperties().get((Object)"id");
            ListField listField = new ListField(col);
            listField.setKey(prop.getName());
            listField.setFieldProp(prop);
            AbstractColumnDesc columnDesc = ((FieldProp)prop).getListColumnDesc(listField);
            desc = new BaseDataColumnDesc(col.getKey(), (IDataEntityProperty)this, col.getFieldProp(), columnDesc);
        } else if (keys.length == 2) {
            IDataEntityProperty prop = (IDataEntityProperty)basedataProp.getComplexType().getProperties().get((Object)keys[1]);
            if (prop == null) {
                throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{basedataProp.getComplexType().getName(), keys[1]});
            }
            ListField listField = new ListField(col);
            listField.setKey(prop.getName());
            listField.setFieldProp(prop);
            AbstractColumnDesc columnDesc = ((FieldProp)prop).getListColumnDesc(listField);
            desc = new BaseDataColumnDesc(col.getKey(), (IDataEntityProperty)this, col.getFieldProp(), columnDesc);
        } else {
            IDataEntityProperty prop = (IDataEntityProperty)basedataProp.getComplexType().getProperties().get((Object)keys[1]);
            IDataEntityProperty refProp = (IDataEntityProperty)((BasedataProp)prop).getComplexType().getProperties().get((Object)keys[2]);
            if (refProp == null) {
                throw new KDException(BosErrorCode.fieldNotExist, new Object[]{((BasedataProp)prop).getComplexType().getName(), keys[2]});
            }
            ListField listField = new ListField(col);
            listField.setKey(refProp.getName());
            listField.setFieldProp(refProp);
            AbstractColumnDesc columnDesc = ((FieldProp)refProp).getListColumnDesc(listField);
            desc = new BaseDataRefColumnDesc(col.getKey(), (IDataEntityProperty)this, col.getFieldProp(), prop, columnDesc);
        }
        return desc;
    }

    @Override
    public void applyDefaultValue(IDataModel model, DynamicObject dataEntity, int rowIndex) {
        String configBillTypeId = model.getContextVariable("DEFAULT_BILLTYPE_ID") + "";
        if (StringUtils.isNotBlank((CharSequence)configBillTypeId) && StringUtils.isNumeric((CharSequence)configBillTypeId)) {
            Long billTypeId = Long.parseLong(configBillTypeId);
            if (this.queryBillTypeEnable(billTypeId)) {
                this.setFieldValue(model, dataEntity, billTypeId);
            }
        } else {
            String billformId = model.getDataEntityType().getName();
            Long defaultBillTypeId = this.queryDefaultBillType(billformId);
            if (defaultBillTypeId != null) {
                this.setFieldValue(model, dataEntity, defaultBillTypeId);
            }
        }
    }

    public boolean queryBillTypeEnable(Long billTypeId) {
        QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C"), new QFilter("id", "=", (Object)billTypeId)};
        DynamicObject billTypeObj = ORM.create().queryOne("bos_billtype", "id", filters);
        return billTypeObj != null;
    }

    public Long queryDefaultBillType(String billformId) {
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)billformId), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C"), new QFilter("isdefault", "=", (Object)Boolean.TRUE)};
        DynamicObject billTypeObj = ORM.create().queryOne("bos_billtype", "id", filters);
        if (billTypeObj != null) {
            return (Long)billTypeObj.getPkValue();
        }
        return null;
    }

    @Override
    public void setFieldValue(IDataModel model, Object dataEntity, Object value) {
        if (value == null) {
            this.setValueFast(dataEntity, null);
        } else {
            super.setFieldValue(model, dataEntity, value);
        }
    }

    @Override
    public List<QFilter> getF7InnerFilters(String formId, String entityId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (entityId != null) {
            formId = entityId;
        }
        qFilters.add(new QFilter("billformid", "=", (Object)formId));
        return qFilters;
    }
}

