/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ComboPropShowStyle;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.ComboColumnDesc;
import kd.bos.entity.property.EntityTreeNode;
import kd.bos.entity.property.FieldProp;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class ComboProp
extends FieldProp {
    private static final long serialVersionUID = -7314462680658131362L;
    private int showStyle;
    private boolean editable;
    private boolean comboValueCheck;
    private List<ValueMapItem> comboItems = new ArrayList<ValueMapItem>();
    private String optionDisplayMode;
    private Map<String, ValueMapItem> valueMapItems = new HashMap<String, ValueMapItem>();

    public ComboProp() {
        this.filterControlType = "enum";
        this.compareGroupID = "10,11";
        this.defaultCompareTypeId = "105";
        this.defaultMultiCompareTypeId = "17";
    }

    @Override
    public int getDbType() {
        return 12;
    }

    public Class<?> getPropertyType() {
        return String.class;
    }

    @KSMethod
    @SimplePropertyAttribute
    public int getShowStyle() {
        return this.showStyle;
    }

    public void setShowStyle(int showStyle) {
        this.showStyle = showStyle;
    }

    @SimplePropertyAttribute(name="Editable")
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @SimplePropertyAttribute(name="ComboValueCheck")
    public boolean isComboValueCheck() {
        return this.comboValueCheck;
    }

    public void setComboValueCheck(boolean comboValueCheck) {
        this.comboValueCheck = comboValueCheck;
    }

    @KSMethod
    @CollectionPropertyAttribute(name="ComboItems", collectionItemPropertyType=ValueMapItem.class)
    public List<ValueMapItem> getComboItems() {
        return this.comboItems;
    }

    public void setComboItems(List<ValueMapItem> comboItems) {
        this.comboItems = comboItems;
    }

    @SimplePropertyAttribute(name="OptionDisplayMode")
    public String getOptionDisplayMode() {
        return this.optionDisplayMode;
    }

    public void setOptionDisplayMode(String optionDisplayMode) {
        this.optionDisplayMode = optionDisplayMode;
    }

    @KSMethod
    public boolean isEmptyItems() {
        return this.getComboItems().isEmpty();
    }

    @KSMethod
    public boolean isExistItem(String name) {
        for (ValueMapItem item : this.getComboItems()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)item.getValue())) continue;
            return true;
        }
        return false;
    }

    @SdkInternal
    protected ValueMapItem getValueMapItemByName(String name) {
        if (this.valueMapItems.isEmpty() && !this.comboItems.isEmpty()) {
            for (ValueMapItem valueMapItem : this.comboItems) {
                this.valueMapItems.put(valueMapItem.getValue(), valueMapItem);
            }
        }
        return this.valueMapItems.get(name);
    }

    @KSMethod
    public Object getItemByNameAndShowStyle(String name, int showStyleId) {
        ValueMapItem valueMapItem = this.getValueMapItemByName(name);
        if (valueMapItem == null) {
            return "";
        }
        if (showStyleId == ComboPropShowStyle.Img.getValue()) {
            return valueMapItem.getImageKey();
        }
        return valueMapItem.getName().toString();
    }

    @KSMethod
    public String getItemByName(String name) {
        ValueMapItem valueMapItem = this.getValueMapItemByName(name);
        if (valueMapItem == null) {
            return "";
        }
        return valueMapItem.getName().toString();
    }

    @Override
    public AbstractColumnDesc getListColumnDesc(ListField col) {
        ComboColumnDesc cb = new ComboColumnDesc(col.getKey(), this, col.getFieldProp());
        cb.setShowStyle(col.getShowStyle());
        return cb;
    }

    @Override
    public Map<String, Object> createEntityTreeNode(EntityTreeNode parentEntityTreeNode) {
        Map<String, Object> col = super.createEntityTreeNode(parentEntityTreeNode);
        col.put("CommonFilterApType", "CommonFilterColumnAp");
        col.put("SchemeFilterApType", "SchemeComboFilterColumnAp");
        col.put("MobCommonFilterApType", "MobCommonFilterColumnAp");
        col.put("Type", "ComboListColumnAp");
        col.put("IsMulti", true);
        col.put("Custom", false);
        return col;
    }

    @Override
    public Object getBasePropDisplayValue(Object basedataObj) {
        return this.getItemByName(String.valueOf(this.getValueFast(basedataObj)));
    }

    @Override
    public String getClientType() {
        String clientType = "combo";
        if (StringUtils.equals((CharSequence)"flat", (CharSequence)this.getOptionDisplayMode())) {
            clientType = "radiooptgroup";
        }
        return clientType;
    }

    public long getEstimatedLen() {
        return 4L;
    }
}

