/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataTypeEnum;

public class EntityTreeNode {
    private String key;
    private String name;
    private String parentKey;
    private String parentName;
    private boolean isEntry_i;
    private boolean isBaseData_i;
    private int level = 3;
    private boolean isFieldPropAliasEmpty_i;
    private String baseEntityId;
    BasedataTypeEnum basedataTypeEnum = BasedataTypeEnum.None;

    public EntityTreeNode() {
    }

    public EntityTreeNode(String key, String name) {
        this.key = key;
        this.name = name;
    }

    public EntityTreeNode(String key, String name, boolean isEntry) {
        this.key = key;
        this.name = name;
        this.isEntry_i = isEntry;
    }

    public EntityTreeNode(String key, String name, boolean isEntry, boolean isBaseData, BasedataTypeEnum basedataTypeEnum, int level, String baseEntityId) {
        this.key = key;
        this.name = name;
        this.isEntry_i = isEntry;
        this.isBaseData_i = isBaseData;
        this.basedataTypeEnum = basedataTypeEnum;
        this.level = level;
        this.baseEntityId = baseEntityId;
    }

    public EntityTreeNode(String key, String name, String parentKey, String parentName) {
        this.key = key;
        this.name = name;
        this.parentKey = parentKey;
        this.parentName = parentName;
    }

    public EntityTreeNode(String key, String name, String parentKey, String parentName, boolean isEntry, boolean isBaseData, BasedataTypeEnum basedataTypeEnum, String baseEntityId) {
        this.key = key;
        this.name = name;
        this.parentKey = parentKey;
        this.parentName = parentName;
        this.isEntry_i = isEntry;
        this.isBaseData_i = isBaseData;
        this.basedataTypeEnum = basedataTypeEnum;
        this.baseEntityId = baseEntityId;
    }

    public boolean isBaseData() {
        return this.isBaseData_i;
    }

    @SimplePropertyAttribute
    public String getBaseEntityId() {
        return this.baseEntityId;
    }

    public int getLevel() {
        return this.level;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getParentKey() {
        return this.parentKey;
    }

    public String getParentName() {
        return this.parentName;
    }

    public boolean isEntry() {
        return this.isEntry_i;
    }

    public BasedataTypeEnum getBasedataTypeEnum() {
        return this.basedataTypeEnum;
    }

    private String getName(String preName, String name) {
        if (StringUtils.isBlank((CharSequence)preName)) {
            return name;
        }
        return StringUtils.isNotBlank((CharSequence)name) ? String.format("%s.%s", preName, name) : preName;
    }

    public String getTreeNodeKey() {
        return this.getName(this.parentKey, this.key);
    }

    public String getTreeNodeName() {
        return this.getName(this.parentName, this.name);
    }

    public boolean isFieldPropAliasEmpty() {
        return this.isFieldPropAliasEmpty_i;
    }

    public void setFieldPropAliasEmpty(boolean isFieldPropAliasEmpty) {
        this.isFieldPropAliasEmpty_i = isFieldPropAliasEmpty;
    }
}

