/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRegisterFlexPropertyListener;
import kd.bos.entity.datamodel.IRegisterPropertyListener;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.events.RegisterFlexPropertyArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.flex.CreateFlexMetaArgs;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.flex.FlexType;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.FlexColumnDesc;
import kd.bos.entity.nameversion.NameVersionService;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreateExtendFilterFieldsResult;
import kd.bos.entity.property.EntityTreeNode;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexPropRegisterPropertyListener;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.qing.AnalysisField;
import kd.bos.entity.qing.FlexAnalysisField;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ksql.exception.NotSupportedException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class FlexProp
extends BasedataProp {
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private static final String VALUE = "value";
    private static final String F_VALUE = "fvalue";
    private static final String NUMBER = "number";
    private static final String LONG_NUMBER = "longNumber";
    private static final String FULL_NAME = "fullName";
    private static final String NUMBER_AND_FULLNAME = "number,fullName";
    private static final String FORMAT = "%s:%s";
    private static final String NAME = "name";
    private static Log log = LogFactory.getLog(FlexProp.class);
    private static final long serialVersionUID = -7398694949706492532L;
    public static final String BASEVALUETYPE = "1";
    public static final String ASSISTANTVALUETYPE = "2";
    public static final String TEXTVALUETYPE = "3";
    private int flexTypeId;
    private String basePropertyKey;
    private List<IDataEntityProperty> flexProps = new ArrayList<IDataEntityProperty>();

    public FlexProp() {
        this.compareGroupID = "0,1,2,3";
        this.defaultCompareTypeId = "0";
        this.defaultMultiCompareTypeId = "0";
    }

    @Override
    public String getCompareGroupID() {
        return this.compareGroupID;
    }

    @Override
    public void setCompareGroupID(String compareGroupID) {
        this.compareGroupID = compareGroupID;
    }

    @Override
    public String getDefaultCompareTypeId() {
        return this.defaultCompareTypeId;
    }

    @Override
    public void setDefaultCompareTypeId(String defaultCompareTypeId) {
        this.defaultCompareTypeId = defaultCompareTypeId;
    }

    @Override
    public String getDefaultMultiCompareTypeId() {
        return this.defaultMultiCompareTypeId;
    }

    @Override
    public void setDefaultMultiCompareTypeId(String defaultMultiCompareTypeId) {
        this.defaultMultiCompareTypeId = defaultMultiCompareTypeId;
    }

    @KSMethod
    @SimplePropertyAttribute
    public int getFlexTypeId() {
        return this.flexTypeId;
    }

    public void setFlexTypeId(int flexType) {
        this.flexTypeId = flexType;
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getBasePropertyKey() {
        return this.basePropertyKey;
    }

    public void setBasePropertyKey(String basePropertyKey) {
        this.basePropertyKey = basePropertyKey;
    }

    @Override
    public Class<?> getPropertyType() {
        return ((DynamicObjectType)this.getComplexType()).getClrType();
    }

    @Override
    public IDataEntityType getComplexType() {
        return super.getComplexType();
    }

    @Override
    public void setFieldValue(IDataModel model, Object dataEntity, Object value) {
        DynamicObjectType dt = this.getFlexDataType();
        if (value != null) {
            DynamicObject dynamicObject = null;
            if (!(value instanceof DynamicObject)) {
                if (value instanceof String && StringUtils.isBlank((CharSequence)((String)value)) && dt.getPrimaryKey() instanceof LongProp) {
                    value = 0L;
                }
                Map mapObjects = model.loadReferenceDataBatch(dt, new Object[]{value});
                dynamicObject = (DynamicObject)mapObjects.get(value);
            } else {
                dynamicObject = (DynamicObject)value;
            }
            if (dynamicObject != null) {
                this.getRefIdProp().setValueFast(dataEntity, dynamicObject.getPkValue());
            }
            this.setValueFast(dataEntity, dynamicObject);
        } else {
            this.setValueFast(dataEntity, null);
            if (dt.getPrimaryKey().getPropertyType().equals(String.class)) {
                this.getRefIdProp().setValueFast(dataEntity, (Object)"");
            } else {
                this.getRefIdProp().setValueFast(dataEntity, (Object)0);
            }
        }
    }

    @Override
    public void setFieldValueForWebApi(IDataModel model, Object dataEntity, Object value, boolean checkImportable) {
        if (checkImportable && !this.isImportable()) {
            LocaleString dispName = this.getDisplayName();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5141\u8bb8\u5bfc\u5165", (String)"FlexProp_6", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), StringUtils.isNotBlank((Object)dispName) ? dispName.toString() : this.getName()));
        }
        if (value == null) {
            this.setFieldValue(model, dataEntity, null);
        } else if (value instanceof Map) {
            Map objValue = (Map)value;
            Object id = objValue.get("id");
            if (id != null) {
                this.setFieldValue(model, dataEntity, id);
            } else {
                String number = (String)objValue.get(this.getNumberProp());
                DynamicObject dataObject = (DynamicObject)dataEntity;
                model.setItemValueByNumber((IDataEntityProperty)this, dataObject, number);
                if (StringUtils.isNotBlank((CharSequence)number) && model.getValue(this.getName()) == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8981\u8bbe\u7f6e\u7684%1$s\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u88ab\u5220\u9664\uff1a%2$s", (String)"FlexProp_7", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.getName(), number));
                }
            }
        }
    }

    @Override
    public AbstractColumnDesc getListColumnDesc(ListField col) {
        return new FlexColumnDesc(col.getKey(), (IDataEntityProperty)this, col.getFieldProp(), col.getControlField().getFieldName());
    }

    public DynamicObjectType getFlexDataType() {
        FlexType flexType = FlexEntityMetaUtils.getFlexType(this.flexTypeId);
        RefEntityType dt = new RefEntityType();
        LongProp pkProperty = new LongProp();
        pkProperty.setName("id");
        pkProperty.setDbType(4);
        pkProperty.setAlias("fid");
        pkProperty.setPrimaryKey(true);
        dt.addProperty((DynamicProperty)pkProperty);
        TextProp property = new TextProp();
        property.setName(VALUE);
        property.setAlias(F_VALUE);
        property.setDbType(-9);
        dt.addProperty((DynamicProperty)property);
        dt.setAlias(flexType.getFlexDataTable());
        BasedataEntityType flexEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType(flexType.getFormNumber());
        if (flexEntityType == null || !StringUtils.isNotEmpty((CharSequence)flexEntityType.getDBRouteKey())) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u7c7b\u578b%1$s\u5b9a\u4e49\u7684\u8868\u5355%2$s\u7684DBRouteKey\u4e3a\u7a7a\u3002", (String)"FlexProp_8", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.flexTypeId, flexType.getFormNumber())});
        }
        String dbRouteKey = flexEntityType.getDBRouteKey();
        dt.setDBRouteKey(dbRouteKey);
        dt.setName(flexType.getNumber());
        return dt;
    }

    public DynamicObject getFlexDataDynamicObject(IDataModel model, Object pk) {
        DynamicObjectType dt = this.getFlexDataType();
        DynamicObject dynamicObject = null;
        Map mapObjects = model.loadReferenceDataBatch(dt, new Object[]{pk});
        dynamicObject = (DynamicObject)mapObjects.get(pk.toString());
        return dynamicObject;
    }

    @Override
    public boolean isSysField() {
        return false;
    }

    public List<IDataEntityProperty> getFlexProps() {
        return this.flexProps;
    }

    public void setFlexProps(List<IDataEntityProperty> flexProps) {
        this.flexProps = flexProps;
    }

    @Override
    public List<FilterField> createFilterFields(MainEntityType mainType) {
        ArrayList<FilterField> filterFields = new ArrayList<FilterField>();
        FilterField filterField = this.createFilterField(mainType, this.getName());
        filterFields.add(filterField);
        return filterFields;
    }

    public CreateExtendFilterFieldsResult createExtendFilterFields(MainEntityType mainType) {
        ArrayList<FilterField> filterFields = new ArrayList<FilterField>(10);
        List<IRegisterPropertyListener> registerPropertyListeners = this.extendFlexProperties(mainType.getName(), registerFlexPropertyArgs -> {
            if (registerFlexPropertyArgs.getBaseProp() != null) {
                BasedataEntityType type = (BasedataEntityType)registerFlexPropertyArgs.getBaseProp().getComplexType();
                String name = String.format("%s.%s.%s", registerFlexPropertyArgs.getDimensionProp().getName(), registerFlexPropertyArgs.getBaseProp(), type.getPrimaryKey().getName());
                FilterField filterField = FilterField.create(registerFlexPropertyArgs.getEntityType(), name);
                filterField.setCaption(registerFlexPropertyArgs.getDimensionProp().getDisplayName());
                filterFields.add(filterField);
            } else {
                String name = String.format("%s.%s", registerFlexPropertyArgs.getDimensionProp().getName(), VALUE);
                FilterField filterField = FilterField.create(registerFlexPropertyArgs.getEntityType(), name);
                filterField.setCaption(registerFlexPropertyArgs.getDimensionProp().getDisplayName());
                filterFields.add(filterField);
            }
        });
        return new CreateExtendFilterFieldsResult(filterFields, registerPropertyListeners);
    }

    @Override
    public FilterField createFilterField(MainEntityType mainType, String propName) {
        return new FilterField(mainType, (IDataEntityProperty)this, null, null, null);
    }

    @Override
    public List<AnalysisField> createAnalysisFields(MainEntityType mainType) {
        ArrayList<AnalysisField> analysisFields = new ArrayList<AnalysisField>();
        AnalysisField analysisField = this.createAnalysisField(mainType, this.getName());
        if (analysisField != null) {
            analysisFields.add(analysisField);
        }
        return analysisFields;
    }

    @Override
    public AnalysisField createAnalysisField(MainEntityType mainType, String propName) {
        DynamicObjectType dt = this.getFlexDataType();
        return new FlexAnalysisField(mainType, (IDataEntityProperty)this, dt, this.getFlexTypeId());
    }

    @Override
    public int getDbType() {
        return ((DynamicSimpleProperty)this.getRefIdProp()).getDbType();
    }

    @Override
    public String getFilterControlType() {
        return "text";
    }

    @Override
    public List<Map<String, Object>> createEntityTreeNodes(EntityTreeNode entityTreeNode, boolean isAllNode) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        cols.add(this.createEntityTreeNode(entityTreeNode));
        return cols;
    }

    public Map<String, Object> createEntityTreeNode(EntityTreeNode entityTreeNode) {
        HashMap<String, Object> nodeItem = new HashMap<String, Object>();
        nodeItem.put("Id", entityTreeNode.getTreeNodeKey());
        nodeItem.put("Type", "FlexListColumnAp");
        nodeItem.put("Name", entityTreeNode.getTreeNodeName());
        nodeItem.put("CreateType", 1);
        nodeItem.put("compareGroupId", this.getCompareGroupID());
        nodeItem.put("IsMulti", false);
        nodeItem.put("Custom", false);
        nodeItem.put("SeqType", "NotSeq");
        nodeItem.put("EntryEntity", entityTreeNode.isEntry());
        nodeItem.put("IsBaseData", entityTreeNode.isBaseData());
        nodeItem.put("DataType", this.getFilterControlType());
        nodeItem.put("ClientType", this.getClientType());
        nodeItem.put("FilterApType", "FilterColumnAp");
        nodeItem.put("CommonFilterApType", "CommonFilterColumnAp");
        nodeItem.put("SchemeFilterApType", "FlexSchemeFilterColumnAp");
        return nodeItem;
    }

    @SdkInternal
    public String getClientType() {
        int length = this.getClass().getSimpleName().length();
        if (this.getClass().getName().endsWith("Prop")) {
            return this.getClass().getSimpleName().substring(0, length - 4).toLowerCase();
        }
        return this.getClass().getSimpleName().toLowerCase();
    }

    @Override
    public String getClientType(String refPropKey) {
        return "flexfield";
    }

    private DynamicObjectType getFlexDataType(FlexType flexType, String name, IDataEntityProperty dataEntityProperty, String dbRouteKey) {
        String tableName;
        BasedataEntityType dt = new BasedataEntityType();
        if (dataEntityProperty instanceof TextProp) {
            tableName = flexType.getFlexDataTable() + "_txt";
        } else if (dataEntityProperty instanceof BasedataProp) {
            tableName = flexType.getFlexDataTable() + "_bd";
        } else {
            throw new NotSupportedException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5f39\u6027\u57df\u7c7b\u578b:%s", (String)"FlexProp_3", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), dataEntityProperty.getClass()));
        }
        LongProp pkProperty = new LongProp();
        pkProperty.setName("id");
        pkProperty.setDbType(4);
        pkProperty.setAlias("fid");
        pkProperty.setPrimaryKey(true);
        dt.addProperty((DynamicProperty)pkProperty);
        TextProp propertyId = new TextProp();
        propertyId.setName("propertyId");
        propertyId.setAlias("fflexfield");
        propertyId.setDbType(-9);
        dt.addProperty((DynamicProperty)propertyId);
        TextProp propertyValue = new TextProp();
        propertyValue.setName(VALUE);
        propertyValue.setAlias(F_VALUE);
        propertyValue.setDbType(-9);
        dt.addProperty((DynamicProperty)propertyValue);
        dt.setAlias(tableName);
        dt.setName(name);
        dt.setDBRouteKey(dbRouteKey);
        dt.setDisplayName(dataEntityProperty.getDisplayName());
        return dt;
    }

    private BasedataProp registerBasedataProp(DynamicObjectType dt, String propName, DynamicObjectType entityType, String alias, boolean isEntry, LocaleString displayName, BasedataProp baseProp, Consumer<BasedataProp> consumer) {
        LongProp pRefId = new LongProp(true);
        pRefId.setPrimaryKey(false);
        pRefId.setName(propName + "_id");
        baseProp.setName(propName);
        baseProp.setAlias(alias);
        baseProp.setDbIgnore(true);
        baseProp.setRefIdPropName(propName + "_id");
        baseProp.setRefIdProp((IDataEntityProperty)pRefId);
        baseProp.setComplexType((IDataEntityType)dt);
        baseProp.setBaseEntityId(dt.getName());
        baseProp.setDisplayName(displayName);
        if (consumer != null) {
            consumer.accept(baseProp);
        }
        if (isEntry) {
            EntryType entryType;
            String entryName = this.getParent().getName();
            EntryProp parentEntryProp = (EntryProp)((MainEntityType)entityType).findProperty(entryName);
            if (parentEntryProp == null) {
                entryType = new EntryType();
                entryType.setName(entryName);
                VarcharProp pk = new VarcharProp();
                pk.setName("id");
                pk.setPrimaryKey(true);
                entryType.addProperty((DynamicProperty)pk);
                EntryProp entryProp = new EntryProp();
                entryProp.setName(entryType.getName());
                entryProp.setItemType((IDataEntityType)entryType);
                entityType.addProperty((DynamicProperty)entryProp);
            } else {
                entryType = (EntryType)parentEntryProp.getItemType();
            }
            entryType.addProperty((DynamicProperty)pRefId);
            entryType.addProperty((DynamicProperty)baseProp);
        } else {
            entityType.registerSimpleProperty((DynamicSimpleProperty)pRefId);
            entityType.registerComplexProperty((DynamicComplexProperty)baseProp);
        }
        return baseProp;
    }

    private RegisterFlexPropertyArgs registerProperty(DynamicObjectType dt, String propName, IDataEntityProperty dataEntityProperty, MainEntityType entityType) {
        if (entityType.getProperty(propName) != null) {
            BasedataProp dimensionProp = (BasedataProp)entityType.getProperty(propName);
            if (dataEntityProperty instanceof BasedataProp) {
                DynamicObjectType basedataEntityType = (DynamicObjectType)((BasedataProp)dataEntityProperty).getComplexType();
                BasedataProp basedataProp = (BasedataProp)((BasedataEntityType)dimensionProp.getComplexType()).getProperty(basedataEntityType.getName());
                return new RegisterFlexPropertyArgs(dataEntityProperty, dimensionProp, basedataProp, entityType);
            }
            return new RegisterFlexPropertyArgs(dataEntityProperty, dimensionProp, null, entityType);
        }
        BasedataProp dimensionProp = this.registerBasedataProp(dt, propName, entityType, this.getAlias(), this.getParent() instanceof EntryType, dataEntityProperty.getDisplayName(), new BasedataProp(), null);
        BasedataProp basedataProp = null;
        if (dataEntityProperty instanceof BasedataProp) {
            BasedataProp newBasedataProp;
            DynamicObjectType basedataEntityType = (DynamicObjectType)((BasedataProp)dataEntityProperty).getComplexType();
            Consumer<BasedataProp> consumer = null;
            if (dataEntityProperty instanceof AssistantProp) {
                newBasedataProp = new AssistantProp();
                consumer = t -> {
                    AssistantProp assistantProp = (AssistantProp)t;
                    assistantProp.setAsstTypeId(((AssistantProp)dataEntityProperty).getAsstTypeId());
                };
            } else if (dataEntityProperty instanceof OrgProp) {
                newBasedataProp = new OrgProp();
                consumer = t -> {
                    OrgProp orgProp = (OrgProp)t;
                    orgProp.setOrgFunc(((OrgProp)dataEntityProperty).getOrgFunc());
                };
            } else {
                newBasedataProp = new BasedataProp();
            }
            basedataProp = this.registerBasedataProp(basedataEntityType, basedataEntityType.getName(), dt, F_VALUE, false, dataEntityProperty.getDisplayName(), newBasedataProp, consumer);
        }
        return new RegisterFlexPropertyArgs(dataEntityProperty, dimensionProp, basedataProp, entityType);
    }

    private DynamicObject getBaseDataObjectValue(BasedataProp flexObjectProp, Object value, BiFunction<DynamicObjectType, Object, DynamicObject> loadReferenceData) {
        Object baseValue = null;
        baseValue = value instanceof Integer ? Long.valueOf(((Integer)value).longValue()) : value;
        return loadReferenceData.apply((DynamicObjectType)flexObjectProp.getComplexType(), baseValue);
    }

    private Object[] flexBasePropValue(DynamicObject dataEntity, BasedataProp flexObjectProp, Object value, BiFunction<DynamicObjectType, Object, DynamicObject> loadReferenceData, BiConsumer<DynamicObject, Object[]> editListener) {
        DynamicObject baseDataObjectValue = this.getBaseDataObjectValue(flexObjectProp, value, loadReferenceData);
        if (dataEntity != null && baseDataObjectValue != null) {
            baseDataObjectValue = NameVersionService.getInstance().getNameVersionData(baseDataObjectValue, dataEntity);
        }
        String displayProperty = flexObjectProp.getDisplayProp();
        Object[] bindingBasedataValue = (Object[])flexObjectProp.getBindingBasedataValue(baseDataObjectValue, displayProperty);
        if (editListener != null) {
            editListener.accept(baseDataObjectValue, bindingBasedataValue);
        }
        return bindingBasedataValue;
    }

    private Map<String, String> getFlexValueMap(DynamicObject dataEntity) {
        DynamicObject flexObject = (DynamicObject)this.getValue(dataEntity);
        DynamicProperty p1 = this.getDynamicComplexPropertyType().getProperty(VALUE);
        Object flexValue = null;
        if (flexObject != null) {
            flexValue = p1.getValue((Object)flexObject);
        }
        if (flexValue != null) {
            return (Map)SerializationUtils.fromJsonString((String)flexValue.toString(), Map.class);
        }
        return null;
    }

    public Map<String, Object> getQingValue(MainEntityType flexEntityType, DynamicObject v, BiFunction<DynamicObjectType, Object, DynamicObject> loadReferenceData) {
        Map<String, String> valueMap = this.getFlexValueMap(v);
        HashMap<String, Object> flexValueMap = new HashMap<String, Object>();
        if (valueMap == null) {
            return flexValueMap;
        }
        for (IDataEntityProperty flexObjectProp : flexEntityType.getProperties()) {
            String[] keys;
            String value;
            if (!(flexObjectProp instanceof BasedataProp) && !(flexObjectProp instanceof AssistantProp) && !(flexObjectProp instanceof TextProp) || (value = valueMap.get((keys = flexObjectProp.getName().split("__"))[1])) == null || !(flexObjectProp instanceof BasedataProp)) continue;
            DynamicObject baseDataObjectValue = this.getBaseDataObjectValue((BasedataProp)flexObjectProp, value, loadReferenceData);
            flexValueMap.put(keys[1], ((BasedataProp)flexObjectProp).getPropertiesValueMap(baseDataObjectValue, "id", NUMBER, NAME));
        }
        return flexValueMap;
    }

    private String getFlexValueString(DynamicObject dataEntity, IDataEntityProperty flexObjectProp, Map<String, String> valueMap, BiFunction<DynamicObjectType, Object, DynamicObject> loadReferenceData) {
        String[] keys = flexObjectProp.getName().split("__");
        String value = valueMap.get(keys[1]);
        if (value != null) {
            if (flexObjectProp instanceof BasedataProp) {
                Object[] arrValue = this.flexBasePropValue(dataEntity, (BasedataProp)flexObjectProp, value, loadReferenceData, null);
                return this.getDisplayData(arrValue, (BasedataProp)flexObjectProp);
            }
            if (flexObjectProp instanceof TextProp) {
                return String.format(FORMAT, ((FieldProp)flexObjectProp).getDisplayName(), value.toString());
            }
        }
        return "";
    }

    private String getReportClientValue(DynamicObject dataEntity, List<IDataEntityProperty> properties, Map<String, String> valueMap, BiFunction<DynamicObjectType, Object, DynamicObject> loadReferenceData) {
        if (valueMap == null) {
            return "";
        }
        ArrayList<String> valueList = new ArrayList<String>();
        for (IDataEntityProperty flexObjectProp : properties) {
            if (!(flexObjectProp instanceof BasedataProp) && !(flexObjectProp instanceof AssistantProp) && !(flexObjectProp instanceof TextProp)) continue;
            valueList.add(this.getFlexValueString(dataEntity, flexObjectProp, valueMap, loadReferenceData));
        }
        return String.join((CharSequence)";", valueList);
    }

    public Object getReportValue(DynamicObject dataEntity, BiFunction<DynamicObjectType, Object, DynamicObject> loadReferenceData) {
        Map<String, String> valueMap = this.getFlexValueMap(dataEntity);
        if (valueMap == null) {
            return "";
        }
        ArrayList<IDataEntityProperty> properties = new ArrayList<IDataEntityProperty>(20);
        for (Map.Entry<String, String> entry : valueMap.entrySet()) {
            String key = entry.getKey();
            FlexProperty fp = FlexEntityMetaUtils.getFlexProperty(key);
            if (fp == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7684\u5c5e\u6027%2$s\u4e0d\u5b58\u5728\u3002", (String)"FlexProp_9", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.getDisplayName(), key));
            }
            DynamicProperty prop = FlexEntityMetaUtils.createProperty("", fp);
            properties.add((IDataEntityProperty)prop);
        }
        return this.getReportClientValue(dataEntity, properties, valueMap, loadReferenceData);
    }

    private Map<String, Object> getFlexValueMap(DynamicObject dataEntity, IDataEntityProperty flexObjectProp, Map<String, String> valueMap, BiFunction<DynamicObjectType, Object, DynamicObject> loadReferenceData, BiConsumer<DynamicObject, Object[]> editListener) {
        String keyShort = "k";
        String valueShort = "v";
        String aliasShort = "alias";
        HashMap<String, Object> flexValueMap = new HashMap<String, Object>();
        if (valueMap == null) {
            flexValueMap.put(keyShort, flexObjectProp.getName());
            flexValueMap.put(valueShort, "");
            flexValueMap.put(aliasShort, "");
        } else {
            String[] keys = flexObjectProp.getName().split("__");
            String value = valueMap.get(keys[1]);
            if (value != null) {
                if (flexObjectProp instanceof BasedataProp) {
                    flexValueMap.put(keyShort, flexObjectProp.getName());
                    Object[] arrValue = this.flexBasePropValue(dataEntity, (BasedataProp)flexObjectProp, value, loadReferenceData, editListener);
                    boolean valIsNull = true;
                    for (Object v : arrValue) {
                        if (v == null || !StringUtils.isNotBlank((CharSequence)v.toString())) continue;
                        valIsNull = false;
                        break;
                    }
                    if (valIsNull) {
                        flexValueMap.put(valueShort, "");
                    } else {
                        flexValueMap.put(valueShort, arrValue);
                    }
                    String alias = this.getDisplayData(arrValue, (BasedataProp)flexObjectProp);
                    flexValueMap.put(aliasShort, alias);
                } else if (flexObjectProp instanceof TextProp) {
                    flexValueMap.put(keyShort, flexObjectProp.getName());
                    flexValueMap.put(valueShort, value);
                    String alias = "";
                    if (StringUtils.isNotBlank((Object)value)) {
                        alias = String.format(FORMAT, ((TextProp)flexObjectProp).getDisplayName(), value);
                    }
                    flexValueMap.put(aliasShort, alias);
                }
            } else {
                flexValueMap.put(keyShort, flexObjectProp.getName());
                flexValueMap.put(valueShort, "");
                flexValueMap.put(aliasShort, "");
            }
        }
        return flexValueMap;
    }

    private List<Object> getFlexValue(DynamicObject dataEntity, List<IDataEntityProperty> properties, Map<String, String> valueMap, BiFunction<DynamicObjectType, Object, DynamicObject> loadReferenceData, BiConsumer<DynamicObject, Object[]> editListener) {
        ArrayList<Object> arr = new ArrayList<Object>();
        for (IDataEntityProperty flexObjectProp : properties) {
            if (!(flexObjectProp instanceof BasedataProp) && !(flexObjectProp instanceof AssistantProp) && !(flexObjectProp instanceof TextProp)) continue;
            arr.add(this.getFlexValueMap(dataEntity, flexObjectProp, valueMap, loadReferenceData, editListener));
        }
        return arr;
    }

    private String getDisplayData(Object[] arrValue, BasedataProp prop) {
        String alias = "";
        if (arrValue[0] != null && StringUtils.isNotBlank((CharSequence)arrValue[0].toString()) || arrValue[1] != null && StringUtils.isNotBlank((CharSequence)arrValue[1].toString()) || arrValue[3] != null && StringUtils.isNotBlank((CharSequence)arrValue[3].toString()) || arrValue[4] != null && StringUtils.isNotBlank((CharSequence)arrValue[4].toString())) {
            Object displayVal;
            switch (prop.getDisplayProp()) {
                case "number": {
                    displayVal = arrValue[0];
                    break;
                }
                case "name": {
                    displayVal = arrValue[1];
                    break;
                }
                case "longNumber": {
                    displayVal = arrValue[3];
                    break;
                }
                case "fullName": {
                    displayVal = arrValue[4];
                    break;
                }
                case "number,fullName": {
                    displayVal = String.format("%s,%s", arrValue[0], arrValue[4]);
                    break;
                }
                default: {
                    displayVal = String.format("%s,%s", arrValue[0], arrValue[1]);
                }
            }
            alias = String.format(FORMAT, prop.getDisplayName(), displayVal);
        }
        return alias;
    }

    public Object getValue(MainEntityType flexEntityType, DynamicObject dataEntity, BiFunction<DynamicObjectType, Object, DynamicObject> loadReferenceData) {
        return this.getValue(flexEntityType, dataEntity, loadReferenceData, null);
    }

    public Object getValue(MainEntityType flexEntityType, DynamicObject dataEntity, BiFunction<DynamicObjectType, Object, DynamicObject> loadReferenceData, BiConsumer<DynamicObject, Object[]> editListener) {
        Object properties = flexEntityType instanceof FlexEntityType ? ((FlexEntityType)flexEntityType).getOrderProperties() : flexEntityType.getProperties();
        return this.getFlexValue(dataEntity, (List<IDataEntityProperty>)properties, this.getFlexValueMap(dataEntity), loadReferenceData, editListener);
    }

    public List<IRegisterPropertyListener> extendFlexProperties(String entityName, IRegisterFlexPropertyListener registerPropertyListener) {
        ArrayList<IRegisterPropertyListener> registerPropertyListeners = new ArrayList<IRegisterPropertyListener>();
        String sql = "select fid, fentryid from t_bas_flex_property where fid = ? ";
        SqlParameter parameter = new SqlParameter(":fid", 4, (Object)this.flexTypeId);
        List properties = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new SqlParameter[]{parameter}, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws SQLException {
                ArrayList<Long> properties = new ArrayList<Long>(10);
                while (rs.next()) {
                    Long propertyId = rs.getLong(2);
                    properties.add(propertyId);
                }
                return properties;
            }
        });
        FlexType flexType = FlexEntityMetaUtils.getFlexType(this.getFlexTypeId());
        if (properties.isEmpty()) {
            return registerPropertyListeners;
        }
        MainEntityType entityType = new MainEntityType();
        entityType.setName(entityName);
        VarcharProp pk = new VarcharProp();
        pk.setName("id");
        pk.setPrimaryKey(true);
        entityType.addProperty((DynamicProperty)pk);
        String fieldName = this.getName();
        if (this.getParent() instanceof SubEntryType) {
            fieldName = this.getParent().getParent().getName() + "." + this.getParent().getName() + "." + fieldName;
        } else if (this.getParent() instanceof EntryType) {
            fieldName = this.getParent().getName() + "." + fieldName;
        }
        CreateFlexMetaArgs args = new CreateFlexMetaArgs(entityType.getName(), fieldName, this.getFlexTypeId(), properties);
        FlexEntityType flexEntityType = FlexEntityMetaUtils.getBasedataPropFlexEntityType(args);
        if (flexEntityType == null) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"%s\u7684\u5f39\u6027\u57df\u7c7b\u578b\u6ca1\u6709\u6784\u9020\u6210\u529f", (String)"FlexProp_5", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.getName())});
        }
        String dbRouteKey = DBRoute.basedata.getRouteKey();
        if (StringUtils.isNotEmpty((CharSequence)flexEntityType.getDBRouteKey())) {
            dbRouteKey = flexEntityType.getDBRouteKey();
        }
        for (IDataEntityProperty dataEntityProperty : flexEntityType.getProperties()) {
            if (dataEntityProperty.getDisplayName() == null) continue;
            String[] keys = dataEntityProperty.getName().substring(2).split("__");
            String propName = this.getName() + "_" + keys[1];
            DynamicObjectType dt = this.getFlexDataType(flexType, propName, dataEntityProperty, dbRouteKey);
            if (!(dataEntityProperty instanceof TextProp) && !(dataEntityProperty instanceof BasedataProp)) continue;
            RegisterFlexPropertyArgs registerPropertyArgs = this.registerProperty(dt, propName, dataEntityProperty, entityType);
            registerPropertyListeners.add(new FlexPropRegisterPropertyListener(registerPropertyArgs));
        }
        entityType.createPropIndexsNoCache();
        if (registerPropertyListener != null) {
            for (IRegisterPropertyListener rListener : registerPropertyListeners) {
                if (!(rListener instanceof FlexPropRegisterPropertyListener)) continue;
                registerPropertyListener.registerProperty(((FlexPropRegisterPropertyListener)rListener).getRegisterFlexPropertyArgs());
            }
        }
        return registerPropertyListeners;
    }
}

