/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.util.ArrayList;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.BaseDataColumnDesc;
import kd.bos.entity.list.column.MulBaseDataColumnDesc;
import kd.bos.entity.list.column.RefBillColumnDesc;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.IRefBillField;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;

class ListColumnDescBuilder {
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private IBasedataField basedataField;
    private IRefBillField refBillField;

    ListColumnDescBuilder(IBasedataField basedataField) {
        this.basedataField = basedataField;
    }

    ListColumnDescBuilder(IRefBillField refBillField) {
        this.refBillField = refBillField;
    }

    AbstractColumnDesc createColumnDesc(ListField col) {
        if (col.getListFieldKey().isEmpty()) {
            return null;
        }
        if (this.refBillField != null) {
            return this.createColumnDesc_refBill(col);
        }
        return this.createColumnDesc_baseData(col);
    }

    AbstractColumnDesc createColumnDesc_baseData(ListField col) {
        String[] keys = col.getListFieldKey().split("\\.");
        IDataEntityProperty prop = null;
        if (keys.length == 1) {
            prop = this.basedataField.getDispProp();
            if (prop == null) {
                ErrorCode errorCode = new ErrorCode("bos.fieldNotExit", String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u201c%1$s\u201d\u4e0d\u5b58\u5728\u5b57\u6bb5\u201c%2$s\u201d\u7684\u663e\u793a\u5c5e\u6027\uff0c\u9519\u8bef\u4ee3\u7801\uff1a%3$s", (String)"ListColumnDescBuilder_2", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.basedataField.getComplexType().getName(), this.basedataField.getDisplayName(), "FIELDNOTEXISTS000008"));
                throw new KDBizException(errorCode, new Object[0]);
            }
        } else {
            ArrayList<String> propNames = new ArrayList<String>(10);
            for (int i = 0; i < keys.length; ++i) {
                propNames.add(keys[i]);
            }
            while (!((String)propNames.get(0)).equals(this.basedataField.getName())) {
                propNames.remove(0);
            }
            if (propNames.size() > 1) {
                prop = ((MainEntityType)this.basedataField.getComplexType()).findProperty((String)propNames.get(1));
            }
            if (prop == null) {
                throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.basedataField.getComplexType().getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"ListColumnDescBuilder_3", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), propNames.get(1), "FIELDNOTEXISTS000003")});
            }
        }
        ListField listField = new ListField(col);
        int length = keys[0].length();
        if (col.getListFieldKey().substring(length).startsWith(".")) {
            ++length;
        }
        String listFieldKey = col.getListFieldKey().substring(length);
        listField.setListFieldKey(listFieldKey);
        listField.setSrcFieldProp((IDataEntityProperty)this.basedataField);
        listField.setKey(prop.getName());
        listField.setFieldName(prop.getName());
        listField.setFieldProp(prop);
        AbstractColumnDesc columnDesc = ((IFieldHandle)prop).getListColumnDesc(listField);
        if (this.basedataField instanceof BasedataProp) {
            return new BaseDataColumnDesc(col.getKey(), (IDataEntityProperty)this.basedataField, col.getFieldProp(), columnDesc);
        }
        if (this.basedataField instanceof MulBasedataProp) {
            return new MulBaseDataColumnDesc(col.getKey(), (IDataEntityProperty)this.basedataField, col.getFieldProp(), columnDesc);
        }
        return null;
    }

    AbstractColumnDesc createColumnDesc_refBill(ListField col) {
        String[] keys = col.getListFieldKey().split("\\.");
        IDataEntityProperty prop = null;
        if (keys.length == 1) {
            prop = this.refBillField.getDispProp();
            if (prop == null) {
                ErrorCode errorCode = new ErrorCode("bos.fieldNotExit", String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u201c%1$s\u201d\u4e0d\u5b58\u5728\u5b57\u6bb5\u201c%2$s\u201d\u7684\u663e\u793a\u5c5e\u6027\uff0c\u9519\u8bef\u4ee3\u7801\uff1a%3$s", (String)"ListColumnDescBuilder_2", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.refBillField.getComplexType().getName(), this.refBillField.getDisplayName(), "FIELDNOTEXISTS000008"));
                throw new KDBizException(errorCode, new Object[0]);
            }
        } else {
            ArrayList<String> propNames = new ArrayList<String>(10);
            for (int i = 0; i < keys.length; ++i) {
                propNames.add(keys[i]);
            }
            while (!((String)propNames.get(0)).equals(this.refBillField.getName())) {
                propNames.remove(0);
            }
            if (propNames.size() > 1) {
                prop = ((MainEntityType)this.refBillField.getComplexType()).findProperty((String)propNames.get(1));
            }
            if (prop == null) {
                throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.refBillField.getComplexType().getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"ListColumnDescBuilder_3", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), propNames.get(1), "FIELDNOTEXISTS000003")});
            }
        }
        ListField listField = new ListField(col);
        int length = keys[0].length();
        if (col.getListFieldKey().substring(length).startsWith(".")) {
            ++length;
        }
        String listFieldKey = col.getListFieldKey().substring(length);
        listField.setListFieldKey(listFieldKey);
        listField.setSrcFieldProp((IDataEntityProperty)this.refBillField);
        listField.setKey(prop.getName());
        listField.setFieldName(prop.getName());
        listField.setFieldProp(prop);
        AbstractColumnDesc columnDesc = ((IFieldHandle)prop).getListColumnDesc(listField);
        if (this.refBillField instanceof RefBillProp) {
            return new RefBillColumnDesc(col.getKey(), (IDataEntityProperty)this.refBillField, col.getFieldProp(), columnDesc);
        }
        return null;
    }
}

