/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataStorage;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.MuliLangTextColumnDesc;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.IValueComparator;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class MuliLangTextProp
extends TextProp
implements ILocaleProperty {
    private static final Log log = LogFactory.getLog(MuliLangTextProp.class);
    private static final long serialVersionUID = 2951227813118594547L;
    private static String GLang = "GLang";
    private DynamicSimpleProperty inLocaleProperty;
    private IDataEntityProperty localeProperty;
    private boolean gl = false;
    private boolean isGlangText = false;

    public MuliLangTextProp() {
        this.setDbIgnore(true);
    }

    public void setLocaleProperty(IDataEntityProperty localeProperty, DynamicSimpleProperty inLocaleProperty) {
        this.localeProperty = localeProperty;
        this.inLocaleProperty = inLocaleProperty;
    }

    @KSMethod
    @SimplePropertyAttribute(name="DbIgnore")
    @DefaultValueAttribute(value="true")
    public boolean isDbIgnore() {
        return super.isDbIgnore();
    }

    @Override
    public Class<?> getPropertyType() {
        return ILocaleString.class;
    }

    @SimplePropertyAttribute(name="GL")
    @DefaultValueAttribute(value="false")
    public boolean isGL() {
        return this.gl;
    }

    public void setGL(boolean gl) {
        this.gl = gl;
    }

    @KSMethod
    public String getAlias() {
        if (this.inLocaleProperty == null) {
            return "";
        }
        return this.inLocaleProperty.getAlias();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDTValueFast(DynamicObject dataEntity) {
        IDataStorage storage = dataEntity.getDataStorage();
        Object localCache = storage.getLocalValue((IDataEntityProperty)this);
        if (localCache == null || !(localCache instanceof OrmLocaleValue)) {
            IDataStorage iDataStorage = storage;
            synchronized (iDataStorage) {
                localCache = storage.getLocalValue((IDataEntityProperty)this);
                if (localCache == null || !(localCache instanceof OrmLocaleValue)) {
                    LocaleDynamicObjectCollection col = (LocaleDynamicObjectCollection)this.localeProperty.getValueFast((Object)dataEntity);
                    ILocaleString newLocal = (ILocaleString)LocaleDynamicObjectCollection.createLocaleValue((LocaleDynamicObjectCollection)col, (DynamicSimpleProperty)this.inLocaleProperty);
                    storage.setLocalValue((IDataEntityProperty)this, (Object)newLocal);
                    if (localCache instanceof Map) {
                        newLocal.putAll((Map)localCache);
                    }
                    localCache = newLocal;
                }
            }
        }
        return localCache;
    }

    public Map<String, Object> buildPlainStrMap() {
        Map data = super.buildPlainStrMap();
        data.put("inLocaleProperty", this.inLocaleProperty == null ? "null" : this.inLocaleProperty.toPlainString());
        data.put("localeProperty", this.localeProperty == null ? "null" : this.localeProperty.toPlainString());
        data.put("gl", this.gl);
        return data;
    }

    public void setGlangValue(Object dataEntity, Object newValue) {
        if (this.isDbIgnore() && !this.isGL()) {
            return;
        }
        ILocaleString lcValue = (ILocaleString)this.getValueFast(dataEntity);
        if (newValue == null) {
            lcValue.setItem(GLang, (Object)"");
        } else if (newValue instanceof String) {
            lcValue.setItem(GLang, (Object)((String)newValue));
        }
    }

    protected void setValuePrivate(DynamicObject dataEntity, Object newValue) {
        LocaleDynamicObjectCollection col = (LocaleDynamicObjectCollection)this.localeProperty.getValueFast((Object)dataEntity);
        LocaleDynamicObjectCollection oldValue = null;
        if (col.getDynamicObjectType() != null) {
            oldValue = new LocaleDynamicObjectCollection(col.getDynamicObjectType(), null);
        } else if (this.localeProperty instanceof DynamicLocaleProperty) {
            oldValue = new LocaleDynamicObjectCollection(((DynamicLocaleProperty)this.localeProperty).getDynamicCollectionItemPropertyType(), null);
        }
        if (oldValue != null) {
            for (Object dynamicObject : col) {
                DynamicObject object = (DynamicObject)dynamicObject.getDynamicObjectType().createInstance();
                object.setDataStorage(dynamicObject.getDataStorage().memberClone());
                oldValue.add((Object)object);
            }
        }
        ILocaleString lcValue = (ILocaleString)this.getValueFast(dataEntity);
        if (newValue == null) {
            lcValue.setItem(GLang, (Object)"");
            col.clearValue((IDataEntityProperty)this.inLocaleProperty);
        } else if (newValue instanceof String) {
            if (this.isGL() || !this.isDbIgnore()) {
                lcValue.setItem(GLang, (Object)((String)newValue));
            }
            if (this.useGlangText()) {
                for (String lang : lcValue.keySet()) {
                    col.setValue((IDataEntityProperty)this.inLocaleProperty, lang, newValue);
                }
            }
            col.setCurrentLocaleValue((IDataEntityProperty)this.inLocaleProperty, newValue);
        } else if (newValue instanceof ILocaleString) {
            String newGlangValue = (String)((ILocaleString)newValue).get((Object)GLang);
            if (StringUtils.isBlank((CharSequence)newGlangValue)) {
                newGlangValue = (String)((ILocaleString)newValue).get((Object)Lang.get().toString());
            }
            if (newGlangValue == null && ((ILocaleString)newValue).size() > 0) {
                newGlangValue = (String)((ILocaleString)newValue).values().iterator().next();
            }
            if (this.isGL() || !this.isDbIgnore()) {
                lcValue.setItem(GLang, (Object)(newGlangValue == null ? "" : newGlangValue));
            }
            col.setValue((DynamicProperty)this.inLocaleProperty, (ILocaleString)newValue);
        } else if (newValue instanceof Map) {
            String newGlangValue;
            Map val = (Map)newValue;
            String clientGlangValue = (String)val.get(GLang);
            String string = newGlangValue = this.useGlangText() && StringUtils.isNotBlank((CharSequence)clientGlangValue) ? clientGlangValue : (String)val.get(Lang.get().toString());
            if (StringUtils.isBlank((CharSequence)newGlangValue) && val.size() > 0) {
                for (Map.Entry it : val.entrySet()) {
                    if (!GLang.equals(it.getKey()) && StringUtils.isNotBlank((CharSequence)(newGlangValue = (String)it.getValue()))) break;
                }
            }
            if (this.isGL() || !this.isDbIgnore()) {
                lcValue.setItem(GLang, (Object)(newGlangValue == null ? "" : newGlangValue));
            }
            val.remove(GLang);
            for (Map.Entry item : val.entrySet()) {
                lcValue.setItem((String)item.getKey(), item.getValue());
            }
        } else {
            throw new RuntimeException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u503c\u7c7b\u578b\u4e0d\u6b63\u786e", (String)"MuliLangTextProp_0", (String)"bos-entity-metadata", (Object[])new Object[0]));
        }
        this.onPropertyChanged(dataEntity, col, oldValue);
    }

    @Override
    public AbstractColumnDesc getListColumnDesc(ListField col) {
        return new MuliLangTextColumnDesc(col.getKey(), (IDataEntityProperty)this, col.getFieldProp());
    }

    protected void afterClone() {
        try (EntityTraceSpan span = null;){
            super.afterClone();
            if (this.getParent() != null) {
                this.localeProperty = ((DynamicObjectType)this.getParent()).getLocaleProperty();
                IDataEntityType type = ((ICollectionProperty)this.localeProperty).getItemType();
                this.inLocaleProperty = (DynamicSimpleProperty)type.getProperties().get((Object)this.inLocaleProperty.getName());
            }
        }
    }

    @Override
    public String getClientType() {
        return "localeText";
    }

    @Override
    public boolean checkScope(Object fldValue) {
        block6: {
            int valueLength;
            block5: {
                valueLength = 0;
                if (fldValue == null && this.isOverScope(valueLength)) {
                    return false;
                }
                if (!(fldValue instanceof ILocaleString)) break block5;
                ILocaleString items = (ILocaleString)fldValue;
                String currLang = RequestContext.get().getLang().toString();
                String currLangValue = (String)items.get((Object)currLang);
                int n = valueLength = currLangValue == null ? 0 : currLangValue.trim().length();
                if (this.isOverScope(valueLength)) {
                    return false;
                }
                if (items.isEmpty()) break block6;
                for (Map.Entry item : items.entrySet()) {
                    if ("GLang".equals(item.getKey()) || !this.isOverScope(valueLength = item.getValue() == null ? 0 : ((String)item.getValue()).length())) continue;
                    return false;
                }
                break block6;
            }
            if (fldValue instanceof Map) {
                Map multiLang = (Map)fldValue;
                for (Map.Entry item : multiLang.entrySet()) {
                    String itemValue = (String)item.getValue();
                    valueLength = itemValue == null ? 0 : itemValue.trim().length();
                    if (!this.isOverScope(valueLength)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isOverScope(int length) {
        return length < this.getMinLenth() || this.getMaxLenth() > 0 && length > this.getMaxLenth();
    }

    @Override
    public IValueComparator getValueComparator() {
        return new IValueComparator(){

            @Override
            public boolean compareValue(Object o) {
                if (o == null) {
                    return true;
                }
                if (o instanceof ILocaleString) {
                    return StringUtils.isBlank((CharSequence)((CharSequence)((ILocaleString)o).getDefaultItem()));
                }
                return StringUtils.isBlank((CharSequence)o.toString());
            }
        };
    }

    @SimplePropertyAttribute(name="GlangText")
    @DefaultValueAttribute(value="false")
    public boolean isGlangText() {
        return this.isGlangText;
    }

    public void setGlangText(boolean glangText) {
        this.isGlangText = glangText;
    }

    public boolean useGlangText() {
        return this.isGlangText;
    }
}

