/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.TimeColumnDesc;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.validate.IValueComparator;
import kd.bos.exception.KDBizException;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang.StringUtils;

@KSObject
@SdkPublic
public class TimeProp
extends FieldProp {
    private static final long serialVersionUID = -2584750800939380991L;
    private String relateTimeRange;
    private boolean startTimeRange;
    private int timeZoneTransType = 0;

    @KSMethod
    @SimplePropertyAttribute
    @DefaultValueAttribute(value="0")
    public int getTimeZoneTransType() {
        return this.timeZoneTransType;
    }

    public void setTimeZoneTransType(int timeZoneTransType) {
        this.timeZoneTransType = timeZoneTransType;
    }

    @SimplePropertyAttribute(name="RelateTimeRange")
    public String getRelateTimeRange() {
        return this.relateTimeRange;
    }

    public void setRelateTimeRange(String relateTimeRange) {
        this.relateTimeRange = relateTimeRange;
    }

    @SimplePropertyAttribute(name="StartTimeRange")
    @DefaultValueAttribute(value="false")
    public boolean isStartTimeRange() {
        return this.startTimeRange;
    }

    public void setStartTimeRange(boolean startTimeRange) {
        this.startTimeRange = startTimeRange;
    }

    @Override
    @KSMethod
    public int getDbType() {
        return 4;
    }

    @Override
    public Object getDefValue() {
        return -1;
    }

    public Class<?> getPropertyType() {
        return Integer.class;
    }

    @Override
    protected ColumnDesc createColumnDesc(ListField col) {
        return new TimeColumnDesc(col.getKey(), this, col.getFieldProp());
    }

    @Override
    public String getClientType() {
        return "time";
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("HH:mm:ss");
    }

    @Override
    public String getFilterControlType() {
        return "time";
    }

    @Override
    public void setFieldValue(IDataModel model, Object dataEntity, Object value) {
        this.setDTValueFast((DynamicObject)dataEntity, value);
    }

    @Override
    public void setFieldValueForWebApi(IDataModel model, Object dataEntity, Object value, boolean checkImportable) {
        String localeValue = this.getDisplayName() == null ? this.getName() : this.getDisplayName().getLocaleValue();
        super.setFieldValueForWebApi(model, dataEntity, TimeProp.timeToSecond(value, localeValue), checkImportable);
    }

    public static int timeToSecond(Object value, String fieldName) {
        int secondOfTime = -1;
        if (value instanceof String) {
            String time = (String)value;
            if (StringUtils.isNotBlank((String)(time = time.trim()))) {
                Pattern pattern = Pattern.compile("[0-9]{1,}");
                Matcher matcher = pattern.matcher(time);
                if (matcher.matches()) {
                    if (TimeProp.isIntegerRange(time)) {
                        return Integer.parseInt(time);
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u65f6\u95f4\u603b\u79d2\u6570\u8d85\u8fc7\u8303\u56f4[0,86399]\u3002", (String)"TimeProp_0", (String)"bos-entity-metadata", (Object[])new Object[0]));
                }
                pattern = Pattern.compile("^(([0-1]?[0-9])|([2][0-3])):([0-5]?[0-9])(:([0-5]?[0-9]))$");
                matcher = pattern.matcher(time);
                if (matcher.matches()) {
                    String[] timeArr = time.split(":");
                    int hours = Integer.parseInt(timeArr[0]);
                    int minutes = Integer.parseInt(timeArr[1]);
                    int seconds = Integer.parseInt(timeArr[2]);
                    secondOfTime = seconds + minutes * 60 + hours * 3600;
                } else {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u4e0d\u5b58\u5728\u3002", (String)"TimeProp_2", (String)"bos-entity-metadata", (Object[])new Object[0]), fieldName, value));
                }
            }
        }
        return secondOfTime;
    }

    private static boolean isIntegerRange(String time) {
        BigInteger timeBig = new BigInteger(time);
        BigInteger minValue = BigInteger.valueOf(0L);
        BigInteger maxValue = BigInteger.valueOf(86399L);
        return timeBig.compareTo(minValue) >= 0 && timeBig.compareTo(maxValue) <= 0;
    }

    private int intOfTime(Object value) {
        String time = "";
        int secondOfTime = -1;
        if (value instanceof String && !(time = (String)value).isEmpty()) {
            Pattern pattern = Pattern.compile("[0-9]{1,}");
            Matcher matcher = pattern.matcher(time);
            if (matcher.matches()) {
                return Integer.parseInt(time);
            }
            int hours = Integer.parseInt(time.substring(0, 2));
            int minutes = Integer.parseInt(time.substring(3, 5));
            int seconds = Integer.parseInt(time.substring(6, 8));
            secondOfTime = seconds + minutes * 60 + hours * 3600;
        }
        return secondOfTime;
    }

    public TimeProp() {
        this.compareGroupID = "0";
        this.defaultCompareTypeId = "67";
        this.defaultMultiCompareTypeId = "1";
        this.filterControlType = "time";
    }

    @Override
    public Object getBasePropDisplayValue(Object baseObj) {
        Integer value = (Integer)this.getValueFast(baseObj);
        return TimeProp.formatTimeStr(value);
    }

    private static String formatTimeStr(Integer timeObj) {
        if (timeObj == null || timeObj < 0) {
            return null;
        }
        int time = timeObj;
        int second = time % 60;
        int minute = (time /= 60) % 60;
        int hour = (time /= 60) % 24;
        return String.format("%02d:%02d:%02d", hour, minute, second);
    }

    @Override
    public IValueComparator getValueComparator() {
        return o -> o == null || Integer.parseInt(String.valueOf(o)) == -1;
    }

    public long getEstimatedLen() {
        return 8L;
    }
}

