/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.rule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;

class GetUpDataEntities {
    private IDataModel model;
    private IDataEntityType eventTable;
    private IDataEntityType targetTable;
    private List<RowDataEntity> eventDataEntities;

    public GetUpDataEntities(IDataModel model, IDataEntityType eventTable, IDataEntityType targetTable, List<RowDataEntity> eventDataEntities) {
        this.model = model;
        this.eventTable = eventTable;
        this.targetTable = targetTable;
        this.eventDataEntities = eventDataEntities;
    }

    public List<RowDataEntity> getRowDataEntitys() {
        if (this.targetTable instanceof MainEntityType) {
            return this.getBillHead();
        }
        return this.getEntryRows();
    }

    private List<RowDataEntity> getBillHead() {
        DynamicObject parentRow;
        ArrayList<RowDataEntity> list = new ArrayList<RowDataEntity>();
        if (this.model != null) {
            list.add(new RowDataEntity(0, this.model.getDataEntity(true)));
            return list;
        }
        if (this.eventDataEntities.isEmpty()) {
            return list;
        }
        for (parentRow = (DynamicObject)this.eventDataEntities.get(0).getDataEntity().getParent(); parentRow != null && !StringUtils.equals((CharSequence)this.targetTable.getName(), (CharSequence)parentRow.getDataEntityType().getName()); parentRow = (DynamicObject)parentRow.getParent()) {
        }
        if (parentRow != null) {
            list.add(new RowDataEntity(0, parentRow));
        }
        return list;
    }

    private List<RowDataEntity> getEntryRows() {
        ArrayList<RowDataEntity> list = new ArrayList<RowDataEntity>();
        HashSet<Integer> rowIndexs = new HashSet<Integer>(32);
        for (RowDataEntity eventRow : this.eventDataEntities) {
            DynamicObject grandParentRow;
            DynamicObjectCollection rows;
            int rowIndex;
            DynamicObject parentRow;
            for (parentRow = (DynamicObject)eventRow.getDataEntity().getParent(); parentRow != null && !StringUtils.equals((CharSequence)this.targetTable.getName(), (CharSequence)parentRow.getDataEntityType().getName()); parentRow = (DynamicObject)parentRow.getParent()) {
            }
            if (parentRow == null || parentRow.getParent() == null || !rowIndexs.add(rowIndex = (rows = (grandParentRow = (DynamicObject)parentRow.getParent()).getDynamicObjectCollection(this.targetTable.getName())).indexOf((Object)parentRow))) continue;
            list.add(new RowDataEntity(rowIndex, parentRow));
        }
        return list;
    }
}

