/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class TreeMenuNode
implements Serializable {
    private static final long serialVersionUID = 2256027234003976633L;
    private String id = "";
    private String text = ResManager.loadKDString((String)"\u672a\u547d\u540d", (String)"TreeMenuNode_0", (String)"bos-entity-metadata", (Object[])new Object[0]);
    private String parentid = "";
    protected List<TreeMenuNode> children;
    private String iconUrl;
    private String activedIconUrl;
    private String menuType;
    private String grayValid;

    public TreeMenuNode() {
    }

    public TreeMenuNode(String parentId, String id, String text) {
        this(parentId, id, text, null, null);
    }

    public TreeMenuNode(String parentId, String id, String text, String iconUrl, String activedIconUrl) {
        this();
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            this.setParentid(parentId);
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.setId(id);
        }
        if (StringUtils.isNotBlank((CharSequence)text)) {
            this.setText(text);
        }
        if (StringUtils.isNotBlank((CharSequence)iconUrl)) {
            this.iconUrl = iconUrl;
        }
        if (StringUtils.isNotBlank((CharSequence)activedIconUrl)) {
            this.activedIconUrl = activedIconUrl;
        }
    }

    @KSMethod
    public final String getId() {
        return this.id;
    }

    @KSMethod
    public final void setId(String value) {
        this.id = value;
    }

    @KSMethod
    public final String getText() {
        return this.text;
    }

    @KSMethod
    public final void setText(String value) {
        this.text = value;
    }

    @KSMethod
    public final String getParentid() {
        return this.parentid;
    }

    @KSMethod
    public final void setParentid(String value) {
        this.parentid = value;
    }

    @KSMethod
    public List<TreeMenuNode> getChildren() {
        return this.children;
    }

    @KSMethod
    public void setChildren(List<TreeMenuNode> arrayList) {
        this.children = arrayList;
    }

    @KSMethod
    public String getIconUrl() {
        return this.iconUrl;
    }

    @KSMethod
    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    @KSMethod
    public String getActivedIconUrl() {
        return this.activedIconUrl;
    }

    @KSMethod
    public void setActivedIconUrl(String activedIconUrl) {
        this.activedIconUrl = activedIconUrl;
    }

    @KSMethod
    public String getMenuType() {
        return this.menuType;
    }

    @KSMethod
    public void setMenuType(String menuType) {
        this.menuType = menuType;
    }

    @KSMethod
    public String getGrayValid() {
        return this.grayValid;
    }

    @KSMethod
    public void setGrayValid(String grayValid) {
        this.grayValid = grayValid;
    }

    @KSMethod
    public TreeMenuNode addChild(TreeMenuNode node) {
        if (this.getChildren() == null) {
            this.setChildren(new ArrayList<TreeMenuNode>());
        }
        if (node != null) {
            this.getChildren().add(node);
        }
        return this;
    }

    @KSMethod
    public TreeMenuNode addChild(int i, TreeMenuNode node) {
        if (this.children == null) {
            this.setChildren(new ArrayList<TreeMenuNode>());
        }
        if (node != null) {
            if (i < this.children.size()) {
                this.children.add(i, node);
            } else {
                this.children.add(node);
            }
        }
        return this;
    }

    @KSMethod
    public TreeMenuNode addChildren(List<TreeMenuNode> nodes) {
        if (this.getChildren() == null) {
            this.setChildren(new ArrayList<TreeMenuNode>());
        }
        if (nodes != null) {
            this.getChildren().addAll(nodes);
        }
        return this;
    }

    @KSMethod
    public TreeMenuNode getTreeNode(String id, int maxLevel) {
        if (this.getId().equalsIgnoreCase(id)) {
            return this;
        }
        if (maxLevel > 0 && this.getChildren() != null) {
            for (TreeMenuNode child : this.getChildren()) {
                TreeMenuNode node = child.getTreeNode(id, maxLevel - 1);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    @KSMethod
    public int getNodeLevel(String id, int startLevel) {
        if (this.getId().equalsIgnoreCase(id)) {
            return startLevel;
        }
        if (this.getChildren() != null) {
            for (TreeMenuNode child : this.getChildren()) {
                int currLevel = child.getNodeLevel(id, startLevel + 1);
                if (currLevel == -1) continue;
                return currLevel;
            }
        }
        return -1;
    }

    @KSMethod
    public List<String> getChildPath(String id) {
        HashMap map = new HashMap();
        this.iterate(10, n -> map.put(n.id, n));
        ArrayList<String> path = new ArrayList<String>();
        while (map.containsKey(id)) {
            path.add(0, id);
            id = ((TreeMenuNode)map.get((Object)id)).parentid;
        }
        return path;
    }

    public void iterate(int maxLevel, Consumer<TreeMenuNode> callback) {
        callback.accept(this);
        if (maxLevel > 0 && this.getChildren() != null) {
            for (TreeMenuNode child : this.getChildren()) {
                child.iterate(maxLevel - 1, callback);
            }
        }
    }

    @KSMethod
    public TreeMenuNode deleteChildNode(String id) {
        if (this.getChildren() != null) {
            for (TreeMenuNode child : this.getChildren()) {
                if (child.getId().equalsIgnoreCase(id)) {
                    this.getChildren().remove(child);
                    return this;
                }
                TreeMenuNode node = child.deleteChildNode(id);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }
}

