/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.validate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.operate.OperateProgress;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ValidateContext {
    String entityNumber;
    protected MainEntityType billEntityType;
    protected MainEntityType subEntityType;
    private FunctionManage funcLib;
    Map<String, Object> operateMetaMap;
    List<Map<String, Object>> validationMeta;
    String operateKey;
    String operateName;
    String operateType;
    private OperateOption option;
    private OperateProgress operateProgress;
    ExtendedDataEntitySet extendedDataEntitySet;
    private ValidateResultCollection validateResults;
    private String validatePrefix;
    private boolean isControlFunction_i;
    protected String dimType;
    protected String dimFldKey;
    protected String dimAssistFldKey;
    private List<String> mustInputLang;
    private boolean checkMustInput = false;
    private int dataEntityLength;

    public ValidateContext(List<Map<String, Object>> validationMeta, String entityNumber, String operateKey, ExtendedDataEntitySet extendedDataEntitySet) {
        this.validationMeta = validationMeta;
        this.entityNumber = entityNumber;
        this.operateKey = operateKey;
        this.extendedDataEntitySet = extendedDataEntitySet;
    }

    public List<String> getMustInputLang() {
        if (this.mustInputLang == null) {
            this.mustInputLang = new ArrayList<String>(1);
        }
        return this.mustInputLang;
    }

    public void setMustInputLang(List<String> mustInputLang) {
        this.mustInputLang = mustInputLang;
    }

    public Map<String, Object> getOperateMetaMap() {
        return this.operateMetaMap;
    }

    public void setOperateMetaMap(Map<String, Object> operateMetaMap) {
        this.operateMetaMap = operateMetaMap;
    }

    public List<Map<String, Object>> getValidationMeta() {
        return this.validationMeta;
    }

    public String getOperateKey() {
        return this.operateKey;
    }

    public String getOperateName() {
        return this.operateName;
    }

    public void setOperateName(String operateName) {
        this.operateName = operateName;
    }

    public ExtendedDataEntitySet getExtendedDataEntitySet() {
        return this.extendedDataEntitySet;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public MainEntityType getBillEntityType() {
        return this.billEntityType;
    }

    public boolean isControlFunction() {
        return this.isControlFunction_i;
    }

    public String getDimType() {
        return this.dimType;
    }

    public String getDimFldKey() {
        return this.dimFldKey;
    }

    public String getDimAssistFldKey() {
        return this.dimAssistFldKey;
    }

    public boolean isCheckMustInput() {
        return this.checkMustInput;
    }

    public void setCheckMustInput(boolean checkMustInput) {
        this.checkMustInput = checkMustInput;
    }

    public void setBillEntityType(MainEntityType billEntityType) {
        this.billEntityType = billEntityType;
        this.initPermissionControlType(billEntityType);
    }

    protected void initPermissionControlType(MainEntityType billEntityType) {
        this.isControlFunction_i = billEntityType.getPermissionControlType().isControlFunction();
        this.dimType = billEntityType.getPermissionControlType().getDimension();
        this.dimFldKey = billEntityType.getPermissionControlType().getDataDimensionField();
        this.dimAssistFldKey = billEntityType.getPermissionControlType().getDataAssistDimensionField();
        if (StringUtils.isNotBlank((CharSequence)this.dimFldKey) && billEntityType.findProperty(this.dimFldKey) == null) {
            this.dimFldKey = null;
        }
        if (StringUtils.isNotBlank((CharSequence)this.dimAssistFldKey) && billEntityType.findProperty(this.dimAssistFldKey) == null) {
            this.dimAssistFldKey = null;
        }
        if (StringUtils.isBlank((CharSequence)this.dimFldKey) && StringUtils.isNotBlank((CharSequence)billEntityType.getMainOrg())) {
            this.dimFldKey = billEntityType.getMainOrg();
        }
    }

    public MainEntityType getSubEntityType() {
        return this.subEntityType;
    }

    public void setSubEntityType(MainEntityType subEntityType) {
        this.subEntityType = subEntityType;
    }

    public String getOperateType() {
        return this.operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }

    public OperateOption getOption() {
        return this.option;
    }

    public void setOption(OperateOption option) {
        this.option = option;
    }

    public OperateProgress getOperateProgress() {
        return this.operateProgress;
    }

    public void setOperateProgress(OperateProgress operateProgress) {
        this.operateProgress = operateProgress;
    }

    public ValidateResultCollection getValidateResults() {
        return this.validateResults;
    }

    public void setValidateResults(ValidateResultCollection validateResults) {
        this.validateResults = validateResults;
    }

    public FunctionManage getFuncLib() {
        return this.funcLib;
    }

    public void setFuncLib(FunctionManage funcLib) {
        this.funcLib = funcLib;
    }

    public String getValidatePrefix() {
        return this.validatePrefix;
    }

    public void setValidatePrefix(String validatePrefix) {
        this.validatePrefix = validatePrefix;
    }

    public int getDataEntityLength() {
        return this.dataEntityLength;
    }

    public void setDataEntityLength(int dataEntityLength) {
        this.dataEntityLength = dataEntityLength;
    }

    public static String switchLang(List<String> langBillParams) {
        List enabledLangList = ((IInteService)ServiceFactory.getService(IInteService.class)).getEnabledLang();
        StringBuilder strBuilder = new StringBuilder();
        for (String lanBillParam : langBillParams) {
            for (EnabledLang enabledLang : enabledLangList) {
                String lanNumber = enabledLang.getNumber().trim();
                if (!lanNumber.equals(lanBillParam) && !lanNumber.equals(lanBillParam.replace('-', '_'))) continue;
                strBuilder.append(enabledLang.getName()).append(" ");
            }
        }
        return strBuilder.length() >= 2 ? strBuilder.substring(0, strBuilder.length() - 1) : "";
    }
}

