/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.utils;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import kd.bos.dataentity.utils.StringUtils;

public class KDEncodeUtil {
    private static final String BASE64 = "base64";
    private static final String ENCODE_HEADER = "&#base64#&";

    public static String kdEncoding(String encode, String content) {
        if (StringUtils.isNotBlank((CharSequence)content) && BASE64.equals(encode)) {
            Base64.Encoder encoder = Base64.getEncoder();
            content = ENCODE_HEADER + encoder.encodeToString(content.getBytes(StandardCharsets.UTF_8));
        }
        return content;
    }

    public static String kdDecoding(String content) {
        if (StringUtils.isNotBlank((CharSequence)content) && content.startsWith(ENCODE_HEADER)) {
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] decode = decoder.decode(content.replaceFirst(ENCODE_HEADER, ""));
            Charset cs = StandardCharsets.UTF_8;
            ByteBuffer bb = ByteBuffer.allocate(decode.length);
            bb.put(decode).flip();
            CharBuffer cb = cs.decode(bb);
            content = cb.toString();
        }
        return content;
    }
}

