/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IFilterModel;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.filter.FilterSchemeL;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.entity.userconfig.UserConfig;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterSchemeData;
import kd.bos.filter.FilterSchemeService;
import kd.bos.filter.SchemeCodeType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.filter.FilterSchemeDto;
import kd.bos.form.control.events.filter.FilterSchemeRow;
import kd.bos.list.query.SchemeQuery;
import kd.bos.list.query.SchemeWriter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.IUserService;
import kd.bos.service.ServiceFactory;
import kd.bos.userconfig.UserConfigQuery;
import kd.bos.userconfig.UserConfigWriter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class FilterSchemeUIProxy {
    public static final String COMPARE = "Compare";
    public static final String VALUE = "Value";
    public static final String LEFT = "Left";
    public static final String RIGHT = "Right";
    public static final String LOGIC = "Logic";
    public static final String AND = "AND";
    public static final String OR = "OR";
    public static final String ID = "Id";
    private IFormView view;
    private IClientViewProxy clientViewProxy;
    private String invokeMethodControlKey;
    private IFilterModel filterModel;
    private String formId;
    private boolean isLookUp;
    private Map<String, List<CompareType>> fieldCompareTypeMap;
    private String billFormId;
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    public static final String FIELD_NAME = "FieldName";
    private static final String SCHEME = "scheme";
    private static final String FIELDCOMPAREGROUPID = "9";
    private static final Log log = LogFactory.getLog(FilterSchemeUIProxy.class);

    public FilterSchemeUIProxy() {
    }

    public FilterSchemeUIProxy(IFormView view, IFilterModel filterModel, String formId, String invokeMethodControlKey, Map<String, List<CompareType>> fieldCompareTypeMap, String billFormId) {
        this.view = view;
        this.filterModel = filterModel;
        this.formId = formId;
        this.invokeMethodControlKey = invokeMethodControlKey;
        this.clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        this.fieldCompareTypeMap = fieldCompareTypeMap;
        this.billFormId = billFormId;
    }

    void setLookUp(boolean lookUp) {
        this.isLookUp = lookUp;
    }

    public static boolean isNeedShareScheme() {
        ArrayList<Long> userIds = new ArrayList<Long>(1);
        long currUserId = RequestContext.get().getCurrUserId();
        userIds.add(currUserId);
        IUserService service = (IUserService)ServiceFactory.getService(IUserService.class);
        Map userBaseTypeByIds = service.getUserBaseTypeByIds(userIds);
        Integer userType = (Integer)userBaseTypeByIds.get(currUserId);
        return userType == null || userType != 200;
    }

    public static void checkFilterSchemeNull(FilterScheme fScheme) {
        if (fScheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"FilterSchemeUIProxy_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
        }
    }

    static boolean isSchemeExists(List<FilterScheme> filterSchemes, String schemeName) {
        for (FilterScheme filterScheme2 : filterSchemes) {
            if (!schemeName.equalsIgnoreCase(filterScheme2.getSchemeName()) || RequestContext.get().getCurrUserId() != filterScheme2.getUserId()) continue;
            return true;
        }
        return false;
    }

    List<FilterScheme> getCurrentUserSchemeList(List<FilterScheme> sharedSchemeList) {
        IFilterModel schemeFilterModel = this.filterModel;
        schemeFilterModel.setFormId(this.formId);
        List filterSchemes = this.isLookUp ? schemeFilterModel.getF7SchemeList() : schemeFilterModel.getSchemeList();
        ArrayList<FilterScheme> allSchemeList = new ArrayList<FilterScheme>();
        allSchemeList.addAll(filterSchemes);
        allSchemeList.addAll(sharedSchemeList);
        return allSchemeList;
    }

    private void buildDescription(FilterScheme filterScheme, List<Map<String, List<Object>>> schemeRows) {
        MainEntityType dataType = this.filterModel.getDataType();
        FilterObject filterObject = this.filterModel.getFilterObject();
        FilterBuilder filterBuilder = new FilterBuilder(dataType, filterObject);
        for (Map<String, List<Object>> dct : schemeRows) {
            FilterField filterField;
            String fieldName = dct.get(FIELD_NAME).get(0).toString();
            FilterField filterField1 = (FilterField)filterObject.getAllFilterFields().get(fieldName);
            if (filterField1 != null) {
                if (filterField1.getCompareGroupID().contains(FIELDCOMPAREGROUPID) || (filterField = FilterBuilder.getFilterField((MainEntityType)dataType, (String)fieldName)) == null) continue;
                this.addFieldCompareType(filterField, dct, filterObject);
                continue;
            }
            filterField = FilterBuilder.getFilterField((MainEntityType)dataType, (String)fieldName);
            if (filterField == null) continue;
            this.addFieldCompareType(filterField, dct, filterObject);
        }
        filterBuilder.setFieldCompareTypeMap(this.fieldCompareTypeMap);
        filterBuilder.setSchemeSetting(schemeRows, true);
        filterObject.setCheckInput(false);
        filterObject.buildFilter(false);
        String description = filterObject.getFilterResult().getFilterGroup()[0];
        if (description.length() > 255) {
            description = description.substring(0, 254);
        }
        filterScheme.setDescription(description);
    }

    private void addFieldCompareType(FilterField filterField, Map<String, List<Object>> dct, FilterObject filterObject) {
        if (filterField != null) {
            List<Object> compareTypeId = dct.get(COMPARE);
            if (kd.bos.util.CollectionUtils.isNotEmpty(compareTypeId) && compareTypeId.get(0) != null && this.isSchemeFieldCompare(compareTypeId.get(0).toString())) {
                List allCompareTypes = new ArrayList();
                allCompareTypes.addAll(filterField.getCompareTypes());
                allCompareTypes = EntityTypeUtil.setCompareTypes(allCompareTypes, (boolean)true);
                filterField.setCompareTypes(allCompareTypes);
                String oldCompareGroupID = filterField.getCompareGroupID();
                StringBuilder newCompareGroupId = new StringBuilder(oldCompareGroupID);
                newCompareGroupId.append(",").append(FIELDCOMPAREGROUPID);
                filterField.setCompareGroupID(newCompareGroupId.toString());
            }
            filterObject.addField(filterField);
        }
    }

    private boolean isSchemeFieldCompare(String compareTypeId) {
        CompareTypeEnum[] fieldCompareTypeEnums;
        for (CompareTypeEnum fieldCompareTypeEnum : fieldCompareTypeEnums = new CompareTypeEnum[]{CompareTypeEnum.FIELDEQUAL, CompareTypeEnum.FIELDNOTEQUAL, CompareTypeEnum.FIELDGREATEROREQUAL, CompareTypeEnum.FIELDGREATER, CompareTypeEnum.FIELDSMALLEROREQUAL, CompareTypeEnum.FIELDSMALLER}) {
            if (!StringUtils.equals((CharSequence)fieldCompareTypeEnum.getId(), (CharSequence)compareTypeId)) continue;
            return true;
        }
        return false;
    }

    public void loadSchemeList(List<FilterScheme> filterSchemes, List<FilterScheme> sharedSchemeList, boolean isSimple, SchemeCodeType schemeCodeType) {
        List schemeIdList = filterSchemes.stream().map(i -> i.getId()).collect(Collectors.toList());
        schemeIdList.addAll(sharedSchemeList.stream().map(i -> i.getId()).collect(Collectors.toList()));
        schemeIdList = schemeIdList.stream().distinct().collect(Collectors.toList());
        Map<String, Integer> map = new HashMap();
        if (!CollectionUtils.isEmpty(schemeIdList)) {
            map = this.filterModel.getShareSchemeMap(RequestContext.get().getCurrUserId(), schemeIdList);
        }
        for (FilterScheme scheme : filterSchemes) {
            if (!scheme.isFixed() || CollectionUtils.isEmpty(map) || !map.containsKey(scheme.getId()) || (Integer)map.get(scheme.getId()) != 1) continue;
            scheme.setDefault(true);
        }
        List<Map<String, Object>> schemeList = FilterSchemeService.getSchemeList(filterSchemes, isSimple, schemeCodeType);
        List<Object> ownerSchemeIdList = schemeList.stream().map(i -> i.get("id")).collect(Collectors.toList());
        schemeList.addAll(FilterSchemeService.getSharedSchemeList(filterSchemes, sharedSchemeList, isSimple, schemeCodeType, ownerSchemeIdList, map));
        this.clientViewProxy.invokeControlMethod(this.invokeMethodControlKey, "loadSchemeList", schemeList);
    }

    public void setDefaultScheme(String schemeId, boolean isDefault) {
        this.setDefaultScheme(schemeId, isDefault, false);
    }

    public void setDefaultSchemeForShared(boolean isDefault, String schemeId) {
        this.filterModel.setDefaultScheme(isDefault, schemeId);
    }

    public void setF7DefaultScheme(String schemeId, boolean isDefault) {
        this.setDefaultScheme(schemeId, isDefault, true);
    }

    private void setDefaultScheme(String schemeId, boolean isDefault, boolean isF7) {
        StringBuilder errorMessage = new StringBuilder();
        String opMessage = isDefault ? ResManager.loadKDString((String)"\u8bbe\u7f6e", (String)"FilterSchemeUIProxy_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d6\u6d88", (String)"FilterSchemeUIProxy_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]);
        SchemeQuery schemeQuery = new SchemeQuery();
        FilterScheme filterScheme = schemeQuery.getScheme(schemeId);
        FilterSchemeUIProxy.checkFilterSchemeNull(filterScheme);
        if (isF7 ? this.filterModel.updateF7Scheme(schemeId, isDefault, errorMessage) : this.filterModel.updateScheme(schemeId, isDefault, errorMessage)) {
            this.clientViewProxy.invokeControlMethod(this.invokeMethodControlKey, "setDefaultScheme", isDefault);
            this.view.showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"FilterSchemeUIProxy_4", (String)BOS_FORM_METADATA, (Object[])new Object[0]), opMessage));
        } else {
            this.view.showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"FilterSchemeUIProxy_5", (String)BOS_FORM_METADATA, (Object[])new Object[0]), opMessage, errorMessage));
        }
    }

    public void saveScheme(Map<String, Object> filterSchemeMap, Consumer<FilterSchemeData> callBackLogic, Function<FilterSchemeDto, Boolean> verifyFunction) {
        this.saveScheme(filterSchemeMap, callBackLogic, null, verifyFunction);
    }

    public void saveScheme(Map<String, Object> filterSchemeMap, Consumer<FilterSchemeData> callBackLogic, Consumer<Boolean> verifyAndPutSchemeToMap) {
        this.saveScheme(filterSchemeMap, callBackLogic, verifyAndPutSchemeToMap, null);
    }

    public void saveScheme(Map<String, Object> filterSchemeMap, Consumer<FilterSchemeData> callBackLogic, Consumer<Boolean> verifyAndPutSchemeToMap, Function<FilterSchemeDto, Boolean> verifyFunction) {
        Object schemeNameObject = filterSchemeMap.get("schemeName");
        if (StringUtils.isBlank((Object)schemeNameObject)) {
            this.view.showErrorNotification(ResManager.loadKDString((String)"\u201c\u65b9\u6848\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FilterSchemeUIProxy_6", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
            return;
        }
        String schemeName = schemeNameObject.toString();
        if (schemeName.length() > 100) {
            this.view.showErrorNotification(ResManager.loadKDString((String)"\u201c\u65b9\u6848\u540d\u79f0\u201d\u8fc7\u957f\uff0c\u8bf7\u63a7\u5236\u5728100\u4e2a\u5b57\u7b26\u4ee5\u5185\u3002", (String)"FilterSchemeUIProxy_7", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
            return;
        }
        String methodName = "addScheme";
        List<FilterScheme> allSchemeList = this.getCurrentUserSchemeList(new ArrayList<FilterScheme>());
        if (filterSchemeMap.get("id") != null) {
            SchemeQuery schemeQuery = new SchemeQuery();
            FilterScheme filterScheme = schemeQuery.getScheme(filterSchemeMap.get("id").toString());
            FilterSchemeUIProxy.checkFilterSchemeNull(filterScheme);
            if ((filterScheme.isShare() && filterScheme.getUserId() == RequestContext.get().getCurrUserId() || !filterScheme.isShare()) && !filterScheme.isFixed() && (this.isLookUp || filterScheme.getLocaleFilterScheme().entrySet().stream().anyMatch(f -> ((FilterSchemeL)f.getValue()).getName().equals(schemeName)))) {
                boolean isCurrentUserScheme = this.isCurrentUserScheme(allSchemeList, (String)filterSchemeMap.get("id"));
                if (!isCurrentUserScheme) {
                    this.view.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u65b9\u6848\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"FilterSchemeUIProxy_9", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
                    return;
                }
                if (this.checkRepeate(schemeName, filterScheme, allSchemeList)) {
                    return;
                }
                methodName = "updateScheme";
            } else {
                filterSchemeMap.remove("id");
                if (this.checkRepeate(schemeName, null, allSchemeList)) {
                    return;
                }
            }
        } else if (this.checkRepeate(schemeName, null, allSchemeList)) {
            return;
        }
        filterSchemeMap.put("formId", this.formId);
        filterSchemeMap.put("userId", RequestContext.get().getCurrUserId());
        List<Map<String, List<Object>>> schemeRows = new ArrayList();
        if (verifyAndPutSchemeToMap != null) {
            verifyAndPutSchemeToMap.accept(null);
            if (filterSchemeMap.get(SCHEME) == null) {
                return;
            }
        } else {
            schemeRows = (List)filterSchemeMap.get(SCHEME);
            filterSchemeMap.put(SCHEME, SerializationUtils.serializeToBase64(schemeRows));
        }
        FilterScheme filterscheme = (FilterScheme)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(filterSchemeMap), FilterScheme.class);
        if (!schemeRows.isEmpty()) {
            this.buildDescription(filterscheme, schemeRows);
        }
        FilterSchemeDto filterSchemeDto = this.convertFilterSchemeToDto(filterscheme, schemeRows);
        if (verifyFunction != null && !verifyFunction.apply(filterSchemeDto).booleanValue()) {
            return;
        }
        StringBuilder errorMessage = new StringBuilder();
        if (this.filterModel.saveScheme(filterscheme, errorMessage)) {
            UserConfig globalUserConfig;
            UserConfigQuery userConfigQuery = new UserConfigQuery();
            String schemeColumnKey = this.billFormId + "." + filterscheme.getId();
            UserConfig userConfig = userConfigQuery.getUserConfig(schemeColumnKey, RequestContext.get().getCurrUserId());
            if (userConfig.getId() == null && StringUtils.isNotBlank((CharSequence)this.billFormId) && filterscheme.getUserId() == RequestContext.get().getCurrUserId() && (globalUserConfig = this.getUserConfigByCache(RequestContext.get().getCurrUserId(), this.billFormId)).getId() != null) {
                this.setSetting(RequestContext.get().getCurrUserId(), schemeColumnKey, globalUserConfig.getSetting());
            }
            if (verifyAndPutSchemeToMap == null) {
                filterSchemeMap.put(SCHEME, schemeRows);
            }
            FilterSchemeService.fixSchemeMap(filterscheme, filterSchemeMap);
            this.clientViewProxy.invokeControlMethod(this.invokeMethodControlKey, methodName, filterSchemeMap);
            if (callBackLogic != null) {
                callBackLogic.accept(new FilterSchemeData(schemeRows, filterscheme));
            }
            this.view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"FilterSchemeUIProxy_10", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
        } else {
            this.view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"FilterSchemeUIProxy_11", (String)BOS_FORM_METADATA, (Object[])new Object[0]), errorMessage));
        }
    }

    private UserConfig getUserConfigByCache(long userID, String key) {
        UserConfigQuery userConfigQuery = new UserConfigQuery();
        return userConfigQuery.getUserConfig(key, userID);
    }

    private boolean setSetting(long userID, String key, String setting) {
        UserConfigWriter userConfigWriter = new UserConfigWriter();
        UserConfig userConfig = new UserConfig();
        userConfig.setKey(key);
        userConfig.setUserId(userID);
        userConfig.setSetting(setting);
        StringBuilder errorMessage = new StringBuilder();
        boolean isSuccess = userConfigWriter.saveUserConfig(userConfig, errorMessage);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            log.info(errorMessage.toString());
        }
        return isSuccess;
    }

    private FilterSchemeDto convertFilterSchemeToDto(FilterScheme filterScheme, List<Map<String, List<Object>>> schemeRows) {
        ArrayList<FilterSchemeRow> filterSchemeRows = new ArrayList<FilterSchemeRow>(10);
        for (Map<String, List<Object>> schemeRow : schemeRows) {
            List<Object> valueList = schemeRow.get(VALUE);
            ArrayList<Object> validValueList = new ArrayList<Object>(valueList.size());
            for (Object o : valueList) {
                if (o == null) continue;
                validValueList.add(o);
            }
            filterSchemeRows.add(new FilterSchemeRow(schemeRow.get(FIELD_NAME).get(0).toString(), CompareTypeEnum.createCompareTypeEnum((String)schemeRow.get(COMPARE).get(0).toString()), validValueList.stream().map(v -> v.toString()).collect(Collectors.toList()), schemeRow.get(LEFT) != null ? schemeRow.get(LEFT).get(0).toString() : "", schemeRow.get(RIGHT) != null ? schemeRow.get(RIGHT).get(0).toString() : "", LogicOperate.valueOf((String)(schemeRow.get(LOGIC) != null ? ("0".equals(schemeRow.get(LOGIC).toString()) ? AND : OR) : AND)), schemeRow.get(ID) != null ? schemeRow.get(ID).stream().map(v -> v.toString()).collect(Collectors.toList()) : new ArrayList<String>(0)));
        }
        return new FilterSchemeDto(filterSchemeRows, filterScheme.isFixed(), filterScheme.isShare());
    }

    private boolean checkRepeate(String schemeName, FilterScheme filterScheme, List<FilterScheme> allSchemeList) {
        if (allSchemeList.stream().anyMatch(p -> p.getLocaleFilterScheme().entrySet().stream().anyMatch(e -> schemeName.equals(((FilterSchemeL)e.getValue()).getName()) && (filterScheme == null || filterScheme != null && !filterScheme.getLocaleFilterScheme().entrySet().stream().anyMatch(f -> ((FilterSchemeL)f.getValue()).getName().equals(((FilterSchemeL)e.getValue()).getName())))))) {
            this.view.showTipNotification(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u540d\u79f0\u3002", (String)"FilterSchemeUIProxy_8", (String)BOS_FORM_METADATA, (Object[])new Object[0]), schemeName));
            return true;
        }
        return false;
    }

    private boolean isCurrentUserScheme(List<FilterScheme> allSchemeList, String schemeId) {
        if (StringUtils.isNotBlank((CharSequence)schemeId)) {
            for (FilterScheme filterScheme : allSchemeList) {
                if (!schemeId.equals(filterScheme.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public void deleteScheme(String schemeId) {
        List sharedSchemeList = this.isLookUp ? this.filterModel.getF7SharedSchemeList() : this.filterModel.getSharedSchemeList();
        List<FilterScheme> allSchemeList = this.getCurrentUserSchemeList(sharedSchemeList);
        if (!this.checkIsTheCurrentUserScheme(schemeId, allSchemeList)) {
            return;
        }
        StringBuilder errorMessage = new StringBuilder();
        SchemeQuery schemeQuery = new SchemeQuery();
        FilterScheme fScheme = schemeQuery.getScheme(schemeId);
        FilterSchemeUIProxy.checkFilterSchemeNull(fScheme);
        if (fScheme.isFixed()) {
            this.view.showErrorNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u65b9\u6848\u4e0d\u80fd\u5220\u9664\u3002", (String)"FilterSchemeUIProxy_12", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
            return;
        }
        for (FilterScheme filterScheme : sharedSchemeList) {
            if (!schemeId.equals(filterScheme.getId()) || RequestContext.get().getUserId().equals(Long.toString(filterScheme.getUserId()))) continue;
            if (this.filterModel.deleteShareUser(schemeId, errorMessage)) {
                this.clientViewProxy.invokeControlMethod(this.invokeMethodControlKey, "deleteScheme", schemeId);
                this.view.showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"FilterSchemeUIProxy_13", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
            } else {
                this.view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"FilterSchemeUIProxy_14", (String)BOS_FORM_METADATA, (Object[])new Object[0]), errorMessage));
            }
            return;
        }
        if (this.filterModel.deleteScheme(schemeId, errorMessage)) {
            this.clientViewProxy.invokeControlMethod(this.invokeMethodControlKey, "deleteScheme", schemeId);
            this.view.showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"FilterSchemeUIProxy_13", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
        } else {
            this.view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"FilterSchemeUIProxy_14", (String)BOS_FORM_METADATA, (Object[])new Object[0]), errorMessage));
        }
    }

    public void shareScheme(String schemeId) {
        this.shareScheme(schemeId, false);
    }

    public void shareF7Scheme(String schemeId) {
        this.shareScheme(schemeId, true);
    }

    private void shareScheme(String schemeId, boolean isf7) {
        List<FilterScheme> myFilterSchemesNotShare = this.getMySchemeListNotShare(isf7);
        if (!this.checkIsTheCurrentUserScheme(schemeId, myFilterSchemesNotShare)) {
            return;
        }
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setFormId("bos_share_filterscheme");
        baseShowParameter.setStatus(OperationStatus.ADDNEW);
        baseShowParameter.setCustomParam("schemeid", schemeId);
        List<String> properties = Collections.singletonList("usertype");
        String appNum = this.view.getFormShowParameter().getAppId();
        String userType = "";
        Log log = LogFactory.getLog(FilterSchemeUIProxy.class);
        StringBuilder builder = new StringBuilder();
        builder.append("shareScheme.appid: ").append(appNum);
        if (StringUtils.isNotBlank((CharSequence)appNum)) {
            DynamicObject appObject;
            DynamicObjectType bizappObjectType = EntityMetadataCache.getSubDataEntityType((String)"bos_devportal_bizapp", properties);
            Map objectDynamicObjectMap = BusinessDataReader.loadFromCache((DynamicObjectType)bizappObjectType, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)appNum)});
            Collection values = objectDynamicObjectMap.values();
            builder.append("shareScheme.bos_devportal_bizapp isEmpty: ").append(values.isEmpty());
            if (!values.isEmpty() && (appObject = (DynamicObject)values.stream().findFirst().get()).get("usertype") != null) {
                userType = appObject.getString("userType");
                builder.append("shareScheme.externalUserType: ").append(userType);
            }
        }
        log.info(builder.toString());
        if (StringUtils.isNotBlank((CharSequence)userType)) {
            baseShowParameter.setCustomParam("externalUserType", userType);
        }
        CloseCallBack closeCallBack = new CloseCallBack(this.view.getControl(this.invokeMethodControlKey).getClass().getName(), "shareScheme$" + schemeId + "$" + (this.billFormId == null ? "" : this.billFormId));
        closeCallBack.setControlKey(this.invokeMethodControlKey);
        baseShowParameter.setCloseCallBack(closeCallBack);
        SchemeWriter.copyIDToSchemeId((String)schemeId);
        SchemeQuery schemeQuery = new SchemeQuery();
        FilterScheme fScheme = schemeQuery.getScheme(schemeId);
        FilterSchemeUIProxy.checkFilterSchemeNull(fScheme);
        if (fScheme.isFixed()) {
            this.view.showErrorNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u65b9\u6848\u4e0d\u80fd\u5171\u4eab\u3002", (String)"FilterSchemeUIProxy_15", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
            return;
        }
        this.view.showForm(baseShowParameter);
    }

    private List<FilterScheme> getMySchemeListNotShare(boolean isf7) {
        IFilterModel schemeFilterModel = this.filterModel;
        schemeFilterModel.setFormId(this.formId);
        return isf7 ? schemeFilterModel.getF7SchemeList() : schemeFilterModel.getSchemeList();
    }

    public void updateShareScheme(String schemeId) {
        this.updateShareScheme(schemeId, false);
    }

    public void updateF7ShareScheme(String schemeId) {
        this.updateShareScheme(schemeId, true);
    }

    private void updateShareScheme(String schemeId, boolean isF7) {
        List<FilterScheme> myFilterSchemesNotShare = this.getMySchemeListNotShare(isF7);
        if (!this.checkIsTheCurrentUserScheme(schemeId, myFilterSchemesNotShare)) {
            return;
        }
        Long sharedSchemeId = this.filterModel.getSharedSchemeId(schemeId);
        if (sharedSchemeId == null) {
            this.shareScheme(schemeId);
            return;
        }
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setFormId("bos_share_filterscheme");
        baseShowParameter.setStatus(OperationStatus.EDIT);
        baseShowParameter.setPkId(sharedSchemeId);
        CloseCallBack closeCallBack = new CloseCallBack(this.view.getControl(this.invokeMethodControlKey).getClass().getName(), "shareScheme$" + schemeId + "$" + (this.billFormId == null ? "" : this.billFormId));
        closeCallBack.setControlKey(this.invokeMethodControlKey);
        baseShowParameter.setCloseCallBack(closeCallBack);
        this.view.showForm(baseShowParameter);
    }

    private boolean checkIsTheCurrentUserScheme(String schemeId, List<FilterScheme> myFilterSchemesNotShare) {
        boolean isCurrentUserScheme = this.isCurrentUserScheme(myFilterSchemesNotShare, schemeId);
        if (!isCurrentUserScheme) {
            this.view.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u65b9\u6848\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"FilterSchemeUIProxy_9", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
        }
        return isCurrentUserScheme;
    }
}

