/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.LoadingType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ClientMethodResult;
import kd.bos.form.IClientCallback;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.SignCallbackEvent;
import kd.bos.form.SignCallbackLisenter;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.StringUtils;
import kd.bos.script.annotations.KSMethod;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class ClientCallback
implements IClientCallback,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(ClientCallback.class);
    private IFormView view;
    private Map<String, String> optionVariables;
    private String operateKey;
    private boolean is_FirstSave;
    private SignClientType type = SignClientType.Standard;
    protected List<SignCallbackLisenter> signCallbackLisenter;
    private List<String> signCallbackPlugins = new ArrayList<String>();
    private String clearText;
    private Map<String, String> customParameter = new HashMap<String, String>();
    private String callbackId;
    private static final String BOS_FORM_METADATA = "bos-form-metadata";

    public ClientCallback() {
    }

    public ClientCallback(String operateKey) {
        this.operateKey = operateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCallClientMethod(ClientMethodResult ret) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8c03\u7528\u7c7b\u578b\u4e3a: %s", (String)"ClientCallback_4", (String)BOS_FORM_METADATA, (Object[])new Object[0]), this.type.getValue()));
            if (this.type == SignClientType.Secondry) {
                builder.append(String.format(ResManager.loadKDString((String)"secondry \u5c06\u89e6\u53d1\u63d2\u4ef6\u7b7e\u540d\u56de\u8c03\u4e8b\u4ef6.\u5ba2\u6237\u7aef\u7b7e\u540d\u7ed3\u679c\u4e3a\uff1a %1$s, \u7b7e\u540d\u5185\u5bb9\u4e3a\uff1a %2$s", (String)"ClientCallback_5", (String)BOS_FORM_METADATA, (Object[])new Object[0]), ret.getSuccess(), SerializationUtils.toJsonString(ret.getResult())));
                this.fireSignCallback(ret);
                builder.append(ResManager.loadKDString((String)"\u63d2\u4ef6\u8c03\u7528\u7ed3\u675f", (String)"ClientCallback_3", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
            } else {
                boolean firstSave = false;
                Object Id2 = this.getView().getModel().getDataEntity().getPkValue();
                if (this.getView() instanceof IBillView && ("0".equals(Id2.toString()) || StringUtils.isEmpty((Object)Id2.toString()))) {
                    firstSave = true;
                }
                IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
                if (ret.getSuccess().booleanValue()) {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("signCallbackFlag", "true");
                    for (Map.Entry<String, String> entry : this.getOptionVariables().entrySet()) {
                        option.setVariableValue(entry.getKey(), entry.getValue());
                    }
                    option.setVariableValue("signResult", SerializationUtils.toJsonString(ret.getResult()));
                    option.setVariableValue("clearResult", cache.get("clearText"));
                    option.setVariableValue("signFirstSave", String.valueOf(firstSave));
                    this.getView().invokeOperation(this.getOperateKey(), option);
                } else {
                    builder.append(ResManager.loadKDString((String)"\u5ba2\u6237\u7aef\u7b7e\u540d\u5931\u8d25\uff01", (String)"ClientCallback_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
                }
            }
            log.info(builder.toString());
        }
        finally {
            this.showLoading(this.view, null, false);
        }
    }

    private void showLoading(IFormView view, String msg, boolean visible) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("text", msg);
        paraMap.put("type", LoadingType.Default.getType());
        paraMap.put("visible", visible);
        paraMap.put("pageId", view.getPageId());
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction("setPageLoading", paraMap);
    }

    public void fireSignCallback(ClientMethodResult ret) {
        SignCallbackEvent evt = new SignCallbackEvent(this, ret, this.getView(), this.clearText, this.optionVariables, this.getCustomParameter(), this.callbackId);
        this.loadSignCallbackLisenter();
        if (this.signCallbackLisenter != null) {
            log.debug("\u63d2\u4ef6\u76d1\u542c\u5668\u4e0d\u4e3a\u7a7a\uff0csize\uff1a" + this.signCallbackLisenter.size());
            for (SignCallbackLisenter l : this.signCallbackLisenter) {
                l.signCallback(evt);
            }
        }
    }

    private void loadSignCallbackLisenter() {
        for (String clzName : this.signCallbackPlugins) {
            if (clzName == null) continue;
            try {
                Class<?> clz = Class.forName(clzName);
                Object newInst = clz.newInstance();
                if (!(newInst instanceof SignCallbackLisenter)) continue;
                SignCallbackLisenter lisenter = (SignCallbackLisenter)newInst;
                if (newInst instanceof IFormPlugin) {
                    ((IFormPlugin)((Object)lisenter)).setView(this.getView());
                }
                if (this.signCallbackLisenter == null) {
                    this.signCallbackLisenter = new ArrayList<SignCallbackLisenter>();
                }
                this.signCallbackLisenter.add(lisenter);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25\uff01", (String)"ClientCallback_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
                throw new KDException((Throwable)e, BosErrorCode.beanNotOfRequiredType, new Object[]{ResManager.loadKDString((String)"\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25", (String)"ClientCallback_2", (String)BOS_FORM_METADATA, (Object[])new Object[0])});
            }
        }
    }

    @KSMethod
    public void addSignCallbackLisenter(SignCallbackLisenter listener) {
        if (this.signCallbackPlugins == null) {
            this.signCallbackPlugins = new ArrayList<String>();
        }
        String clzName = listener.getClass().getCanonicalName();
        this.signCallbackPlugins.add(clzName);
    }

    private String getFormId() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (this.getView() instanceof IListView) {
            formId = ((IListView)this.getView()).getBillFormId();
        }
        return formId;
    }

    public String getOperateKey() {
        return this.operateKey;
    }

    public void setOperateKey(String operateKey) {
        this.operateKey = operateKey;
    }

    public Map<String, String> getOptionVariables() {
        return this.optionVariables;
    }

    public void setOptionVariables(Map<String, String> optionVariables) {
        this.optionVariables = optionVariables;
    }

    public IFormView getView() {
        return this.view;
    }

    public void setView(IFormView view) {
        this.view = view;
    }

    public boolean isFirstSave() {
        return this.is_FirstSave;
    }

    public void setFirstSave(boolean isFirstSave) {
        this.is_FirstSave = isFirstSave;
    }

    public SignClientType getType() {
        return this.type;
    }

    public void setType(SignClientType type) {
        this.type = type;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    public void setCallbackId(String callbackId) {
        this.callbackId = callbackId;
    }

    public String getClearText() {
        return this.clearText;
    }

    public void setClearText(String clearText) {
        this.clearText = clearText;
    }

    public Map<String, String> getCustomParameter() {
        return this.customParameter;
    }

    public void setCustomParameter(Map<String, String> customParameter) {
        this.customParameter = customParameter;
    }

    public List<SignCallbackLisenter> getSignCallbackLisenter() {
        return this.signCallbackLisenter;
    }

    public void setSignCallbackLisenter(List<SignCallbackLisenter> signCallbackLisenter) {
        this.signCallbackLisenter = signCallbackLisenter;
    }

    public List<String> getSignCallbackPlugins() {
        return this.signCallbackPlugins;
    }

    public void setSignCallbackPlugins(List<String> signCallbackPlugins) {
        this.signCallbackPlugins = signCallbackPlugins;
    }

    public static enum SignClientType {
        Standard("1"),
        Secondry("2");

        private String val;

        private SignClientType(String val) {
            this.val = val;
        }

        public String getValue() {
            return this.val;
        }
    }
}

