/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import java.util.ArrayList;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.parameter.MobileListParam;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class CoreShowFormHelper {
    private static final String LISTFILTERPARAMETER = "listFilterParameter";
    private static final String PRIMARYFIELD = "primaryField";
    private static final String PAGEROW = "pageRow";

    public static ListShowParameter createShowListForm(ListParamCreateOption option) {
        return CoreShowFormHelper.createShowListForm(option.getFormId(), option.isMultiSelect(), option.getF7Style(), option.isLookUp());
    }

    public static ListShowParameter createShowListForm(String formId, boolean isMultiSelect) {
        return CoreShowFormHelper.createShowListForm(formId, isMultiSelect, 0);
    }

    @SdkInternal
    public static ListShowParameter createShowListForm(String formId, boolean isMultiSelect, int f7Style) {
        return CoreShowFormHelper.createShowListForm(formId, isMultiSelect, f7Style, true);
    }

    @SdkInternal
    public static ListShowParameter createShowListForm(String formId, boolean isMultiSelect, int f7Style, boolean isLookUP) {
        ListShowParameter para = new ListShowParameter();
        para.setLookUp(isLookUP);
        para.setBillFormId(formId);
        if (isLookUP) {
            para.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            css.setWidth("960px");
            css.setHeight("580px");
            para.getOpenStyle().setInlineStyleCss(css);
            para.setFormId(CoreShowFormHelper.getListFormId(formId, f7Style));
            para.setF7Style(f7Style);
        } else {
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            FormConfig formConfig = FormMetadataCache.getListFormConfig(formId);
            para.setFormId(formConfig.getListFormId());
        }
        para.setMultiSelect(isMultiSelect);
        para.setShowTitle(false);
        para.setHasRight(true);
        return para;
    }

    private static String getListFormId(String formId, int f7Style) {
        FormConfig formConfig = FormMetadataCache.getListFormConfig(formId);
        switch (f7Style) {
            case 1: {
                if ("bos_user".equals(formId)) {
                    return formConfig.getF7ListFormId();
                }
                return "bos_orgtreelistf7";
            }
            case 2: {
                return "bos_listf7";
            }
        }
        if (formConfig == null) {
            return formId;
        }
        return formConfig.getF7ListFormId();
    }

    private static String serializeListShowParameter(ListShowParameter listShowParameter) {
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>();
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(MobileListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRowCollection.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRow.class));
        DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
        return dcJsonSerializer.serializeToString((Object)listShowParameter, null);
    }

    private static String serializeMobileListParam(MobileListParam mobileListParam) {
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>();
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(MobileListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRowCollection.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRow.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(MobileListParam.class));
        DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
        return dcJsonSerializer.serializeToString((Object)mobileListParam, null);
    }

    @Deprecated
    @SdkInternal
    public static FormShowParameter createMobileListF7ShowForm(String key, ListShowParameter listFilterParameter, String primaryField, String secondField, String iconField, boolean showModal, int pageRow) {
        MobileFormShowParameter para = new MobileFormShowParameter();
        para.setFormId("bos_moblistf7");
        para.getOpenStyle().setShowType(ShowType.Floating);
        if (showModal) {
            para.getOpenStyle().setShowType(ShowType.Modal);
        }
        para.setCustomParam(LISTFILTERPARAMETER, CoreShowFormHelper.serializeListShowParameter(listFilterParameter));
        para.setCustomParam(PRIMARYFIELD, primaryField);
        para.setCustomParam("secondField", secondField);
        para.setCustomParam("iconField", iconField);
        para.setCustomParam("showModal", showModal);
        para.setCustomParam(PAGEROW, pageRow);
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(key);
        para.setCloseCallBack(closeCallBack);
        return para;
    }

    @SdkInternal
    public static FormShowParameter createMobileListF7ShowForm(String key, MobileListParam mobileListParam) {
        MobileFormShowParameter para = new MobileFormShowParameter();
        para.setFormId("bos_moblistf7");
        para.getOpenStyle().setShowType(ShowType.Floating);
        if (mobileListParam.isShowModal()) {
            para.getOpenStyle().setShowType(ShowType.Modal);
        }
        para.setCustomParam("mobileListParam", CoreShowFormHelper.serializeMobileListParam(mobileListParam));
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(key);
        para.setCloseCallBack(closeCallBack);
        return para;
    }

    @Deprecated
    @SdkInternal
    public static FormShowParameter createMobileTreeListF7ShowForm(String key, ListShowParameter listFilterParameter, String primaryField, int pageRow) {
        MobileFormShowParameter para = new MobileFormShowParameter();
        para.setFormId("bos_mobtreelistf7");
        para.getOpenStyle().setShowType(ShowType.Floating);
        para.setCustomParam(LISTFILTERPARAMETER, CoreShowFormHelper.serializeListShowParameter(listFilterParameter));
        para.setCustomParam(PRIMARYFIELD, primaryField);
        para.setCustomParam(PAGEROW, pageRow);
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(key);
        para.setCloseCallBack(closeCallBack);
        return para;
    }

    @SdkInternal
    public static FormShowParameter createMobileTreeListF7ShowForm(String key, MobileListParam mobileListParam) {
        MobileFormShowParameter para = new MobileFormShowParameter();
        para.setFormId("bos_mobtreelistf7");
        para.getOpenStyle().setShowType(ShowType.Floating);
        para.setCustomParam("mobileListParam", CoreShowFormHelper.serializeMobileListParam(mobileListParam));
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(key);
        para.setCloseCallBack(closeCallBack);
        return para;
    }

    @SdkInternal
    public static FormShowParameter createDateSelectShowForm(String key, String value, String editor, boolean isStart, String minDate, String maxDate) {
        MobileFormShowParameter para = new MobileFormShowParameter();
        para.setFormId("bos_dateselect");
        para.getOpenStyle().setShowType(ShowType.Floating);
        para.setCustomParam("isStart", isStart);
        para.setCustomParam("value", value);
        para.setCustomParam("editor", editor);
        para.setCustomParam("minDate", minDate);
        para.setCustomParam("maxDate", maxDate);
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(key);
        para.setCloseCallBack(closeCallBack);
        return para;
    }

    @SdkInternal
    public static String getBizAppId(FormShowParameter showParameter) {
        String formId;
        if (StringUtils.isNotBlank((CharSequence)showParameter.getAppId())) {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)showParameter.getAppId());
            return appInfo.getId();
        }
        String entityTypeId = null;
        entityTypeId = showParameter instanceof ListShowParameter ? (StringUtils.isBlank((CharSequence)(formId = ((ListShowParameter)showParameter).getBillFormId())) ? showParameter.getFormId() : FormMetadataCache.getFormConfig(formId).getEntityTypeId()) : (showParameter instanceof BillShowParameter || showParameter instanceof MobileFormShowParameter ? showParameter.getFormConfig().getEntityTypeId() : showParameter.getFormId());
        BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
        return bizAppService.getAppIdByFormNum(entityTypeId);
    }

    public static class ListParamCreateOption {
        private String formId;
        private boolean isMultiSelect = true;
        private boolean lookUp = true;
        private int f7Style = 0;

        public ListParamCreateOption(String formId, boolean isMultiSelect) {
            this.formId = formId;
            this.isMultiSelect = isMultiSelect;
        }

        public ListParamCreateOption(String formId, boolean isMultiSelect, int f7Style) {
            this.formId = formId;
            this.isMultiSelect = isMultiSelect;
            this.f7Style = f7Style;
        }

        public ListParamCreateOption(String formId, boolean isMultiSelect, int f7Style, boolean lookUp) {
            this.formId = formId;
            this.isMultiSelect = isMultiSelect;
            this.lookUp = lookUp;
            this.f7Style = f7Style;
        }

        public String getFormId() {
            return this.formId;
        }

        public void setFormId(String formId) {
            this.formId = formId;
        }

        public int getF7Style() {
            return this.f7Style;
        }

        public void setF7Style(int f7Style) {
            this.f7Style = f7Style;
        }

        public boolean isMultiSelect() {
            return this.isMultiSelect;
        }

        public void setMultiSelect(boolean multiSelect) {
            this.isMultiSelect = multiSelect;
        }

        public boolean isLookUp() {
            return this.lookUp;
        }

        public void setLookUp(boolean lookUp) {
            this.lookUp = lookUp;
        }
    }
}

