/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.gray.MetaGrayInfo;
import kd.bos.entity.operate.IOperate;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.rule.AbstractRule;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.BinderMap;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataLocalCache;
import kd.bos.form.FormMetadataProvide;
import kd.bos.form.IFormMetadataProvide;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.instance.AppGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metagray.MetaGrayService;
import kd.bos.sharemeta.ShareMetaUtil;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FormMetadataCache {
    private static IFormMetadataProvide provide;
    private static Log log;

    @SdkInternal
    public static IFormMetadataProvide getFormMetadataProvide() {
        if (provide == null) {
            provide = ShareMetaUtil.enableShareMeta() ? (IFormMetadataProvide)TypesContainer.createInstance((String)"kd.bos.form.FormMetadataShareProvider") : new FormMetadataProvide();
        }
        return provide;
    }

    @SdkInternal
    public static void setFormMetadataProvide(IFormMetadataProvide pro) {
        provide = pro;
    }

    public static String getFormAppId(String formId) {
        try {
            FormConfig formConfig = FormMetadataCache.getFormConfig(formId);
            return formConfig.getAppId();
        }
        catch (KDException e) {
            String appId = "";
            if (e.getErrorCode().getCode().equals(BosErrorCode.metaNotFound.getCode()) && AppGroup.isGrayUpgrade()) {
                MetaGrayService mgs = new MetaGrayService();
                MetaGrayInfo mgi = mgs.getMetaGrayInfo(formId);
                if (mgi != null) {
                    appId = mgi.getMainAppId();
                }
                log.info("traceid:{} formid:{} - getFormConfig metaNotFound, getMetaGrayInfo(t_meta_graymeta).appId:{}", new Object[]{RequestContext.get().getTraceId(), formId, appId});
            }
            if (StringUtils.isBlank((CharSequence)appId)) {
                throw e;
            }
            return appId;
        }
    }

    public static FormConfig getFormConfig(String formId) {
        if (formId == null) {
            throw new IllegalArgumentException(" getFormConfig(String formId), formId==null");
        }
        return FormMetadataCache.getFormMetadataProvide().getFormConfig(formId.toLowerCase());
    }

    public static FormRoot getRootControl(String formId) {
        return FormMetadataCache.getFormMetadataProvide().getRootControl(formId.toLowerCase());
    }

    @SdkInternal
    public static List<String> getHeadDecimalFields(String formId) {
        return FormMetadataCache.getFormMetadataProvide().getHeadDecimalFields(formId.toLowerCase());
    }

    @SdkInternal
    public static List<String> getHeadDateTimeFields(String formId) {
        return FormMetadataCache.getFormMetadataProvide().getHeadDateTimeFields(formId.toLowerCase());
    }

    public static <T extends Control> T getControl(String formId, String key) {
        return FormMetadataCache.getFormMetadataProvide().getControl(formId, key);
    }

    @SdkInternal
    public static BinderMap getBinderMap(String formId) {
        return FormMetadataCache.getFormMetadataProvide().getBinderMap(formId);
    }

    @SdkInternal
    public static Map<String, List<AbstractRule>> getAllEntityRules(String formId) {
        return FormMetadataCache.getFormMetadataProvide().getAllEntityRules(formId);
    }

    public static IOperate getFormOperation(String entityId, String operationKey) {
        return FormMetadataCache.getFormMetadataProvide().getFormOperation(entityId.toLowerCase(), operationKey.toLowerCase());
    }

    @SdkInternal
    public static AbstractOperateWebApi getFormOperationApi(String entityId, String opNumber) {
        return FormMetadataCache.getFormMetadataProvide().getFormOperationApi(entityId.toLowerCase(), opNumber.toLowerCase());
    }

    @SdkInternal
    public static String getFormPluginScripts(String formId, String key) {
        return FormMetadataCache.getFormMetadataProvide().getFormPluginScripts(formId, key);
    }

    public static Map<String, Object> getMobFilterMeta(String formId) {
        return FormMetadataCache.getFormMetadataProvide().getMobFilterMeta(formId);
    }

    public static Map<String, Object> getMobListMeta(String formId) {
        return FormMetadataCache.getFormMetadataProvide().getMobListMeta(formId);
    }

    public static Map<String, Object> getListMeta(String formId) {
        return FormMetadataCache.getFormMetadataProvide().getListMeta(formId);
    }

    public static Map<String, Object> getFilterMeta(String formId) {
        return FormMetadataCache.getFormMetadataProvide().getFilterMeta(formId);
    }

    @SdkInternal
    public static Map<String, Object> getListToolBar(String formId) {
        return FormMetadataCache.getFormMetadataProvide().getListToolBar(formId);
    }

    public static Object getListQingView(String billFormId) {
        return FormMetadataCache.getFormMetadataProvide().getListQingView(billFormId);
    }

    public static FormConfig getListFormConfig(String formId) {
        return FormMetadataCache.getFormMetadataProvide().getListFormConfig(formId);
    }

    public static FormConfig getMobListFormConfig(String formId) {
        return FormMetadataCache.getFormMetadataProvide().getMobListFormConfig(formId);
    }

    public static TreeNode getEntityTypeTree(EntityType dt) {
        TreeNode root = new TreeNode();
        root.setId(dt.getName());
        if (dt.getDisplayName() != null) {
            root.setText((String)dt.getDisplayName().getDefaultItem());
        } else {
            root.setText(dt.getName());
        }
        FormMetadataCache.addNodes((IDataEntityType)dt, root, null);
        return root;
    }

    private static TreeNode addNodes(IDataEntityType dt, TreeNode root, String parentKey) {
        TreeNode node = new TreeNode();
        String id = null;
        for (IDataEntityProperty prop : dt.getProperties()) {
            id = StringUtils.isBlank((CharSequence)parentKey) ? prop.getName() : parentKey + "." + id;
            if (prop instanceof BasedataProp) {
                node.setId(id);
                node.setText((String)((BasedataProp)prop).getDisplayName().getDefaultItem());
                FormMetadataCache.addNodes(((BasedataProp)prop).getComplexType(), node, id);
            } else if (prop instanceof FieldProp) {
                node.setId(prop.getName());
                node.setText((String)((FieldProp)prop).getDisplayName().getDefaultItem());
            } else if (prop instanceof EntryProp) {
                node.setId(prop.getName());
                node.setText((String)((EntryProp)prop).getDisplayName().getDefaultItem());
                FormMetadataCache.addNodes(((EntryProp)prop).getItemType(), node, null);
            }
            root.addChild(node);
        }
        return root;
    }

    @SdkInternal
    public static void removeLocalCache(String number) {
        FormMetadataCache.removeLocalCache("", number);
    }

    @SdkInternal
    public static void removeLocalCache(String appGroup, String number) {
        FormMetadataLocalCache.remove(appGroup, number);
    }

    static {
        log = LogFactory.getLog(FormMetadataCache.class);
    }
}

