/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import java.util.ArrayList;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.form.FormMetadataLocalDiskCache;
import kd.bos.sharemeta.ShareMetaUtil;
import org.jetbrains.annotations.Nullable;

class FormMetadataLocalCache {
    private static final String CONFIG = "Config";
    private static final String FILTER = "Filter";
    private static final String QINGVIEW = "qingview";
    private static final String TOOL_BAR = "ToolBar";
    private static final String LIST = "List";
    private static final String[] KEYSTOCLEAR;
    private static final String LOCALCACHE_MAXITEMSIZE = "meta.localcache.form.maxitemsize";
    private static final String LOCALCACHE_TIMEOUT = "meta.localcache.form.timeout";
    private static int configMaxItemSize;
    private static int configTimeout;
    private static boolean mergeRegion;

    private FormMetadataLocalCache() {
    }

    private static LocalMemoryCache getLocalCache(String formId) {
        String acctId = CacheKeyUtil.getAcctId();
        String region = ShareMetaUtil.getLocalCacheRegion((String)acctId, (String)formId);
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(configTimeout);
        info.setMaxItemSize(configMaxItemSize);
        return FormMetadataLocalCache.getOrCreateLocalCache(info, region);
    }

    private static LocalMemoryCache getOrCreateLocalCache(CacheConfigInfo info, String cacheRegion) {
        String region = cacheRegion;
        if (mergeRegion) {
            region = "metadata";
        }
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, "FormMetadata", info);
    }

    public static void cacheRuntimeMetaTypeMeta(String formId, RuntimeMetaType runtimeMetaType, Object value) {
        FormMetadataLocalCache.getLocalCache(formId).put(FormMetadataLocalCache.getCacheKey(runtimeMetaType, formId), value);
    }

    public static <T> T getRuntimeMetaTypeMeta(String formId, RuntimeMetaType runtimeMetaType) {
        return (T)FormMetadataLocalCache.getLocalCache(formId).get(FormMetadataLocalCache.getCacheKey(runtimeMetaType, formId));
    }

    public static void cacheRuntimeMetaTypeMeta(String formId, RuntimeMetaType runtimeMetaType, String key, Object value) {
        String cacheKey = FormMetadataLocalCache.getCacheKey(runtimeMetaType, formId, key);
        FormMetadataLocalCache.getLocalCache(formId).put(cacheKey, value);
    }

    public static <T> T getRuntimeMetaTypeMeta(String formId, RuntimeMetaType runtimeMetaType, String key) {
        String cacheKey = FormMetadataLocalCache.getCacheKey(runtimeMetaType, formId, key);
        return (T)FormMetadataLocalCache.getLocalCache(formId).get(cacheKey);
    }

    public static String getFormConfig(String formId) {
        return FormMetadataLocalCache.getValue(RuntimeMetaType.Config, formId);
    }

    public static void putFormConfig(String formId, String strConfig) {
        FormMetadataLocalCache.putValue(RuntimeMetaType.Config, formId, strConfig);
    }

    public static String getRootControl(String formId) {
        return FormMetadataLocalCache.getValue(RuntimeMetaType.Form, formId);
    }

    public static void putRootControl(String formId, String formMetaStr) {
        FormMetadataLocalCache.putValue(RuntimeMetaType.Form, formId, formMetaStr);
    }

    public static String getAllEntityRules(String formId) {
        return FormMetadataLocalCache.getValue(RuntimeMetaType.Rule, formId);
    }

    public static void putAllEntityRules(String formId, String formRulesStr) {
        FormMetadataLocalCache.putValue(RuntimeMetaType.Rule, formId, formRulesStr);
    }

    public static void remove(String number) {
        FormMetadataLocalCache.remove("", number);
    }

    public static void remove(String appGroup, String number) {
        LocalMemoryCache localCache = FormMetadataLocalCache.getLocalCache(number);
        ArrayList<String> keys = new ArrayList<String>(10);
        for (RuntimeMetaType runtimeMetaType : RuntimeMetaType.values()) {
            keys.add(FormMetadataLocalCache.getCacheKey(appGroup, number, runtimeMetaType, null));
        }
        for (String string : KEYSTOCLEAR) {
            keys.add(FormMetadataLocalCache.getCacheKey(appGroup, number, RuntimeMetaType.List, string));
        }
        for (String string : KEYSTOCLEAR) {
            keys.add(FormMetadataLocalCache.getCacheKey(appGroup, number, RuntimeMetaType.MobList, string));
        }
        keys.add(FormMetadataLocalCache.getCacheKey(appGroup, number, RuntimeMetaType.DecimalFields, null));
        keys.add(FormMetadataLocalCache.getCacheKey(appGroup, number, RuntimeMetaType.DateTimeFields, null));
        localCache.remove(keys.toArray(new String[0]));
        FormMetadataLocalDiskCache.remove(appGroup, number);
    }

    @Nullable
    private static String getValue(RuntimeMetaType metaType, String formId) {
        String key = FormMetadataLocalCache.getCacheKey(metaType, formId);
        LocalMemoryCache localCache = FormMetadataLocalCache.getLocalCache(formId);
        String val = (String)localCache.get(key);
        if (val == null && (val = FormMetadataLocalDiskCache.get(metaType, formId, null)) != null) {
            localCache.put(key, (Object)val);
        }
        return val;
    }

    private static void putValue(RuntimeMetaType metaType, String formId, String val) {
        String key = FormMetadataLocalCache.getCacheKey(metaType, formId);
        LocalMemoryCache localCache = FormMetadataLocalCache.getLocalCache(formId);
        localCache.put(key, (Object)val);
        FormMetadataLocalDiskCache.put(metaType, formId, null, val);
    }

    private static String getCacheKey(RuntimeMetaType runtimeMetaType, String formId) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        return FormMetadataLocalCache.getCacheKey(appGroup, formId, runtimeMetaType, null);
    }

    static String getCacheKey(RuntimeMetaType runtimeMetaType, String formId, String key) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        return FormMetadataLocalCache.getCacheKey(appGroup, formId, runtimeMetaType, key);
    }

    static String getCacheKey(String appGroup, String formId, RuntimeMetaType runtimeMetaType, String key) {
        String cacheKey = "";
        if (mergeRegion) {
            cacheKey = ShareMetaUtil.getLocalCacheRegion((String)CacheKeyUtil.getAcctId(), (String)formId) + ".";
        }
        if (StringUtils.isNotBlank((CharSequence)appGroup) && !"defaultGroup".equals(appGroup)) {
            cacheKey = cacheKey + appGroup + ".";
        }
        cacheKey = cacheKey + formId + "." + runtimeMetaType.getValue();
        if (StringUtils.isNotBlank((CharSequence)key)) {
            cacheKey = cacheKey + "." + key;
        }
        return cacheKey.toLowerCase();
    }

    static {
        String timeoutStr;
        KEYSTOCLEAR = new String[]{CONFIG, FILTER, QINGVIEW, TOOL_BAR, LIST};
        configMaxItemSize = 10000;
        configTimeout = 43200;
        mergeRegion = true;
        String itemSizeStr = System.getProperty(LOCALCACHE_MAXITEMSIZE);
        if (StringUtils.isNotBlank((CharSequence)itemSizeStr)) {
            configMaxItemSize = Integer.parseInt(itemSizeStr);
        }
        if (StringUtils.isNotBlank((CharSequence)(timeoutStr = System.getProperty(LOCALCACHE_TIMEOUT)))) {
            configTimeout = Integer.parseInt(timeoutStr);
        }
        mergeRegion = Boolean.getBoolean("meta.localcache.mergeregion");
    }
}

