/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import java.util.ArrayList;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.EhcacheStoreType;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.form.FormMetadataLocalCache;
import kd.bos.sharemeta.ShareMetaUtil;

public class FormMetadataLocalDiskCache {
    private static final String[] KEYSTOCLEAR;
    private static boolean enableLocalDiskCache;
    private static final String LOCALDISKCACHE_MAXMEMSIZE = "meta.localdiskcache.form.maxmemsize";
    private static final String LOCALDISKCACHE_TIMEOUT = "meta.localdiskcache.form.timeout";
    private static int configDiskMaxMemSize;
    private static int configDiskTimeout;
    private static boolean mergeRegion;

    private static LocalMemoryCache getLocalDiskCache(String formId) {
        String acctId = CacheKeyUtil.getAcctId();
        String region = ShareMetaUtil.getLocalCacheRegion((String)acctId, (String)formId);
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(configDiskTimeout);
        info.setMaxMemSize(configDiskMaxMemSize);
        return FormMetadataLocalDiskCache.getOrCreateLocalCache(info, region);
    }

    private static LocalMemoryCache getOrCreateLocalCache(CacheConfigInfo info, String cacheRegion) {
        String region = cacheRegion;
        if (mergeRegion) {
            region = "metadata";
        }
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, "FormMetadata", info, EhcacheStoreType.Disk);
    }

    static String get(RuntimeMetaType metaType, String formId, String key) {
        if (enableLocalDiskCache) {
            String region = FormMetadataLocalDiskCache.getRegion(formId);
            String cacheKey = FormMetadataLocalCache.getCacheKey(metaType, formId, key);
            return (String)ThreadCache.get((Object)("meta.form." + metaType.getValue() + "." + cacheKey), () -> (String)FormMetadataLocalDiskCache.getLocalDiskCache(region).get(cacheKey));
        }
        return null;
    }

    static void put(RuntimeMetaType metaType, String formId, String key, String val) {
        if (enableLocalDiskCache) {
            String region = FormMetadataLocalDiskCache.getRegion(formId);
            String cacheKey = FormMetadataLocalCache.getCacheKey(metaType, formId, key);
            FormMetadataLocalDiskCache.getLocalDiskCache(region).put(cacheKey, (Object)val);
            ThreadCache.put((Object)("meta.form." + metaType.getValue() + "." + cacheKey), (Object)val);
        }
    }

    static void remove(String appGroup, String number) {
        if (!enableLocalDiskCache) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(10);
        for (RuntimeMetaType runtimeMetaType : RuntimeMetaType.values()) {
            keys.add(FormMetadataLocalDiskCache.getCacheKey(appGroup, number, runtimeMetaType, null));
        }
        for (String string : KEYSTOCLEAR) {
            keys.add(FormMetadataLocalDiskCache.getCacheKey(appGroup, number, RuntimeMetaType.List, string));
        }
        for (String string : KEYSTOCLEAR) {
            keys.add(FormMetadataLocalDiskCache.getCacheKey(appGroup, number, RuntimeMetaType.MobList, string));
        }
        keys.add(FormMetadataLocalDiskCache.getCacheKey(appGroup, number, RuntimeMetaType.DecimalFields, null));
        keys.add(FormMetadataLocalDiskCache.getCacheKey(appGroup, number, RuntimeMetaType.DateTimeFields, null));
        String string = CacheKeyUtil.getAcctId();
        String region = ShareMetaUtil.getLocalCacheRegion((String)string, (String)number);
        FormMetadataLocalDiskCache.getLocalDiskCache(region).remove(keys.toArray(new String[0]));
    }

    private static String getRegion(String formId) {
        String acctId = CacheKeyUtil.getAcctId();
        return ShareMetaUtil.getLocalCacheRegion((String)acctId, (String)formId);
    }

    private static String getCacheKey(String appGroup, String formId, RuntimeMetaType runtimeMetaType, String key) {
        return FormMetadataLocalCache.getCacheKey(appGroup, formId, runtimeMetaType, key);
    }

    static {
        String timeoutStr;
        KEYSTOCLEAR = new String[]{"Config", "Filter", "qingview", "ToolBar", "List"};
        enableLocalDiskCache = false;
        configDiskMaxMemSize = 3072;
        configDiskTimeout = 43200;
        mergeRegion = true;
        enableLocalDiskCache = Boolean.getBoolean("meta.localdiskcache.form.enable");
        String itemSizeStr = System.getProperty(LOCALDISKCACHE_MAXMEMSIZE);
        if (StringUtils.isNotBlank((CharSequence)itemSizeStr)) {
            configDiskMaxMemSize = Integer.parseInt(itemSizeStr);
        }
        if (StringUtils.isNotBlank((CharSequence)(timeoutStr = System.getProperty(LOCALDISKCACHE_TIMEOUT)))) {
            configDiskTimeout = Integer.parseInt(timeoutStr);
        }
        mergeRegion = Boolean.getBoolean("meta.localcache.mergeregion");
    }
}

