/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.IOperate;
import kd.bos.entity.operate.OperationType;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.util.StringUtils;

public class FormOperateTypes {
    private static Map<String, String> types = new HashMap<String, String>();
    private static final String KD_BOS_ENTITY_OPERATE_STATUS_CONVERT = "kd.bos.entity.operate.StatusConvert";
    private static final String BOS_FORM_METADATA = "bos-form-metadata";

    public static void register(String type, String className) {
        types.put(type, className);
    }

    public static IOperate createFormOperate(Map<String, Object> opMeta) {
        String type = (String)opMeta.get("type");
        String typeName = types.get(type);
        if (typeName == null || StringUtils.isBlank((String)typeName)) {
            OperationType opType = OperationTypeCache.LoadSingle((String)type);
            if (opType == null || StringUtils.isBlank((String)opType.getFormServiceClass())) {
                throw new KDException(BosErrorCode.cannotLoadBeanClass, new Object[]{String.format(ResManager.loadKDString((String)"%s \u64cd\u4f5c\u672a\u5b9a\u4e49\u5b9e\u73b0\u7c7b\uff01", (String)"FormOperateTypes_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), type)});
            }
            FormOperateTypes.register(type, opType.getFormServiceClass());
            typeName = types.get(type);
        }
        Class cls = TypesContainer.getOrRegister((String)typeName);
        AbstractOperate opInst = (AbstractOperate)TypesContainer.createInstance((Class)cls);
        opInst.initialize(opMeta);
        return opInst;
    }

    static {
        FormOperateTypes.register("enable", KD_BOS_ENTITY_OPERATE_STATUS_CONVERT);
        FormOperateTypes.register("disable", KD_BOS_ENTITY_OPERATE_STATUS_CONVERT);
        FormOperateTypes.register("draft", "kd.bos.entity.operate.Draft");
        FormOperateTypes.register("save", "kd.bos.entity.operate.Save");
        FormOperateTypes.register("saveandnew", "kd.bos.entity.operate.SaveAndNew");
        FormOperateTypes.register("submit", "kd.bos.entity.operate.Submit");
        FormOperateTypes.register("submitandnew", "kd.bos.entity.operate.SubmitAndNew");
        FormOperateTypes.register("unsubmit", "kd.bos.entity.operate.UnSubmit");
        FormOperateTypes.register("audit", "kd.bos.entity.operate.Audit");
        FormOperateTypes.register("unaudit", "kd.bos.entity.operate.UnAudit");
        FormOperateTypes.register("load", "kd.bos.entity.operate.DefaultEntityOperate");
        FormOperateTypes.register("delete", "kd.bos.entity.operate.Delete");
        FormOperateTypes.register("donothing", "kd.bos.entity.operate.Donothing");
        FormOperateTypes.register("statusconvert", KD_BOS_ENTITY_OPERATE_STATUS_CONVERT);
        FormOperateTypes.register("invalid", "kd.bos.entity.operate.Invalid");
        FormOperateTypes.register("valid", "kd.bos.entity.operate.Valid");
        FormOperateTypes.register("pushandsave", "kd.bos.entity.operate.PushAndSave");
        FormOperateTypes.register("newentry", "kd.bos.form.operate.formop.NewEntry");
        FormOperateTypes.register("deleteentry", "kd.bos.form.operate.formop.DeleteEntry");
        FormOperateTypes.register("insertentry", "kd.bos.form.operate.formop.InsertEntry");
        FormOperateTypes.register("copyentryrow", "kd.bos.form.operate.formop.CopyEntryRow");
        FormOperateTypes.register("refresh", "kd.bos.form.operate.formop.Refresh");
        FormOperateTypes.register("close", "kd.bos.form.operate.formop.Close");
        FormOperateTypes.register("returndata", "kd.bos.form.operate.listop.ReturnData");
        FormOperateTypes.register("new", "kd.bos.form.operate.New");
        FormOperateTypes.register("newimporttemplate", "kd.bos.form.operate.NewImportTemplate");
        FormOperateTypes.register("modify", "kd.bos.form.operate.Modify");
        FormOperateTypes.register("view", "kd.bos.form.operate.View");
        FormOperateTypes.register("filter", "kd.bos.form.operate.Filter");
        FormOperateTypes.register("cooperation", "kd.bos.form.operate.Cooperation");
        FormOperateTypes.register("runscript", "kd.bos.form.operate.formop.RunScript");
        FormOperateTypes.register("imagereview", "kd.bos.form.operate.formop.ImageReview");
        FormOperateTypes.register("copy", "kd.bos.form.operate.Copy");
        FormOperateTypes.register("first", "kd.bos.form.operate.listop.First");
        FormOperateTypes.register("exportentry", "kd.bos.form.operate.formop.ExportEntry");
        FormOperateTypes.register("importentry", "kd.bos.form.operate.formop.ImportEntry");
        FormOperateTypes.register("last", "kd.bos.form.operate.listop.Last");
        FormOperateTypes.register("next", "kd.bos.form.operate.listop.Next");
        FormOperateTypes.register("previous", "kd.bos.form.operate.listop.Previous");
        FormOperateTypes.register("push", "kd.bos.form.operate.botp.Push");
        FormOperateTypes.register("draw", "kd.bos.form.operate.botp.Draw");
        FormOperateTypes.register("trackdown", "kd.bos.form.operate.botp.TrackDown");
        FormOperateTypes.register("trackup", "kd.bos.form.operate.botp.TrackUp");
        FormOperateTypes.register("trackall", "kd.bos.form.operate.botp.TrackAll");
        FormOperateTypes.register("moveentryup", "kd.bos.form.operate.MoveEntryUp");
        FormOperateTypes.register("moveentrydown", "kd.bos.form.operate.MoveEntryDown");
        FormOperateTypes.register("batchfillentry", "kd.bos.form.operate.BatchFillEntry");
        FormOperateTypes.register("batchcopyentry", "kd.bos.form.operate.BatchCopyEntry");
        FormOperateTypes.register("calllist", "kd.bos.form.operate.CallList");
        FormOperateTypes.register("tenanttrackup", "kd.bos.form.operate.TenantTrackUp");
        FormOperateTypes.register("tenanttrackdown", "kd.bos.form.operate.TenantTrackDown");
        FormOperateTypes.register("ctpush", "kd.bos.form.operate.CtPush");
        FormOperateTypes.register("printpreview", "kd.bos.form.operate.printop.PrintPreview");
        FormOperateTypes.register("printsetting", "kd.bos.form.operate.printop.PrintSetting");
        FormOperateTypes.register("print", "kd.bos.form.operate.printop.Print");
        FormOperateTypes.register("selecttplprint", "kd.bos.form.operate.printop.SelectTplPrint");
        FormOperateTypes.register("listprintpreview", "kd.bos.form.operate.printop.ListPrintPreview");
        FormOperateTypes.register("clientpreview", "kd.bos.form.operate.printop.ClientPreview");
        FormOperateTypes.register("exportexcel", "kd.bos.form.operate.ExportExcel");
        FormOperateTypes.register("option", "kd.bos.form.operate.formop.Option");
        FormOperateTypes.register("parametersave", "kd.bos.form.operate.formop.ParameterSave");
        FormOperateTypes.register("reset", "kd.bos.form.operate.formop.Reset");
        FormOperateTypes.register("assign", "kd.bos.form.operate.Assign");
        FormOperateTypes.register("unassign", "kd.bos.form.operate.UnAssign");
        FormOperateTypes.register("attachment", "kd.bos.entity.operate.Attachment");
        FormOperateTypes.register("attachmentview", "kd.bos.entity.operate.AttachmentView");
        FormOperateTypes.register("attachmentdownload", "kd.bos.entity.operate.AttachmentDownload");
        FormOperateTypes.register("batchdownloadattachment", "kd.bos.form.operate.BatchDownloadAttachment");
        FormOperateTypes.register("importtemplate", "kd.bos.entity.operate.ImportTemplate");
        FormOperateTypes.register("importtemplatelist", "kd.bos.entity.operate.ImportTemplateList");
        FormOperateTypes.register("importdata", "kd.bos.form.operate.listop.ImportData");
        FormOperateTypes.register("importexport_userset", "kd.bos.form.operate.listop.ImportAndExportConfig");
        FormOperateTypes.register("importdetails", "kd.bos.form.operate.listop.ImportDetails");
        FormOperateTypes.register("exportlist", "kd.bos.form.operate.listop.ExportList");
        FormOperateTypes.register("exportlist_expt", "kd.bos.form.operate.listop.ExportList_expt");
        FormOperateTypes.register("exportdetails", "kd.bos.form.operate.listop.ExportDetails");
        FormOperateTypes.register("exportlistdownload", "kd.bos.form.operate.listop.ExportListDownload");
        FormOperateTypes.register("viewflowchart", "kd.bos.workflow.form.operate.ViewFlowchart");
        FormOperateTypes.register("withdraw", "kd.bos.workflow.form.operate.Withdraw");
        FormOperateTypes.register("configuregrid", "kd.bos.form.operate.formop.ConfigureGrid");
        FormOperateTypes.register("configurereport", "kd.bos.form.operate.formop.ConfigureReport");
        FormOperateTypes.register("reportmultifieldsort", "kd.bos.form.operate.formop.ReportMultiFieldSort");
        FormOperateTypes.register("syncexportexcel", "kd.bos.form.operate.report.SyncExportExcel");
        FormOperateTypes.register("exportreport", "kd.bos.form.operate.report.ExportReportData");
        FormOperateTypes.register("OpenQingView", "kd.bos.form.operate.report.OpenQingView");
        FormOperateTypes.register("scanQRCode", "kd.bos.form.operate.mobileop.MobileFormOp");
        FormOperateTypes.register("multifieldsort", "kd.bos.form.operate.listop.MultiFieldSort");
        FormOperateTypes.register("mobtoolbarselect", "kd.bos.form.operate.mobileop.MobToolBarSelect");
        FormOperateTypes.register("mobtoolbarcancel", "kd.bos.form.operate.mobileop.MobToolBarCancel");
        FormOperateTypes.register("kflow", "kd.bos.form.operate.KFlowOp");
    }
}

