/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ITipsSupport;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TipsSupport
extends Control
implements ITipsSupport {
    private List<TipsListener> listeners = null;
    private static final String BOS_FORM_METADATA = "bos-form-metadata";

    @Override
    @SdkInternal
    public void showFormByTips(String formId, String elementId, String triggerType) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            this.getView().showErrMessage(String.format(ResManager.loadKDString((String)"\u63a7\u4ef6[%s]\u663e\u793atips\u5c5e\u6027formId\u4e0d\u80fd\u4e3a\u7a7a", (String)"TipsSupport_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), this.getKey()), ResManager.loadKDString((String)"\u663e\u793atips\u914d\u7f6e\u9519\u8bef", (String)"TipsSupport_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
        } else {
            Map<String, Object> formParam;
            BeforeShowTipsEvent event = new BeforeShowTipsEvent(this);
            event.setFormId(formId);
            event.setElementId(elementId);
            event.setTriggerType(triggerType);
            if (this.listeners != null) {
                this.listeners.forEach(listener -> listener.beforeShowTips(event));
            }
            if (event.isCancel()) {
                return;
            }
            FormShowParameter param = event.getFormshowParameter();
            if (param == null) {
                param = new FormShowParameter();
            }
            if ((formParam = event.getParamsMap()) != null && !formParam.isEmpty()) {
                param.setCustomParams(formParam);
            }
            param.getOpenStyle().setShowType(ShowType.ToolTips);
            String modelType = this.getView().getFormShowParameter().getFormConfig().getModelType();
            if ("mobilebill".equals(modelType) || "mobileform".equals(modelType)) {
                param.getOpenStyle().setShowType(ShowType.Modal);
            }
            HashMap<String, String> custParam = new HashMap<String, String>();
            custParam.put("elementId", elementId);
            custParam.put("triggerType", triggerType);
            param.getOpenStyle().setCustParam(custParam);
            param.getOpenStyle().setTargetKey(this.getKey());
            param.setFormId(formId);
            this.getView().showForm(param);
            AfterShowTipsEvent afterEvent = new AfterShowTipsEvent(this);
            if (this.listeners != null) {
                this.listeners.forEach(listener -> listener.afterShowTips(afterEvent));
            }
        }
    }

    @Override
    @KSMethod
    public void addTipsListener(TipsListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<TipsListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    @KSMethod
    public void hideTips() {
        this.clientViewProxy.setFieldProperty(this.getKey(), "tips", null);
    }

    @Override
    @KSMethod
    public void addTips(Tips tips) {
        Map<String, Object> data = this.createTipsData(tips);
        if (data != null && data.size() > 0) {
            this.clientViewProxy.setFieldProperty(this.getKey(), "tips", data);
        }
    }

    private Map<String, Object> createTipsData(Tips tips) {
        if (tips == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        String type = tips.getType();
        if ("bill".equals(type)) {
            String billNo = tips.getBillno();
            if (StringUtils.isBlank((CharSequence)billNo)) {
                return Collections.EMPTY_MAP;
            }
            data.put("billno", billNo);
        } else {
            LocaleString title = tips.getTitle();
            LocaleString content = tips.getContent();
            if (content == null || StringUtils.isBlank((CharSequence)content.toString())) {
                return Collections.EMPTY_MAP;
            }
            if (title != null && StringUtils.isNotBlank((CharSequence)title.toString())) {
                data.put("title", title);
            }
            if (tips.isLink()) {
                data.put("link", tips.isLink());
                data.put("linkData", tips.getLinkData());
            }
            data.put("content", content);
        }
        data.put("type", type);
        boolean isShowIcon = tips.isShowIcon();
        data.put("showIcon", isShowIcon);
        if (isShowIcon) {
            data.put("iconClassName", tips.getIconClassName());
        }
        data.put("triggerType", tips.getTriggerType());
        data.put("place", tips.getPlace());
        return data;
    }
}

