/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.chart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.BaseGraphicType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.Series;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ChartData {
    private static final String ORIENT = "orient";
    private static final String VERTICAL = "vertical";
    private static final String DATA = "data";
    private static final String TITLE = "title";
    private static final String LEGEND = "legend";
    private static final String TOOLTIP = "tooltip";
    private static final String XAXIS = "xAxis";
    private static final String YAXIS = "yAxis";
    private static final String SERIES = "series";
    private static final String GRID = "grid";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String GRAPHIC = "graphic";
    private List<Axis> xAxisList = new ArrayList<Axis>();
    private List<Axis> yAxisList = new ArrayList<Axis>();
    private List<Series> seriesList = new ArrayList<Series>();
    private Map<String, Object> toolUseTip = new HashMap<String, Object>();
    private List<List<Object>> paths = new ArrayList<List<Object>>();
    List<BaseGraphicType> UseGraphic = new ArrayList<BaseGraphicType>();
    private Chart chart;

    public List<BaseGraphicType> getUseGraphic() {
        return this.UseGraphic;
    }

    public void setUseGraphic(List<BaseGraphicType> useGraphic) {
        this.UseGraphic = useGraphic;
    }

    protected void setChart(Chart chart) {
        this.chart = chart;
    }

    protected Chart getChart() {
        return this.chart;
    }

    protected Map<String, Object> getTitle() {
        Chart chartTemp = this.getChart();
        HashMap<String, Object> title = new HashMap<String, Object>();
        if (chartTemp.getName() != null) {
            title.put("text", chartTemp.getName().getDefaultItem());
        }
        title.put(X, chartTemp.getTitleXAlign());
        title.put(Y, chartTemp.getTitleYAlign());
        title.putAll(this.getChart().getTitleData());
        return title;
    }

    public List<Axis> getXAxisList() {
        return this.xAxisList;
    }

    public void addXAxis(Axis xAxis) {
        this.xAxisList.add(xAxis);
    }

    public List<Axis> getYAxisList() {
        return this.yAxisList;
    }

    public void addYAxis(Axis yAxis) {
        this.yAxisList.add(yAxis);
    }

    public void addSeries(Series xAxis) {
        this.seriesList.add(xAxis);
    }

    public List<Series> getSeries() {
        return this.seriesList;
    }

    protected Map<String, Object> toCharData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Chart chartTemp = this.getChart();
        if (chartTemp.isShowTitle()) {
            data.put(TITLE, this.getTitle());
        }
        if (chartTemp.isShowTooltip()) {
            if (!this.toolUseTip.isEmpty()) {
                data.put(TOOLTIP, this.toolUseTip);
            } else {
                data.put(TOOLTIP, this.getTooltip());
            }
        }
        if (chartTemp.isShowLegend()) {
            data.put(LEGEND, this.getLegend());
        }
        if (this.xAxisList != null && !this.xAxisList.isEmpty()) {
            ArrayList<Map<String, Object>> xAxis = new ArrayList<Map<String, Object>>(10);
            for (Axis x : this.xAxisList) {
                xAxis.add(x.getValues());
            }
            data.put(XAXIS, xAxis);
        }
        if (this.yAxisList != null && !this.yAxisList.isEmpty()) {
            ArrayList<Map<String, Object>> yAxis = new ArrayList<Map<String, Object>>(10);
            for (Axis y : this.yAxisList) {
                yAxis.add(y.getValues());
            }
            data.put(YAXIS, yAxis);
        }
        ArrayList<Map<String, Object>> series = new ArrayList<Map<String, Object>>(10);
        ArrayList<List<Object>> funcPaths = new ArrayList<List<Object>>(10);
        for (int i = 0; i < this.seriesList.size(); ++i) {
            Series s = this.seriesList.get(i);
            series.add(s.getValues());
            for (List<Object> list : s.getFuncPaths()) {
                List list2 = (List)((ArrayList)list).clone();
                list2.add(0, i);
                list2.add(0, SERIES);
                funcPaths.add(list2);
            }
        }
        if (!this.paths.isEmpty()) {
            for (List<Object> path : this.paths) {
                funcPaths.add(path);
            }
        }
        if (!funcPaths.isEmpty()) {
            data.put("functions", funcPaths);
        }
        data.put(SERIES, series);
        data.put(GRID, chartTemp.getGrid());
        data.put(GRAPHIC, this.UseGraphic);
        data.put("isMerge", this.isMerge());
        Map<String, Object> properties = chartTemp.getProperties();
        properties.forEach((key, value) -> data.put((String)key, value));
        return data;
    }

    private Map<String, Object> getLegend() {
        HashMap<String, Object> legendMap = new HashMap<String, Object>();
        legendMap.put(DATA, this.getLegendData());
        if (this.getChart().isLegendVertical()) {
            legendMap.put(ORIENT, VERTICAL);
        } else {
            legendMap.remove(ORIENT);
        }
        legendMap.putAll(this.getChart().getLegendData());
        return legendMap;
    }

    private List<String> getLegendData() {
        ArrayList<String> legend = new ArrayList<String>();
        if (this.isPie()) {
            for (Series series : this.seriesList) {
                List<Object> data = series.getData();
                if (data == null) continue;
                for (Object obj : data) {
                    Map val = (Map)obj;
                    String name = (String)val.get("name");
                    if (legend.contains(name)) continue;
                    legend.add(name);
                }
            }
        } else {
            for (Series series : this.seriesList) {
                legend.add(series.getName());
            }
        }
        return legend;
    }

    private Map<String, Object> getTooltip() {
        HashMap<String, Object> tooltip = new HashMap<String, Object>();
        if (this.isPie()) {
            tooltip.put("trigger", "item");
            tooltip.put("formatter", "{a} <br/>{b} : {c} ({d}%)");
        } else {
            tooltip.put("trigger", "axis");
            if (this.isBar()) {
                HashMap<String, String> axisPointer = new HashMap<String, String>();
                axisPointer.put("type", "shadow");
                tooltip.put("axisPointer", axisPointer);
            }
        }
        return tooltip;
    }

    private boolean isPie() {
        boolean isPie = false;
        for (Series series : this.seriesList) {
            if (series.getType() == ChartType.pie) {
                isPie = true;
                continue;
            }
            isPie = false;
            break;
        }
        return isPie;
    }

    private boolean isBar() {
        boolean isBar = false;
        for (Series series : this.seriesList) {
            if (series.getType() == ChartType.bar) {
                isBar = true;
                continue;
            }
            isBar = false;
            break;
        }
        return isBar;
    }

    public String toString() {
        return this.toCharData().toString();
    }

    public void addTooltip(String key, Object value) {
        this.toolUseTip.put(key, value);
    }

    @SdkInternal
    public void addFuncPath(List<Object> objLists) {
        this.paths.add(objLists);
    }

    @SdkInternal
    public boolean isMerge() {
        Chart chartTemp = this.getChart();
        return chartTemp.isMerge();
    }
}

