/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.BindingContext;
import kd.bos.form.TipsSupport;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ContainerOnShowEvent;
import kd.bos.form.control.events.ContainerOnShowListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class Container
extends TipsSupport
implements ISuportClick {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    List<Control> items = new ArrayList<Control>();
    private String operationKey;
    private List<ContainerOnShowListener> onShowListener = new ArrayList<ContainerOnShowListener>();
    private List<String> collapseFields;
    private List<Control> hiddenItems = new ArrayList<Control>();
    protected List<ClickListener> clickListeners = new ArrayList<ClickListener>();

    @CollectionPropertyAttribute(collectionItemPropertyType=Control.class)
    @KSMethod
    public List<Control> getItems() {
        return this.items;
    }

    @Override
    public void bindData(BindingContext bctx) {
        for (Control ctl : this.items) {
            EntityTraceSpan span = EntityTracer.create((String)ctl.getClass().getSimpleName(), (String)"bindData", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
            Throwable throwable = null;
            try {
                span.addTag("key", ctl.getKey());
                ctl.bindData(bctx);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getOperationKey() {
        return this.operationKey;
    }

    @KSMethod
    public void setBackgroundImg(String imageUrl) {
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setBackgroundImg", imageUrl);
    }

    @KSMethod
    public void setOperationKey(String operationKey) {
        this.operationKey = operationKey;
    }

    @Override
    public void addClickListener(ClickListener listener) {
        this.clickListeners.add(listener);
    }

    @Override
    @KSMethod
    public Map<String, Object> createClientConfig() {
        Map<String, Object> map = super.createClientConfig();
        this.createChildClientConfigs(map);
        return map;
    }

    protected void createChildClientConfigs(Map<String, Object> map) {
        ArrayList<Map<String, Object>> myItems = new ArrayList<Map<String, Object>>();
        for (Control ctl : this.getItems()) {
            if (!StringUtils.isNotBlank((CharSequence)ctl.getKey())) continue;
            myItems.add(ctl.createClientConfig());
        }
        if (!myItems.isEmpty()) {
            map.put("items", myItems);
        }
    }

    public void click() {
        BeforeClickEvent e = new BeforeClickEvent(this);
        this.fireBeforeClick(e);
        if (!e.isCancel()) {
            if (StringUtils.isNotBlank((CharSequence)this.operationKey)) {
                this.getView().invokeOperation(this.operationKey);
            }
            ClickEvent e1 = new ClickEvent(this);
            this.fireClick(e1);
        }
    }

    private void fireBeforeClick(BeforeClickEvent e) {
        for (ClickListener l : this.clickListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".beforeClick"));
            Throwable throwable = null;
            try {
                l.beforeClick(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    private void fireClick(ClickEvent e) {
        if (this.clickListeners != null) {
            for (ClickListener l : this.clickListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".click"));
                Throwable throwable = null;
                try {
                    l.click(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @Override
    public void addItemClickListener(ItemClickListener listener) {
    }

    @KSMethod
    public void addControls(List<Map<String, Object>> items) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.getKey());
        args.add(items);
        this.clientViewProxy.addAction("addControls", args);
    }

    @KSMethod
    public void insertControls(int index, List<Map<String, Object>> items) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.getKey());
        args.add(index);
        args.add(items);
        this.clientViewProxy.addAction("insertControls", args);
    }

    @KSMethod
    public void deleteControls(String ... keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.getKey());
        args.add(keys);
        this.clientViewProxy.addAction("deleteControls", args);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Container cloneContainer = (Container)super.clone();
        ArrayList<Control> myItems = new ArrayList<Control>(this.getItems().size());
        for (Control c : this.getItems()) {
            myItems.add((Control)c.clone());
        }
        cloneContainer.items = myItems;
        return cloneContainer;
    }

    @KSMethod
    public void setCollapse(boolean value) {
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setCollapse", value);
    }

    @KSMethod
    public void setCollapseable(boolean value) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("collapsible", value);
        this.getView().updateControlMetadata(this.getKey(), data);
    }

    @KSMethod
    public void setCollapseFieldsVisible(List<String> addFields, List<String> hideFields) {
        HashMap<String, Object> ctl = new HashMap<String, Object>();
        HashSet<String> fields = new HashSet<String>();
        if (this.getCollapseFields() != null) {
            fields.addAll(this.getCollapseFields());
        }
        if (addFields != null) {
            fields.addAll(addFields);
        }
        if (hideFields != null && !hideFields.isEmpty()) {
            List newFields = fields.stream().map(item -> hideFields.contains(item) ? "" : item).collect(Collectors.toList());
            ctl.put("cf", newFields);
        } else {
            ctl.put("cf", fields);
        }
        this.getView().updateControlMetadata(this.getKey(), ctl);
    }

    @SimplePropertyAttribute
    @KSMethod
    public List<String> getCollapseFields() {
        return this.collapseFields;
    }

    @KSMethod
    public void setCollapseFields(List<String> collapseFields) {
        this.collapseFields = collapseFields;
    }

    @KSMethod
    public void setFireShowEvent(boolean value) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("FireShowEvt", value);
        this.getView().updateControlMetadata(this.getKey(), data);
    }

    @KSMethod
    public void addOnShowListener(ContainerOnShowListener listener) {
        this.onShowListener.add(listener);
    }

    @KSMethod
    public void onShow() {
        ContainerOnShowEvent e = new ContainerOnShowEvent(this);
        if (this.onShowListener != null) {
            for (ContainerOnShowListener l : this.onShowListener) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".containerOnShow"));
                Throwable throwable = null;
                try {
                    l.containerOnShow(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=Control.class, name="HiddenItems")
    @KSMethod
    public List<Control> getHiddenItems() {
        return this.hiddenItems;
    }

    public void setHiddenItems(List<Control> hiddenItems) {
        this.hiddenItems = hiddenItems;
    }
}

