/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Container;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class FormRoot
extends Container {
    private int ruleCount;
    private List<Plugin> jsPlugins = new ArrayList<Plugin>();

    @KSMethod
    @SimplePropertyAttribute
    public int getRuleCount() {
        return this.ruleCount;
    }

    @KSMethod
    public void setRuleCount(int ruleCount) {
        this.ruleCount = ruleCount;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=Plugin.class)
    public List<Plugin> getJsPlugins() {
        return this.jsPlugins;
    }

    public void setJsPlugins(List<Plugin> jsPlugins) {
        this.jsPlugins = jsPlugins;
    }

    @Override
    public void bindData(BindingContext bctx) {
        super.bindData(bctx);
        if (this.jsPlugins.isEmpty()) {
            return;
        }
        HashMap<String, Plugin> scriptMap = new HashMap<String, Plugin>(this.jsPlugins.size());
        ArrayList<String> scriptIds = new ArrayList<String>(this.jsPlugins.size());
        for (Plugin jsPlugin : this.getJsPlugins()) {
            if (!jsPlugin.isEnabled()) continue;
            scriptIds.add(jsPlugin.getFpk());
            scriptMap.put(jsPlugin.getFpk(), jsPlugin);
        }
        Map scriptObjMap = BusinessDataReader.loadFromCache((Object[])scriptIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ide_pluginscript"));
        ArrayList result = new ArrayList(scriptObjMap.size());
        for (Map.Entry scriptObj : scriptObjMap.entrySet()) {
            DynamicObject script = (DynamicObject)scriptObj.getValue();
            String scriptId = (String)scriptObj.getKey();
            String scriptContentStr = script.getString("txt_scriptcontext_tag");
            if (!StringUtils.isNotBlank((CharSequence)scriptContentStr)) continue;
            Map scriptContent = (Map)SerializationUtils.fromJsonString((String)scriptContentStr, Map.class);
            HashMap itemResult = new HashMap(1);
            itemResult.put("compile", scriptContent.get("Compile"));
            String encode = (String)scriptContent.get("Encode");
            if (encode != null) {
                itemResult.put("encode", "");
            }
            Plugin plugin = (Plugin)scriptMap.get(scriptId);
            itemResult.put("formId", plugin.getSourceNumber());
            result.add(itemResult);
        }
        if (!result.isEmpty()) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.addAction("setPageJS", result);
        }
    }
}

