/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.control.DesignerBarListener;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.DesignerBarAction;
import kd.bos.form.control.events.DesignerBarEvent;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.form.control.events.PropertyListener;
import kd.bos.form.control.events.datamodel.TableClickEvent;
import kd.bos.form.control.events.datamodel.TableClickListener;
import kd.bos.form.events.ClosedCallBackEvent;

public class DataModelDesigner
extends Control
implements ICloseCallBack {
    private static final String KEY = "key";
    private List<DesignerBarListener> barListeners = new ArrayList<DesignerBarListener>();
    private List<TableClickListener> tableClickListeners = new ArrayList<TableClickListener>();
    protected List<ClickListener> clickListeners = new ArrayList<ClickListener>();
    protected List<PropertyListener> propertyListeners = new ArrayList<PropertyListener>();
    private Map<String, Object> content;

    public void addBarListener(DesignerBarListener listener) {
        this.barListeners.add(listener);
    }

    public void addTableClickListeners(TableClickListener tableClickListener) {
        this.tableClickListeners.add(tableClickListener);
    }

    public void addClickListener(ClickListener clickListener) {
        this.clickListeners.add(clickListener);
    }

    public void addPropertyListener(PropertyListener propertyListener) {
        this.propertyListeners.add(propertyListener);
    }

    @Override
    public void postBack(Object value) {
        this.content = (Map)value;
    }

    public Map<String, Object> getContent() {
        return this.content;
    }

    public void open(Map<String, Object> doc) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "open", "PhysicalDataModel", doc);
    }

    public void setProperty(Map<String, Object> param) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setProperty", param);
    }

    public void setTableInfo(Map<String, Object> param) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setTableInfo", param);
    }

    public void setTableInfo(List<Object> param) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setTableInfo", param);
    }

    public void setDataModel(List<Map<String, Object>> param) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setDataModel", param);
    }

    public void setDesignerBarVisible(Boolean value, String ... ctlKeys) {
        HashMap<String, Object> visibleMap = new HashMap<String, Object>();
        visibleMap.put("visible", value);
        visibleMap.put("keys", ctlKeys);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setDesignerBarVisible", visibleMap);
    }

    public void designerBarClick(String key) {
        this.designerBarClick(key, "");
    }

    public void designerBarClick(String key, String pageId) {
        if (this.barListeners != null) {
            DesignerBarEvent e = new DesignerBarEvent();
            e.setActionId(DesignerBarAction.Click);
            e.setBarItemKey(key);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put(KEY, key);
            e.setParam(param);
            for (DesignerBarListener l : this.barListeners) {
                l.designerBarClick(e);
            }
        }
    }

    public void tableClick(Map<String, Object> param) {
        TableClickEvent tableClickEvent = new TableClickEvent(this, param);
        this.fireClick(tableClickEvent);
    }

    public void getPropertyAlias(String itemId, String metaType, String propertyName, Map<String, Object> param) {
        PropertyEvent e = new PropertyEvent(this, itemId, metaType, propertyName, param);
        this.fireGetPropertyAlias(e);
    }

    private void fireGetPropertyAlias(PropertyEvent e) {
        if (this.propertyListeners != null) {
            for (PropertyListener l : this.propertyListeners) {
                l.getPropertyAlias(e);
            }
        }
    }

    private void fireClick(TableClickEvent e) {
        if (this.tableClickListeners != null) {
            for (TableClickListener l : this.tableClickListeners) {
                l.tableClick(e);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        if (this.tableClickListeners != null) {
            for (TableClickListener l : this.tableClickListeners) {
                if (!(l instanceof ICloseCallBack)) continue;
                ((ICloseCallBack)((Object)l)).closedCallBack(e);
            }
        }
    }

    public void click(String itemId, String metaType, String propertyName, Map<String, Object> param) {
        PropertyEvent event = new PropertyEvent(this, itemId, metaType, propertyName, param);
        this.propertyClick(event);
    }

    private void propertyClick(PropertyEvent event) {
        if (this.propertyListeners != null) {
            for (PropertyListener l : this.propertyListeners) {
                l.click(event);
            }
        }
    }

    public void click(Map<String, Object> param) {
        ClickEvent e = new ClickEvent(this, param);
        if (this.clickListeners != null) {
            for (ClickListener l : this.clickListeners) {
                l.click(e);
            }
        }
    }
}

