/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.ControlViewProxy;
import kd.bos.form.control.EmbedSubEntryGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class EmbedSubEntryViewProxy
implements ControlViewProxy,
Serializable {
    private static final long serialVersionUID = -7462947001060848450L;
    private static final Log log = LogFactory.getLog(ControlViewProxy.class);
    private static final String FIELDSTATES = "fieldstates";
    private static final String SPAN_TYPE_CLIENTVIEW = "EmbedSubEntryViewProxy";
    private static final String SPAN_PARAM_ACTION = "action";
    private static final String SPAN_PARAM_PARAMS = "params";
    private static final String SPAN_PARAM_KEY = "key";
    private static final String SPAN_PARAM_PROP = "property";
    private static final String SPAN_PARAM_ENTRYKEY = "entryKey";
    private static final String SPAN_PARAM_RESULT = "result";
    private static final String SEP = "$$";
    private Map<String, Map<String, Object>> _dctControlsStates;
    private List<Map<String, Object>> _controlsState;
    private Map<String, Map<Object, List<Object>>> _entryDataRows;
    private IClientViewProxy clientViewProxy;
    private IFormView formView;

    public EmbedSubEntryViewProxy(IClientViewProxy clientViewProxy) {
        this.clientViewProxy = clientViewProxy;
        this.resetActions();
    }

    public EmbedSubEntryViewProxy(IClientViewProxy clientViewProxy, IFormView formView) {
        this.clientViewProxy = clientViewProxy;
        this.formView = formView;
        this.resetActions();
    }

    @Override
    public final void resetActions() {
        this._controlsState = new ArrayList<Map<String, Object>>();
        this._dctControlsStates = new HashMap<String, Map<String, Object>>();
        this._entryDataRows = null;
    }

    public void setEntryProperty(String key, String property, Object v) {
        Map<String, Object> controlState = this._dctControlsStates.get(key);
        if (controlState == null) {
            controlState = new HashMap<String, Object>();
            controlState.put("k", key);
            this._dctControlsStates.put(key, controlState);
            this._controlsState.add(controlState);
        }
        controlState.put(property, v);
        List subdata = (List)v;
        for (int i = subdata.size() - 1; i >= 0; --i) {
            HashMap<String, String> controlState2 = new HashMap<String, String>(10);
            controlState2.put("k", this.getCacheGridKey(key, i));
            this._dctControlsStates.put(this.getCacheGridKey(key, i), controlState2);
            controlState2.put("data", (String)subdata.get(i));
        }
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"setEntryProperty");){
                span.addTag(SPAN_PARAM_KEY, key);
                span.addTag(SPAN_PARAM_PROP, property);
                span.addLocaleTag(SPAN_PARAM_PARAMS, v);
            }
        }
    }

    private Map<String, Object> getControlState(String key) {
        Map<String, Object> controlState = null;
        controlState = this._dctControlsStates.get(key);
        if (controlState == null) {
            controlState = new HashMap<String, Object>();
            controlState.put("k", key);
            if (StringUtils.contains((CharSequence)key, (CharSequence)SEP)) {
                String[] split = StringUtils.split((String)key, (String)SEP);
                controlState.put("k", split[0]);
                controlState.put("pr", Integer.parseInt(split[1]));
            }
            this._dctControlsStates.put(key, controlState);
            this._controlsState.add(controlState);
        }
        return controlState;
    }

    public void setEntryFieldValue(AbstractGrid grid, String key, int rowIndex, int parentRowIndex, Object v) {
        if (this.clientViewProxy.isState(grid.getKey(), "StopUpdateCell")) {
            return;
        }
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"setEntryFieldValue");){
                span.addTag(SPAN_PARAM_ENTRYKEY, grid.getKey());
                span.addTag(SPAN_PARAM_KEY, key);
                span.addTag("row", String.valueOf(rowIndex));
                span.addLocaleTag("val", v);
            }
        }
        String cacheGridKey = this.getCacheGridKey(grid.getKey(), parentRowIndex);
        List<Object> rowData = this.getEntryRow(cacheGridKey, rowIndex);
        String lkey = key;
        Map<String, Integer> dataIndex = null;
        if (grid instanceof EntryGrid) {
            dataIndex = ((EntryGrid)grid).getDataIndex();
        }
        if (rowData != null && dataIndex != null) {
            Integer colIndex = dataIndex.get(lkey);
            if (colIndex != null) {
                rowData.set(colIndex, v);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("Key:").append(lkey).append(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230,dataIndex\u4e2dKey\u6e05\u5355", (String)"ClientViewProxy_0", (String)"bos-form-mvc", (Object[])new Object[0])).append("[");
                for (String keyStr : dataIndex.keySet()) {
                    sb.append(keyStr).append(",");
                }
                sb.append("]");
                log.info(sb.toString());
            }
        } else {
            this.clientViewProxy.queueActions();
            this.getEntryField(cacheGridKey, lkey, rowIndex).put("v", v);
        }
    }

    private Map<String, Object> getEntryField(String entryKey, String fldKey, int rowIndex) {
        String key = entryKey + "." + rowIndex + "." + fldKey;
        Map<String, Object> field = this._dctControlsStates.get(key);
        if (field == null) {
            Map<String, Object> entry = this.getControlState(entryKey);
            if (!entry.containsKey(FIELDSTATES)) {
                entry.put(FIELDSTATES, new ArrayList());
            }
            List entryfieldStates = (List)entry.get(FIELDSTATES);
            field = new HashMap<String, Object>();
            field.put("k", fldKey);
            field.put("r", rowIndex);
            if (entry.containsKey("pr")) {
                field.put("pr", entry.remove("pr"));
            }
            this._dctControlsStates.put(key, field);
            entryfieldStates.add(field);
        }
        return field;
    }

    private List<Object> getEntryRow(String entrykey, int rowIndex) {
        Map objData;
        Object rowData;
        Object data;
        Map<Object, List<Object>> entryRows = this.getEntryRows(entrykey);
        List<Object> row = null;
        row = entryRows.get(rowIndex);
        if (row != null) {
            return row;
        }
        Map<String, Object> entryState = null;
        entryState = this._dctControlsStates.get(entrykey);
        if (entryState != null && (data = entryState.get("data")) != null && (rowData = (objData = (Map)data).get("rows")) != null) {
            List entryData = (List)rowData;
            if (rowIndex >= 0 && rowIndex < entryData.size()) {
                for (int i = 0; i < entryData.size(); ++i) {
                    int index;
                    List rowObj;
                    List list = rowObj = entryData.get(i) == null ? null : (List)entryData.get(i);
                    if (rowObj == null || rowObj.isEmpty()) continue;
                    int n = index = rowObj.get(0) == null ? -1 : (Integer)rowObj.get(0);
                    if (rowIndex != index) continue;
                    return rowObj;
                }
                return null;
            }
        }
        return null;
    }

    private Map<Object, List<Object>> getEntryRows(String entryKey) {
        HashMap entryRows = null;
        if (this._entryDataRows == null) {
            this._entryDataRows = new HashMap<String, Map<Object, List<Object>>>();
        }
        if ((entryRows = (HashMap)this._entryDataRows.get(entryKey)) == null) {
            entryRows = new HashMap();
            this._entryDataRows.put(entryKey, entryRows);
        }
        return entryRows;
    }

    private String getCacheGridKey(String key, int parentRowIndex) {
        return key + SEP + parentRowIndex;
    }

    @Override
    public List<Map<String, Object>> getControlsState() {
        return this._controlsState;
    }

    public Integer getCurrentEntryPr(String key) {
        if (this.formView == null) {
            return null;
        }
        Object grid = null;
        try {
            grid = this.formView.getControl(key);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (grid instanceof EmbedSubEntryGrid) {
            return ((EmbedSubEntryGrid)grid).getCurrentEntryPr();
        }
        return null;
    }
}

