/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.decode.DecodeHandlerFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.DesignerBarListener;
import kd.bos.form.control.DesignerCallListener;
import kd.bos.form.control.events.CreateUIByTypeEvent;
import kd.bos.form.control.events.CreateUIElemntByEntityItemEvent;
import kd.bos.form.control.events.CreateUIElemntListener;
import kd.bos.form.control.events.DesignerBarAction;
import kd.bos.form.control.events.DesignerBarEvent;
import kd.bos.form.control.events.DesignerCallEvent;
import kd.bos.form.control.events.KeyPressArgs;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.form.control.events.PropertyListener;
import kd.bos.form.control.events.ShortCutKeyListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;

@KSObject
public class EntityDesigner
extends Control
implements ICloseCallBack {
    protected static final String CALLBACK_SELECT_FIELD = "selectField";
    protected static final String ENTITY_ID = "entityId";
    protected static final String FROM_ITEM = "fromitem";
    protected static final String IS_STD = "isStd";
    protected static final String FIELDS = "fields";
    protected static final String FIELD_NUMBER = "fieldNumber";
    protected static final String FIELD_NAME = "fieldName";
    protected static final String FIELD_TYPE = "fieldType";
    protected static final String ADD_FIELD = "addField";
    protected static final String CALLBACK_DELETE_CONFIRM = "deleteConfirm";
    protected static final String DELETE_CONFIRM_KEY = "key";
    protected static final String DELETE_CONFIRM_ID = "id";
    protected static final String DELETE_CONFIRM_IS_ENTITY = "isEntity";
    protected static final String DO_DELETE = "doDelete";
    private static final String PAGE_ID = "pageId";
    private static final String KEY = "key";
    protected List<PropertyListener> listeners = new ArrayList<PropertyListener>();
    private List<DesignerBarListener> barListeners = new ArrayList<DesignerBarListener>();
    private List<DesignerCallListener> callListeners = new ArrayList<DesignerCallListener>();
    protected List<CreateUIElemntListener> createUIElementlisteners = new ArrayList<CreateUIElemntListener>();
    protected List<ShortCutKeyListener> shortCutKeyListeners = new ArrayList<ShortCutKeyListener>();
    private Map<String, Object> content;
    private static final String CALL_ACTION_PARSE_RISE_EVENT_TYPES = "parseRiseEventTypes";
    private static final String CALL_ACTION_PARSE_RISE_EVENT_VALUES = "parseRiseEventValues";
    private static final String CALL_ACTION_SHOW_FUNCTION_SETTING = "showFunctionSetting";
    private static final String CALL_ACTION_SHOW_CUSTOM_RULE_SERVICE_SETTING = "showCustomRuleServiceSetting";
    private static final String VALIDATE_FORMULA = "validateFormula";
    private static final String ENTITY_META = "entitymeta";
    private static final String ITEMS = "Items";
    private static final String PARENT_ID = "ParentId";
    private static final String INDEX = "Index";

    public void addBarListener(DesignerBarListener barListener) {
        this.barListeners.add(barListener);
    }

    public void addCallListener(DesignerCallListener callListener) {
        this.callListeners.add(callListener);
    }

    @KSMethod
    public void addPropertyButtonClickListener(PropertyListener listener) {
        this.listeners.add(listener);
    }

    @KSMethod
    public void addCreateUIElemntListener(CreateUIElemntListener listener) {
        this.createUIElementlisteners.add(listener);
    }

    public void addShortCutKeyListener(ShortCutKeyListener listener) {
        this.shortCutKeyListeners.add(listener);
    }

    @KSMethod
    public void click(String itemId, String metaType, String propertyName, Map<String, Object> param) {
        param = this.decodePropertyValue(propertyName, param);
        PropertyEvent e = new PropertyEvent(this, itemId, metaType, propertyName, param);
        this.fireClick(e);
    }

    @KSMethod
    public void afterSetProperty(String itemId, String metaType, String propertyName, Object value) {
        if (this.listeners != null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("value", value);
            PropertyEvent e = new PropertyEvent(this, itemId, metaType, propertyName, param);
            for (PropertyListener l : this.listeners) {
                l.afterSetProperty(e);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        HashMap data;
        IClientViewProxy service;
        Map ret;
        if (CALLBACK_SELECT_FIELD.equals(e.getActionId())) {
            ret = (Map)e.getReturnData();
            if (ret != null) {
                service = (IClientViewProxy)e.getView().getService(IClientViewProxy.class);
                data = new HashMap(10);
                key = (String)ret.get(FROM_ITEM);
                data.put(ENTITY_ID, ret.get(ENTITY_ID));
                data.put(IS_STD, ret.get(IS_STD));
                HashMap field = new HashMap(10);
                field.put(FIELD_NUMBER, ret.get(FIELD_NUMBER));
                field.put(FIELD_NAME, ret.get(FIELD_NAME));
                field.put(FIELD_TYPE, ret.get(FIELD_TYPE));
                ArrayList fields = new ArrayList(1);
                fields.add(field);
                data.put(FIELDS, fields);
                service.invokeControlMethod(key, ADD_FIELD, data);
            }
        } else if (CALLBACK_DELETE_CONFIRM.equals(e.getActionId()) && (ret = (Map)e.getReturnData()) != null && ret.size() > 0) {
            service = (IClientViewProxy)e.getView().getService(IClientViewProxy.class);
            data = new HashMap(10);
            data.put("key", ret.get("key"));
            data.put(DELETE_CONFIRM_ID, ret.get(DELETE_CONFIRM_ID));
            key = (String)ret.get(FROM_ITEM);
            service.invokeControlMethod(key, DO_DELETE, data);
        }
        if (this.listeners != null) {
            for (PropertyListener l : this.listeners) {
                if (!(l instanceof ICloseCallBack)) continue;
                ((ICloseCallBack)((Object)l)).closedCallBack(e);
            }
        }
    }

    @KSMethod
    public void getPropertyAlias(String itemId, String metaType, String propertyName, Map<String, Object> param) {
        param = this.decodePropertyValue(propertyName, param);
        PropertyEvent e = new PropertyEvent(this, itemId, metaType, propertyName, param);
        this.fireGetPropertyAlias(e);
    }

    private Map<String, Object> decodePropertyValue(String propertyName, Map<String, Object> param) {
        Map<Object, Object> result = new HashMap();
        Object value = param.get("kdEncodingKey");
        if (value == null) {
            return param;
        }
        if ("Rules".equals(propertyName) || "ClientRules".equals(propertyName) || "Operations".equals(propertyName) || "OperationKey".equals(propertyName) || "MustInputCondition".equals(propertyName) || "Filter".equals(propertyName)) {
            String type = this.getView().getFormShowParameter().getFormConfig().getKdEncoding();
            String decodeStr = DecodeHandlerFactory.getDecodeHandler(type).decode(value.toString());
            result = (Map)SerializationUtils.fromJsonString((String)decodeStr, Map.class);
        } else {
            result = param;
        }
        return result;
    }

    public void createUIElemntByEntityItem(Map<String, Object> item, Map<String, Object> container) {
        CreateUIElemntByEntityItemEvent e = new CreateUIElemntByEntityItemEvent(this, item, container);
        this.fireCreateUIElemntByEntityItem(e);
    }

    public void createUIElementByType(Map<String, Object> elementType, Map<String, Object> container) {
        CreateUIByTypeEvent e = new CreateUIByTypeEvent(this, elementType, container);
        this.fireCreateUIByType(e);
    }

    @Override
    public void postBack(Object value) {
        this.content = (Map)value;
        String type = this.getView().getFormShowParameter().getFormConfig().getKdEncoding();
        DecodeHandlerFactory.getDecodeHandler(type).decode(this.content);
    }

    @KSMethod
    public Map<String, Object> getContent() {
        return this.content;
    }

    @KSMethod
    public void resetSideBar(String[] items) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "resetSideBar", new Object[]{items});
    }

    public void setProperty(Map<String, Object> param) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setProperty", param);
    }

    public void keyUp(List<Integer> keys) {
        KeyPressArgs args = new KeyPressArgs(keys);
        for (ShortCutKeyListener listener : this.shortCutKeyListeners) {
            listener.keyDown(args);
        }
    }

    public void createUIElement(Map<String, Object> uiElement, Map<String, Object> container) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "createUIElement", uiElement, container);
    }

    public void createEntityElement(String parentId, Map<String, Object> element) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "createEntityElement", parentId, element);
    }

    public void createEntityElement(String parentId, Map<String, Object> element, Map<String, Object> container) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "createEntityElement", parentId, element);
    }

    @KSMethod
    public void removeUIElements(String containerId) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "removeUIElements", containerId);
    }

    public void setProperty(List<Map<String, Object>> params) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setProperty", params);
    }

    public void showErrors(List<Map<String, Object>> erros) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "showErrorList", erros);
    }

    public void setEntityDesignerBar(Map<String, Object> properties) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setEntityDesignerBar", properties);
    }

    public void setTabFocus(String tabId) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setTabFocus", tabId);
    }

    public void designerBarClick(String key) {
        this.designerBarClick(key, "");
    }

    public void designerBarClick(String key, String pageId) {
        if (this.barListeners != null) {
            DesignerBarEvent e = new DesignerBarEvent();
            e.setActionId(DesignerBarAction.Click);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("key", key);
            param.put(PAGE_ID, pageId);
            e.setParam(param);
            for (DesignerBarListener l : this.barListeners) {
                l.designerBarClick(e);
            }
        }
    }

    @KSMethod
    public void open(String modelType, Map<String, Object> doc) {
        boolean isPC;
        boolean bl = isPC = !modelType.startsWith("Mob");
        if (doc.containsKey("isPC")) {
            isPC = (Boolean)doc.get("isPC");
        }
        if (doc.containsKey("formmeta")) {
            doc.remove("formmeta");
        }
        if (doc.containsKey("entitytree")) {
            doc.remove("entitytree");
        }
        if (doc.containsKey("ui")) {
            doc.remove("ui");
        }
        this.sortEntityItems(doc);
        this.setDesignerConfig(doc);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "open", modelType, isPC, doc);
    }

    private void setDesignerConfig(Map<String, Object> doc) {
        DynamicObject dynamicObject;
        String masterId;
        QFilter[] qFilters;
        Map masterBill;
        if (doc == null) {
            return;
        }
        Map entitymeta = (Map)doc.get(ENTITY_META);
        if (entitymeta == null) {
            return;
        }
        String rootIsv = "";
        String currentFormIsv = (String)entitymeta.get("Isv");
        HashMap<String, Boolean> configMap = new HashMap<String, Boolean>(16);
        boolean isLimits = false;
        if (entitymeta.get("EnableGlobalExtLimits") instanceof Boolean) {
            isLimits = (Boolean)entitymeta.get("EnableGlobalExtLimits");
        }
        if (!(masterBill = BusinessDataReader.loadFromCache((String)"bos_formmeta", (QFilter[])(qFilters = new QFilter[]{new QFilter(DELETE_CONFIRM_ID, "=", (Object)(masterId = (String)entitymeta.get("MasterId")))}))).isEmpty() && (dynamicObject = (DynamicObject)masterBill.get(masterId)) != null) {
            rootIsv = dynamicObject.getString("isv");
        }
        if (isLimits && !StringUtils.isEmpty((CharSequence)rootIsv) && !rootIsv.equals(currentFormIsv)) {
            configMap.put("enableExtLimits", true);
        } else {
            configMap.put("enableExtLimits", false);
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setDesignerConfig", configMap);
    }

    public void sendFieldProsLock(Map<String, Object> fieldPropsLockList) {
        if (fieldPropsLockList == null || fieldPropsLockList.isEmpty()) {
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "lockProperty", fieldPropsLockList);
    }

    private void sortEntityItems(Map<String, Object> doc) {
        Map entityMeta = (Map)doc.get(ENTITY_META);
        if (entityMeta == null) {
            return;
        }
        List entityItems = (List)entityMeta.get(ITEMS);
        Collections.sort(entityItems, (o1, o2) -> {
            int compareValue = 0;
            Object parentIdO1 = o1.get(PARENT_ID);
            Object parentIdO2 = o2.get(PARENT_ID);
            compareValue = parentIdO1 == null && parentIdO2 == null ? 0 : (parentIdO1 == null && parentIdO2 != null ? -1 : (parentIdO1 != null && parentIdO2 == null ? 1 : ((String)parentIdO1).compareTo((String)parentIdO2)));
            if (compareValue != 0) {
                return compareValue;
            }
            Object indxO1 = o1.get(INDEX);
            Object indxO2 = o2.get(INDEX);
            compareValue = indxO1 == null && indxO2 == null ? 0 : (indxO1 == null && indxO2 != null ? -1 : (indxO1 != null && indxO2 == null ? 1 : Integer.compare((Integer)indxO1, (Integer)indxO2)));
            return compareValue;
        });
    }

    @KSMethod
    public void selectField(String entityID, boolean isStd) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devpn_addfield");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(ENTITY_ID, entityID);
        parameter.setCustomParam(FROM_ITEM, this.getKey());
        parameter.setCustomParam(IS_STD, isStd);
        CloseCallBack closeCallBack = new CloseCallBack(this.getClass().getName(), CALLBACK_SELECT_FIELD);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    @KSMethod
    public void deleteConfirm(String key, String id, boolean isEntity) {
        if (this.isReferenced(key, id, isEntity)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_devpn_deletehint");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("key", key);
            parameter.setCustomParam(DELETE_CONFIRM_ID, id);
            parameter.setCustomParam(DELETE_CONFIRM_IS_ENTITY, isEntity);
            parameter.setCustomParam(FROM_ITEM, this.getKey());
            CloseCallBack closeCallBack = new CloseCallBack(this.getClass().getName(), CALLBACK_DELETE_CONFIRM);
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        } else {
            if (!isEntity) {
                String deleteFieldKey = this.getView().getPageCache().get("deletefiledkey");
                Set cacheDeletField = StringUtils.isBlank((CharSequence)deleteFieldKey) ? new HashSet() : (Set)SerializationUtils.fromJsonString((String)deleteFieldKey, Set.class);
                cacheDeletField.add(key);
                this.getView().getPageCache().put("deletefiledkey", SerializationUtils.toJsonString(cacheDeletField));
            }
            IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            HashMap<String, String> data = new HashMap<String, String>(10);
            data.put("key", key);
            data.put(DELETE_CONFIRM_ID, id);
            service.invokeControlMethod(this.getKey(), DO_DELETE, data);
        }
    }

    protected boolean isReferenced(String key, String id, boolean isEntity) {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_ID);
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        return metadataService.isEntityItemReferenced(entityId, id);
    }

    private void fireGetPropertyAlias(PropertyEvent e) {
        if (this.listeners != null) {
            for (PropertyListener l : this.listeners) {
                l.getPropertyAlias(e);
            }
        }
    }

    private void fireClick(PropertyEvent e) {
        if (this.listeners != null) {
            for (PropertyListener l : this.listeners) {
                l.click(e);
            }
        }
    }

    private void fireCreateUIElemntByEntityItem(CreateUIElemntByEntityItemEvent e) {
        for (CreateUIElemntListener l : this.createUIElementlisteners) {
            l.createUIElemntByEntityItem(e);
        }
    }

    private void fireCreateUIByType(CreateUIByTypeEvent e) {
        for (CreateUIElemntListener l : this.createUIElementlisteners) {
            l.createUIByType(e);
        }
    }

    @KSMethod
    public void parseRiseEventTypes(List<Map<String, Object>> rets) {
        if (this.callListeners != null) {
            DesignerCallEvent e = new DesignerCallEvent();
            e.setActionId(CALL_ACTION_PARSE_RISE_EVENT_TYPES);
            e.setParam(rets);
            for (DesignerCallListener l : this.callListeners) {
                l.doCall(e);
            }
        }
    }

    @KSMethod
    public void parseRiseEventValues(List<Map<String, List<String>>> data) {
        if (this.callListeners != null) {
            DesignerCallEvent e = new DesignerCallEvent();
            e.setActionId(CALL_ACTION_PARSE_RISE_EVENT_VALUES);
            e.setParam(data);
            for (DesignerCallListener l : this.callListeners) {
                l.doCall(e);
            }
        }
    }

    @KSMethod
    public void showFunctionSetting(String fuctionId, String fieldTreeStr) {
        if (this.callListeners != null) {
            DesignerCallEvent e = new DesignerCallEvent();
            e.setActionId(CALL_ACTION_SHOW_FUNCTION_SETTING);
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("fuctionId", fuctionId);
            param.put("fieldTreeStr", fieldTreeStr);
            e.setParam(param);
            for (DesignerCallListener l : this.callListeners) {
                l.doCall(e);
            }
        }
    }

    @KSMethod
    public void showCustomRuleServiceSetting(String param) {
        if (this.callListeners != null) {
            DesignerCallEvent e = new DesignerCallEvent();
            e.setActionId(CALL_ACTION_SHOW_CUSTOM_RULE_SERVICE_SETTING);
            e.setParam(param);
            for (DesignerCallListener l : this.callListeners) {
                l.doCall(e);
            }
        }
    }

    @KSMethod
    public void validateFormula(String formula) {
        if (this.callListeners != null) {
            DesignerCallEvent e = new DesignerCallEvent();
            String type = this.getView().getFormShowParameter().getFormConfig().getKdEncoding();
            formula = String.valueOf(DecodeHandlerFactory.getDecodeHandler(type).decode(formula));
            e.setActionId(VALIDATE_FORMULA);
            e.setParam(formula);
            for (DesignerCallListener l : this.callListeners) {
                l.doCall(e);
            }
        }
    }
}

