/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.KingScriptEditorListener;
import kd.bos.form.control.events.KingScriptEditorEvent;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.utils.KDEncodeUtil;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.exception.EnginePoolNotReadyException;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.scriptlet.ScriptletService;
import org.apache.commons.collections4.CollectionUtils;

@KSObject
@SdkPublic
public class KingScriptEdit
extends Control {
    private static final String api = "/serverscript/getScript.do?path=";
    private static final String GET_CODEEDITOR_GPT_CONFIG = "getCodeEditorGptConfig";
    private static final String GET_CODEEDITOR_CONFIG = "getCodeEditorConfig";
    private static final String SEND_CODE_EDITOR_DEBUG_PROTOCOL = "sendCodeEditorDebugProtocol";
    private List<KingScriptEditorListener> scriptEditorListeners = new ArrayList<KingScriptEditorListener>();

    public void addScriptEditorListener(KingScriptEditorListener Listener) {
        this.scriptEditorListeners.add(Listener);
    }

    @SdkInternal
    public void getCodeEditorConfig() {
        if (this.scriptEditorListeners != null) {
            KingScriptEditorEvent e = new KingScriptEditorEvent();
            e.setKey(GET_CODEEDITOR_CONFIG);
            e.setParam(new HashMap<String, Object>(0));
            for (KingScriptEditorListener l : this.scriptEditorListeners) {
                l.codeEditorAction(e);
            }
        }
    }

    @SdkInternal
    public void getCodeEditorGptConfig() {
        if (this.scriptEditorListeners != null) {
            KingScriptEditorEvent e = new KingScriptEditorEvent();
            e.setKey(GET_CODEEDITOR_GPT_CONFIG);
            e.setParam(new HashMap<String, Object>(0));
            for (KingScriptEditorListener l : this.scriptEditorListeners) {
                l.codeEditorAction(e);
            }
        }
    }

    @SdkInternal
    public void codeEditorAction(String key, Map<String, Object> param) {
        if (this.scriptEditorListeners != null) {
            KingScriptEditorEvent e = new KingScriptEditorEvent();
            e.setKey(key);
            e.setParam(param);
            for (KingScriptEditorListener l : this.scriptEditorListeners) {
                l.codeEditorAction(e);
            }
        }
    }

    @SdkInternal
    public void requestModule(Map<String, Object> args) {
        if (args == null || args.isEmpty() || !args.containsKey("modules")) {
            return;
        }
        List modules = (List)args.get("modules");
        Map scriptRequestPaths = Collections.emptyMap();
        try (KingScriptEngine engine = ProjectInitializerManager.getEngine(false);){
            scriptRequestPaths = engine.listModuleTypes(modules.toArray(new String[modules.size()]));
        }
        catch (EnginePoolNotReadyException e) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u811a\u672c\u5f15\u64ce\u6c60\u6b63\u5728\u521d\u59cb\u5316\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5\u3002(%s)", (String)"KingScriptEdit_0", (String)"bos-form-metadata", (Object[])new Object[0]), e.getMessage()));
        }
        catch (ScriptException e) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u811a\u672c\u5f15\u64ce\u83b7\u53d6\u5931\u8d25:%s", (String)"KingScriptEdit_1", (String)"bos-form-metadata", (Object[])new Object[0]), e.getMessage()));
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        ArrayList allScriptRequestPaths = new ArrayList();
        for (List value : scriptRequestPaths.values()) {
            allScriptRequestPaths.addAll(value);
        }
        ArrayList pathList = new ArrayList(10);
        if (allScriptRequestPaths != null) {
            allScriptRequestPaths.forEach(path -> pathList.add(api + path));
        }
        proxy.invokeControlMethod(this.getKey(), "setCodeEditorModules", pathList);
    }

    @SdkInternal
    public void sendCodeEditorDebugProtocol(Map<String, Object> args) {
        if (this.scriptEditorListeners != null) {
            KingScriptEditorEvent e = new KingScriptEditorEvent();
            e.setKey(SEND_CODE_EDITOR_DEBUG_PROTOCOL);
            e.setParam(args);
            for (KingScriptEditorListener l : this.scriptEditorListeners) {
                l.codeEditorAction(e);
            }
        }
    }

    @KSMethod
    public String getText() {
        return this.getTextByKey("v");
    }

    @KSMethod
    public String getSelectionText() {
        return this.getTextByKey("selection");
    }

    private String getTextByKey(String key) {
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        String content = (String)proxy.getViewState(this.getKey());
        return KDEncodeUtil.kdDecoding((String)content);
    }

    @Override
    @SdkInternal
    public void postBack(Object postValue) {
        super.postBack(postValue);
    }

    private String getPostDataKey() {
        return this.getKey() + "_pd";
    }

    @KSMethod
    public void setText(String text) {
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        proxy.setFieldProperty(this.getKey(), "v", text);
        proxy.postBack(this.getKey(), text);
    }

    @SdkInternal
    public void getCodeEditorFragmentTree() {
        ScriptletService scriptletService = ScriptletService.create();
        List tree = scriptletService.getCodeEditorFragmentTree();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setCodeEditorFragmentTree", tree);
    }

    @SdkInternal
    public void getCodeEditorFragment(String args) {
        ScriptletService scriptletService = ScriptletService.create();
        List result = scriptletService.getCodeEditorFragment(new String[]{args});
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setCodeEditorFragment", CollectionUtils.isNotEmpty((Collection)result) ? result.get(0) : null);
    }
}

