/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class ProgressBar
extends Control {
    private static final Log logger = LogFactory.getLog(ProgressBar.class);
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    @SdkInternal
    protected List<ProgresssListener> progressListeners;

    @KSMethod
    public void addProgressListener(ProgresssListener listener) {
        if (this.progressListeners == null) {
            this.progressListeners = new ArrayList<ProgresssListener>();
        }
        this.progressListeners.add(listener);
    }

    @KSMethod
    public void start() {
        this.run(true);
    }

    @KSMethod
    public void stop() {
        this.run(false);
    }

    @KSMethod
    public void run(boolean running) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "run", running);
    }

    @KSMethod
    public void setPercent(int v) {
        this.setPercent(v, null);
    }

    @KSMethod
    public void setPercent(int v, String title) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(this.getKey(), "percent", v);
        if (title != null) {
            proxy.setFieldProperty(this.getKey(), "text", title);
        }
    }

    @KSMethod
    @SdkInternal
    public int getPercent() {
        ProgressEvent evt = new ProgressEvent(this);
        if (this.progressListeners != null) {
            try {
                for (ProgresssListener l : this.progressListeners) {
                    EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".onProgress"));
                    Throwable throwable = null;
                    try {
                        l.onProgress(evt);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (span == null) continue;
                        if (throwable != null) {
                            try {
                                span.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        span.close();
                    }
                }
            }
            catch (Throwable t) {
                logger.error(t);
                this.stop();
                this.getView().showErrorNotification(t.getMessage());
            }
        }
        this.setPercent(evt.getProgress(), evt.getText());
        return evt.getProgress();
    }
}

