/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.FireFocusEvent;
import kd.bos.form.control.events.InputFocusListener;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.utils.KDEncodeUtil;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class RichTextEditor
extends Control {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private boolean contentEncode;
    private boolean fireFocus = false;
    private int maxRichTextLength = 20;
    private List<InputFocusListener> inputFocusListeners = new ArrayList<InputFocusListener>();

    @KSMethod
    public boolean isFireFocus() {
        return this.fireFocus;
    }

    public void setFireFocus(boolean isFireFocus) {
        this.fireFocus = isFireFocus;
    }

    @KSMethod
    public void addInputFocusListener(InputFocusListener listener) {
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        ArrayList<Object> paras = new ArrayList<Object>(2);
        HashMap<String, Boolean> ctl = new HashMap<String, Boolean>();
        ctl.put("fireFocusEvent", true);
        paras.add(this.getKey());
        paras.add(ctl);
        proxy.addAction("updateControlMetadata", paras);
        this.inputFocusListeners.add(listener);
    }

    @KSMethod
    public void inputFocus(boolean isFocus) {
        this.setFireFocus(isFocus);
        FireFocusEvent event = new FireFocusEvent(this);
        for (InputFocusListener inputFocusListener : this.inputFocusListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(inputFocusListener.getClass().getName() + ".inputFocus"));
            Throwable throwable = null;
            try {
                inputFocusListener.inputFocus(event);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    @KSMethod
    public String getText() {
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        String content = (String)proxy.getViewState(this.getKey());
        return KDEncodeUtil.kdDecoding((String)content);
    }

    @KSMethod
    public static String decode(String content) {
        return KDEncodeUtil.kdDecoding((String)content);
    }

    @KSMethod
    public void setText(String text) {
        text = this.subStringByMaxRichTextLength(text);
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        proxy.setFieldProperty(this.getKey(), "v", text);
        proxy.postBack(this.getKey(), text);
    }

    private String subStringByMaxRichTextLength(String text) {
        if (text != null) {
            int maxRichTextLength = this.getMaxRichTextLength();
            int maxBytes = maxRichTextLength * 1024 * 1024;
            byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
            if (bytes.length > maxBytes) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u5bcc\u6587\u672c\u5185\u5bb9\u5927\u5c0f\u4e3a\u3010%1$s B\u3011\u8d85\u51fa\u6700\u5927\u3010%2$s B\u3011\u9650\u5236\uff0c\u5185\u5bb9\u5c06\u88ab\u622a\u65ad\uff0c\u53ef\u4ee5\u5728\u8bbe\u8ba1\u5668-\u5bcc\u6587\u672c\u63a7\u4ef6\u5c5e\u6027\u3010\u6700\u5927\u5185\u5bb9\u5927\u5c0f\u3011\u91cd\u65b0\u8bbe\u7f6e\u6700\u5927\u503c\u3002", (String)"RichTextEditor_0", (String)"bos-form-metadata", (Object[])new Object[0]), bytes.length, maxBytes));
                byte[] subBytes = new byte[maxBytes];
                int i = 0;
                int startIndex = 0;
                int endIndex = maxBytes;
                while (startIndex < endIndex) {
                    subBytes[i++] = bytes[startIndex++];
                }
                text = new String(subBytes, StandardCharsets.UTF_8);
            }
        }
        return text;
    }

    @SimplePropertyAttribute(name="ContentEncode")
    public boolean isContentEncode() {
        return this.contentEncode;
    }

    public void setContentEncode(boolean contentEncode) {
        this.contentEncode = contentEncode;
    }

    @Override
    @SdkInternal
    public Object decode(Object postData) {
        return KDEncodeUtil.kdDecoding((String)postData.toString());
    }

    public void setFocus(int rowIndex) {
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setFocus", rowIndex);
    }

    public void setFocus() {
        this.setFocus(-1);
    }

    @SimplePropertyAttribute(name="MaxRichTextLength")
    public int getMaxRichTextLength() {
        return this.maxRichTextLength;
    }

    public void setMaxRichTextLength(int maxRichTextLength) {
        this.maxRichTextLength = maxRichTextLength;
    }
}

