/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.dynplugin;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.dynplugin.EntityDynamicProxyPluginFactory;
import kd.bos.entity.plugin.Plugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FormDynamicProxyPluginFactory {
    private static final Log log = LogFactory.getLog(FormDynamicProxyPluginFactory.class);
    public static final String FORM_PLUGIN = "1";
    public static final String BILL_PLUGIN = "2";
    public static final String LIST_PLUGIN = "3";
    public static final String FORM_PLUGIN_MOB = "5";
    public static final String BILL_PLUGIN_MOB = "6";
    public static final String LIST_PLUGIN_MOB = "7";
    private static HashMap<String, ProxyPluginInfo> dynamicProxyPluginMap = new HashMap(4);

    public static ProxyPluginInfo getProxyPluginInfo(String interfaceType, String client) {
        if (BILL_PLUGIN.equals(client)) {
            switch (interfaceType) {
                case "1": {
                    interfaceType = FORM_PLUGIN_MOB;
                    break;
                }
                case "2": {
                    interfaceType = BILL_PLUGIN_MOB;
                    break;
                }
                case "3": {
                    interfaceType = LIST_PLUGIN_MOB;
                    break;
                }
            }
        }
        return dynamicProxyPluginMap.get(interfaceType);
    }

    public static String getProxyPluginClassname(String interfaceType, String client) {
        ProxyPluginInfo proxyPluginInfo = FormDynamicProxyPluginFactory.getProxyPluginInfo(interfaceType, client);
        if (proxyPluginInfo != null) {
            return proxyPluginInfo.classname;
        }
        return null;
    }

    public static Plugin getProxyPlugin(String interfaceType, String client, int rowKey) {
        Plugin plugin = new Plugin();
        plugin.setClassName(FormDynamicProxyPluginFactory.getProxyPluginClassname(interfaceType, client));
        plugin.setEnabled(true);
        plugin.setType(0);
        plugin.setRowKey(rowKey);
        return plugin;
    }

    public static Method getEventmethod(String interfacetype, String client, String eventmethod) {
        List<Method> methodlist = FormDynamicProxyPluginFactory.getEventmethodList(interfacetype, client);
        for (Method method : methodlist) {
            if (!StringUtils.isNotBlank((CharSequence)eventmethod) || !eventmethod.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    public static List<Method> getEventmethodList(String interfacetype, String client) {
        Object proxyPluginInfo;
        ArrayList<Method> methodlist = null;
        String classname = "";
        String annotationType = "";
        if ("4".equals(interfacetype)) {
            proxyPluginInfo = EntityDynamicProxyPluginFactory.getProxyPluginInfo((String)interfacetype);
            if (proxyPluginInfo == null) {
                return new ArrayList<Method>(0);
            }
            classname = proxyPluginInfo.getClassname();
            annotationType = proxyPluginInfo.getAnnotationType();
        } else {
            proxyPluginInfo = FormDynamicProxyPluginFactory.getProxyPluginInfo(interfacetype, client);
            if (proxyPluginInfo == null) {
                return new ArrayList<Method>(0);
            }
            classname = ((ProxyPluginInfo)proxyPluginInfo).getClassname();
            annotationType = ((ProxyPluginInfo)proxyPluginInfo).getAnnotationType();
        }
        if (StringUtils.isEmpty((CharSequence)classname) || StringUtils.isEmpty((CharSequence)annotationType)) {
            return new ArrayList<Method>(0);
        }
        try {
            Class<?> pluginClass = Class.forName(classname);
            Method[] methods = pluginClass.getMethods();
            methodlist = new ArrayList(methods.length);
            for (Method method : methods) {
                if (!FormDynamicProxyPluginFactory.isDynProxyPluginMethod(method, annotationType)) continue;
                methodlist.add(method);
            }
        }
        catch (ClassNotFoundException exception) {
            log.error(exception.getMessage());
            methodlist = new ArrayList<Method>(0);
        }
        Collections.sort(methodlist, (o1, o2) -> {
            String name1 = o1.getName();
            String name2 = o2.getName();
            return name1.compareTo(name2);
        });
        return methodlist;
    }

    private static boolean isDynProxyPluginMethod(Method method, String annotationType) {
        boolean isExist = false;
        Annotation[] annotations = method.getAnnotations();
        if (annotations.length == 0) {
            return isExist;
        }
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().getName().equals(annotationType)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    static {
        dynamicProxyPluginMap.put(FORM_PLUGIN, new ProxyPluginInfo("kd.bos.form.plugin.FormDynamicProxyPlugin", "kd.bos.form.plugin.annotations.FormPluginMethod"));
        dynamicProxyPluginMap.put(BILL_PLUGIN, new ProxyPluginInfo("kd.bos.bill.BillDynamicProxyPlugin", "kd.bos.form.plugin.annotations.BillPluginMethod"));
        dynamicProxyPluginMap.put(LIST_PLUGIN, new ProxyPluginInfo("kd.bos.list.plugin.ListDynamicProxyPlugin", "kd.bos.form.plugin.annotations.ListPluginMethod"));
        dynamicProxyPluginMap.put(FORM_PLUGIN_MOB, new ProxyPluginInfo("kd.bos.form.plugin.MobFormDynamicProxyPlugin", "kd.bos.form.plugin.annotations.MobFormPluginMethod"));
        dynamicProxyPluginMap.put(BILL_PLUGIN_MOB, new ProxyPluginInfo("kd.bos.bill.MobBillDynamicProxyPlugin", "kd.bos.form.plugin.annotations.MobBillPluginMethod"));
        dynamicProxyPluginMap.put(LIST_PLUGIN_MOB, new ProxyPluginInfo("kd.bos.list.plugin.MobListDynamicProxyPlugin", "kd.bos.form.plugin.annotations.MobListPluginMethod"));
    }

    public static class ProxyPluginInfo {
        private String classname;
        private String annotationType;

        ProxyPluginInfo(String classname, String annotationType) {
            this.classname = classname;
            this.annotationType = annotationType;
        }

        public String getClassname() {
            return this.classname;
        }

        public String getAnnotationType() {
            return this.annotationType;
        }
    }
}

