/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.BindingContext;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.AssistantEdit;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.flex.IFieldFlexEdit;
import kd.bos.form.flex.IFlexEdit;
import kd.bos.list.ListShowParameter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AssistantFlexEdit
extends AssistantEdit
implements IFieldFlexEdit {
    private static String Key_Suffix = "_isFlexEdit";
    private static final long DEFAULT_FUNC = 16L;
    private List<Long> orgIds = new ArrayList<Long>();

    @Override
    public void setView(IFormView view) {
        super.setView(view);
    }

    @Override
    public void bindData(BindingContext bctx) {
        Object v = this.getBindingValue(bctx);
        if (this.prop == null) {
            return;
        }
        if (this.view instanceof IMobileView) {
            String[] keys = this.key.substring(2).split("__");
            FlexProp prop1 = (FlexProp)this.getModel().getProperty(keys[0]);
            if (prop1.getParent() instanceof EntryType) {
                EntryGrid grid = (EntryGrid)this.view.getControl(prop1.getParent().getName());
                int row = this.getModel().getEntryCurrentRowIndex(prop1.getParent().getName());
                this.clientViewProxy.setEntryFieldValue(grid, this.getFieldKey(), row, v);
                return;
            }
            this.clientViewProxy.setFieldProperty(this.getKey(), "v", v);
        } else {
            this.clientViewProxy.setFieldProperty(this.getKey(), "v", v);
        }
    }

    @Override
    public void click() {
        String[] keys = this.key.substring(2).split("__");
        super.click();
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
        String accountId = CacheKeyUtil.getAcctId();
        String type = String.format("%s_%s_isFlexEdit", accountId, this.view.getPageId());
        cache.put(type, keys[0] + Key_Suffix, (Object)"1");
    }

    @Override
    public IDataEntityProperty getProperty() {
        this.prop = this.getFlexModel().getProperty(this.key);
        return this.prop;
    }

    public void setProperty(IDataEntityProperty prop) {
        this.prop = prop;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
        String accountId = CacheKeyUtil.getAcctId();
        String type = String.format("%s_%s_isFlexEdit", accountId, this.view.getPageId());
        cache.remove(type);
        if (!(e.getReturnData() instanceof ListSelectedRowCollection)) {
            return;
        }
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        if (rows == null || rows.isEmpty() && !rows.isClearFlag()) {
            return;
        }
        if (!(this.getView() instanceof IMobileView) && !rows.isEmpty()) {
            this.showFrequent(rows);
        }
        this.modelSetValue(rows, rows.isClearFlag());
    }

    @Override
    protected void modelSetValue(ListSelectedRowCollection rows, boolean isAllowEmptyRow) {
        IDataModel flexModel = this.getFlexModel();
        if (rows.isEmpty()) {
            if (isAllowEmptyRow) {
                flexModel.setValue(this.getKey(), null);
                flexModel.updateCache();
                this.splitSaveDelegate(this.view, this.key);
            }
            return;
        }
        Object value = rows.get(0).getPrimaryKeyValue();
        flexModel.setValue(this.getKey(), value);
        flexModel.updateCache();
        this.splitSaveDelegate(this.view, this.key);
    }

    @Override
    public void setItemByNumber(String number) {
        this.setItemByNumber(number, 0);
    }

    @Override
    public void setItemByNumber(String number, int rowKey) {
        this.getFlexModel().setItemValueByNumber(this.getKey(), number, 0);
        this.getFlexModel().updateCache();
        this.splitSaveDelegate(this.view, this.key);
    }

    @Override
    public void setItemByIdFromClient(List<Object> args) {
        if (args != null && StringUtils.isNotBlank((Object)args.get(0))) {
            Object pk = args.get(0);
            String[] keys = this.key.substring(2).split("__");
            IFlexEdit be = (IFlexEdit)this.view.getControl(keys[0]);
            IDataModel model = be.getFlexModel();
            model.setItemValueByID(this.key, pk, 0);
            model.updateCache();
            this.showFrequent(null);
            this.splitSaveDelegate(this.view, this.key);
        }
    }

    @Override
    protected IDataModel getDataModel() {
        return this.getFlexModel();
    }

    @Override
    protected Object getPkId(int rowIndex) {
        String[] keys = this.key.substring(2).split("__");
        IFlexEdit be = (IFlexEdit)this.view.getControl(keys[0]);
        Object obj = be.getFlexModel().getValue(this.key);
        if (obj == null) {
            return null;
        }
        return ((DynamicObject)obj).getPkValue();
    }

    @Override
    protected ListShowParameter createAndSetListShowParameter(String sourceMethod) {
        if (FormMetadataCache.getListFormConfig(this.getBaseEntityId()) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u57fa\u7840\u8d44\u6599\u672a\u8bbe\u8ba1F7\u5217\u8868\u3002", (String)"AssistantFlexEdit_0", (String)"bos-form-metadata", (Object[])new Object[0]));
        }
        ListShowParameter para = super.createAndSetListShowParameter(sourceMethod);
        String[] keys = this.key.substring(2).split("__");
        FlexEdit be = (FlexEdit)this.view.getControl(keys[0]);
        BeforeF7SelectEvent e = new BeforeF7SelectEvent(this, -1, this.getFlexModel().getValue(this.key));
        e.setFormShowParameter(para);
        be.getFlexBasedataService().beforeFlexItemF7(e);
        if (e.isCancel()) {
            return null;
        }
        return para;
    }

    @Override
    protected boolean isFilterByOrg(AssistantProp asstProp) {
        MainEntityType dt = this.getModel().getDataEntityType();
        return !(dt instanceof MainEntityType) || dt.getMainOrg() != null;
    }

    private IDataModel getFlexModel() {
        String[] keys = this.key.substring(2).split("__");
        IFlexEdit be = (IFlexEdit)this.view.getControl(keys[0]);
        return be.getFlexModel();
    }

    public List<Long> getOrgIds() {
        return this.orgIds;
    }

    public void setOrgIds(List<Long> orgIds) {
        this.orgIds = orgIds;
    }

    @Override
    protected void lookUpListInvoke(Map<String, Object> data) {
        BiConsumer<FlexEdit, Integer> handle = (flexEdit, integer) -> {
            data.put("r", integer);
            this.clientViewProxy.invokeControlMethod(flexEdit.getEntryControlKey(), "setLookUpListValue", data);
        };
        if (this.splitDelegate(this.view, this.key, handle)) {
            return;
        }
        super.lookUpListInvoke(data);
    }
}

