/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.CityProp;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IMobileView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.CityCacheUtil;
import kd.bos.form.field.CityEditUtil;
import kd.bos.form.field.CityORMUtil;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class CityEdit
extends BasedataEdit {
    private static final Log logger = LogFactory.getLog(CityEditUtil.class);
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private static final String BOS_FORM_METADATA = "bos-form-metadata";

    private FormShowParameter createShowMobileListForm(CityProp prop) {
        MobileFormShowParameter para = new MobileFormShowParameter();
        para.setFormId("bos_mobilecitylist");
        para.getOpenStyle().setShowType(ShowType.Floating);
        para.setLocate(true);
        para.setCustomParam("islookup", Boolean.TRUE);
        para.setCustomParam("entityId", prop.getBaseEntityId());
        return para;
    }

    @Override
    public Object getBindingValue(BindingContext bctx) {
        Object value = this.getFieldValue(bctx);
        if (value == null) {
            return null;
        }
        Object[] valueJson = new Object[5];
        Object[] val = (Object[])this.getBindingBasedataValue(value);
        System.arraycopy(val, 0, valueJson, 0, 2);
        Object id = ((DynamicObject)value).getPkValue();
        valueJson[2] = id.toString();
        CityEditUtil.setCountryAndProvince(id, valueJson);
        return valueJson;
    }

    @Override
    public void click() {
        CityProp prop;
        int row = this.getView().getModel().getEntryCurrentRowIndex(this.getProperty().getParent().getName());
        BeforeF7SelectEvent evt = new BeforeF7SelectEvent(this, row, this.getModel().getValue(this.isFlatField() ? this.getFieldKey() : this.key));
        if (this.beforeF7SelectListeners != null) {
            for (BeforeF7SelectListener l : this.beforeF7SelectListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".beforeF7Select"));
                Throwable throwable = null;
                try {
                    l.beforeF7Select(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
            if (evt.isCancel()) {
                return;
            }
        }
        if ((prop = (CityProp)this.getProperty()) != null) {
            if (this.getView() instanceof IMobileView) {
                FormShowParameter para = null;
                para = this.createShowMobileListForm(prop);
                CloseCallBack closeCallBack = new CloseCallBack();
                closeCallBack.setControlKey(this.getKey());
                para.setCloseCallBack(closeCallBack);
                this.view.showForm(para);
            } else {
                this.requestCityList(0);
            }
        }
    }

    public void setLocation(Map<String, String> list) {
        QFilter[] qFilters;
        DynamicObjectCollection cities;
        BillShowParameter billShowParameter;
        boolean isLocate = false;
        FormShowParameter parameter = this.view.getFormShowParameter();
        if (parameter instanceof BillShowParameter && (billShowParameter = (BillShowParameter)this.view.getFormShowParameter()).getStatus() == OperationStatus.ADDNEW) {
            isLocate = true;
        }
        if (!isLocate) {
            return;
        }
        Map<String, String> cityName = list;
        String city = cityName.get("city");
        if (city.endsWith(ResManager.loadKDString((String)"\u5e02", (String)"CityEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]))) {
            city = city.substring(0, city.length() - 1);
        }
        if ((cities = CityORMUtil.getCityLists(qFilters = new QFilter[]{new QFilter("name", "like", (Object)city), new QFilter("enable", "=", (Object)"1")})).size() == 0) {
            this.getView().showErrorNotification(String.format("city %s not find", city));
        }
        for (DynamicObject dynamicObject : cities) {
            String simplespell = dynamicObject.get("simplespell").toString();
            if (simplespell == null) continue;
            String number = dynamicObject.get("number").toString();
            ((CityProp)this.getProperty()).setDefValue(String.valueOf(number));
            int rowIndex = this.getView().getModel().getEntryCurrentRowIndex(this.getProperty().getParent().getName());
            this.getView().getModel().setValue(this.key, (Object)dynamicObject, rowIndex);
            break;
        }
    }

    public void requestCityList(Integer countryId) {
        if (countryId == 0) {
            countryId = 1000001;
        }
        Map<String, Object> citys = CityEditUtil.requestCityList(countryId.longValue(), false);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        IDataEntityType parentType = this.getProperty().getParent();
        if (parentType instanceof EntryType) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("k", this.key);
            map.put("r", this.getModel().getEntryCurrentRowIndex(parentType.getName()));
            map.put("data", citys);
            proxy.invokeControlMethod(this.getEntryGrid().getKey(), "responseCityList", map);
        } else {
            proxy.invokeControlMethod(this.getKey(), "responseCityList", citys);
        }
    }

    public void requestIntnVerCityList(Integer countryId) {
        if (countryId == 0) {
            countryId = 1000001;
        }
        Map<String, Object> citys = CityEditUtil.requestCityList(countryId.longValue(), true);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        IDataEntityType parentType = this.getProperty().getParent();
        if (parentType instanceof EntryType) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("k", this.key);
            map.put("r", this.getModel().getEntryCurrentRowIndex(parentType.getName()));
            map.put("data", citys);
            proxy.invokeControlMethod(this.getEntryGrid().getKey(), "responseIntnVerCityList", map);
        } else {
            proxy.invokeControlMethod(this.getKey(), "responseIntnVerCityList", citys);
        }
    }

    public void getCityGroupList(Integer type, String groupStr, Integer pageSize) {
        this.getCityGroupList(type, groupStr, pageSize, "-1");
    }

    public void getCityGroupList(Integer type, String groupStr, Integer pageSize, String lastCityId) {
        long start = System.currentTimeMillis();
        char[] groupArray = groupStr.toCharArray();
        HashMap<Character, List> groupMap = new HashMap<Character, List>(16);
        HashMap<Character, Map> groupExtraMsgMap = new HashMap<Character, Map>(16);
        for (char group : groupArray) {
            Map<String, Object> cityGroupMap = CityCacheUtil.getCityGroupList(type, group, pageSize, Long.valueOf(lastCityId));
            groupMap.put(Character.valueOf(group), (List)cityGroupMap.get("curentPageCityList"));
            groupExtraMsgMap.put(Character.valueOf(group), (Map)cityGroupMap.get("extraMsgMap"));
        }
        long end = System.currentTimeMillis();
        logger.debug(String.format("CityEdit getCityGroupList method handle %s:%s time is %sms", type, groupStr, end - start));
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        resultMap.put("menu", type);
        resultMap.put("groupList", groupMap);
        resultMap.put("extraMsgList", groupExtraMsgMap);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        IDataEntityType parentType = this.getProperty().getParent();
        if (parentType instanceof EntryType) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("k", this.key);
            map.put("r", this.getModel().getEntryCurrentRowIndex(parentType.getName()));
            map.put("data", resultMap);
            proxy.invokeControlMethod(this.getEntryGrid().getKey(), "setCityGroupList", map);
        } else {
            proxy.invokeControlMethod(this.getKey(), "setCityGroupList", resultMap);
        }
    }

    public void getCitySearchList(Integer type, String keyword) {
        Long start = System.currentTimeMillis();
        List<Map<String, Object>> searchCityList = CityEditUtil.getCitySearchList(type, keyword);
        Long end = System.currentTimeMillis();
        logger.debug(String.format("CityEdit getCitySearchList method handle %s time is %sms", keyword, end - start));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("menu", type);
        resultMap.put("keyword", keyword);
        resultMap.put("searchList", searchCityList);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        IDataEntityType parentType = this.getProperty().getParent();
        if (parentType instanceof EntryType) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("k", this.key);
            map.put("r", this.getModel().getEntryCurrentRowIndex(parentType.getName()));
            map.put("data", resultMap);
            proxy.invokeControlMethod(this.getEntryGrid().getKey(), "setCitySearchList", map);
        } else {
            proxy.invokeControlMethod(this.getKey(), "setCitySearchList", resultMap);
        }
    }

    public void getCityInfo(List<String> commonDomesticCityList) {
        this.getCityInfo(commonDomesticCityList, new ArrayList<String>(16));
    }

    public void getCityInfo(List<String> commonDomesticCityList, List<String> commonForeignCityList) {
        long start = System.currentTimeMillis();
        ArrayList<Long> domesticList = new ArrayList<Long>();
        commonDomesticCityList.forEach(val -> {
            try {
                domesticList.add(Long.parseLong(val));
            }
            catch (NumberFormatException e) {
                logger.error((Throwable)e);
            }
        });
        Map<String, Object> resultMap = CityEditUtil.getCityInfo(domesticList);
        long end = System.currentTimeMillis();
        logger.debug(String.format("CityEdit getCityInfo method handle time is %sms", end - start));
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        IDataEntityType parentType = this.getProperty().getParent();
        if (parentType instanceof EntryType) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("k", this.key);
            map.put("r", this.getModel().getEntryCurrentRowIndex(parentType.getName()));
            map.put("data", resultMap);
            proxy.invokeControlMethod(this.getEntryGrid().getKey(), "setCityInfo", map);
        } else {
            proxy.invokeControlMethod(this.getKey(), "setCityInfo", resultMap);
        }
    }
}

