/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.PinYinBaseUtil;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class ORMUtil {
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static final String ID_NAME = "id,name";
    private static final String ID_ASC = "id asc";
    private static final String COUNTRY = "country";
    private static final String GROUP_TITLE = "groupTitle";
    private static final String ITEMS = "items";
    private static final String BD_ADMINDIVISION = "bd_admindivision";
    private static final String SPAN_TYPE_NAME = "ORMUtil";
    private static Log logger = LogFactory.getLog(ORMUtil.class);

    public static List<Map<String, String>> getCountrys() {
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObjects = orm.query("bd_country", ID_NAME, null, ID_ASC);
        ArrayList<Map<String, String>> countrys = new ArrayList<Map<String, String>>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dynamicObject.get("id").toString());
            map.put("name", dynamicObject.get("name").toString());
            countrys.add(map);
        }
        return countrys;
    }

    private static Map<String, Map<String, Object>> getTelephoneFormatByCountryId(Set<Long> countryIds) {
        StringBuilder countryId = new StringBuilder();
        for (Long id : countryIds) {
            countryId.append(id).append(',');
        }
        String substring = countryId.substring(0, countryId.length() - 1);
        String sql = "select fcountryid, fdigit, fsegment, fischeck from t_cts_telephoneformat where fcountryid in (" + substring + ") and fischeck != '0'";
        HashMap rules = new HashMap(16);
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sql, null, rs -> {
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>(64);
                map.put("digit", rs.getString(2));
                map.put("segment", ORMUtil.splitSegment(rs.getString(3)));
                map.put("isCheck", rs.getString(4));
                rules.put(rs.getString(1), map);
            }
            return rules;
        });
    }

    private static Set<String> splitSegment(String segment) {
        String[] split;
        HashSet<String> set = new HashSet<String>(16);
        for (String s : split = segment.split(",")) {
            if (s.contains("-")) {
                String[] strings = s.split("-");
                String s1 = strings[0];
                String s2 = strings[1];
                for (int i = Integer.parseInt(s1); i <= Integer.parseInt(s2); ++i) {
                    set.add(Integer.toString(i));
                }
                continue;
            }
            set.add(s);
        }
        return set;
    }

    public static Map<String, List<Map<String, Object>>> getCountryAndAreaCode() {
        TreeMap<String, List<Map<String, Object>>> countryAreaCode = new TreeMap<String, List<Map<String, Object>>>(new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return arg0.compareTo(arg1);
            }
        });
        DynamicObject[] countries = ORMUtil.load("bd_country", "id, number, name, areacode, simplespell, description, twocountrycode", new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        if (countries == null || countries.length == 0) {
            return countryAreaCode;
        }
        Set<Long> longs = Arrays.stream(countries).map(e -> e.getLong("id")).collect(Collectors.toSet());
        Map<String, Map<String, Object>> rules = ORMUtil.getTelephoneFormatByCountryId(longs);
        Lang lang = RequestContext.get().getLang();
        HashMap<String, Object> countryMap = null;
        for (DynamicObject country : countries) {
            String areaCode = country.getString("areacode");
            if (null == areaCode || "".equals(areaCode.trim())) continue;
            countryMap = new HashMap<String, Object>();
            countryMap.put("name", country.getString("name"));
            countryMap.put("id", areaCode);
            countryMap.put("jp", country.getString("simplespell"));
            countryMap.put("qp", country.getString("description"));
            countryMap.put("code2", country.getString("twocountrycode"));
            countryMap.put("number", country.getString("number"));
            Map<String, Object> map = rules.get(country.getString("id"));
            if (map != null && map.size() > 0) {
                countryMap.put("digit", map.get("digit"));
                countryMap.put("segment", map.get("segment"));
                countryMap.put("isCheck", map.get("isCheck"));
            }
            OrmLocaleValue localeValue = (OrmLocaleValue)country.get("name");
            String localName = Lang.zh_CN.equals((Object)lang) || Lang.zh_TW.equals((Object)lang) || Lang.en_US.equals((Object)lang) || Lang.ES.equals((Object)lang) ? localeValue.getLocaleValue() : localeValue.getLocaleValue_zh_CN();
            if (StringUtils.isEmpty((CharSequence)localName)) continue;
            try {
                String firstSpell = PinYinBaseUtil.converterToFirstSpell(localName);
                if ((Lang.zh_CN.equals((Object)lang) || Lang.zh_TW.equals((Object)lang)) && localName.startsWith("\u963f") && StringUtils.isNotBlank((CharSequence)firstSpell)) {
                    firstSpell = ORMUtil.getFirstSpell(firstSpell);
                }
                char firstLetter = firstSpell.toUpperCase().charAt(0);
                countryAreaCode.computeIfAbsent(String.valueOf(firstLetter), k -> new ArrayList()).add(countryMap);
            }
            catch (BadHanyuPinyinOutputFormatCombination e2) {
                logger.error(localName + "\u8f6c\u6362\u62fc\u97f3\u9996\u5b57\u6bcd\u5f02\u5e38", (Throwable)e2);
            }
        }
        return countryAreaCode;
    }

    private static String getFirstSpell(String firstSpell) {
        StringBuilder builder = new StringBuilder();
        String[] res = firstSpell.trim().split(",");
        for (int i = 0; i < res.length; ++i) {
            if (res[i].charAt(0) != 'a') continue;
            builder.append(res[i]);
            if (i == res.length - 1) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public static DynamicObject[] load(String entityName, String selectProperties, QFilter[] filters) {
        DynamicObjectType type = ORMUtil.getSubEntityType(entityName, selectProperties);
        IDSet idSet = new IDSet();
        try (DataSet ds = ORM.create().queryDataSet("BusinessDataServiceHelper.load", entityName, "id", filters);){
            ds.forEach(row -> idSet.add(row.get(0)));
        }
        return BusinessDataReader.load((Object[])idSet.toArray(), (DynamicObjectType)type, (Boolean)true);
    }

    private static DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        String[] properties = selectProperties.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        for (String prop : properties) {
            select.add(prop.trim());
        }
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)entityName, select);
        return type;
    }

    public static List<Map<String, String>> getAdmindivisionLevelsByCountryId(String countryId) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter(COUNTRY, "=", (Object)Long.parseLong(countryId));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dynamicObjects = orm.query("bd_admindivisionlevel", ID_NAME, filters, ID_ASC);
        ArrayList<Map<String, String>> admindivisionLevels = new ArrayList<Map<String, String>>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dynamicObject.get("id").toString());
            map.put("name", dynamicObject.get("name").toString());
            admindivisionLevels.add(map);
        }
        return admindivisionLevels;
    }

    public static List<Map<String, Object>> getProvincesByCountryId(String countryId) {
        QFilter filter1;
        QFilter filter;
        QFilter[] filters;
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObjects = orm.query(BD_ADMINDIVISION, "id,name,simplespell", filters = new QFilter[]{filter = new QFilter(COUNTRY, "=", (Object)Long.parseLong(countryId)), filter1 = new QFilter("level", "=", (Object)1)}, ID_ASC);
        if (dynamicObjects.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList provinces1 = new ArrayList();
        ArrayList provinces2 = new ArrayList();
        ArrayList provinces3 = new ArrayList();
        ArrayList provinces4 = new ArrayList();
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dynamicObject.get("id").toString());
            map.put("name", dynamicObject.get("name").toString());
            String simplespell = dynamicObject.get("simplespell").toString();
            char i = simplespell.toUpperCase().charAt(0);
            if (simplespell == null) continue;
            if (i >= 'A' && i <= 'G') {
                provinces1.add(map);
            }
            if (i >= 'H' && i <= 'K') {
                provinces2.add(map);
            }
            if (i >= 'L' && i <= 'S') {
                provinces3.add(map);
            }
            if (i < 'T' || i > 'Z') continue;
            provinces4.add(map);
        }
        ArrayList<Map<String, Object>> provinces = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put(GROUP_TITLE, "A-G");
        map1.put(ITEMS, provinces1);
        provinces.add(map1);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put(GROUP_TITLE, "H-K");
        map2.put(ITEMS, provinces2);
        provinces.add(map2);
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put(GROUP_TITLE, "L-S");
        map3.put(ITEMS, provinces3);
        provinces.add(map3);
        HashMap<String, Object> map4 = new HashMap<String, Object>();
        map4.put(GROUP_TITLE, "T-Z");
        map4.put(ITEMS, provinces4);
        provinces.add(map4);
        return provinces;
    }

    public static List<Map<String, String>> getProvincesByCountryIdForMobile(String countryId) {
        ArrayList<Map<String, String>> provinces = new ArrayList<Map<String, String>>();
        ORM orm = ORM.create();
        QFilter filter = new QFilter(COUNTRY, "=", (Object)Long.parseLong(countryId));
        QFilter filter1 = new QFilter("level", "=", (Object)1);
        QFilter[] filters = new QFilter[]{filter, filter1};
        DynamicObjectCollection dynamicObjects = orm.query(BD_ADMINDIVISION, ID_NAME, filters, ID_ASC);
        if (dynamicObjects.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dynamicObject.get("id").toString());
            map.put("name", dynamicObject.get("name").toString());
            provinces.add(map);
        }
        return provinces;
    }

    public static List<Map<String, String>> getAdminDivisionsByParentId(String parentId) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("parent", "=", (Object)Long.parseLong(parentId));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dynamicObjects = orm.query(BD_ADMINDIVISION, ID_NAME, filters, ID_ASC);
        ArrayList<Map<String, String>> provinces = new ArrayList<Map<String, String>>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dynamicObject.get("id").toString());
            map.put("name", dynamicObject.get("name").toString());
            provinces.add(map);
        }
        return provinces;
    }

    public static Map<String, Object> getAdminDivisionInfo(String adminId) {
        HashMap<String, Object> adminDivisionInfo = new HashMap<String, Object>();
        ORM orm = ORM.create();
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(adminId));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dynamicObjects = orm.query(BD_ADMINDIVISION, "id,name,fullname,country.id,country.name", filters, ID_ASC);
        if (dynamicObjects.size() > 0) {
            adminDivisionInfo.put("countryId", ((DynamicObject)dynamicObjects.get(0)).getLong("country.id"));
            adminDivisionInfo.put("countryName", ((DynamicObject)dynamicObjects.get(0)).getString("country.name"));
            String fullname = ((DynamicObject)dynamicObjects.get(0)).getString("fullname");
            String[] fullNameArr = new String[]{};
            if (!StringUtils.isEmpty((CharSequence)fullname)) {
                fullNameArr = fullname.split("_");
            }
            adminDivisionInfo.put("adminvisionAry", fullNameArr);
        }
        return adminDivisionInfo;
    }

    public static String getFormIdByBillTypeId(long billTypeId) {
        Map<String, String> resultMap = ORMUtil.getFormIdByBillTypeId(billTypeId, false);
        return resultMap.get("formId");
    }

    public static Map<String, String> getFormIdByBillTypeId(long billTypeId, boolean isMob) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"getFormIdByBillTypeId");){
            boolean isMobFormId = false;
            String formId = "";
            DynamicObjectType dt_billType = EntityMetadataCache.getSubDataEntityType((String)"bos_billtype", Arrays.asList("id", "number", "billformid", "layoutsolution", "mob_layoutsolution"));
            Map billTypeObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{billTypeId}, (DynamicObjectType)dt_billType, (boolean)false);
            DynamicObject billTypeObj = (DynamicObject)billTypeObjs.get(billTypeId);
            String layoutId = billTypeObj.getString("layoutsolution");
            String mobLayoutId = billTypeObj.getString("mob_layoutsolution");
            if (isMob && StringUtils.isNotBlank((CharSequence)mobLayoutId) && !"0".equals(mobLayoutId)) {
                layoutId = mobLayoutId;
                isMobFormId = true;
            }
            if (span.isRealtime()) {
                span.addLocaleTag("billTypeId", (Object)billTypeId);
                span.addLocaleTag("isMob", (Object)isMob);
                span.addTag("layoutId", layoutId);
                span.addTag("mobLayoutId", mobLayoutId);
            }
            if (StringUtils.isBlank((CharSequence)layoutId) || "null".equals(layoutId)) {
                formId = billTypeObj.getString("billformid_id");
            } else {
                DynamicObjectType dt_formmeta = EntityMetadataCache.getSubDataEntityType((String)"bos_formmeta", Arrays.asList("id", "number", "modeltype", "parentid", "basedatafield"));
                Map formmetaObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{layoutId}, (DynamicObjectType)dt_formmeta, (boolean)false);
                if (formmetaObjs == null || formmetaObjs.size() <= 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u7c7b\u578b\u7684\u5e03\u5c40\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"ORMUtil_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
                }
                DynamicObject formmetaObj = (DynamicObject)formmetaObjs.get(layoutId);
                formId = formmetaObj.getString("number");
                String modeltype = formmetaObj.getString("modeltype");
                if (isMob && StringUtils.isNotBlank((CharSequence)modeltype) && !"MobileBillFormModel".equals(modeltype)) {
                    String id = formmetaObj.getString("id");
                    String formEntityId = formmetaObj.getString("basedatafield_id");
                    String formParentId = formmetaObj.getString("parentid_id");
                    if (span.isRealtime()) {
                        span.addTag("formEntityId", formEntityId);
                        span.addTag("formParentId", formParentId);
                        span.addTag("id", id);
                        span.addTag("modeltype", modeltype);
                    }
                    formId = !id.equals(formEntityId) && "".equals(formParentId) ? "" : formId + "_mob";
                }
            }
            HashMap<String, String> resultMap = new HashMap<String, String>(2);
            resultMap.put("formId", formId);
            resultMap.put("isMobFormId", String.valueOf(isMobFormId));
            if (span.isRealtime()) {
                span.addLocaleTag("resultMap", resultMap);
            }
            HashMap<String, String> hashMap = resultMap;
            return hashMap;
        }
    }

    private static class IDSet {
        private final Set<Object> sameSet = new HashSet<Object>();
        private final List<Object> idList = new ArrayList<Object>();

        private IDSet() {
        }

        void add(Object obj) {
            if (this.sameSet.add(obj)) {
                this.idList.add(obj);
            }
        }

        Object[] toArray() {
            return this.idList.toArray();
        }
    }
}

