/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.field.FieldEdit;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class TimeEdit
extends FieldEdit {
    private static final String FOCUS_VALUE = "focusValue";
    private static final String ROW_INDEX = "rowIndex";
    private int hours;
    private int minutes;
    private int seconds;
    private int secondOfTime;
    private List<ITimeDataConvert> converts = new ArrayList<ITimeDataConvert>();

    public TimeEdit() {
        this("HH:mm:ss");
    }

    public TimeEdit(String fmtString) {
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getSecondOfTime() {
        return this.secondOfTime;
    }

    public String getTime() {
        return null;
    }

    @Override
    public void postBack(Object value) {
        super.postBack(value);
    }

    @Override
    public void postBack(Object value, int rowIndex, int parentRowIndex) {
        this.view.getModel().setValue(this.getFieldKey(), (Object)this.intOfTime(value), rowIndex, parentRowIndex);
    }

    @Override
    protected Object getFieldValue(BindingContext bctx) {
        IDataEntityProperty property = this.getProperty();
        if (property == null) {
            return null;
        }
        Object val = property.getValue(bctx.getDataEntity());
        if (StringUtils.equals((CharSequence)"-1", (CharSequence)String.valueOf(val))) {
            return null;
        }
        return val;
    }

    private int intOfTime(Object value) {
        if (value instanceof String) {
            String timeStr = (String)value;
            if (timeStr.isEmpty()) {
                this.secondOfTime = -1;
                return -1;
            }
            for (ITimeDataConvert convert : this.getDataConvert()) {
                if (!convert.isMatched(timeStr)) continue;
                int realTime = convert.getData(timeStr);
                this.hours = realTime / 3600;
                this.minutes = realTime % 3600 / 60;
                this.seconds = realTime % 60;
                this.secondOfTime = realTime;
                return convert.getData(timeStr);
            }
            throw new KDBizException(BosErrorCode.conversionNotSupported, new Object[]{String.format(ResManager.loadKDString((String)"\u65f6\u95f4\u8f6c\u6362\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\uff1a%s", (String)"TimeEdit_0", (String)"bos-form-metadata", (Object[])new Object[0]), value.toString())});
        }
        return this.secondOfTime;
    }

    private List<ITimeDataConvert> getDataConvert() {
        if (this.converts.isEmpty()) {
            this.converts.add(new IntegerStrConvert());
            this.converts.add(new FmtStrConvert());
        }
        return this.converts;
    }

    public void setTimeFocusValue(long time) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FOCUS_VALUE, Collections.singletonList(String.valueOf(time)));
        map.put(ROW_INDEX, -1);
        proxy.invokeControlMethod(this.getKey(), "setTimeFocusValue", map);
    }

    public void setEntryTimeFocusValue(long time, int rowIndex) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FOCUS_VALUE, Collections.singletonList(String.valueOf(time)));
        map.put(ROW_INDEX, rowIndex);
        proxy.invokeControlMethod(this.getKey(), "setTimeFocusValue", map);
    }

    static class FmtStrConvert
    implements ITimeDataConvert {
        FmtStrConvert() {
        }

        @Override
        public boolean isMatched(String value) {
            Pattern pattern = Pattern.compile("^[0-9][0-9].[0-9][0-9].[0-9][0-9]");
            Matcher matcher = pattern.matcher(value);
            return matcher.matches();
        }

        @Override
        public int getData(String value) {
            int hour = Integer.parseInt(value.substring(0, 2));
            int minute = Integer.parseInt(value.substring(3, 5));
            int second = Integer.parseInt(value.substring(6, 8));
            return second + minute * 60 + hour * 3600;
        }
    }

    static class IntegerStrConvert
    implements ITimeDataConvert {
        IntegerStrConvert() {
        }

        @Override
        public boolean isMatched(String value) {
            Pattern pattern = Pattern.compile("[0-9]{1,}");
            Matcher matcher = pattern.matcher(value);
            return matcher.matches();
        }

        @Override
        public int getData(String value) {
            return Integer.parseInt(value);
        }
    }

    static interface ITimeDataConvert {
        public boolean isMatched(String var1);

        public int getData(String var1);
    }
}

