/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class UserAvatarEdit
extends BasedataPropEdit
implements ISuportClick {
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static final String GROUP_ID = "groupId";
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    protected List<ClickListener> clickListeners = new ArrayList<ClickListener>();

    @Override
    public void addClickListener(ClickListener listener) {
        this.clickListeners.add(listener);
    }

    @Override
    public void addItemClickListener(ItemClickListener listener) {
    }

    public void click() {
        BeforeClickEvent e = new BeforeClickEvent(this);
        this.fireBeforeClick(e);
        if (!e.isCancel()) {
            ClickEvent e1 = new ClickEvent(this);
            this.fireClick(e1);
        }
    }

    protected void fireBeforeClick(BeforeClickEvent e) {
        for (ClickListener l : this.clickListeners) {
            l.beforeClick(e);
        }
    }

    protected void fireClick(ClickEvent e) {
        if (ParameterHelper.isYzjEnable()) {
            this.yzjPCChat();
        }
        if (this.clickListeners != null) {
            for (ClickListener l : this.clickListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".click"));
                Throwable throwable = null;
                try {
                    l.click(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    private void yzjPCChat() {
        String clazzName = "kd.bos.login.yunzhijia.YunzhijiaUtils";
        try {
            QFilter f1;
            QFilter[] filters;
            String refProp = this.getRefBasedataProp();
            if (StringUtils.isBlank((CharSequence)refProp)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5458\u5de5\u5934\u50cf\u672a\u7ed1\u5b9a\u7528\u6237\u5b57\u6bb5", (String)"UserAvatarEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
                return;
            }
            DynamicObject objUser = (DynamicObject)this.getModel().getValue(refProp);
            if (objUser == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5355\u636e\u4e0a\u7684\u7528\u6237\u6570\u636e\u3002", (String)"UserAvatarEdit_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
                return;
            }
            ORM orm = ORM.create();
            DynamicObjectCollection docUser = orm.query("bos_user", "id,name,useropenid", filters = new QFilter[]{f1 = new QFilter("id", "=", (Object)objUser.getLong("id"))}, "id asc");
            if (docUser == null || docUser.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"UserAvatarEdit_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
                return;
            }
            DynamicObject doUser = (DynamicObject)docUser.get(0);
            HashMap<String, String> mpUser = new HashMap<String, String>();
            mpUser.put("openId", doUser.getString("useropenid"));
            mpUser.put("userName", doUser.getString("name"));
            ArrayList<HashMap<String, String>> chatUsers = new ArrayList<HashMap<String, String>>();
            chatUsers.add(mpUser);
            Class<?> clazz = Class.forName(clazzName);
            Method method = clazz.getMethod("getImGroupIdByOpenIds", List.class);
            Map group = (Map)method.invoke(clazz.newInstance(), chatUsers);
            if (group == null || group.size() == 0) {
                return;
            }
            if (((Boolean)group.get("created")).booleanValue()) {
                Thread.sleep(6000L);
            }
            if (group.get(GROUP_ID) != null) {
                String groupId = group.get(GROUP_ID).toString();
                HashMap<String, String> mp = new HashMap<String, String>();
                mp.put(GROUP_ID, groupId);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("chatToYZJ_PC", mp);
            }
        }
        catch (Exception ex) {
            throw new KDException((Throwable)ex, new ErrorCode("", ""), new Object[]{String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4e91\u4e4b\u5bb6\u804a\u5929\u7fa4\u7ec4\u5931\u8d25.%s", (String)"UserAvatarEdit_3", (String)BOS_FORM_METADATA, (Object[])new Object[0]), ex.getMessage())});
        }
    }
}

