/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.flex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.TextProp;
import kd.bos.flex.FlexService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FlexValueFormatUtils {
    private static final String FORMAT = "%s:%s";
    private static final String NUMBER = "number";

    private FlexValueFormatUtils() {
    }

    private static MainEntityType getFlexEntityType(DynamicObject v, FlexProp flexProp, String basePropDataKey) {
        DynamicObject relateBaseData = v.getDynamicObject(basePropDataKey);
        List<Long> flexPropertyIds = FlexValueFormatUtils.getBasedataUsedFlexProperties(relateBaseData);
        return FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)v.getDataEntityType().getName(), (String)flexProp.getName(), (int)flexProp.getFlexTypeId(), flexPropertyIds);
    }

    private static List<Long> getBasedataUsedFlexProperties(DynamicObject relateBaseData) {
        if (relateBaseData == null || !(relateBaseData.getDataEntityType() instanceof BasedataEntityType)) {
            return new ArrayList<Long>();
        }
        BasedataEntityType relateBDType = (BasedataEntityType)relateBaseData.getDataEntityType();
        String relateBDEntityNumber = relateBDType.getName();
        Object relateBDPKValue = relateBaseData.getPkValue();
        String relateBDFlexPropertyKey = relateBDType.getFlexProperty();
        if (StringUtils.isBlank((CharSequence)relateBDType.getFlexProperty()) && relateBDType.getMasteridType() == 2) {
            BasedataProp masterProp = (BasedataProp)relateBDType.getProperty(relateBDType.getMasteridPropName());
            relateBDFlexPropertyKey = ((BasedataEntityType)masterProp.getComplexType()).getFlexProperty();
            relateBDEntityNumber = masterProp.getBaseEntityId();
            DynamicObject masterObj = (DynamicObject)masterProp.getValue((Object)relateBaseData);
            if (masterObj == null) {
                return new ArrayList<Long>();
            }
            relateBDPKValue = masterObj.getPkValue();
        }
        return FlexService.getBaseUseFlexProperties((String)relateBDEntityNumber, (Object)relateBDPKValue, (String)relateBDFlexPropertyKey);
    }

    private static BiFunction<DynamicObjectType, Object, DynamicObject> getBiFunction() {
        return (basedataEntityType, baseValue) -> {
            Object[] pkValues = new Object[]{baseValue};
            Map loadFromCache = BusinessDataReader.loadFromCache((Object[])pkValues, (DynamicObjectType)basedataEntityType, (boolean)false);
            return (DynamicObject)loadFromCache.get(baseValue);
        };
    }

    public static String getReportDisplayValue(DynamicObject v, FlexProp flexProp) {
        Object val = flexProp.getValue((Object)v);
        if (val == null) {
            return "";
        }
        if (!(val instanceof DynamicObject)) {
            return "";
        }
        Object reportValue = flexProp.getReportValue(v, FlexValueFormatUtils.getBiFunction());
        return reportValue.toString();
    }

    public static String getReportDisplayValue(DynamicObject v, FlexProp flexProp, List<IDataEntityProperty> properties, Map<String, String> valueMap) {
        Object val = flexProp.getValue((Object)v);
        if (val == null) {
            return "";
        }
        if (!(val instanceof DynamicObject)) {
            return "";
        }
        return FlexValueFormatUtils.getReportClientValue(properties, valueMap, FlexValueFormatUtils.getBiFunction());
    }

    private static String getReportClientValue(List<IDataEntityProperty> properties, Map<String, String> valueMap, BiFunction<DynamicObjectType, Object, DynamicObject> loadReferenceData) {
        if (valueMap == null) {
            return "";
        }
        ArrayList<String> valueList = new ArrayList<String>();
        for (IDataEntityProperty flexObjectProp : properties) {
            if (!(flexObjectProp instanceof BasedataProp) && !(flexObjectProp instanceof AssistantProp) && !(flexObjectProp instanceof TextProp)) continue;
            valueList.add(FlexValueFormatUtils.getFlexValueString(flexObjectProp, valueMap, loadReferenceData));
        }
        return String.join((CharSequence)";", valueList);
    }

    private static String getFlexValueString(IDataEntityProperty flexObjectProp, Map<String, String> valueMap, BiFunction<DynamicObjectType, Object, DynamicObject> loadReferenceData) {
        String[] keys = flexObjectProp.getName().split("__");
        String value = valueMap.get(keys[1]);
        if (value != null) {
            if (flexObjectProp instanceof BasedataProp) {
                Object val = "";
                Object[] arrValue = FlexValueFormatUtils.flexBasePropValue((BasedataProp)flexObjectProp, value, loadReferenceData);
                val = "number,name".equalsIgnoreCase(((BasedataProp)flexObjectProp).getDisplayProp()) ? arrValue[0] + " " + arrValue[1] : (NUMBER.equalsIgnoreCase(((BasedataProp)flexObjectProp).getDisplayProp()) ? arrValue[0] : arrValue[1]);
                return String.format(FORMAT, ((BasedataProp)flexObjectProp).getDisplayName(), val);
            }
            if (flexObjectProp instanceof TextProp) {
                return String.format(FORMAT, ((FieldProp)flexObjectProp).getDisplayName(), value.toString());
            }
        }
        return "";
    }

    private static Object[] flexBasePropValue(BasedataProp flexObjectProp, Object value, BiFunction<DynamicObjectType, Object, DynamicObject> loadReferenceData) {
        DynamicObject baseDataObjectValue = FlexValueFormatUtils.getBaseDataObjectValue(flexObjectProp, value, loadReferenceData);
        String displayProperty = flexObjectProp.getDisplayProp();
        return (Object[])flexObjectProp.getBindingBasedataValue((Object)baseDataObjectValue, displayProperty);
    }

    private static DynamicObject getBaseDataObjectValue(BasedataProp flexObjectProp, Object value, BiFunction<DynamicObjectType, Object, DynamicObject> loadReferenceData) {
        Object baseValue = null;
        baseValue = value instanceof Integer ? Long.valueOf(((Integer)value).longValue()) : value;
        return loadReferenceData.apply((DynamicObjectType)flexObjectProp.getComplexType(), baseValue);
    }

    public static Map<String, Object> getQingValue(DynamicObject v, FlexProp flexProp, String basePropDataKey) {
        Object val = flexProp.getValue((Object)v);
        if (val == null) {
            return new HashMap<String, Object>();
        }
        if (!(val instanceof DynamicObject)) {
            return new HashMap<String, Object>();
        }
        return flexProp.getQingValue(FlexValueFormatUtils.getFlexEntityType(v, flexProp, basePropDataKey), v, FlexValueFormatUtils.getBiFunction());
    }

    public static Object getListDisplayValue(DynamicObject v, FlexProp flexProp, String basePropDataKey) {
        Object val = flexProp.getValue((Object)v);
        if (val == null) {
            return "";
        }
        if (!(val instanceof DynamicObject)) {
            return "";
        }
        return flexProp.getValue(FlexValueFormatUtils.getFlexEntityType(v, flexProp, basePropDataKey), v, FlexValueFormatUtils.getBiFunction());
    }
}

