/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.BillParam;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.facade.FacadeResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MsFormFacade;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoCheckDataPermissionArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.InitOperateOptionEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.CoreMutexHelper;
import kd.bos.form.operate.OpFieldValueReader;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.model.CheckDimObjParam;
import kd.bos.service.KDDateUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.service.TimeService;
import kd.bos.threads.ThreadPools;
import kd.bos.utils.DbTypeConverter;
import kd.bos.utils.LogPrintUtil;
import kd.bos.utils.SecurityTypeEnum;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class FormOperate
extends AbstractOperate {
    private static final String SPAN_TYPE_OPERATE = "operate";
    private static final String PERMISSION = "permission";
    private static final String FORM_OPERATE_5 = "FormOperate_5";
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static Log log = LogFactory.getLog(FormOperate.class);
    private String confirmMessage;
    private ConfirmTypes confirmTypes;
    private String permissionItemId;
    private boolean logEnable;
    private boolean opMessageEnable;
    private boolean saveAndSubmit;
    protected Long mainOrgId = null;
    ListSelectedRowCollection listSelectedData = new ListSelectedRowCollection();
    ListSelectedRow listFocusRow;
    private boolean caSign;
    private boolean verifySign;
    private String permissionEntityId;
    private MsFormFacade facade = new MsFormFacade();

    @Override
    public void initialize(Map<String, Object> opMeta) {
        String msg;
        super.initialize(opMeta);
        if (opMeta.get("sign") != null) {
            this.caSign = Boolean.parseBoolean(opMeta.get("sign").toString());
        }
        if (opMeta.get("verifySign") != null) {
            this.verifySign = Boolean.parseBoolean(opMeta.get("verifySign").toString());
        }
        this.confirmTypes = ConfirmTypes.Default;
        LocaleString confirmMsg = this.LocaleFromOpMeta(opMeta, "confirmMsg");
        if (confirmMsg != null && !confirmMsg.isEmpty() && StringUtils.isNotBlank((CharSequence)(msg = confirmMsg.toString()))) {
            this.confirmMessage = msg.replace("[]", "");
        }
        this.permissionItemId = (String)opMeta.get(PERMISSION);
        if (opMeta.containsKey("logEnable")) {
            this.logEnable = (Boolean)opMeta.get("logEnable");
        }
        if (opMeta.containsKey("opMessageEnable")) {
            this.opMessageEnable = (Boolean)opMeta.get("opMessageEnable");
        }
        if (opMeta.containsKey("saveAndSubmit")) {
            this.saveAndSubmit = (Boolean)opMeta.get("saveAndSubmit");
        }
    }

    @Override
    public void setView(IFormView view) {
        Map opMeta;
        super.setView(view);
        if (StringUtils.isNotBlank((CharSequence)this.getPermissionEntityId()) && (opMeta = EntityMetadataCache.getDataEntityOperate((String)this.getPermissionEntityId(), (String)this.getOperateKey())) != null && opMeta.containsKey(PERMISSION)) {
            this.permissionItemId = (String)opMeta.get(PERMISSION);
        }
    }

    public ConfirmTypes getConfirmTypes() {
        return this.confirmTypes;
    }

    public void setConfirmTypes(ConfirmTypes confirmTypes) {
        this.confirmTypes = confirmTypes;
    }

    public String getConfirmMessage() {
        return this.confirmMessage;
    }

    public void setConfirmMessage(String confirmMessage) {
        this.confirmMessage = confirmMessage;
    }

    public String getPermissionItemId() {
        return this.permissionItemId;
    }

    public boolean isLogEnable() {
        return this.logEnable;
    }

    public boolean isOpMessageEnable() {
        return this.opMessageEnable;
    }

    public boolean isSaveAndSubmit() {
        return this.saveAndSubmit;
    }

    public ListSelectedRowCollection getListSelectedData() {
        return this.listSelectedData;
    }

    public void setListSelectedData(ListSelectedRowCollection listSelectedData) {
        this.listSelectedData = listSelectedData;
    }

    public ListSelectedRow getListFocusRow() {
        return this.listFocusRow;
    }

    public void setListFocusRow(ListSelectedRow listFocusRow) {
        this.listFocusRow = listFocusRow;
    }

    public boolean needSelectData() {
        return true;
    }

    private String getCheckRightAppId() {
        String bizAppNumber = this.getView().getFormShowParameter().getCheckRightAppId();
        if (StringUtils.isNotBlank((CharSequence)bizAppNumber)) {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)bizAppNumber);
            return appInfo.getId();
        }
        return null;
    }

    @Override
    public OperationResult execute() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)"FormOperate.execute", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            span.addTag("entity", this.getEntityId());
            span.addTag("opKey", this.getOperateKey());
            span.addTag("opType", this.getClass().getSimpleName());
            span.addTag("opClass", this.getClass().getName());
            span.fireEvent("execute");
            FormViewPluginProxy formViewPluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            InitOperateOptionEventArgs initEvent = new InitOperateOptionEventArgs(this);
            initEvent.setListSelectedData(this.getListSelectedData());
            formViewPluginProxy.fireInitOperateOption(initEvent);
            this.getOperateLog().info(String.format("FormOperate.execute() begin: %s, %s", this.getEntityId(), this.getOperateKey()));
            OperationResult opResult = new OperationResult();
            FacadeResult facadeResult = this.facade.beforeInvokeOperation(opResult, this);
            if (facadeResult != null && facadeResult.isSuccess() && facadeResult.getCode() != 3) {
                OperationResult operationResult = opResult;
                return operationResult;
            }
            try (EntityTraceSpan span1 = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)(this.getClass().getSimpleName() + ".beforeInvokeOperation"), (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
                if (!this.beforeInvokeOperation(opResult)) {
                    this.getOperateLog().info("FormOperate.execute() beforeInvokeOperation: return false");
                    opResult.setSuccess(false);
                    OperationResult operationResult = opResult;
                    return operationResult;
                }
            }
            span1 = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)(this.getClass().getSimpleName() + ".invokeOperation"));
            var8_11 = null;
            try {
                this.getOperateLog().info("FormOperate.execute() call invokeOperation");
                opResult = this.invokeOperation();
            }
            catch (Throwable throwable) {
                var8_11 = throwable;
                throw throwable;
            }
            finally {
                if (span1 != null) {
                    if (var8_11 != null) {
                        try {
                            span1.close();
                        }
                        catch (Throwable throwable) {
                            var8_11.addSuppressed(throwable);
                        }
                    } else {
                        span1.close();
                    }
                }
            }
            this.repairIntentLocks(opResult);
            if (opResult != null && !opResult.isSuccess() && opResult.isNeedWfAssignPersons() && !Boolean.parseBoolean((String)this.getOption().getVariables().get("wfAssignCallbackFlag"))) {
                this.getOperateLog().info("FormOperate.execute() call wfAssignCallbackFlag");
                span1 = opResult;
                return span1;
            }
            this.getOperateLog().info("FormOperate.execute() call afterInvokeOperation");
            facadeResult = this.facade.beforeAfterInvokeOperation(opResult, this);
            if (facadeResult != null) {
                switch (facadeResult.getCode()) {
                    case 7: {
                        span1 = opResult;
                        return span1;
                    }
                }
            }
            span1 = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)(this.getClass().getSimpleName() + ".afterInvokeOperation"));
            var8_11 = null;
            try {
                this.afterInvokeOperation(opResult);
            }
            catch (Throwable throwable) {
                var8_11 = throwable;
                throw throwable;
            }
            finally {
                if (span1 != null) {
                    if (var8_11 != null) {
                        try {
                            span1.close();
                        }
                        catch (Throwable throwable) {
                            var8_11.addSuppressed(throwable);
                        }
                    } else {
                        span1.close();
                    }
                }
            }
            facadeResult = this.facade.afterInvokeOperation(opResult, this);
            if (facadeResult != null) {
                switch (facadeResult.getCode()) {
                    case 7: {
                        span1 = opResult;
                        return span1;
                    }
                }
            }
            span1 = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)(this.getClass().getSimpleName() + ".afterOperationClose"));
            var8_11 = null;
            try {
                this.getOperateLog().info("FormOperate.execute() call afterOperationClose");
                this.afterOperationClose(opResult);
            }
            catch (Throwable throwable) {
                var8_11 = throwable;
                throw throwable;
            }
            finally {
                if (span1 != null) {
                    if (var8_11 != null) {
                        try {
                            span1.close();
                        }
                        catch (Throwable throwable) {
                            var8_11.addSuppressed(throwable);
                        }
                    } else {
                        span1.close();
                    }
                }
            }
            span1 = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)(this.getClass().getSimpleName() + ".afterOperationRefresh"));
            var8_11 = null;
            try {
                this.getOperateLog().info("FormOperate.execute() call afterOperationRefresh");
                this.afterOperationRefresh(opResult);
            }
            catch (Throwable throwable) {
                var8_11 = throwable;
                throw throwable;
            }
            finally {
                if (span1 != null) {
                    if (var8_11 != null) {
                        try {
                            span1.close();
                        }
                        catch (Throwable throwable) {
                            var8_11.addSuppressed(throwable);
                        }
                    } else {
                        span1.close();
                    }
                }
            }
            if (this.getOperateLog().isWriteLog()) {
                String info = opResult == null ? "FormOperate.execute() end\uff1a operationResult = null" : String.format("FormOperate.execute() end, operationResult: isSucccess = %s, BillCount = %s, SuccessIds = %s, msg = %s", opResult.isSuccess(), opResult.getBillCount(), opResult.getSuccessPkIds().size(), opResult.getMessage());
                this.getOperateLog().info(info);
            }
            OperationResult operationResult = opResult;
            return operationResult;
        }
    }

    protected boolean beforeInvokeOperation(OperationResult result) {
        this.getOperateLog().info("FormOperate.beforeInvokeOperation");
        try (EntityTraceSpan span1 = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)(this.getClass().getSimpleName() + ".hasRight"));){
            if (this.hasRight(result) != 1) {
                this.doFailCheckRight(result);
                result.setSuccess(false);
                this.getOperateLog().info("FormOperate.beforeInvokeOperation: no right return");
                boolean bl = false;
                return bl;
            }
        }
        boolean isConfirm = "MessageCallBackType".equals(this.getParameter().get("sourceName"));
        String scene = this.getScene(this.getView());
        if (StringUtils.isNotBlank((CharSequence)this.getConfirmMessage()) && !isConfirm) {
            this.getOption().removeVariable("ishasright");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("contentChange", this);
            String confirmTip = this.getConfirmMessage() + "";
            this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, this.getConfirmTypes(), confirmCallBacks);
            result.setSuccess(false);
            this.getOperateLog().info("FormOperate.beforeInvokeOperation: show confirm return");
            return false;
        }
        if (this.opMessageEnable && StringUtils.isBlank((CharSequence)this.getOption().getVariableValue("reason", null)) && "pc".equals(scene)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            String orignOpKey = this.getOption().getVariableValue("oriOperationKey", null);
            if (StringUtils.isNotBlank((CharSequence)orignOpKey)) {
                parameter.setCustomParam("operateKey", orignOpKey);
            } else {
                parameter.setCustomParam("operateKey", this.getOperateKey());
            }
            parameter.setCustomParam("operateOperation", SerializationUtils.toJsonString((Object)this.getOption().getVariables()));
            parameter.setCustomParam("pageId", this.getView().getPageId());
            parameter.setFormId("operatereason");
            this.getView().showForm(parameter);
            result.setSuccess(false);
            return false;
        }
        FormViewPluginProxy formViewPluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        BeforeDoOperationEventArgs bdoeArgs = new BeforeDoOperationEventArgs(this);
        bdoeArgs.setListSelectedData(this.getListSelectedData());
        formViewPluginProxy.fireBeforeDoOperation(bdoeArgs);
        this.setListSelectedData(bdoeArgs.getListSelectedData());
        if (bdoeArgs.isCancel()) {
            result.setSuccess(false);
            if (StringUtils.isNotBlank((CharSequence)bdoeArgs.getCancelMessage())) {
                result.setMessage(bdoeArgs.getCancelMessage());
            }
            this.getOperateLog().info("FormOperate.beforeInvokeOperation: plug set cancel return");
        }
        return !bdoeArgs.isCancel();
    }

    protected OperationResult invokeOperation() {
        return new OperationResult();
    }

    protected void afterInvokeOperation(OperationResult opResult) {
        this.getOperateLog().info("FormOperate.afterInvokeOperation: begin fire afterDoOperation ");
        AfterDoOperationEventArgs afterDoOperationEventArgs = new AfterDoOperationEventArgs(this, this.getOperateKey(), opResult);
        FormViewPluginProxy formViewPluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        formViewPluginProxy.fireAfterDoOperation(afterDoOperationEventArgs);
        this.getOperateLog().info("FormOperate.afterInvokeOperation: end fire afterDoOperation ");
        try (EntityTraceSpan span1 = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)(this.getClass().getSimpleName() + ".writeLog"));){
            this.writeLog(opResult);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        this.writeOpMessage(opResult);
    }

    protected void afterOperationClose(OperationResult opResult) {
    }

    protected void afterOperationRefresh(OperationResult opResult) {
    }

    protected void writeLog(OperationResult opResult) {
        Object logInfo;
        if (!this.isLogEnable()) {
            return;
        }
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        OpFieldValueReader fieldValueReader = OpFieldValueReader.get(this.getView());
        boolean logDetail = this.wirteDetailLog();
        if (opResult == null) {
            OpLogAppInfo logInfo2;
            String billNo = fieldValueReader.getBillNo(null);
            if (logDetail) {
                String msg = "";
                msg = StringUtils.isBlank((CharSequence)billNo) ? ResManager.loadKDString((String)"%s\u6210\u529f", (String)"FormOperate_0", (String)BOS_FORM_METADATA, (Object[])new Object[]{this.getLogOperateName()}) : ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c%2$s\u6210\u529f", (String)"FormOperate_1", (String)BOS_FORM_METADATA, (Object[])new Object[]{billNo, this.getLogOperateName()});
                logInfo2 = this.buildOpLogInfo(this.mainOrgId, msg);
            } else {
                logInfo2 = this.buildLogInfo(this.mainOrgId, new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f", "FormOperate_13", BOS_FORM_METADATA), new String[0]);
            }
            logInfo2.setStatus("1");
            if (StringUtils.isNotBlank((CharSequence)billNo)) {
                logInfo2.setKeyWord(billNo);
            }
            logService.addLog((AppLogInfo)logInfo2);
            return;
        }
        if (opResult.isCancelWriteLog()) {
            return;
        }
        ArrayList<OpLogAppInfo> appLogInfoList = new ArrayList<OpLogAppInfo>(10);
        for (Object pkValue : opResult.getSuccessPkIds()) {
            String billNo = fieldValueReader.getBillNo(pkValue);
            if (logDetail) {
                String msg = "";
                msg = StringUtils.isBlank((CharSequence)billNo) ? ResManager.loadKDString((String)"%s\u6210\u529f", (String)"FormOperate_0", (String)BOS_FORM_METADATA, (Object[])new Object[]{this.getLogOperateName()}) : ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c%2$s\u6210\u529f", (String)"FormOperate_1", (String)BOS_FORM_METADATA, (Object[])new Object[]{billNo, this.getLogOperateName()});
                logInfo = this.buildOpLogInfo(fieldValueReader.getMainOrg(pkValue), msg);
            } else {
                MultiLangEnumBridge langEnumBridge = new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f", "FormOperate_13", BOS_FORM_METADATA);
                String[] langArgs = new String[]{};
                logInfo = this.buildLogInfo(fieldValueReader.getMainOrg(pkValue), langEnumBridge, langArgs);
            }
            logInfo.setStatus("1");
            appLogInfoList.add((OpLogAppInfo)logInfo);
        }
        if (!appLogInfoList.isEmpty()) {
            logService.addBatchLog(appLogInfoList);
        }
        List errorInfos = opResult.getAllErrorOrValidateInfo();
        if (opResult.getSuccessPkIds().isEmpty() && errorInfos.isEmpty()) {
            OpLogAppInfo logInfo3;
            String billNo = fieldValueReader.getBillNo(null);
            if (logDetail) {
                String msg = "";
                msg = StringUtils.isBlank((CharSequence)billNo) ? (opResult.isSuccess() ? ResManager.loadKDString((String)"%s\u6210\u529f", (String)"FormOperate_15", (String)BOS_FORM_METADATA, (Object[])new Object[]{this.getLogOperateName()}) : ResManager.loadKDString((String)"%s\u5931\u8d25", (String)"FormOperate_16", (String)BOS_FORM_METADATA, (Object[])new Object[]{this.getLogOperateName()})) : (opResult.isSuccess() ? ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c%2$s\u6210\u529f", (String)"FormOperate_17", (String)BOS_FORM_METADATA, (Object[])new Object[]{billNo, this.getLogOperateName()}) : ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c%2$s\u5931\u8d25", (String)"FormOperate_18", (String)BOS_FORM_METADATA, (Object[])new Object[]{billNo, this.getLogOperateName()}));
                if (!opResult.isSuccess() && StringUtils.isNotBlank((CharSequence)opResult.getMessage())) {
                    msg = msg + ": " + opResult.getMessage();
                }
                logInfo3 = this.buildOpLogInfo(fieldValueReader.getMainOrg(null), msg);
            } else {
                MultiLangEnumBridge langEnumBridge = opResult.isSuccess() ? new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f", "FormOperate_13", BOS_FORM_METADATA) : new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25", "FormOperate_14", BOS_FORM_METADATA);
                logInfo3 = this.buildLogInfo(fieldValueReader.getMainOrg(null), langEnumBridge, new String[0]);
            }
            logInfo3.setStatus(opResult.isSuccess() ? "1" : "0");
            if (StringUtils.isNotBlank((CharSequence)billNo)) {
                logInfo3.setKeyWord(billNo);
            }
            logService.addLog((AppLogInfo)logInfo3);
        }
        appLogInfoList = new ArrayList(10);
        for (IOperateInfo errorInfo : errorInfos) {
            logInfo = logDetail ? this.buildLogInfo(errorInfo.getMessage(), fieldValueReader.getMainOrg(errorInfo.getPkValue())) : this.buildLogInfo(fieldValueReader.getMainOrg(errorInfo.getPkValue()), new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25", "FormOperate_14", BOS_FORM_METADATA), new String[0]);
            logInfo.setStatus("0");
            appLogInfoList.add((OpLogAppInfo)logInfo);
        }
        if (!appLogInfoList.isEmpty()) {
            logService.addBatchLog(appLogInfoList);
        }
    }

    private boolean wirteDetailLog() {
        try {
            AppParam param = new AppParam();
            param.setAppId("83bfebc800003dac");
            param.setViewType("15");
            param.setOrgId(Long.valueOf(((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId()));
            Map devParams = ParameterReader.loadSystemParameterFromCache((AppParam)param);
            return devParams.get("operation_log_detail") != null && Boolean.parseBoolean(String.valueOf(devParams.get("operation_log_detail")));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return false;
        }
    }

    private void writeOpMessage(OperationResult opResult) {
        if (this.isOpMessageEnable() && opResult != null && !opResult.getSuccessPkIds().isEmpty()) {
            final List successPkIds = opResult.getSuccessPkIds();
            final OpFieldValueReader fieldValueReader = OpFieldValueReader.get(this.getView());
            final String username = RequestContext.get().getUserName();
            final Date date = KDDateUtils.now();
            final String reason = (String)this.getOption().getVariables().get("reason");
            final MainEntityType reasonEntityType = EntityMetadataCache.getDataEntityType((String)"operatereason");
            ThreadPools.executeOnce((String)this.getOperateKey(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(10);
                    for (Object pkId : successPkIds) {
                        DynamicObject dynamicObject = ORM.create().newDynamicObject("operatereason");
                        String billNo = fieldValueReader.getBillNo(pkId);
                        String description = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c%2$s\u6210\u529f", (String)"FormOperate_1", (String)FormOperate.BOS_FORM_METADATA, (Object[])new Object[0]), billNo, FormOperate.this.getLocaleOperateName());
                        dynamicObject.set("reason", (Object)reason);
                        dynamicObject.set("user", (Object)username);
                        dynamicObject.set("time", (Object)date);
                        dynamicObject.set("name", (Object)FormOperate.this.getLocaleOperateName());
                        dynamicObject.set("description", (Object)description);
                        dynamicObject.set("reid", pkId);
                        dynamicObjects.add(dynamicObject);
                    }
                    BusinessDataWriter.save((IDataEntityType)reasonEntityType, (Object[])dynamicObjects.toArray());
                }
            });
        }
    }

    private String getLocaleOperateName() {
        String localeName = this.getOperateName().toString();
        return localeName == null ? "" : localeName;
    }

    protected String getLogOperateName() {
        return this.getLocaleOperateName();
    }

    protected String getLogOperateName_CN() {
        LocaleString localeName = this.getOperateName();
        if (localeName == null || StringUtils.isBlank((CharSequence)localeName.getLocaleValue_zh_CN())) {
            return this.getOperateKey();
        }
        return localeName.getLocaleValue_zh_CN();
    }

    protected int hasRight(OperationResult result) {
        return this.facade.hasRight(this.permissionItemId, result, this.getRealPermissionEntityId(), this.mainOrgId, this);
    }

    private void doDataRuleCheckInBill(MainEntityType mainEntityType, OperationResult result) {
        Object pkId = null;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (showParameter instanceof BillShowParameter) {
            BillShowParameter billParam = (BillShowParameter)showParameter;
            pkId = billParam.getPkId();
        }
        if (pkId == null) {
            pkId = this.getView().getModel().getDataEntity().getPkValue();
        }
        if (pkId == null) {
            return;
        }
        if (mainEntityType != null) {
            int dbType = mainEntityType.getPrimaryKey().getDbType();
            pkId = DbTypeConverter.safeConvert((int)dbType, (Object)pkId);
        }
        if (!FormOperate.hasEnableOldDataRule()) {
            FormViewPluginProxy formViewPluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            BeforeDoCheckDataPermissionArgs checkArgs = new BeforeDoCheckDataPermissionArgs(this);
            checkArgs.setPkId(pkId);
            formViewPluginProxy.fireBeforeCheckDataPermission(checkArgs);
            if (checkArgs.isCancel()) {
                ValidateResult validateResult = new ValidateResult();
                ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", checkArgs.getCancelMessage(), ErrorLevel.FatalError);
                validateResult.addErrorInfo((OperateErrorInfo)info);
                result.setSuccess(false);
                result.getValidateResult().addValidateError(PERMISSION, validateResult);
            }
            if (checkArgs.isSkipCheckDataPermission()) {
                this.getOption().getVariables().put("skipCheckDataPermission", "true");
            }
            if (!checkArgs.isSkipCheckDataPermission() && !checkArgs.isCancel()) {
                long userId = Long.parseLong(RequestContext.get().getUserId());
                String bizAppId = this.getView().getFormShowParameter().getServiceAppId();
                QFilter[] qfilters = new QFilter[]{new QFilter("id", "=", pkId)};
                PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
                boolean hasPerm = false;
                if (mainEntityType != null) {
                    hasPerm = permissionService.matchDataRule(userId, bizAppId, mainEntityType.getName(), this.permissionItemId, qfilters);
                }
                if (!hasPerm) {
                    ValidateResult validateResult = new ValidateResult();
                    LocaleString formName = FormMetadataCache.getFormConfig(this.getView().getFormShowParameter().getFormId()).getCaption();
                    String msg = String.format(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709[%1$s][%2$s]\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)FORM_OPERATE_5, (String)BOS_FORM_METADATA, (Object[])new Object[0]), this.getLocaleOperateName(), formName);
                    ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", msg, ErrorLevel.FatalError);
                    validateResult.addErrorInfo((OperateErrorInfo)info);
                    result.setSuccess(false);
                    result.getValidateResult().addValidateError(PERMISSION, validateResult);
                }
            }
        }
    }

    private void doDataRuleCheckInList(MainEntityType mainEntityType, OperationResult result) {
        if (!FormOperate.hasEnableOldDataRule() && this.needSelectData() && !this.getListSelectedData().isEmpty()) {
            FormViewPluginProxy formViewPluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            BeforeDoCheckDataPermissionArgs checkArgs = new BeforeDoCheckDataPermissionArgs(this);
            checkArgs.setListSelectedData(this.getListSelectedData());
            formViewPluginProxy.fireBeforeCheckDataPermission(checkArgs);
            if (checkArgs.isCancel()) {
                ValidateResult validateResult = new ValidateResult();
                ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", checkArgs.getCancelMessage(), ErrorLevel.FatalError);
                validateResult.addErrorInfo((OperateErrorInfo)info);
                result.setSuccess(false);
                result.getValidateResult().addValidateError(PERMISSION, validateResult);
            }
            if (checkArgs.isSkipCheckDataPermission()) {
                this.getOption().getVariables().put("skipCheckDataPermission", "true");
            }
            if (!checkArgs.isSkipCheckDataPermission() && !checkArgs.isCancel()) {
                ArrayList<Object> pks = new ArrayList<Object>(10);
                ListSelectedRowCollection collection = this.getListSelectedData();
                for (Object pk : collection.getPrimaryKeyValues()) {
                    pks.add(pk);
                }
                long userId = Long.parseLong(RequestContext.get().getUserId());
                String bizAppId = this.getView().getFormShowParameter().getServiceAppId();
                QFilter[] qfilters = new QFilter[]{new QFilter("id", "in", (Object)pks.toArray())};
                PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
                boolean hasPerm = permissionService.matchDataRule(userId, bizAppId, mainEntityType.getName(), this.permissionItemId, qfilters);
                if (!hasPerm) {
                    ValidateResult validateResult = new ValidateResult();
                    LocaleString formName = FormMetadataCache.getFormConfig(this.getView().getFormShowParameter().getFormId()).getCaption();
                    String msg = String.format(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709[%1$s][%2$s]\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)FORM_OPERATE_5, (String)BOS_FORM_METADATA, (Object[])new Object[0]), this.getLocaleOperateName(), formName);
                    ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", msg, ErrorLevel.FatalError);
                    validateResult.addErrorInfo((OperateErrorInfo)info);
                    result.setSuccess(false);
                    result.getValidateResult().addValidateError(PERMISSION, validateResult);
                }
            }
        }
    }

    private static boolean hasEnableOldDataRule() {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"perm_olddataruleenable");
        Map rets = BusinessDataReader.loadFromCache((Object[])new Object[]{1L}, (DynamicObjectType)type, (boolean)false);
        DynamicObject dObj = (DynamicObject)rets.get(1L);
        if (dObj == null) {
            return true;
        }
        return dObj.getBoolean("enable_olddatarule");
    }

    protected String getRealPermissionEntityId() {
        return StringUtils.isNotBlank((CharSequence)this.getPermissionEntityId()) ? this.getPermissionEntityId() : this.getEntityId();
    }

    public String getPermissionEntityId() {
        if (!(this.getView().getFormShowParameter() instanceof BillShowParameter)) {
            return this.permissionEntityId;
        }
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        return billShowParameter.getPermissionEntityId();
    }

    public void setPermissionEntityId(String permissionEntityId) {
        this.permissionEntityId = permissionEntityId;
    }

    protected int checkRightInListForm(MainEntityType mainEntityType, OperationResult result) {
        if (!this.needSelectData()) {
            this.doPermission(result, this.getPermissionItemId(), 0L);
        } else {
            List<ListSelectedRow> checkRightRows = this.getCheckRightRowsInList();
            if (checkRightRows == null || checkRightRows.isEmpty()) {
                this.doPermission(result, this.getPermissionItemId(), 0L);
            } else {
                String dimType = mainEntityType.getPermissionControlType().getDimension();
                String dimFldKey = mainEntityType.getPermissionControlType().getDataDimensionField();
                String dimAssitFldKey = mainEntityType.getPermissionControlType().getDataAssistDimensionField();
                if (StringUtils.isNotBlank((CharSequence)dimFldKey) && mainEntityType.findProperty(dimFldKey) == null) {
                    dimFldKey = null;
                }
                if (StringUtils.isNotBlank((CharSequence)dimAssitFldKey) && mainEntityType.findProperty(dimAssitFldKey) == null) {
                    dimAssitFldKey = null;
                }
                HashSet<Long> dimFldValues = new HashSet<Long>();
                IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
                String verifyOrg = pageCache.get("verifyOrg");
                if (verifyOrg != null && verifyOrg.trim().length() > 0) {
                    dimFldValues.add(Long.parseLong(verifyOrg));
                    for (Long orgId : dimFldValues) {
                        this.doPermission(result, this.getPermissionItemId(), orgId);
                    }
                    return 1;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)dimType, (CharSequence)"DIM_ORG") || StringUtils.isBlank((CharSequence)dimFldKey)) {
                    dimType = "DIM_ORG";
                    if (StringUtils.isNotBlank((CharSequence)mainEntityType.getMainOrg())) {
                        dimFldKey = mainEntityType.getMainOrg();
                    }
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)dimType, (CharSequence)"DIM_NULL") || StringUtils.isBlank((CharSequence)dimFldKey)) {
                    this.doPermission(result, this.getPermissionItemId(), 0L);
                } else {
                    HashSet<Object> pkIds = new HashSet<Object>(16);
                    for (ListSelectedRow row : checkRightRows) {
                        Object pkId = row.getPrimaryKeyValue();
                        pkIds.add(pkId);
                    }
                    QFilter[] filters = new QFilter[]{pkIds.size() == 1 ? new QFilter("id", "=", pkIds.iterator().next()) : new QFilter("id", "in", (Object)pkIds.toArray())};
                    String algoKey = mainEntityType.getName();
                    String entityName = mainEntityType.getName();
                    String selectFields = "id";
                    if (StringUtils.isNotBlank((CharSequence)dimFldKey)) {
                        selectFields = selectFields + "," + dimFldKey;
                    }
                    if (dimAssitFldKey != null && StringUtils.isNotBlank((CharSequence)dimAssitFldKey) && !dimAssitFldKey.equals(dimFldKey)) {
                        selectFields = selectFields + "," + dimAssitFldKey;
                    }
                    String orderBys = null;
                    ORM orm = ORM.create();
                    ArrayList<CheckDimObjParam> dimObjParamList = new ArrayList<CheckDimObjParam>();
                    try (DataSet ds = orm.queryDataSet(algoKey, entityName, selectFields, filters, orderBys);){
                        DynamicObjectCollection objs = orm.toPlainDynamicObjectCollection(ds);
                        for (DynamicObject obj : objs) {
                            CheckDimObjParam dimObjParam = new CheckDimObjParam();
                            if (StringUtils.isNotBlank((CharSequence)dimFldKey)) {
                                dimObjParam.setDimensionOrg(obj.getLong(dimFldKey));
                                dimObjParam.setId(obj.getPkValue());
                            }
                            if (StringUtils.isNotBlank((CharSequence)dimAssitFldKey) && dimAssitFldKey != null && !dimAssitFldKey.equals(dimFldKey)) {
                                dimObjParam.setAssistDimensionOrg(obj.getLong(dimAssitFldKey));
                            }
                            if (dimObjParam.getDimensionOrg() == null) continue;
                            dimObjParamList.add(dimObjParam);
                        }
                    }
                    if (!dimObjParamList.isEmpty()) {
                        this.doPermissionBatch(result, this.getPermissionItemId(), dimObjParamList);
                    } else {
                        this.doPermission(result, this.getPermissionItemId(), dimType, 0L);
                    }
                }
            }
        }
        if (!result.isSuccess()) {
            this.getOption().removeVariable("ishasright");
            return 0;
        }
        this.doDataRuleCheckInList(mainEntityType, result);
        return 1;
    }

    protected int checkRightInBillForm(MainEntityType mainEntityType, OperationResult result) {
        int hasRight = this.checkRightInDynamicForm(mainEntityType, result);
        if (!result.isSuccess()) {
            this.getOption().removeVariable("ishasright");
            return 0;
        }
        this.doDataRuleCheckInBill(mainEntityType, result);
        return hasRight;
    }

    protected int checkRightInDynamicForm(MainEntityType mainEntityType, OperationResult result) {
        long orgId = 0L;
        String dimType = mainEntityType.getPermissionControlType().getDimension();
        String dimFldKey = mainEntityType.getPermissionControlType().getDataDimensionField();
        String dimAssistFldKey = mainEntityType.getPermissionControlType().getDataAssistDimensionField();
        if (StringUtils.isNotBlank((CharSequence)dimFldKey) && mainEntityType.findProperty(dimFldKey) == null) {
            dimFldKey = null;
        }
        if (StringUtils.isNotBlank((CharSequence)dimAssistFldKey) && mainEntityType.findProperty(dimAssistFldKey) == null) {
            dimAssistFldKey = null;
        }
        ArrayList<CheckDimObjParam> dimObjParamList = new ArrayList<CheckDimObjParam>();
        CheckDimObjParam dimObjParam = new CheckDimObjParam();
        if (StringUtils.isNotBlank((CharSequence)dimAssistFldKey)) {
            DynamicObject tempAssistObjId = (DynamicObject)this.getView().getModel().getValue(dimAssistFldKey);
            long dimAssistObjId = tempAssistObjId == null ? 0L : tempAssistObjId.getLong("id");
            dimObjParam.setAssistDimensionOrg(dimAssistObjId);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)dimType, (CharSequence)"DIM_ORG") && StringUtils.isBlank((CharSequence)dimFldKey) && StringUtils.isNotBlank((CharSequence)mainEntityType.getMainOrg())) {
            dimFldKey = mainEntityType.getMainOrg();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)dimType, (CharSequence)"DIM_NULL") || StringUtils.isBlank((CharSequence)dimFldKey)) {
            this.doPermission(result, this.getPermissionItemId(), 0L);
        } else {
            if (!StringUtils.equalsIgnoreCase((CharSequence)dimType, (CharSequence)"DIM_ORG") && StringUtils.isNotBlank((CharSequence)dimFldKey)) {
                DynamicObject tempObjId = (DynamicObject)this.getView().getModel().getValue(dimFldKey);
                long dimObjId = tempObjId == null ? 0L : tempObjId.getLong("id");
                dimObjParam.setDimensionOrg(dimObjId);
            } else {
                DynamicObject orgObject = (DynamicObject)this.getView().getModel().getValue(dimFldKey);
                orgId = orgObject == null ? 0L : (Long)orgObject.getPkValue();
                dimObjParam.setDimensionOrg(orgId);
                dimObjParam.setId(this.getView().getModel().getDataEntity().getPkValue());
            }
            if (dimObjParam.getDimensionOrg() != null && dimObjParam.getDimensionOrg() > 0L) {
                dimObjParamList.add(dimObjParam);
                this.doPermissionBatch(result, this.getPermissionItemId(), dimObjParamList);
            } else {
                this.doPermission(result, this.getPermissionItemId(), dimType, 0L);
            }
        }
        return 1;
    }

    private void doPermissionBatch(OperationResult result, String permissionItemId, List<CheckDimObjParam> dimObjParamList) {
        List<CheckDimObjParam> checkList = this.checkFunctionPermissionBatch(permissionItemId, dimObjParamList);
        if (checkList == null || !checkList.isEmpty()) {
            String msg = ResManager.loadResFormat((String)this.getNoOperatePermissionMsgType(), (String)FORM_OPERATE_5, (String)BOS_FORM_METADATA, (Object[])new Object[]{FormMetadataCache.getFormConfig(this.getEntityId()).getCaption().toString(), this.getOperateName()});
            ValidateResult validateResult = new ValidateResult();
            ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", msg, ErrorLevel.FatalError);
            validateResult.addErrorInfo((OperateErrorInfo)info);
            result.setSuccess(false);
            result.getValidateResult().addValidateError(PERMISSION, validateResult);
            LogPrintUtil.writeLog((SecurityTypeEnum)SecurityTypeEnum.OVERPERMISSION, (AppLogInfo)this.buildLogInfo(msg, this.mainOrgId));
        }
    }

    protected List<CheckDimObjParam> checkFunctionPermissionBatch(String permissionItemId, List<CheckDimObjParam> dimObjParamList) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        String bizAppId = this.getView().getFormShowParameter().getCheckRightAppId();
        return permissionService.checkPermissionBatch(Long.valueOf(userId), bizAppId, this.getRealPermissionEntityId(), permissionItemId, dimObjParamList);
    }

    protected Boolean isAllUserApp() {
        return false;
    }

    protected boolean hasNewPermission() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        String appId = this.getCheckRightAppId();
        BizAppService service = (BizAppService)ServiceFactory.getService(BizAppService.class);
        String bizAppId = StringUtils.isBlank((CharSequence)appId) ? service.getAppIdByFormNum(this.getRealPermissionEntityId()) : AppMetadataCache.getAppInfo((String)appId).getId();
        return permissionService.hasNewPermission(userId, bizAppId, this.getRealPermissionEntityId());
    }

    protected int checkFunctionPermission(long orgId, String permissionItemId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        String bizAppId = this.getCheckRightAppId();
        return permissionService.checkPermission(userId, "DIM_ORG", orgId, bizAppId, this.getRealPermissionEntityId(), permissionItemId);
    }

    protected int checkFunctionPermission(List<Long> orgIds, String permissionItemId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        String bizAppId = this.getView().getFormShowParameter().getCheckRightAppId();
        return permissionService.checkPermission(Long.valueOf(userId), "DIM_ORG", orgIds, bizAppId, this.getRealPermissionEntityId(), permissionItemId);
    }

    protected int checkFunctionPermission(String permissionItemId, String dimType, long dimObjId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        String bizAppId = this.getCheckRightAppId();
        return permissionService.checkPermission(userId, dimType, dimObjId, bizAppId, this.getRealPermissionEntityId(), permissionItemId);
    }

    protected int checkFunctionPermission(String permissionItemId, String dimType, List<Long> dimObjIds) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        String bizAppId = this.getView().getFormShowParameter().getCheckRightAppId();
        return permissionService.checkPermission(Long.valueOf(userId), dimType, dimObjIds, bizAppId, this.getRealPermissionEntityId(), permissionItemId);
    }

    protected boolean checkFunctionPerm() {
        if (StringUtils.isBlank((CharSequence)this.permissionItemId)) {
            return true;
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        String bizAppId = this.getCheckRightAppId();
        int ret = permissionService.checkPermission(userId, "DIM_ORG", this.mainOrgId == null ? 0L : this.mainOrgId, bizAppId, this.getRealPermissionEntityId(), this.permissionItemId);
        return ret == 1;
    }

    private void doPermission(OperationResult result, String permissionItemId, String dimType, long dimObjId) {
        if (this.checkFunctionPermission(permissionItemId, dimType, dimObjId) != 1) {
            String msg = ResManager.loadResFormat((String)this.getNoOperatePermissionMsgType(), (String)FORM_OPERATE_5, (String)BOS_FORM_METADATA, (Object[])new Object[]{FormMetadataCache.getFormConfig(this.getEntityId()).getCaption().toString(), this.getOperateName()});
            ValidateResult validateResult = new ValidateResult();
            ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", msg, ErrorLevel.FatalError);
            validateResult.addErrorInfo((OperateErrorInfo)info);
            result.setSuccess(false);
            result.getValidateResult().addValidateError(PERMISSION, validateResult);
            LogPrintUtil.writeLog((SecurityTypeEnum)SecurityTypeEnum.OVERPERMISSION, (AppLogInfo)this.buildLogInfo(msg, this.mainOrgId));
        }
    }

    private void doPermission(OperationResult result, String permissionItemId, String dimType, List<Long> dimObjIds) {
        if (this.checkFunctionPermission(permissionItemId, dimType, dimObjIds) != 1) {
            String msg = ResManager.loadResFormat((String)this.getNoOperatePermissionMsgType(), (String)FORM_OPERATE_5, (String)BOS_FORM_METADATA, (Object[])new Object[]{FormMetadataCache.getFormConfig(this.getEntityId()).getCaption().toString(), this.getOperateName()});
            ValidateResult validateResult = new ValidateResult();
            ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", msg, ErrorLevel.FatalError);
            validateResult.addErrorInfo((OperateErrorInfo)info);
            result.setSuccess(false);
            result.getValidateResult().addValidateError(PERMISSION, validateResult);
            LogPrintUtil.writeLog((SecurityTypeEnum)SecurityTypeEnum.OVERPERMISSION, (AppLogInfo)this.buildLogInfo(msg, this.mainOrgId));
        }
    }

    protected void doPermission(OperationResult result, String permissionItemId, long orgId) {
        if (this.checkFunctionPermission(orgId, permissionItemId) != 1) {
            String msg = ResManager.loadResFormat((String)this.getNoOperatePermissionMsgType(), (String)FORM_OPERATE_5, (String)BOS_FORM_METADATA, (Object[])new Object[]{FormMetadataCache.getFormConfig(this.getEntityId()).getCaption().toString(), this.getOperateName()});
            ValidateResult validateResult = new ValidateResult();
            ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", msg, ErrorLevel.FatalError);
            validateResult.addErrorInfo((OperateErrorInfo)info);
            result.setSuccess(false);
            result.getValidateResult().addValidateError(PERMISSION, validateResult);
            LogPrintUtil.writeLog((SecurityTypeEnum)SecurityTypeEnum.OVERPERMISSION, (AppLogInfo)this.buildLogInfo(msg, this.mainOrgId));
        }
    }

    protected void doPermission(OperationResult result, String permissionItemId, List<Long> orgIds) {
        if (this.checkFunctionPermission(orgIds, permissionItemId) != 1) {
            String msg = ResManager.loadResFormat((String)this.getNoOperatePermissionMsgType(), (String)FORM_OPERATE_5, (String)BOS_FORM_METADATA, (Object[])new Object[]{FormMetadataCache.getFormConfig(this.getEntityId()).getCaption().toString(), this.getOperateName()});
            ValidateResult validateResult = new ValidateResult();
            ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", msg, ErrorLevel.FatalError);
            validateResult.addErrorInfo((OperateErrorInfo)info);
            result.setSuccess(false);
            result.getValidateResult().addValidateError(PERMISSION, validateResult);
            LogPrintUtil.writeLog((SecurityTypeEnum)SecurityTypeEnum.OVERPERMISSION, (AppLogInfo)this.buildLogInfo(msg, this.mainOrgId));
        }
    }

    private String getControlTypeName(String dimType) {
        String name = null;
        QFilter q = new QFilter("number", "=", (Object)dimType);
        QFilter[] qs = new QFilter[]{q};
        Map types = BusinessDataReader.loadFromCache((String)"perm_ctrltype", (QFilter[])qs);
        DynamicObject type = null;
        DynamicObject dynamicObject = type = types.size() > 0 ? (DynamicObject)types.values().toArray()[0] : null;
        if (type != null && type.getString("name") != null) {
            name = type.getString("name");
        }
        return name;
    }

    private String getPermissionItemName(String permissionItemId) {
        DynamicObject item;
        String name = null;
        QFilter q = new QFilter("id", "=", (Object)permissionItemId);
        QFilter[] qs = new QFilter[]{q};
        Map items = BusinessDataReader.loadFromCache((String)"perm_permitem", (QFilter[])qs);
        DynamicObject dynamicObject = item = items.size() > 0 ? (DynamicObject)items.values().toArray()[0] : null;
        if (item != null && item.getString("name") != null) {
            name = item.getString("name");
        }
        return name;
    }

    @Deprecated
    protected Map<Long, List<Object>> getListSelectOrgList(ListSelectedRowCollection selectedRows) {
        HashMap<Long, List<Object>> orgRows = new HashMap<Long, List<Object>>();
        for (ListSelectedRow row : selectedRows) {
            Long rowOrgId = row.getMainOrgId();
            ArrayList<Object> list = (ArrayList<Object>)orgRows.get(rowOrgId);
            if (list == null) {
                list = new ArrayList<Object>();
                orgRows.put(rowOrgId, list);
            }
            list.add(row.getPrimaryKeyValue());
        }
        return orgRows;
    }

    protected List<ListSelectedRow> getCheckRightRowsInList() {
        ArrayList<ListSelectedRow> list = new ArrayList<ListSelectedRow>();
        if (this.getListSelectedData() != null) {
            list.addAll((Collection<ListSelectedRow>)this.getListSelectedData());
        }
        return list;
    }

    protected void doFailCheckRight(OperationResult result) {
        this.getView().showOperationResult(result);
    }

    protected void clearEntryRows() {
        MainEntityType dt = EntityMetadataCache.getDataEntityTypeNoCache((String)this.getEntityId());
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Map entityMap = dt.getAllEntities();
        for (Map.Entry en : entityMap.entrySet()) {
            EntityType et = (EntityType)en.getValue();
            if (!(et instanceof EntryType)) continue;
            EntryType entryType = (EntryType)et;
            String entryKey = entryType.getName();
            proxy.selectRows(entryKey, new int[]{-1}, -1);
        }
    }

    private DynamicObjectCollection getDataEntities() {
        DynamicObjectCollection entities = new DynamicObjectCollection();
        BillParam billParam = ParameterHelper.getBillParam((String)this.getEntityId());
        if (billParam != null && billParam.getOverallParam() != null && billParam.getOverallParam().isEnableSignOrg()) {
            Object[] selectForms = null;
            if (this.getView() instanceof IBillView) {
                entities.add((Object)this.getView().getModel().getDataEntity());
            } else if (this.getView() instanceof IListView) {
                selectForms = ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues();
                Map dataMap = BusinessDataReader.loadFromCache((Object[])selectForms, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getEntityId()));
                entities.addAll(dataMap.values());
            }
        }
        return entities;
    }

    @Deprecated
    protected AppLogInfo buildLogInfo(String msg, Long orgId) {
        OpLogAppInfo logInfo = this.buildLog(orgId);
        logInfo.setOpDescription(msg);
        return logInfo;
    }

    protected OpLogAppInfo buildLogInfo(Long orgId, MultiLangEnumBridge descBridge, String ... args) {
        OpLogAppInfo logInfo = this.buildLog(orgId);
        logInfo.setOpDesc(descBridge, args);
        return logInfo;
    }

    protected OpLogAppInfo buildOpLogInfo(Long orgId, String msg) {
        OpLogAppInfo logInfo = this.buildLog(orgId);
        logInfo.setOpDescription(msg);
        return logInfo;
    }

    private OpLogAppInfo buildLog(Long orgId) {
        AppInfo appInfo;
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String appId = " ";
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && null != (appInfo = AppMetadataCache.getAppInfo((String)appNumber))) {
            appId = appInfo.getId();
        }
        if (StringUtils.isBlank((CharSequence)appId)) {
            FormShowParameter param;
            BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
            String billFormId = "";
            if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
                param = (ListShowParameter)this.getView().getFormShowParameter();
                billFormId = ((ListShowParameter)param).getBillFormId();
            } else if (this.getView().getFormShowParameter() instanceof BillShowParameter) {
                param = (BillShowParameter)this.getView().getFormShowParameter();
                billFormId = param.getFormId();
            } else {
                billFormId = this.getView().getFormShowParameter().getFormId();
            }
            if (StringUtils.isNotBlank((CharSequence)billFormId)) {
                appId = bizAppService.getAppIdByFormNum(billFormId);
            }
        }
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID(this.getEntityId());
        if (orgId != null && Long.compare(0L, orgId) != 0) {
            logInfo.setOrgID(orgId);
        } else {
            logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        }
        TimeService timeService = new TimeService();
        logInfo.setOpTime(timeService.getCurrentSystemTime());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(this.getOperateKey(), this.getLogOperateName_CN());
        try {
            Object billno;
            BillEntityType mainEntityType;
            String billNoKey;
            if (this.getView() instanceof IBillView && this.getView().getModel() != null && this.getView().getModel().getDataEntityType() instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)(billNoKey = (mainEntityType = (BillEntityType)this.getView().getModel().getDataEntityType()).getBillNo())) && mainEntityType.getProperty(billNoKey) != null && StringUtils.isNotBlank((Object)(billno = this.getView().getModel().getValue(billNoKey)))) {
                logInfo.setModifyBillNo(billno.toString());
                logInfo.setKeyWord(billno.toString());
            }
        }
        catch (Exception e) {
            log.error("addlog with modifybillno err," + e.getMessage(), (Throwable)e);
        }
        return logInfo;
    }

    private void repairIntentLocks(OperationResult opResult) {
        if (opResult == null) {
            return;
        }
        try {
            if (opResult.isSuccess() && this.isSpecialOperation()) {
                return;
            }
            boolean applyIntentLock = false;
            if (this.isSpecialOperation()) {
                applyIntentLock = true;
            } else {
                Map denco = EntityMetadataCache.getDataEntityNetCtrlOperate((String)this.getEntityId());
                block2: for (Map.Entry entry : denco.entrySet()) {
                    List value = (List)entry.getValue();
                    for (Map operateMap : value) {
                        if (!StringUtils.equals((CharSequence)String.valueOf(operateMap.get("operationKey")), (CharSequence)this.getOperateKey())) continue;
                        applyIntentLock = true;
                        continue block2;
                    }
                }
            }
            Object pkValue = this.getView().getModel().getDataEntity().getPkValue();
            if (CoreMutexHelper.isOpenIntentLocks() && applyIntentLock && this.getView() instanceof IBillView) {
                CoreMutexHelper.requireIntent(this.getView(), this.getEntityId(), String.valueOf(pkValue), new StringBuilder());
            }
        }
        catch (Exception e) {
            log.warn("repairIntentLocks failed", (Throwable)e);
        }
    }

    private boolean isSpecialOperation() {
        return StringUtils.equals((CharSequence)this.getClass().getName(), (CharSequence)"kd.bos.entity.operate.Save") || StringUtils.equals((CharSequence)this.getClass().getName(), (CharSequence)"kd.bos.entity.operate.Submit") || StringUtils.equals((CharSequence)this.getClass().getName(), (CharSequence)"kd.bos.entity.operate.Audit");
    }

    private String getNoOperatePermissionMsgType() {
        return ResManager.loadKDString((String)"\u65e0\u201c%1\u201d\u7684\u201c%2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FormOperate_6", (String)BOS_FORM_METADATA, (Object[])new Object[0]);
    }

    protected String getScene(IFormView formView) {
        String modelType = formView.getFormShowParameter().getFormConfig().getModelType();
        String scene = null;
        scene = "mobilebase".equalsIgnoreCase(modelType) || "mobilebill".equalsIgnoreCase(modelType) || "mobileform".equalsIgnoreCase(modelType) || "mobilelist".equalsIgnoreCase(modelType) ? "mob" : "pc";
        return scene;
    }
}

