/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.webapi;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ModelEventProxy;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.form.operate.webapi.ApiPropConvertContext;
import kd.bos.form.operate.webapi.ApiPropConvertItem;
import kd.bos.form.operate.webapi.EntyRowMatchStyle;
import kd.bos.form.operate.webapi.IApiPropConverter;
import kd.bos.form.operate.webapi.RowMapper;
import kd.bos.permission.api.HasPermDimObjResult;

public class OperateDataConverter {
    private IDataModel model;
    private ModelEventProxy modelEventProxy;
    private PKFieldProp pkFieldProp;
    private ApiPropConvertContext context;
    private List<String> dataConvertOrder = new ArrayList<String>();

    @Deprecated
    public OperateDataConverter(IDataModel model) {
        this(model, null);
    }

    public OperateDataConverter(IDataModel model, Map<BasedataItem, Object> basePKs) {
        this.model = model;
        this.modelEventProxy = (ModelEventProxy)model.getService(ModelEventProxy.class);
        this.context = new ApiPropConvertContext(model, this.modelEventProxy, basePKs);
        this.pkFieldProp = (PKFieldProp)this.model.getDataEntityType().getPrimaryKey();
    }

    public OperateDataConverter(IDataModel model, Map<BasedataItem, Object> basePKs, Map<String, Map<Object, DynamicObject>> baseObjs) {
        this.model = model;
        this.modelEventProxy = (ModelEventProxy)model.getService(ModelEventProxy.class);
        this.context = new ApiPropConvertContext(model, this.modelEventProxy, basePKs, baseObjs);
        this.pkFieldProp = (PKFieldProp)this.model.getDataEntityType().getPrimaryKey();
    }

    public void setHasPermResult(HasPermDimObjResult hasPermResult) {
        this.context.setHasPermResult(hasPermResult);
    }

    public boolean isModify() {
        return this.context.isModify();
    }

    public void setModify(boolean modify) {
        this.context.setModify(modify);
    }

    public Set<String> getNeedUpdateFields() {
        return this.context.getNeedUpdateFields();
    }

    public void setNeedUpdateFields(Set<String> needUpdateFields) {
        this.context.setNeedUpdateFields(needUpdateFields);
    }

    public EntyRowMatchStyle getEntyRowMatchStyle() {
        return this.context.getEntyRowMatchStyle();
    }

    public void setEntyRowMatchStyle(EntyRowMatchStyle entyRowMatchStyle) {
        this.context.setEntyRowMatchStyle(entyRowMatchStyle);
    }

    public boolean isImportMode() {
        return this.context.isImportMode();
    }

    public void setImportMode(boolean importMode) {
        this.context.setImportMode(importMode);
    }

    public Long getMainOrgId() {
        return this.context.getMainOrgId();
    }

    public Map<BasedataItem, Object> getBasePKs() {
        return this.context.getBasePKs();
    }

    public Map<String, Map<Object, DynamicObject>> getBaseObjs() {
        return this.context.getBaseObjs();
    }

    @Deprecated
    public void beginNewBill() {
        this.context.setMainOrgId(null);
        this.context.clearErrorInfos();
    }

    public void beginNewBill(int rowNum) {
        this.context.setMainOrgId(null);
        this.context.clearErrorInfos();
        this.context.setEntityExcelRowIndex(rowNum);
    }

    public void filterBasedatas(Map<String, Object> sourceObj, DynamicObject targetObj, int rowIndex) {
        RowMapper currRowMapper = new RowMapper(sourceObj, targetObj, null, rowIndex);
        List<ApiPropConvertItem> fieldItems = this.context.sortPropConverters((EntityType)this.context.getModel().getDataEntityType(), sourceObj);
        for (ApiPropConvertItem fieldItem : fieldItems) {
            fieldItem.getPropConverter().beginParseValue(currRowMapper, fieldItem.getValue());
        }
        this.cacheCurrId(sourceObj, targetObj);
    }

    public void cacheBasedataPKIds() {
        ArrayList<IApiPropConverter> propConverters = new ArrayList<IApiPropConverter>(this.context.getPropConverters().values());
        propConverters.sort(new Comparator<IApiPropConverter>(){

            @Override
            public int compare(IApiPropConverter o1, IApiPropConverter o2) {
                return o1.getConvertSeq() - o2.getConvertSeq();
            }
        });
        for (IApiPropConverter propConverter : propConverters) {
            propConverter.endParseValue();
        }
    }

    public void convertComplexProperty(Map<String, Object> sourceObj, DynamicObject targetObj, int rowIndex) {
        if (sourceObj == null) {
            return;
        }
        if (targetObj == null) {
            return;
        }
        RowMapper currRowMapper = new RowMapper(sourceObj, targetObj, null, rowIndex);
        List<ApiPropConvertItem> fieldItems = this.context.sortPropConverters((EntityType)this.context.getModel().getDataEntityType(), sourceObj);
        for (ApiPropConvertItem fieldItem : fieldItems) {
            fieldItem.getPropConverter().setValue(currRowMapper, targetObj, fieldItem.getValue());
        }
    }

    private void cacheCurrId(Map<String, Object> sourceObj, DynamicObject targetObj) {
        if (!(targetObj.getDataEntityType() instanceof BasedataEntityType)) {
            return;
        }
        BasedataEntityType bdType = (BasedataEntityType)targetObj.getDataEntityType();
        Object pkValue = this.pkFieldProp.getValueFast((Object)targetObj);
        if (this.pkFieldProp.getValueComparator().compareValue(pkValue)) {
            pkValue = this.pkFieldProp instanceof VarcharProp ? DB.genStringIds((String)"", (int)1)[0] : Long.valueOf(DB.genGlobalLongId());
            this.pkFieldProp.setValueFast((Object)targetObj, pkValue);
        }
        String searchKey = null;
        String searchValue = null;
        if (sourceObj.containsKey("number")) {
            searchKey = bdType.getNumberProperty();
            searchValue = (String)sourceObj.get("number");
            BasedataItem currItem = new BasedataItem(bdType.getName(), bdType.getName(), bdType, this.getMainOrgId(), searchKey, searchValue);
            this.getBasePKs().put(currItem, pkValue);
        }
        if (sourceObj.containsKey("name")) {
            searchKey = bdType.getNameProperty();
            Object nameObj = sourceObj.get("name");
            searchValue = nameObj instanceof Map ? LocaleString.fromMap((Map)((Map)nameObj)).toString() : String.valueOf(nameObj);
            BasedataItem currItem = new BasedataItem(bdType.getName(), bdType.getName(), bdType, this.getMainOrgId(), searchKey, searchValue);
            this.getBasePKs().put(currItem, pkValue);
        }
    }

    @Deprecated
    public List<String> getContextErrorInfos() {
        return this.context.getErrorInfos();
    }

    public Map<Integer, List<String>> getContextErrorInfo() {
        return this.context.getErrorInfo();
    }

    public ModelEventProxy getModelEventProxy() {
        return this.modelEventProxy;
    }

    public void setModelEventProxy(ModelEventProxy modelEventProxy) {
        this.modelEventProxy = modelEventProxy;
    }

    public List<String> getDataConvertOrder() {
        return this.dataConvertOrder;
    }

    public void setDataConvertOrder(List<String> dataConvertOrder) {
        this.dataConvertOrder = dataConvertOrder;
        this.context.setDataConvertOrder(dataConvertOrder);
    }

    public void setCheckImportable(boolean checkImportable) {
        this.context.setCheckImportable(checkImportable);
    }
}

