/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ModelEventProxy;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.plugin.Plugin;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.dynplugin.FormDynamicPluginCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.annotations.MobBillPluginMethod;
import kd.bos.form.plugin.annotations.MobFormPluginMethod;
import kd.bos.list.IListView;
import kd.bos.list.IMobileListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.service.dynplugin.DynPlugin;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.sdk.kingscript.mixture.MixtureFactory;
import kd.sdk.kingscript.mixture.MixtureProxy;
import kd.sdk.kingscript.mixture.PluginMixtureProxy;

public class MobFormDynamicProxyPlugin<T extends IFormPlugin>
extends AbstractMobFormPlugin {
    private static final Log log = LogFactory.getLog(MobFormDynamicProxyPlugin.class);
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private Map<String, T> formPluginMap = new HashMap<String, T>(10);

    public String getInterfacetype() {
        return "1";
    }

    @MobFormPluginMethod
    @MobBillPluginMethod
    public void afterAddRow(AfterAddRowEventArgs e) {
        this.invokePluginMethod(e, plugin -> plugin.afterAddRow(e), "afterAddRow");
    }

    @MobFormPluginMethod
    @MobBillPluginMethod
    public void afterCreateNewData(EventObject e) {
        this.invokePluginMethod(e, plugin -> plugin.afterCreateNewData(e), "afterCreateNewData");
    }

    @MobFormPluginMethod
    @MobBillPluginMethod
    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        this.invokePluginMethod(e, plugin -> plugin.afterDeleteEntry(e), "afterDeleteEntry");
    }

    @MobFormPluginMethod
    @MobBillPluginMethod
    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.invokePluginMethod(e, plugin -> plugin.afterDeleteRow(e), "afterDeleteRow");
    }

    @MobFormPluginMethod
    @MobBillPluginMethod
    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        this.invokePluginMethod(e, plugin -> plugin.afterMoveEntryDown(e), "afterMoveEntryDown");
    }

    @MobFormPluginMethod
    @MobBillPluginMethod
    public void beforeDeleteEntry(BeforeDeleteEntryEventArgs e) {
        this.invokePluginMethod(e, plugin -> plugin.beforeDeleteEntry(e), "beforeDeleteEntry");
    }

    @MobFormPluginMethod
    @MobBillPluginMethod
    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        this.invokePluginMethod(e, plugin -> plugin.beforeDeleteRow(e), "beforeDeleteRow");
    }

    @MobFormPluginMethod
    @MobBillPluginMethod
    public void createNewData(BizDataEventArgs e) {
        this.invokePluginMethod(e, plugin -> plugin.createNewData(e), "createNewData");
    }

    @MobFormPluginMethod(isSupportConditionValid=true)
    @MobBillPluginMethod(isSupportConditionValid=true)
    public void propertyChanged(PropertyChangedArgs e) {
        this.invokePluginMethod(e, plugin -> plugin.propertyChanged(e), "propertyChanged");
    }

    @Override
    @MobFormPluginMethod
    @MobBillPluginMethod
    public void afterBindData(EventObject e) {
        this.invokePluginMethod(e, plugin -> plugin.afterBindData(e), "afterBindData");
    }

    @Override
    @MobFormPluginMethod
    @MobBillPluginMethod
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        this.invokePluginMethod(e, plugin -> plugin.afterDoOperation(e), "afterDoOperation");
    }

    @Override
    @MobFormPluginMethod
    @MobBillPluginMethod
    public void beforeBindData(EventObject e) {
        this.invokePluginMethod(e, plugin -> plugin.beforeBindData(e), "beforeBindData");
    }

    @Override
    @MobFormPluginMethod
    @MobBillPluginMethod
    public void beforeClosed(BeforeClosedEvent e) {
        this.invokePluginMethod(e, plugin -> plugin.beforeClosed(e), "beforeClosed");
    }

    @Override
    @MobFormPluginMethod
    @MobBillPluginMethod
    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        this.invokePluginMethod(e, plugin -> plugin.loadCustomControlMetas(e), "loadCustomControlMetas");
    }

    @Override
    @MobFormPluginMethod
    @MobBillPluginMethod
    public void preOpenForm(PreOpenFormEventArgs e) {
        this.invokePluginMethod(e, plugin -> plugin.preOpenForm(e), "preOpenForm");
    }

    @Override
    @MobFormPluginMethod
    @MobBillPluginMethod
    public void confirmCallBack(MessageBoxClosedEvent e) {
        this.invokePluginMethod(e, plugin -> plugin.confirmCallBack(e), "confirmCallBack");
    }

    @Override
    @MobFormPluginMethod
    @MobBillPluginMethod
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        this.invokePluginMethod(e, plugin -> plugin.beforeDoOperation(e), "beforeDoOperation");
    }

    @Override
    @MobFormPluginMethod
    @MobBillPluginMethod
    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        this.invokePluginMethod(e, plugin -> plugin.beforeFieldPostBack(e), "beforeFieldPostBack");
    }

    @Override
    @MobFormPluginMethod
    @MobBillPluginMethod
    public void pageRelease(EventObject e) {
        this.invokePluginMethod(e, plugin -> plugin.pageRelease(e), "pageRelease");
    }

    @MobBillPluginMethod
    public void afterCopyData(EventObject e) {
        this.invokePluginMethod(e, plugin -> plugin.afterCopyData(e), "afterCopyData");
    }

    protected void invokePluginMethod(Object eventObject, Consumer<T> pluginConsumer, String eventmethod) {
        try (EntityTraceSpan span = EntityTracer.create((String)"proxyplugin", (String)("invokePluginMethod." + eventmethod), (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            List<T> plugins;
            if (span.isRealtime()) {
                span.addTag("eventmethod", eventmethod);
            }
            if (CollectionUtils.isEmpty(plugins = this.getPlugins(eventObject, eventmethod))) {
                return;
            }
            List<String> formViewPluginNames = this.getFormViewPluginNames();
            if (span.isRealtime()) {
                span.addLocaleTag("formViewPluginNames", formViewPluginNames);
                span.addLocaleTag("plugins", plugins);
            }
            for (IFormPlugin plugin : plugins) {
                if (this.getView() != null && CollectionUtils.isNotEmpty(formViewPluginNames) && formViewPluginNames.contains(plugin.getPluginName())) {
                    return;
                }
                EntityTraceSpan spanPlugin = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + "." + eventmethod), (EntityTraceHint)EntityTraceHint.getHintLinkAPM());
                Throwable throwable = null;
                try {
                    try {
                        pluginConsumer.accept(plugin);
                    }
                    catch (Exception e) {
                        log.error("\u8c03\u7528\u8868\u5355\u63d2\u4ef6\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
                        spanPlugin.throwException((Throwable)e);
                        throw e;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (spanPlugin == null) continue;
                    if (throwable != null) {
                        try {
                            spanPlugin.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    spanPlugin.close();
                }
            }
        }
    }

    private List<T> getPlugins(Object eventObject, String eventmethod) {
        String interfacetype;
        List<DynPlugin> dynamicPlugins;
        String formId = this.getFormId(eventObject);
        if (StringUtils.isEmpty((String)formId)) {
            return null;
        }
        String client = "1";
        if (this.getView() instanceof IMobileView || this.getView() instanceof IMobileListView || eventObject instanceof EventObject && (((EventObject)eventObject).getSource() instanceof MobileFormShowParameter || ((EventObject)eventObject).getSource() instanceof MobileBillShowParameter)) {
            client = "2";
            if (formId.endsWith("_mob")) {
                formId = formId.substring(0, formId.lastIndexOf("_mob"));
            }
        }
        if (CollectionUtils.isNotEmpty(dynamicPlugins = FormDynamicPluginCache.getDynamicPlugins(formId, interfacetype = this.getInterfacetype(), eventmethod, client))) {
            DynPlugin dynPlugin;
            ArrayList<Plugin> plugins = new ArrayList<Plugin>(dynamicPlugins.size());
            for (int i = 0; i < dynamicPlugins.size() && this.isPassCondition(dynPlugin = dynamicPlugins.get(i)); ++i) {
                Object plugin = new Plugin();
                plugin.setClassName(dynamicPlugins.get(i).getClassName());
                plugin.setRowKey(i);
                plugin.setEnabled(true);
                plugin.setType(Integer.parseInt(dynamicPlugins.get(i).getCodeType()));
                plugin.setEvents(new ArrayList(0));
                plugin.setDynamicPlugin(false);
                plugin.setDescription(eventmethod);
                plugins.add((Plugin)plugin);
            }
            List<T> instancePlugins = this.createPlugin(plugins);
            if (CollectionUtils.isNotEmpty(instancePlugins) && this.getView() != null) {
                for (Object plugin : instancePlugins) {
                    plugin.setViewNoModelListener(this.getView());
                }
            }
            return instancePlugins;
        }
        return null;
    }

    private boolean isPassCondition(DynPlugin dynPlugin) {
        String runcondition = dynPlugin.getRuncondition();
        if (StringUtils.isNotEmpty((String)runcondition)) {
            String preCondition = "";
            Map runconditionMap = (Map)SerializationUtils.fromJsonString((String)runcondition, Map.class);
            if (runconditionMap != null) {
                String filter1 = "";
                String filter2 = "";
                if (runconditionMap.get("filterString") != null) {
                    FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)((String)runconditionMap.get("filterString")), FilterCondition.class);
                    FilterBuilder builder = new FilterBuilder(this.getModel().getDataEntityType(), filterCondition);
                    String[] filterScripts = builder.buildFilterScript();
                    if (filterScripts != null && filterScripts.length > 0 && StringUtils.isNotEmpty((String)filterScripts[0])) {
                        filter1 = filterScripts[0];
                    }
                }
                if (runconditionMap.get("expression") != null) {
                    filter2 = (String)runconditionMap.get("expression");
                }
                preCondition = this.joinFilter(filter1, filter2);
            }
            if (StringUtils.isEmpty((String)preCondition)) {
                return false;
            }
            RowDataModel rowDataModel = new RowDataModel(this.getModel().getDataEntityType().getName(), this.getModel());
            ExpressionParameter parameter = new ExpressionParameter(preCondition, rowDataModel);
            parameter.setActiveRow((Object)this.getModel().getDataEntity());
            Object expValue = CalcExprParser.getExpressionValue((ExpressionParameter)parameter);
            return expValue != null && (Boolean)expValue != false;
        }
        return true;
    }

    private List<T> createPlugin(List<Plugin> plugins) {
        try (EntityTraceSpan span = EntityTracer.create((String)"proxyplugin", (String)"createPlugin");){
            ArrayList<IFormPlugin> formPlugins = new ArrayList<IFormPlugin>(plugins.size());
            if (plugins == null) {
                ArrayList<IFormPlugin> arrayList = formPlugins;
                return arrayList;
            }
            for (Plugin ins : plugins) {
                IFormPlugin instance = (IFormPlugin)this.formPluginMap.get(ins.getClassName());
                if (instance != null) {
                    formPlugins.add(instance);
                    continue;
                }
                if (0 == ins.getType()) {
                    try {
                        instance = (IFormPlugin)TypesContainer.createInstance((String)ins.getClassName());
                        formPlugins.add(instance);
                        this.formPluginMap.put(ins.getClassName(), instance);
                        span.addLocaleTag(SPAN_TYPE_PLUGIN + formPlugins.size(), (Object)ins.getClassName());
                        continue;
                    }
                    catch (Exception e) {
                        HashMap<String, MobFormDynamicProxyPlugin> tags = new HashMap<String, MobFormDynamicProxyPlugin>(1);
                        tags.put("formConfig", this);
                        EntityTracer.throwException((String)"proxyplugin", (String)"createPlugin", null, (Throwable)e, tags);
                        ErrorCode errorCode = new ErrorCode("bos.createPluginError", e.getMessage());
                        throw new KDException(errorCode, e.getMessage(), (Throwable)e);
                    }
                }
                if (4 != ins.getType() || !Plugin.enableRunKingScript()) continue;
                try {
                    IFormPlugin splugin = (IFormPlugin)MixtureFactory.createMixtureProxy((MixtureProxy)new PluginMixtureProxy(ins.getClassName(), scriptPath -> ProjectInitializerManager.getEngineAutoDebug(scriptPath)));
                    if (splugin != null) {
                        splugin.setPluginName(ins.getClassName() + "_" + ins.getDescription());
                        formPlugins.add(splugin);
                        this.formPluginMap.put(ins.getClassName(), instance);
                    }
                    span.addLocaleTag(SPAN_TYPE_PLUGIN + formPlugins.size(), (Object)ins.getClassName());
                }
                catch (Exception e) {
                    HashMap<String, MobFormDynamicProxyPlugin> tags = new HashMap<String, MobFormDynamicProxyPlugin>(1);
                    tags.put("formConfig", this);
                    EntityTracer.throwException((String)"proxyplugin", (String)"createPlugin", null, (Throwable)e, tags);
                    ErrorCode errorCode = new ErrorCode("bos.createPluginError", e.getMessage());
                    throw new KDException(errorCode, e.getMessage(), (Throwable)e);
                }
            }
            ArrayList<IFormPlugin> arrayList = formPlugins;
            return arrayList;
        }
    }

    private void removeModelListeners(List<T> instancePlugins, String eventmethod) {
        try {
            ModelEventProxy modelEventProxy = (ModelEventProxy)this.getView().getModel().getService(ModelEventProxy.class);
            Field modelListenersField = ModelEventProxy.class.getDeclaredField("modelListeners");
            Field modelChangeListenersField = ModelEventProxy.class.getDeclaredField("modelChangeListeners");
            modelListenersField.setAccessible(true);
            modelChangeListenersField.setAccessible(true);
            LinkedHashSet modelChangeListeners = (LinkedHashSet)modelChangeListenersField.get(modelEventProxy);
            List modelListeners = (List)modelListenersField.get(modelEventProxy);
            for (IFormPlugin plugin : instancePlugins) {
                if (CollectionUtils.isNotEmpty((Collection)modelChangeListeners)) {
                    if (plugin instanceof Proxy) {
                        String pluginName = plugin.getPluginName() + "_" + eventmethod;
                        modelChangeListeners.removeIf(item -> item instanceof IFormPlugin && pluginName.equals(((IFormPlugin)item).getPluginName()));
                    } else {
                        modelChangeListeners.remove(plugin);
                    }
                }
                if (!CollectionUtils.isNotEmpty((Collection)modelListeners)) continue;
                modelListeners.remove(plugin);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException var2) {
            throw new RuntimeException(var2);
        }
    }

    private List<String> getFormViewPluginNames() {
        FormViewPluginProxy formViewPluginProxy;
        if (this.getView() != null && (formViewPluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class)).getPlugIns() != null && formViewPluginProxy.getPlugIns().size() > 0) {
            ArrayList<String> formViewPluginNames = new ArrayList<String>(formViewPluginProxy.getPlugIns().size());
            for (IFormPlugin plugin : formViewPluginProxy.getPlugIns()) {
                formViewPluginNames.add(plugin.getPluginName());
            }
            return formViewPluginNames;
        }
        return new ArrayList<String>(0);
    }

    private String getFormId(Object eventObject) {
        String formId = "";
        if (eventObject instanceof EventObject) {
            Object source = ((EventObject)eventObject).getSource();
            FormShowParameter showParameter = null;
            if (source instanceof IFormView) {
                showParameter = ((IFormView)source).getFormShowParameter();
            } else if (source instanceof FormShowParameter) {
                showParameter = (FormShowParameter)source;
            }
            if (showParameter instanceof ListShowParameter) {
                formId = ((ListShowParameter)showParameter).getBillFormId();
            } else if (showParameter instanceof FormShowParameter) {
                formId = showParameter.getFormId();
            }
        }
        if (StringUtils.isEmpty((String)formId)) {
            if (this.getView() instanceof IListView) {
                formId = ((IListView)this.getView()).getBillFormId();
            } else if (this.getView() != null && this.getView().getFormShowParameter() instanceof FormShowParameter) {
                formId = this.getView().getFormShowParameter().getFormId();
            }
        }
        return formId;
    }

    private String joinFilter(String filter1, String filter2) {
        if (StringUtils.isEmpty((String)filter1)) {
            return filter2;
        }
        if (StringUtils.isEmpty((String)filter2)) {
            return filter1;
        }
        return String.format("(%s) and (%s)", filter1, filter2);
    }
}

