/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.EventObject;
import java.util.function.Consumer;
import kd.bos.bill.events.LocateEvent;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.events.TimeZoneLocationEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.IMobFormPlugin;

public class MobFormViewPluginProxy
extends FormViewPluginProxy {
    private static final String SPAN_TYPE_PLUGIN = "plugin";

    private void invokeMobFormMethod(Consumer<IFormPlugin> consumer, String methodName, Class<?> ... parameterTypes) {
        for (IFormPlugin pl : this.plugIns) {
            if (!this.isNotOverride(pl.getClass(), methodName, parameterTypes) || !(pl instanceof IMobFormPlugin)) continue;
            consumer.accept(pl);
        }
    }

    public void fireMobileUpload(UploadEvent e) {
        for (IFormPlugin plugin : this.getPlugIns()) {
            if (!this.isNotOverride(plugin.getClass(), "uploadFile", UploadEvent.class) || !(plugin instanceof IMobFormPlugin)) continue;
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".uploadFile"));
            Throwable throwable = null;
            try {
                ((IMobFormPlugin)((Object)plugin)).uploadFile((EventObject)e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void fireLocate(LocateEvent e) {
        this.invokeMobFormMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".locate"));){
                ((IMobFormPlugin)((Object)plugin)).locate(e);
            }
        }, "locate", LocateEvent.class);
    }

    public void fireTimeZoneLocate(TimeZoneLocationEvent e) {
        this.invokeMobFormMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".timeZoneLocate"));){
                ((IMobFormPlugin)((Object)plugin)).timeZoneLocate(e);
            }
        }, "timeZoneLocate", TimeZoneLocationEvent.class);
    }

    public void fireRefreshData() {
        this.invokeMobFormMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".refreshData"));){
                ((IMobFormPlugin)((Object)plugin)).refreshData();
            }
        }, "refreshData", new Class[0]);
    }

    public void fireAfterMobilePageClose(EventObject e) {
        this.invokeMobFormMethod(plugin -> {
            if (plugin instanceof IMobFormPlugin) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".afterMobilePageClose"));){
                    ((IMobFormPlugin)((Object)plugin)).afterMobilePageClose(e);
                }
            }
        }, "afterMobilePageClose", EventObject.class);
    }
}

