/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.spread;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.form.container.Container;
import kd.bos.form.spread.SpreadActionAdapter;
import kd.bos.form.spread.SpreadExceptionCheck;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSObject;
import kd.bos.util.CollectionUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class Spread
extends Container {
    private static Log log = LogFactory.getLog(Spread.class);
    private SpreadPostDataInfo postData;
    private List<ISpreadAction> spreadActions = new ArrayList<ISpreadAction>(4);

    public void addSpreadAction(ISpreadAction spreadAction) {
        this.spreadActions.add(spreadAction);
    }

    @SdkInternal
    public void deleteRows(List<Integer> postDatas) {
        this.packInvokeListParams(postDatas);
        SpreadEvent eventArgs = new SpreadEvent(this, this.postData);
        this.addSpreadActionMethod(spreadAction -> spreadAction.deleteRows(eventArgs));
    }

    @SdkInternal
    public void deleteColumns(List<Integer> postDatas) {
        this.packInvokeListParams(postDatas);
        SpreadEvent eventArgs = new SpreadEvent(this, this.postData);
        this.addSpreadActionMethod(spreadAction -> spreadAction.deleteColumns(eventArgs));
    }

    @SdkInternal
    public void addRows(List<Integer> postDatas) {
        this.packInvokeListParams(postDatas);
        SpreadEvent eventArgs = new SpreadEvent(this, this.postData);
        this.addSpreadActionMethod(spreadAction -> spreadAction.addRows(eventArgs));
    }

    @SdkInternal
    public void addColumns(List<Integer> postDatas) {
        this.packInvokeListParams(postDatas);
        SpreadEvent eventArgs = new SpreadEvent(this, this.postData);
        this.addSpreadActionMethod(spreadAction -> spreadAction.addColumns(eventArgs));
    }

    @SdkInternal
    public void entryRowClick(int arg) {
        SpreadEvent eventArgs = new SpreadEvent(this, this.postData);
        this.addSpreadActionMethod(spreadAction -> spreadAction.selectedSpread(eventArgs));
    }

    @SdkInternal
    public void askExecute(LinkedHashMap<String, Object> postDatas) {
        this.packInvokeParams(postDatas);
        SpreadEvent eventArgs = new SpreadEvent(this, this.postData);
        this.addSpreadActionMethod(spreadAction -> spreadAction.askExecute(eventArgs));
    }

    @SdkInternal
    public void cellIsLocked(LinkedHashMap<String, Object> postDatas) {
        this.packInvokeParams(postDatas);
        SpreadEvent eventArgs = new SpreadEvent(this, this.postData);
        this.addSpreadActionMethod(spreadAction -> spreadAction.cellIsLocked(eventArgs));
    }

    @SdkInternal
    public void f7Click(LinkedHashMap<String, Object> postDatas) {
        this.packInvokeParams(postDatas);
        SpreadEvent eventArgs = new SpreadEvent(this, this.postData);
        this.addSpreadActionMethod(spreadAction -> spreadAction.f7Click(eventArgs));
    }

    @SdkInternal
    public void showFormulaPanel(LinkedHashMap<String, Object> postDatas) {
        this.packInvokeParams(postDatas);
        SpreadEvent eventArgs = new SpreadEvent(this, this.postData);
        this.addSpreadActionMethod(spreadAction -> spreadAction.showFormulaPanel(eventArgs));
    }

    @SdkInternal
    public void updateFormula(LinkedHashMap<String, Object> postDatas) {
        this.packInvokeParams(postDatas);
        SpreadEvent eventArgs = new SpreadEvent(this, this.postData);
        this.addSpreadActionMethod(spreadAction -> spreadAction.updateFormula(eventArgs));
    }

    @SdkInternal
    public void getLookupData(LinkedHashMap<String, Object> postDatas) {
        this.packInvokeParams(postDatas);
        SpreadEvent eventArgs = new SpreadEvent(this, this.postData);
        this.addSpreadActionMethod(spreadAction -> spreadAction.getLookupData(eventArgs));
    }

    @SdkInternal
    public void setItemByIdFromClient(List<Object> postDatas) {
        this.postData = new SpreadPostDataInfo();
        LinkedHashMap<String, Object> invokeParams = new LinkedHashMap<String, Object>();
        invokeParams.put("id", postDatas.get(0));
        invokeParams.put("number", postDatas.get(1));
        invokeParams.put("name", postDatas.get(2));
        invokeParams.put("r", postDatas.get(3));
        invokeParams.put("c", postDatas.get(4));
        this.postData.setInvokeParams(invokeParams);
        SpreadEvent eventArgs = new SpreadEvent(this, this.postData);
        this.addSpreadActionMethod(spreadAction -> spreadAction.setItemByIdFromClient(eventArgs));
    }

    @SdkInternal
    public void updateValue(LinkedHashMap<String, Object> postDatas) {
        this.postData = new SpreadPostDataInfo();
        this.postData.setValues(postDatas);
        SpreadEvent eventArgs = new SpreadEvent(this, this.postData);
        this.addSpreadActionMethod(spreadAction -> spreadAction.updateCellValue(eventArgs));
    }

    @SdkInternal
    public void invokeAction(LinkedHashMap<String, Object> postDatas) {
        this.packInvokeParams(postDatas);
        SpreadEvent eventArgs = new SpreadEvent(this, this.postData);
        this.addSpreadActionMethod(spreadAction -> spreadAction.invokePluginMethod(eventArgs));
    }

    private void packInvokeParams(LinkedHashMap<String, Object> postDatas) {
        this.postData = new SpreadPostDataInfo();
        this.postData.setInvokeParams(postDatas);
    }

    private void packInvokeListParams(List<?> postDatas) {
        this.postData = new SpreadPostDataInfo();
        this.postData.setInvokeListParams(postDatas);
    }

    private ISpreadAction getActionService() {
        return this.getView().getService(ISpreadAction.class) == null ? new SpreadActionAdapter(null) : (ISpreadAction)this.getView().getService(ISpreadAction.class);
    }

    @Override
    @SdkInternal
    public void postBack(Object value) {
        super.postBack(value);
        this.postData = SpreadPostDataInfo.convertMap2SpreadPostDataInfo(value);
    }

    public SpreadPostDataInfo getPostDataInfo() {
        return this.postData;
    }

    @SdkInternal
    public void printClick() {
    }

    @SdkInternal
    public void cellFormatIconClick() {
    }

    private void addSpreadActionMethod(Consumer<ISpreadAction> spreadActionConsumer) {
        this.invokeSpreadActionMethod(spreadActionConsumer, this.getActionService());
        if (CollectionUtils.isNotEmpty(this.spreadActions)) {
            for (ISpreadAction spreadAction : this.spreadActions) {
                this.invokeSpreadActionMethod(spreadActionConsumer, spreadAction);
            }
        }
    }

    private void invokeSpreadActionMethod(Consumer<ISpreadAction> spreadActionConsumer, ISpreadAction spreadAction) {
        try {
            spreadActionConsumer.accept(spreadAction);
        }
        catch (Exception e) {
            if (SpreadExceptionCheck.isNeedCatchException(e)) {
                log.error("\u8c03\u7528\u63d2\u4ef6\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            }
            throw e;
        }
    }
}

