/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.spread;

import java.util.HashSet;
import java.util.Set;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class SpreadExceptionCheck {
    private static Set<String> exceptionSet = null;

    public static boolean isNeedCatchException(Exception e) {
        String exceptionMsg = e.getMessage();
        if (StringUtils.isEmpty((String)exceptionMsg)) {
            return false;
        }
        if (SpreadExceptionCheck.checkExceptionMsg(exceptionMsg)) {
            return true;
        }
        HashSet<String> exceptionts = new HashSet<String>(3);
        exceptionts.add(exceptionMsg);
        return SpreadExceptionCheck.isNeedCatchException(exceptionts, e);
    }

    private static boolean isNeedCatchException(Set<String> exceptionts, Throwable t) {
        if (t == null || t.getCause() == null) {
            return false;
        }
        String exceptionMsg = t.getCause().toString();
        if (StringUtils.isEmpty((String)exceptionMsg) || exceptionts.contains(exceptionMsg)) {
            return false;
        }
        if (SpreadExceptionCheck.checkExceptionMsg(exceptionMsg)) {
            return true;
        }
        exceptionts.add(exceptionMsg);
        return SpreadExceptionCheck.isNeedCatchException(exceptionts, t.getCause());
    }

    private static boolean checkExceptionMsg(String exceptionMsg) {
        for (String exception : exceptionSet) {
            if (!exceptionMsg.startsWith(exception)) continue;
            return true;
        }
        return false;
    }

    static {
        exceptionSet = new HashSet<String>(3);
        exceptionSet.add("java.lang.NoSuchMethodException");
        exceptionSet.add("java.lang.IllegalAccessException");
        exceptionSet.add("java.lang.reflect.InvocationTargetException");
    }
}

