/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.id.Base39Coder;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.MetaBuildContext;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class AbstractMetadata
implements ISupportInitialize,
Serializable {
    private static final long serialVersionUID = 2343187651886932648L;
    private List<ErrorInfo> buildErrors = new ArrayList<ErrorInfo>();
    private String inheritPath;
    private String parentId;
    private String masterId;
    private String devType;
    private String modelType;
    private String Id;
    protected Integer subSysId = 0;
    private String bizappId;
    private boolean runtime;
    private String isv;
    private String isvSign;
    private String modifierId;
    private Date modifyDate;
    private String mergeVersion;
    private MetaBuildContext context;
    private boolean enableGlobalExtLimits;
    private String envRegion;
    private boolean ignoreBuildError;

    @SimplePropertyAttribute(name="EnableGlobalExtLimits")
    public boolean isEnableGlobalExtLimits() {
        return this.enableGlobalExtLimits;
    }

    public void setEnableGlobalExtLimits(boolean enableGlobalExtLimits) {
        this.enableGlobalExtLimits = enableGlobalExtLimits;
    }

    @SimplePropertyAttribute(name="EnvRegion")
    public String getEnvRegion() {
        return this.envRegion;
    }

    public void setEnvRegion(String envRegion) {
        this.envRegion = envRegion;
    }

    @KSMethod
    public void endInit() {
    }

    @KSMethod
    public void beginInit() {
    }

    public Integer getSubSysId() {
        return this.subSysId;
    }

    public void setSubSysId(Integer subSysId) {
        this.subSysId = subSysId;
    }

    @SimplePropertyAttribute(displayName="bizAppId")
    public String getBizappId() {
        return this.bizappId;
    }

    public void setBizappId(String bizappId) {
        this.bizappId = bizappId;
    }

    @KSMethod
    public boolean isInitialized() {
        return false;
    }

    @KSMethod
    public List<ErrorInfo> getBuildErrors() {
        return this.buildErrors;
    }

    @KSMethod
    public void addError(ErrorInfo info) {
        ErrorInfo err = info;
        if (this.ignoreBuildError && info.getLevel() == 2) {
            err = info.copy();
            err.setLevel(1);
        }
        this.buildErrors.add(err);
    }

    public void setIgnoreBuildError(boolean ignoreBuildError) {
        this.ignoreBuildError = ignoreBuildError;
    }

    public boolean isIgnoreBuildError() {
        return this.ignoreBuildError;
    }

    @SimplePropertyAttribute(displayName="ID")
    @KSMethod
    public String getId() {
        return this.Id;
    }

    @KSMethod
    public void setId(String id) {
        this.Id = id;
    }

    @SimplePropertyAttribute(displayName="parent ID")
    @KSMethod
    public String getParentId() {
        if (StringUtils.isEmpty((CharSequence)this.parentId)) {
            return "";
        }
        return this.parentId;
    }

    @KSMethod
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @KSMethod
    @SimplePropertyAttribute(displayName="inherit path")
    public String getInheritPath() {
        if (StringUtils.isEmpty((CharSequence)this.inheritPath)) {
            return "";
        }
        return this.inheritPath;
    }

    @KSMethod
    public void setInheritPath(String inheritPath) {
        this.inheritPath = inheritPath;
    }

    @KSMethod
    public boolean isInherit() {
        return StringUtils.isNotEmpty((CharSequence)this.inheritPath);
    }

    @KSMethod
    @SimplePropertyAttribute(displayName="master ID")
    public String getMasterId() {
        return this.masterId;
    }

    @KSMethod
    public void setMasterId(String masterId) {
        this.masterId = masterId;
    }

    @KSMethod
    @SimplePropertyAttribute(displayName="develop type")
    public String getDevType() {
        return this.devType;
    }

    @KSMethod
    public void setDevType(String devType) {
        this.devType = devType;
    }

    @KSMethod
    @SimplePropertyAttribute(displayName="domain model")
    public String getModelType() {
        return this.modelType;
    }

    @KSMethod
    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    @KSMethod
    @SimplePropertyAttribute(displayName="isv")
    public String getIsv() {
        return this.isv;
    }

    @KSMethod
    public void setIsv(String isv) {
        this.isv = isv;
    }

    @KSMethod
    @SimplePropertyAttribute(displayName="isv sign")
    public String getIsvSign() {
        return this.isvSign;
    }

    @KSMethod
    public void setIsvSign(String isvSign) {
        this.isvSign = isvSign;
    }

    public abstract IDataEntityType getDesingerMetaType();

    public abstract IDataEntityType getDesingerMetaLType();

    public void convertFromDesignMeta(DesignMeta designMeta) {
        this.setId(designMeta.getId());
        this.setModelType(designMeta.getModelType());
        this.setParentId(designMeta.getParentId());
        this.setInheritPath(designMeta.getInheritPath());
        this.setMasterId(designMeta.getMasterId());
        this.setDevType(designMeta.getDevType());
        this.setBizappId(designMeta.getBizappId());
        this.setSubSysId(designMeta.getSubSysId());
        this.setIsv(designMeta.getIsv());
    }

    public DesignMeta convertToDesignMeta(String xml) {
        DesignMeta designMeta = (DesignMeta)this.getDesingerMetaType().createInstance();
        designMeta.setDataXml(xml);
        this.setDesignMeta(designMeta);
        return designMeta;
    }

    protected void setDesignMeta(DesignMeta designMeta) {
        designMeta.setId(this.getId());
        designMeta.setModelType(this.getModelType());
        designMeta.setParentId(this.getParentId());
        designMeta.setInheritPath(this.getInheritPath());
        designMeta.setMasterId(this.getMasterId());
        designMeta.setDevType(this.getDevType());
        String isv = StringUtils.isBlank((CharSequence)this.getIsv()) ? "" : this.getIsv();
        designMeta.setIsv(isv);
        designMeta.setVersion(System.currentTimeMillis());
        designMeta.setBizappId(this.getBizappId());
        designMeta.setSubSysId(this.getSubSysId());
    }

    public DesignMetaL convertToDesignMetaL(String localeId, String langXml) {
        DesignMetaL designMetaL = (DesignMetaL)this.getDesingerMetaLType().createInstance();
        designMetaL.setDataXml(langXml);
        this.setDesignMetaL(localeId, designMetaL);
        return designMetaL;
    }

    protected void setDesignMetaL(String localeId, DesignMetaL designMetaL) {
        designMetaL.setLocaleId(localeId);
        designMetaL.setPkId(Base39Coder.toString((long)DB.genGlobalLongId()));
        designMetaL.setId(this.getId());
    }

    public Map<String, Object> buildDesignMeta(String lang) {
        HashMap<String, Object> clientMeta = new HashMap<String, Object>();
        clientMeta.put("id", this.getId());
        boolean isPC = !this.getModelType().startsWith("Mob");
        clientMeta.put("isPC", isPC);
        clientMeta.put("modelType", this.getModelType());
        clientMeta.put("language", lang);
        clientMeta.put("bizappid", this.getBizappId());
        clientMeta.put("modifierId", this.getModifierId());
        clientMeta.put("modifyDate", this.getModifyDate());
        return clientMeta;
    }

    public boolean isRuntime() {
        return this.runtime;
    }

    public void setRuntime(boolean runtime) {
        this.runtime = runtime;
    }

    public Date getModifyDate() {
        return this.modifyDate;
    }

    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    public String getModifierId() {
        return this.modifierId;
    }

    public void setModifierId(String modifierId) {
        this.modifierId = modifierId;
    }

    public String getMergeVersion() {
        return this.mergeVersion;
    }

    public void setMergeVersion(String mergeVersion) {
        this.mergeVersion = mergeVersion;
    }

    @Deprecated
    protected void fillTermRes() {
    }

    public void fillTermRes(Map<String, Map<String, Object>> termRes) {
    }

    public MetaBuildContext getBuildContext() {
        return this.context;
    }

    public void setBuildContext(MetaBuildContext context) {
        this.context = context;
    }
}

