/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.billlayout;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.DifferentialControlInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LayoutControlInfo;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.billlayout.EntityLayoutSchemeCacheInfos;
import kd.bos.metadata.billlayout.LayoutSchemeFieldPermCacheInfo;
import kd.bos.metadata.billlayout.LayoutSchemeLocalCache;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.FieldAp;

public class BillLayoutReader {
    public static final String FORMID_BOS_LAYOUTSCHEME = "bos_newpageconfig";
    public static final String FORMID_BOS_FORMMETA = "bos_formmeta";
    public static final String KEY_FIELD_CONTROL_ENTRY = "fieldcontrolentry";
    public static final String KEY_BILL_FORMID = "billformid";
    public static final String KEY_FIELDKEY = "fieldkey";
    public static final String KEY_MUST_INPUT = "mustinput";
    public static final String KEY_DEFAULT_VALUE = "defaultvalue";
    public static final String KEY_LAYOUT = "layoutnumber";
    public static final String KEY_MODIFYTIME = "modifytime";
    public static final Map<String, String> VISIBLE2STATUS = new HashMap<String, String>();
    public static final Map<String, String> LOCK2STATUS = new HashMap<String, String>();
    public static final Set<String> selectedFields = new HashSet<String>();
    public static final Set<String> modifyTimeFields = new HashSet<String>();
    private static final Log log = LogFactory.getLog(BillLayoutReader.class);

    private static DynamicObject loadModifyTimeFromCache(String entityNumber, long layoutSchemeId) {
        DynamicObjectType dType = EntityMetadataCache.getSubDataEntityType((String)FORMID_BOS_LAYOUTSCHEME, modifyTimeFields);
        Map layoutSchemeObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{layoutSchemeId}, (DynamicObjectType)dType);
        if (layoutSchemeObjs == null || layoutSchemeObjs.isEmpty()) {
            return null;
        }
        return (DynamicObject)layoutSchemeObjs.get(layoutSchemeId);
    }

    public static List<DifferentialControlInfo> loadDifferentialControlInfosFromCache(String entityNumber, long layoutSchemeId) {
        Date modifyTime;
        EntityLayoutSchemeCacheInfos entityControlCacheInfos = LayoutSchemeLocalCache.getEntityControlCacheInfos(entityNumber);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (entityControlCacheInfos != null && !StringUtils.equals((CharSequence)mainType.getVersion(), (CharSequence)entityControlCacheInfos.getEntityVersion())) {
            LayoutSchemeLocalCache.removeEntityControlCacheInfos(entityNumber);
            entityControlCacheInfos = null;
        }
        LayoutSchemeFieldPermCacheInfo layoutSchemeFieldPermCacheInfo = null;
        DynamicObject modityTimeObj = BillLayoutReader.loadModifyTimeFromCache(entityNumber, layoutSchemeId);
        Date date = modifyTime = modityTimeObj == null ? null : modityTimeObj.getDate(KEY_MODIFYTIME);
        if (entityControlCacheInfos != null && (layoutSchemeFieldPermCacheInfo = entityControlCacheInfos.getSchemeCacheInfos().get(layoutSchemeId)) != null) {
            if (layoutSchemeFieldPermCacheInfo.isTimeOut() || Long.compare(layoutSchemeFieldPermCacheInfo.getModifyTime(), modifyTime == null ? 0L : modifyTime.getTime()) != 0) {
                layoutSchemeFieldPermCacheInfo = null;
            } else {
                return layoutSchemeFieldPermCacheInfo.getDeffControlInfos();
            }
        }
        List<DifferentialControlInfo> differentialControlInfos = null;
        differentialControlInfos = BillLayoutReader.loadDifferentialControlInfos(entityNumber, layoutSchemeId);
        if (entityControlCacheInfos == null) {
            entityControlCacheInfos = new EntityLayoutSchemeCacheInfos(entityNumber, mainType.getVersion());
        }
        layoutSchemeFieldPermCacheInfo = new LayoutSchemeFieldPermCacheInfo(layoutSchemeId, modifyTime == null ? 0L : modifyTime.getTime());
        layoutSchemeFieldPermCacheInfo.setDeffControlInfos(differentialControlInfos);
        entityControlCacheInfos.getSchemeCacheInfos().put(layoutSchemeId, layoutSchemeFieldPermCacheInfo);
        LayoutSchemeLocalCache.putEntityControlCacheInfos(entityNumber, entityControlCacheInfos);
        return differentialControlInfos;
    }

    private static List<DifferentialControlInfo> loadDifferentialControlInfos(String entityNumber, long schemeId) {
        DynamicObject schemeObj = BillLayoutReader.loadSchemeObject(entityNumber, schemeId);
        DynamicObjectCollection storeInfos = schemeObj == null ? null : schemeObj.getDynamicObjectCollection(KEY_FIELD_CONTROL_ENTRY);
        String layoutNumber = "";
        if (schemeObj != null) {
            layoutNumber = schemeObj.getString(KEY_LAYOUT);
        }
        Map<String, LayoutControlInfo> fullInfo = BillLayoutReader.getControlInfos(layoutNumber, entityNumber);
        return BillLayoutReader.resolveDifferentialControlInfos(fullInfo, storeInfos);
    }

    private static DynamicObject loadSchemeObject(String entityNumber, Long schemeId) {
        MainEntityType dType = EntityMetadataCache.getDataEntityType((String)FORMID_BOS_LAYOUTSCHEME);
        Map layoutSchemeObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{schemeId}, (DynamicObjectType)dType, (boolean)true);
        if (LayoutControlInfo.isOutLog()) {
            log.warn(String.format("loadSchemeObject layout count:%s, current layout schemeId:%s", layoutSchemeObjs.size(), schemeId));
        }
        if (layoutSchemeObjs.isEmpty()) {
            return null;
        }
        return (DynamicObject)layoutSchemeObjs.get(schemeId);
    }

    private static Map<String, LayoutControlInfo> getControlInfos(String layoutNumber, String entityNumber) {
        return StringUtils.isBlank((CharSequence)layoutNumber) ? BillLayoutReader.getFullControlInfos(entityNumber) : BillLayoutReader.getFullControlInfos(layoutNumber, entityNumber);
    }

    private static List<DifferentialControlInfo> resolveDifferentialControlInfos(Map<String, LayoutControlInfo> fullInfo, DynamicObjectCollection storeInfos) {
        ArrayList<DifferentialControlInfo> difInfos = new ArrayList<DifferentialControlInfo>();
        HashMap<String, DifferentialControlInfo> finishedFields = new HashMap<String, DifferentialControlInfo>();
        if (storeInfos == null) {
            return difInfos;
        }
        for (DynamicObject storeInfo : storeInfos) {
            String fieldKey = storeInfo.getString(KEY_FIELDKEY);
            LayoutControlInfo fieldInfo = fullInfo.get(fieldKey);
            if (fieldInfo == null) continue;
            DifferentialControlInfo differentialControlInfo = (DifferentialControlInfo)finishedFields.get(fieldKey);
            if (differentialControlInfo == null) {
                differentialControlInfo = new DifferentialControlInfo();
                difInfos.add(differentialControlInfo);
                finishedFields.put(fieldKey, differentialControlInfo);
            }
            differentialControlInfo.setFieldKey(fieldKey);
            differentialControlInfo.setFieldId(fieldInfo.getFieldId());
            differentialControlInfo.setEntityFieldKey(fieldInfo.getEntityFieldKey());
            if (!Objects.equals(storeInfo.getBoolean(KEY_MUST_INPUT), fieldInfo.isMustInput()) && !fieldInfo.isMustInput()) {
                differentialControlInfo.setMustInput(true);
            }
            for (Map.Entry<String, String> entry : VISIBLE2STATUS.entrySet()) {
                if (!Objects.equals(storeInfo.get(entry.getKey()), fieldInfo.isVisible(entry.getValue()))) {
                    differentialControlInfo.addVisible(entry.getValue(), false);
                    continue;
                }
                differentialControlInfo.addVisible(entry.getValue(), fieldInfo.isVisible(entry.getValue()));
            }
            for (Map.Entry<String, String> entry : LOCK2STATUS.entrySet()) {
                if (!Objects.equals(storeInfo.get(entry.getKey()), fieldInfo.isLock(entry.getValue()))) {
                    differentialControlInfo.addLock(entry.getValue(), true);
                    continue;
                }
                differentialControlInfo.addLock(entry.getValue(), fieldInfo.isLock(entry.getValue()));
            }
            if (!StringUtils.isNotBlank((CharSequence)storeInfo.getString(KEY_DEFAULT_VALUE))) continue;
            differentialControlInfo.setDefaultValue(storeInfo.getString(KEY_DEFAULT_VALUE));
        }
        return difInfos;
    }

    public static Map<String, LayoutControlInfo> getFullControlInfos(String formId) {
        LinkedHashMap<String, LayoutControlInfo> infos = new LinkedHashMap<String, LayoutControlInfo>(50);
        String id = MetadataDao.getIdByNumber(formId, MetaCategory.Entity);
        EntityMetadata entityMeta = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta(id, MetaCategory.Entity);
            BillLayoutReader.toLayoutCtlInfo(infos, entityMeta);
        }
        if (StringUtils.isNotBlank((CharSequence)(id = MetadataDao.getIdByNumber(formId, MetaCategory.Form)))) {
            FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta(id, MetaCategory.Form);
            BillLayoutReader.toLayoutCtlInfo(infos, formMeta);
        }
        if (entityMeta != null) {
            return BillLayoutReader.sort(infos, entityMeta);
        }
        return infos;
    }

    private static Map<String, LayoutControlInfo> sort(Map<String, LayoutControlInfo> infos, EntityMetadata entityMeta) {
        LinkedHashMap<String, LayoutControlInfo> ret = new LinkedHashMap<String, LayoutControlInfo>();
        List<Entity<?, ?>> items = entityMeta.getEntitys();
        for (Entity<?, ?> entity : items) {
            for (EntityItem<?> item : entity.getItems()) {
                if (infos.containsKey(item.getKey())) {
                    ret.put(item.getKey(), infos.get(item.getKey()));
                }
                infos.forEach((k, v) -> {
                    if (v.getFieldId().equals(item.getId())) {
                        ret.put((String)k, (LayoutControlInfo)v);
                    }
                });
            }
        }
        if (!ret.isEmpty()) {
            infos = ret;
        }
        return infos;
    }

    public static Map<String, LayoutControlInfo> getFullControlInfos(String formId, String originalFormId) {
        LinkedHashMap<String, LayoutControlInfo> infos = new LinkedHashMap<String, LayoutControlInfo>(50);
        String id = MetadataDao.getIdByNumber(formId, MetaCategory.Form);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta(id, MetaCategory.Form);
            BillLayoutReader.toLayoutCtlInfo(infos, formMeta);
        }
        if (StringUtils.isNotBlank((CharSequence)(id = MetadataDao.getIdByNumber(originalFormId, MetaCategory.Entity)))) {
            EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta(id, MetaCategory.Entity);
            BillLayoutReader.toLayoutCtlInfo(infos, entityMeta);
            return BillLayoutReader.sort(infos, entityMeta);
        }
        return infos;
    }

    public static Map<String, String> getFieldVisibleInfo(FormMetadata formmeta) {
        LinkedHashMap<String, String> visMap = new LinkedHashMap<String, String>();
        Consumer<FieldAp> consumer = fieldAp -> visMap.put(fieldAp.getKey(), fieldAp.getVisible());
        BillLayoutReader.travelFieldApInfo(formmeta, consumer);
        return visMap;
    }

    public static Map<String, String> getFieldLockInfo(FormMetadata formmeta) {
        LinkedHashMap<String, String> lockMap = new LinkedHashMap<String, String>();
        Consumer<FieldAp> consumer = fieldAp -> lockMap.put(fieldAp.getKey(), fieldAp.getLock());
        BillLayoutReader.travelFieldApInfo(formmeta, consumer);
        return lockMap;
    }

    public static Map<String, String> getFieldName(EntityMetadata entityMeta) {
        LinkedHashMap<String, String> nameMap = new LinkedHashMap<String, String>();
        Consumer<Field<?>> consumer = field -> nameMap.put(field.getKey(), field.getName().getLocaleValue());
        BillLayoutReader.travelFieldEntityInfo(entityMeta, consumer);
        return nameMap;
    }

    public static void travelFieldEntityInfo(EntityMetadata entityMeta, Consumer<Field<?>> consumer) {
        LinkedHashSet<MainEntity> entityContainer = new LinkedHashSet<MainEntity>();
        entityContainer.add(entityMeta.getRootEntity());
        Predicate<EntityItem> predicate = item -> item instanceof EntryEntity;
        boolean isChanged = false;
        do {
            isChanged = false;
            LinkedHashSet<MainEntity> tmpContainer = new LinkedHashSet<MainEntity>();
            tmpContainer.addAll(entityContainer);
            int n = entityContainer.size();
            entityContainer.forEach(entity -> entity.getItems().stream().filter(predicate).forEach(item -> tmpContainer.add((MainEntity)((Object)((EntryEntity)item)))));
            if (n == tmpContainer.size()) continue;
            isChanged = true;
            entityContainer.addAll(tmpContainer);
        } while (isChanged);
        for (Entity entity2 : entityContainer) {
            for (EntityItem<?> item2 : entity2.getItems()) {
                if (!(item2 instanceof Field)) continue;
                Field field = (Field)item2;
                consumer.accept(field);
            }
        }
    }

    public static void travelFieldApInfo(FormMetadata formmeta, Consumer<FieldAp> consumer) {
        for (ControlAp<?> ctlAp : formmeta.getItems()) {
            if (!(ctlAp instanceof FieldAp) || ctlAp.isHidden() || StringUtils.isBlank((CharSequence)ctlAp.getVisible())) continue;
            consumer.accept((FieldAp)ctlAp);
        }
    }

    private static void toLayoutCtlInfo(Map<String, LayoutControlInfo> infos, FormMetadata formmeta) {
        Consumer<FieldAp> consumer = fieldAp -> {
            LayoutControlInfo ctlInfo = (LayoutControlInfo)infos.get(fieldAp.getKey());
            if (ctlInfo == null) {
                ctlInfo = new LayoutControlInfo();
                ctlInfo.setFieldKey(fieldAp.getKey());
                ctlInfo.setFieldId(fieldAp.getFieldId());
            }
            ctlInfo.setVisible(fieldAp.getVisibleValue());
            ctlInfo.setLockInStr(fieldAp.getLock());
            String fieldPrefix = "";
            ControlAp<?> pControl = formmeta.getItem(fieldAp.getParentId());
            if (pControl instanceof EntryAp) {
                fieldPrefix = pControl.getName().getLocaleValue() + ".";
            }
            String name = fieldPrefix + fieldAp.getName().getLocaleValue();
            ctlInfo.setFieldName(name);
            infos.put(fieldAp.getKey(), ctlInfo);
        };
        BillLayoutReader.travelFieldApInfo(formmeta, consumer);
    }

    private static void toLayoutCtlInfo(Map<String, LayoutControlInfo> infos, EntityMetadata entityMeta) {
        LinkedHashSet<MainEntity> entityContainer = new LinkedHashSet<MainEntity>();
        entityContainer.add(entityMeta.getRootEntity());
        Predicate<EntityItem> predicate = item -> item instanceof EntryEntity;
        boolean isChanged = false;
        HashMap<String, Field> mapAllField = new HashMap<String, Field>();
        do {
            isChanged = false;
            LinkedHashSet<MainEntity> tmpContainer = new LinkedHashSet<MainEntity>();
            tmpContainer.addAll(entityContainer);
            int n = entityContainer.size();
            entityContainer.forEach(entity -> entity.getItems().stream().filter(predicate).forEach(item -> tmpContainer.add((MainEntity)((Object)((EntryEntity)item)))));
            if (n == tmpContainer.size()) continue;
            isChanged = true;
            entityContainer.addAll(tmpContainer);
        } while (isChanged);
        for (Entity entity2 : entityContainer) {
            for (EntityItem<?> item2 : entity2.getItems()) {
                if (!(item2 instanceof Field)) continue;
                mapAllField.put(item2.getId(), (Field)item2);
            }
        }
        for (Map.Entry entry : infos.entrySet()) {
            String fieldId = ((LayoutControlInfo)entry.getValue()).getFieldId();
            Field field = (Field)mapAllField.get(fieldId);
            LayoutControlInfo ctlInfo = (LayoutControlInfo)entry.getValue();
            if (field == null) continue;
            ctlInfo.setEntityFieldKey(field.getKey());
            ctlInfo.setDefValueType(field.getDefValueType());
            ctlInfo.setMustInputType(field.getMustInputType());
            ctlInfo.setMustInput(field.isMustInput());
            ctlInfo.setFieldType(field.getClass().getSimpleName());
        }
    }

    static {
        VISIBLE2STATUS.put("vinit", "init");
        VISIBLE2STATUS.put("vnew", "new");
        VISIBLE2STATUS.put("vedit", "edit");
        VISIBLE2STATUS.put("vview", "view");
        VISIBLE2STATUS.put("vsubmit", "submit");
        VISIBLE2STATUS.put("vaudit", "audit");
        LOCK2STATUS.put("enabled", "new");
        LOCK2STATUS.put("editenabled", "edit");
        LOCK2STATUS.put("submitenabled", "submit");
        LOCK2STATUS.put("auditenabled", "audit");
        selectedFields.add("id");
        selectedFields.add(KEY_BILL_FORMID);
        selectedFields.add(KEY_LAYOUT);
        selectedFields.add(KEY_FIELDKEY);
        selectedFields.add(KEY_MUST_INPUT);
        selectedFields.add(KEY_DEFAULT_VALUE);
        selectedFields.add(KEY_MODIFYTIME);
        selectedFields.addAll(VISIBLE2STATUS.keySet());
        selectedFields.addAll(LOCK2STATUS.keySet());
        modifyTimeFields.add("id");
        modifyTimeFields.add(KEY_MODIFYTIME);
    }
}

