/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.billtype;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillTypeControlInfo;
import kd.bos.entity.DifferentialControlInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.metadata.FieldApInfoUtils;
import kd.bos.metadata.billtype.BillTypeControlCacheInfo;
import kd.bos.metadata.billtype.BillTypeFieldUtils;
import kd.bos.metadata.billtype.BillTypeLocalCache;
import kd.bos.metadata.billtype.BillTypeReader;
import kd.bos.metadata.billtype.BillTypeWriter;
import kd.bos.metadata.billtype.EntityControlCacheInfos;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;

public class BillTypeDao {
    public static Map<Object, DynamicObject> loadBillTypeObjects(String entityNumber) {
        return BillTypeReader.loadBillTypeObjects(entityNumber);
    }

    public static DynamicObjectCollection loadFieldEntryRows(String entityNumber, long billTypeId) {
        return BillTypeReader.loadFieldEntryRows(entityNumber, billTypeId);
    }

    public static List<DifferentialControlInfo> loadDifferentialControlInfos(String entityNumber, long billTypeId) {
        String layoutId;
        DynamicObject billTypeObj = BillTypeReader.loadBillTypeObject(entityNumber, billTypeId);
        DynamicObjectCollection storeInfos = billTypeObj == null ? null : billTypeObj.getDynamicObjectCollection("fieldcontrolentry");
        String layoutNumber = "";
        if (billTypeObj != null && StringUtils.isNotBlank((CharSequence)(layoutId = billTypeObj.getString("layoutsolution")))) {
            layoutNumber = BillTypeReader.loadLayoutNumber(entityNumber, layoutId);
        }
        Map<String, BillTypeControlInfo> fullInfo = BillTypeDao.getFullControlInfos(layoutNumber, entityNumber);
        return BillTypeDao.resolveDifferentialControlInfos(fullInfo, storeInfos);
    }

    public static List<DifferentialControlInfo> loadRuntimeDiffControlInfos(String entityNumber, long billTypeId) {
        return BillTypeDao.loadRuntimeDiffControlInfos(entityNumber, billTypeId, false);
    }

    public static List<DifferentialControlInfo> loadRuntimeDiffControlInfos(String entityNumber, long billTypeId, boolean isMob) {
        DynamicObjectCollection storeInfos;
        DynamicObject billTypeObj = BillTypeReader.loadBillTypeObject(entityNumber, billTypeId);
        String layoutNumber = "";
        boolean isMobLayout = false;
        if (billTypeObj != null) {
            String mobLayoutId;
            String layoutId = billTypeObj.getString("layoutsolution");
            if (isMob && StringUtils.isNotBlank((CharSequence)(mobLayoutId = billTypeObj.getString("mob_layoutsolution"))) && !"0".equals(mobLayoutId)) {
                layoutId = mobLayoutId;
                isMobLayout = true;
            }
            if (StringUtils.isNotBlank((CharSequence)layoutId)) {
                layoutNumber = BillTypeReader.loadLayoutNumber(entityNumber, layoutId);
            }
        }
        DynamicObjectCollection dynamicObjectCollection = storeInfos = billTypeObj == null ? null : billTypeObj.getDynamicObjectCollection("fieldcontrolentry");
        if (isMobLayout) {
            storeInfos = billTypeObj == null ? null : billTypeObj.getDynamicObjectCollection("mob_fieldcontrolentry");
        }
        Map<String, BillTypeControlInfo> fullInfo = BillTypeDao.getRuntimeFullControlInfos(layoutNumber, entityNumber, isMobLayout);
        return BillTypeDao.resolveDifferentialControlInfos(fullInfo, storeInfos);
    }

    public static List<DifferentialControlInfo> loadDifferentialControlInfosFromCache(String entityNumber, long billTypeId) {
        long modifyTime;
        EntityControlCacheInfos entityControlCacheInfos = BillTypeLocalCache.getEntityControlCacheInfos(entityNumber);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (entityControlCacheInfos != null && !StringUtils.equals((CharSequence)mainType.getVersion(), (CharSequence)entityControlCacheInfos.getEntityVersion())) {
            BillTypeLocalCache.removeEntityControlCacheInfos(entityNumber);
            entityControlCacheInfos = null;
        }
        BillTypeControlCacheInfo billTypeControlCacheInfo = null;
        DynamicObject modityTimeObj = BillTypeReader.loadModifyTimeFromCache(entityNumber, billTypeId);
        Date modifyTimeStamp = modityTimeObj.getDate("modifytime");
        long l = modifyTime = modifyTimeStamp == null ? 0L : modifyTimeStamp.getTime();
        if (entityControlCacheInfos != null && (billTypeControlCacheInfo = entityControlCacheInfos.getBillTypeCacheInfos().get(billTypeId)) != null) {
            boolean reloadModifyTime = false;
            if (billTypeControlCacheInfo.needCheckVersion()) {
                modifyTime = BillTypeReader.loadModifyTimeFormDB(entityNumber, billTypeId);
                reloadModifyTime = true;
            }
            if (billTypeControlCacheInfo.isTimeOut() || Long.compare(billTypeControlCacheInfo.getBillTypeModifyTime(), modifyTime) != 0) {
                billTypeControlCacheInfo = null;
            } else {
                if (reloadModifyTime) {
                    billTypeControlCacheInfo.resetLastCheckVersionTime();
                }
                return billTypeControlCacheInfo.getDeffControlInfos();
            }
        }
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        List<DifferentialControlInfo> differentialControlInfos = null;
        String billTypeCtlInfo = metadataService.loadEntityRuntimeMeta(entityNumber, (int)RuntimeMetaType.BilltypeCtlInfo.getValue(), String.valueOf(billTypeId));
        if (StringUtils.isNotBlank((CharSequence)billTypeCtlInfo)) {
            differentialControlInfos = SerializationUtils.fromJsonStringToList((String)billTypeCtlInfo, DifferentialControlInfo.class);
        } else {
            differentialControlInfos = BillTypeDao.loadDifferentialControlInfos(entityNumber, billTypeId);
            BillTypeDao.storeDifferentialControlInfos(entityNumber, billTypeId, differentialControlInfos);
        }
        if (entityControlCacheInfos == null) {
            entityControlCacheInfos = new EntityControlCacheInfos(entityNumber, mainType.getVersion());
        }
        billTypeControlCacheInfo = new BillTypeControlCacheInfo(billTypeId, modifyTime);
        billTypeControlCacheInfo.setDeffControlInfos(differentialControlInfos);
        entityControlCacheInfos.getBillTypeCacheInfos().put(billTypeId, billTypeControlCacheInfo);
        BillTypeLocalCache.putEntityControlCacheInfos(entityNumber, entityControlCacheInfos);
        return differentialControlInfos;
    }

    public static List<DifferentialControlInfo> loadRuntimeDiffControlInfosFromCache(String entityNumber, long billTypeId) {
        return BillTypeDao.loadRuntimeDiffControlInfosFromCache(entityNumber, billTypeId, false);
    }

    public static List<DifferentialControlInfo> loadRuntimeDiffControlInfosFromCache(String entityNumber, long billTypeId, boolean isMob) {
        long modifyTime;
        String entityNumberCacheKey = entityNumber;
        if (isMob) {
            entityNumberCacheKey = entityNumber + "_mob";
        }
        EntityControlCacheInfos entityControlCacheInfos = BillTypeLocalCache.getRuntimeEntityControlCache(entityNumberCacheKey);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (entityControlCacheInfos != null && !StringUtils.equals((CharSequence)mainType.getVersion(), (CharSequence)entityControlCacheInfos.getEntityVersion())) {
            BillTypeLocalCache.removeEntityControlCacheInfos(entityNumberCacheKey);
            entityControlCacheInfos = null;
        }
        BillTypeControlCacheInfo billTypeControlCacheInfo = null;
        DynamicObject modityTimeObj = BillTypeReader.loadModifyTimeFromCache(entityNumber, billTypeId);
        Date modifyTimeStamp = modityTimeObj.getDate("modifytime");
        long l = modifyTime = modifyTimeStamp == null ? 0L : modifyTimeStamp.getTime();
        if (entityControlCacheInfos != null && (billTypeControlCacheInfo = entityControlCacheInfos.getBillTypeCacheInfos().get(billTypeId)) != null) {
            boolean reloadModifyTime = false;
            if (billTypeControlCacheInfo.needCheckVersion()) {
                modifyTime = BillTypeReader.loadModifyTimeFormDB(entityNumber, billTypeId);
                reloadModifyTime = true;
            }
            if (billTypeControlCacheInfo.isTimeOut() || Long.compare(billTypeControlCacheInfo.getBillTypeModifyTime(), modifyTime) != 0) {
                billTypeControlCacheInfo = null;
            } else {
                if (reloadModifyTime) {
                    billTypeControlCacheInfo.resetLastCheckVersionTime();
                }
                return billTypeControlCacheInfo.getDeffControlInfos();
            }
        }
        List<DifferentialControlInfo> differentialControlInfos = BillTypeDao.loadRuntimeDiffControlInfos(entityNumber, billTypeId, isMob);
        if (entityControlCacheInfos == null) {
            entityControlCacheInfos = new EntityControlCacheInfos(entityNumberCacheKey, mainType.getVersion());
        }
        billTypeControlCacheInfo = new BillTypeControlCacheInfo(billTypeId, modifyTime);
        billTypeControlCacheInfo.setDeffControlInfos(differentialControlInfos);
        entityControlCacheInfos.getBillTypeCacheInfos().put(billTypeId, billTypeControlCacheInfo);
        BillTypeLocalCache.putRuntimeEntityControlCache(entityNumberCacheKey, entityControlCacheInfos);
        return differentialControlInfos;
    }

    public static Map<Object, List<BillTypeControlInfo>> loadFullControlInfos(String entityNumber) {
        HashMap<Object, List<BillTypeControlInfo>> result = new HashMap<Object, List<BillTypeControlInfo>>(16);
        Map<Object, DynamicObject> allStoreInfos = BillTypeReader.loadSubBillTypeObjectsFromCache(entityNumber);
        Map<String, Map<String, Object>> layouts = BillTypeReader.loadBillLayoutByFormId(entityNumber);
        for (Map.Entry<Object, DynamicObject> entry : allStoreInfos.entrySet()) {
            Map<String, BillTypeControlInfo> fullInfo = null;
            String layoutId = (String)entry.getValue().get("layoutsolution");
            fullInfo = StringUtils.isNotBlank((CharSequence)layoutId) && layouts.containsKey(layoutId) ? FieldApInfoUtils.getFullControlInfos((String)layouts.get(layoutId).get("number"), entityNumber) : FieldApInfoUtils.getFullControlInfos(entityNumber);
            DynamicObjectCollection storeInfos = entry.getValue().getDynamicObjectCollection("fieldcontrolentry");
            List<BillTypeControlInfo> controlInfos = BillTypeDao.mergeMustInputInfos(fullInfo, storeInfos);
            result.put(entry.getKey(), controlInfos);
        }
        return result;
    }

    public static Map<Object, List<DifferentialControlInfo>> loadAllDifferentialControlInfosFromCache(String entityNumber) {
        HashMap<Object, List<DifferentialControlInfo>> result = new HashMap<Object, List<DifferentialControlInfo>>();
        EntityControlCacheInfos entityControlCacheInfos = BillTypeLocalCache.getEntityControlCacheInfos(entityNumber);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (entityControlCacheInfos != null && !StringUtils.equals((CharSequence)mainType.getVersion(), (CharSequence)entityControlCacheInfos.getEntityVersion())) {
            BillTypeLocalCache.removeEntityControlCacheInfos(entityNumber);
            entityControlCacheInfos = null;
        }
        if (entityControlCacheInfos == null) {
            entityControlCacheInfos = new EntityControlCacheInfos(entityNumber, mainType.getVersion());
        }
        Map<Object, Long> billTypeModifyTimeObjs = BillTypeReader.loadModifytimesFormDB(entityNumber);
        ArrayList<Long> rebuildBillTypeIds = new ArrayList<Long>(billTypeModifyTimeObjs.size());
        for (Map.Entry<Object, Long> entry : billTypeModifyTimeObjs.entrySet()) {
            BillTypeControlCacheInfo billTypeControlCacheInfo = null;
            long billTypeId = (Long)entry.getKey();
            long modifyTime = entry.getValue();
            billTypeControlCacheInfo = entityControlCacheInfos.getBillTypeCacheInfos().get(billTypeId);
            if (billTypeControlCacheInfo == null) {
                rebuildBillTypeIds.add(billTypeId);
                continue;
            }
            if (billTypeControlCacheInfo.isTimeOut() || Long.compare(billTypeControlCacheInfo.getBillTypeModifyTime(), modifyTime) != 0) {
                rebuildBillTypeIds.add(billTypeId);
                continue;
            }
            result.put(billTypeId, billTypeControlCacheInfo.getDeffControlInfos());
        }
        if (!rebuildBillTypeIds.isEmpty()) {
            Map<Object, List<DifferentialControlInfo>> rebuildControlInfos = BillTypeDao.rebuildDifferentialControlInfos(entityNumber, rebuildBillTypeIds);
            result.putAll(rebuildControlInfos);
            for (Map.Entry<Object, List<DifferentialControlInfo>> entry : rebuildControlInfos.entrySet()) {
                Long billTypeId = (Long)entry.getKey();
                long modifyTime = billTypeModifyTimeObjs.getOrDefault(billTypeId, 0L);
                BillTypeControlCacheInfo billTypeControlCacheInfo = new BillTypeControlCacheInfo(billTypeId, modifyTime);
                billTypeControlCacheInfo.setDeffControlInfos(entry.getValue());
                entityControlCacheInfos.getBillTypeCacheInfos().put(billTypeId, billTypeControlCacheInfo);
            }
        }
        BillTypeLocalCache.putEntityControlCacheInfos(entityNumber, entityControlCacheInfos);
        return result;
    }

    public static Map<Object, List<DifferentialControlInfo>> loadRuntimeDiffControlInfosFromCache(String entityNumber) {
        return BillTypeDao.loadRuntimeDiffControlInfosFromCache(entityNumber, false);
    }

    public static Map<Object, List<DifferentialControlInfo>> loadRuntimeDiffControlInfosFromCache(String entityNumber, boolean isMob) {
        HashMap<Object, List<DifferentialControlInfo>> result = new HashMap<Object, List<DifferentialControlInfo>>();
        String entityNumberCacheKey = entityNumber;
        if (isMob) {
            entityNumberCacheKey = entityNumberCacheKey + "_mob";
        }
        EntityControlCacheInfos entityControlCacheInfos = BillTypeLocalCache.getRuntimeEntityControlCache(entityNumberCacheKey);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (entityControlCacheInfos != null && !StringUtils.equals((CharSequence)mainType.getVersion(), (CharSequence)entityControlCacheInfos.getEntityVersion())) {
            BillTypeLocalCache.removeEntityControlCacheInfos(entityNumberCacheKey);
            entityControlCacheInfos = null;
        }
        if (entityControlCacheInfos == null) {
            entityControlCacheInfos = new EntityControlCacheInfos(entityNumberCacheKey, mainType.getVersion());
        }
        Map<Object, Long> billTypeModifyTimes = BillTypeReader.loadModifytimesFormDB(entityNumber);
        ArrayList<Long> rebuildBillTypeIds = new ArrayList<Long>(billTypeModifyTimes.size());
        for (Map.Entry<Object, Long> entry : billTypeModifyTimes.entrySet()) {
            BillTypeControlCacheInfo billTypeControlCacheInfo = null;
            long billTypeId = (Long)entry.getKey();
            long modifyTime = entry.getValue();
            billTypeControlCacheInfo = entityControlCacheInfos.getBillTypeCacheInfos().get(billTypeId);
            if (billTypeControlCacheInfo == null) {
                rebuildBillTypeIds.add(billTypeId);
                continue;
            }
            if (billTypeControlCacheInfo.isTimeOut() || Long.compare(billTypeControlCacheInfo.getBillTypeModifyTime(), modifyTime) != 0) {
                rebuildBillTypeIds.add(billTypeId);
                continue;
            }
            result.put(billTypeId, billTypeControlCacheInfo.getDeffControlInfos());
        }
        if (!rebuildBillTypeIds.isEmpty()) {
            Map<Object, List<DifferentialControlInfo>> rebuildControlInfos = BillTypeDao.rebuildRuntimeDiffControlInfos(entityNumber, rebuildBillTypeIds, isMob);
            result.putAll(rebuildControlInfos);
            for (Map.Entry<Object, List<DifferentialControlInfo>> entry : rebuildControlInfos.entrySet()) {
                Long billTypeId = (Long)entry.getKey();
                long modifyTime = billTypeModifyTimes.getOrDefault(billTypeId, 0L);
                BillTypeControlCacheInfo billTypeControlCacheInfo = new BillTypeControlCacheInfo(billTypeId, modifyTime);
                billTypeControlCacheInfo.setDeffControlInfos(entry.getValue());
                entityControlCacheInfos.getBillTypeCacheInfos().put(billTypeId, billTypeControlCacheInfo);
            }
        }
        BillTypeLocalCache.putRuntimeEntityControlCache(entityNumberCacheKey, entityControlCacheInfos);
        return result;
    }

    public static void storeDifferentialControlInfos(String entityNumber, Long billtypeId, List<DifferentialControlInfo> difInfos) {
        BillTypeWriter.storeDifferentialControlInfos(entityNumber, billtypeId, difInfos);
    }

    public static void deleteBillTypeRuntime(String entityNumber, Long billtypeId) {
        BillTypeWriter.deleteBillTypeRuntime(entityNumber, billtypeId);
    }

    public static void deleteBillTypeRuntime(Long billtypeId) {
        BillTypeWriter.deleteBillTypeRuntime(billtypeId);
    }

    private static Map<Object, List<DifferentialControlInfo>> rebuildDifferentialControlInfos(String entityNumber, List<Long> rebuildBillTypeIds) {
        HashMap<Object, List<DifferentialControlInfo>> result = new HashMap<Object, List<DifferentialControlInfo>>(16);
        Map<Object, DynamicObject> billTypeObjs = BillTypeReader.loadSubBillTypeObjectsFromCache(rebuildBillTypeIds);
        Map<String, Map<String, Object>> layouts = BillTypeReader.loadBillLayoutByFormId(entityNumber);
        HashMap layoutControlInfos = new HashMap();
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        for (Map.Entry<Object, DynamicObject> entry : billTypeObjs.entrySet()) {
            Long billTypeId = (Long)entry.getKey();
            DynamicObject billTypeObj = entry.getValue();
            List<DifferentialControlInfo> differentialControlInfos = null;
            String billTypeCtlInfo = metadataService.loadEntityRuntimeMeta(entityNumber, (int)RuntimeMetaType.BilltypeCtlInfo.getValue(), String.valueOf(entry.getKey()));
            if (StringUtils.isNotBlank((CharSequence)billTypeCtlInfo)) {
                differentialControlInfos = SerializationUtils.fromJsonStringToList((String)billTypeCtlInfo, DifferentialControlInfo.class);
            } else {
                Map<String, BillTypeControlInfo> layoutControlInfo;
                String layoutNumber = entityNumber;
                String layoutId = (String)billTypeObj.get("layoutsolution");
                if (StringUtils.isNotBlank((CharSequence)layoutId) && layouts.containsKey(layoutId)) {
                    layoutNumber = (String)layouts.get(layoutId).get("number");
                }
                if ((layoutControlInfo = (Map<String, BillTypeControlInfo>)layoutControlInfos.get(layoutNumber)) == null) {
                    layoutControlInfo = BillTypeDao.getFullControlInfos(layoutNumber, entityNumber);
                }
                DynamicObjectCollection storeInfos = billTypeObj.getDynamicObjectCollection("fieldcontrolentry");
                differentialControlInfos = BillTypeDao.resolveDifferentialControlInfos(layoutControlInfo, storeInfos);
                BillTypeDao.storeDifferentialControlInfos(entityNumber, billTypeId, differentialControlInfos);
            }
            result.put(entry.getKey(), differentialControlInfos);
        }
        return result;
    }

    private static Map<Object, List<DifferentialControlInfo>> rebuildRuntimeDiffControlInfos(String entityNumber, List<Long> rebuildBillTypeIds, boolean isMob) {
        HashMap<Object, List<DifferentialControlInfo>> result = new HashMap<Object, List<DifferentialControlInfo>>(16);
        Map<Object, DynamicObject> billTypeObjs = BillTypeReader.loadSubBillTypeObjectsFromCache(rebuildBillTypeIds);
        Map<String, Map<String, Object>> layouts = BillTypeReader.loadBillLayoutByFormId(entityNumber);
        HashMap layoutControlInfos = new HashMap();
        for (Map.Entry<Object, DynamicObject> entry : billTypeObjs.entrySet()) {
            Map<String, BillTypeControlInfo> layoutControlInfo;
            String mobLayoutId;
            DynamicObject billTypeObj = entry.getValue();
            String layoutNumber = entityNumber;
            String layoutId = (String)billTypeObj.get("layoutsolution");
            boolean isMobLayout = false;
            if (isMob && StringUtils.isNotBlank((CharSequence)(mobLayoutId = billTypeObj.getString("mob_layoutsolution")))) {
                layoutId = mobLayoutId;
                isMobLayout = true;
            }
            if (StringUtils.isNotBlank((CharSequence)layoutId) && layouts.containsKey(layoutId)) {
                layoutNumber = (String)layouts.get(layoutId).get("number");
            }
            if ((layoutControlInfo = (Map<String, BillTypeControlInfo>)layoutControlInfos.get(layoutNumber)) == null) {
                layoutControlInfo = BillTypeDao.getRuntimeFullControlInfos(layoutNumber, entityNumber, isMobLayout);
            }
            DynamicObjectCollection storeInfos = billTypeObj.getDynamicObjectCollection("fieldcontrolentry");
            if (isMobLayout) {
                storeInfos = billTypeObj == null ? null : billTypeObj.getDynamicObjectCollection("mob_fieldcontrolentry");
            }
            List<DifferentialControlInfo> differentialControlInfos = BillTypeDao.resolveDifferentialControlInfos(layoutControlInfo, storeInfos);
            result.put(entry.getKey(), differentialControlInfos);
        }
        return result;
    }

    private static List<DifferentialControlInfo> resolveDifferentialControlInfos(Map<String, BillTypeControlInfo> fullInfo, DynamicObjectCollection storeInfos) {
        ArrayList<DifferentialControlInfo> difInfos = new ArrayList<DifferentialControlInfo>();
        HashMap<String, DifferentialControlInfo> finishedFields = new HashMap<String, DifferentialControlInfo>();
        if (storeInfos == null) {
            return difInfos;
        }
        String prefix = "";
        if ("mob_fieldcontrolentry".equals(storeInfos.getDynamicObjectType().getName())) {
            prefix = "mob_";
        }
        for (DynamicObject storeInfo : storeInfos) {
            String fieldKey = storeInfo.getString(prefix + "fieldkey");
            BillTypeControlInfo fieldInfo = fullInfo.get(fieldKey);
            if (fieldInfo == null) continue;
            DifferentialControlInfo differentialControlInfo = (DifferentialControlInfo)finishedFields.get(fieldKey);
            if (differentialControlInfo == null) {
                differentialControlInfo = new DifferentialControlInfo();
                difInfos.add(differentialControlInfo);
                finishedFields.put(fieldKey, differentialControlInfo);
            }
            differentialControlInfo.setFieldKey(fieldKey);
            differentialControlInfo.setFieldId(fieldInfo.getFieldId());
            differentialControlInfo.setEntityFieldKey(fieldInfo.getEntityFieldKey());
            if (!Objects.equals(storeInfo.getBoolean(prefix + "mustinput"), fieldInfo.isMustInput()) && !fieldInfo.isMustInput()) {
                differentialControlInfo.setMustInput(true);
            }
            for (Map.Entry<String, String> entry : BillTypeReader.VISIBLE2STATUS.entrySet()) {
                if (!Objects.equals(storeInfo.get(prefix + entry.getKey()), fieldInfo.isVisible(entry.getValue()))) {
                    differentialControlInfo.addVisible(entry.getValue(), false);
                    continue;
                }
                differentialControlInfo.addVisible(entry.getValue(), fieldInfo.isVisible(entry.getValue()));
            }
            for (Map.Entry<String, String> entry : BillTypeReader.LOCK2STATUS.entrySet()) {
                if (!Objects.equals(storeInfo.get(prefix + entry.getKey()), fieldInfo.isLock(entry.getValue()))) {
                    differentialControlInfo.addLock(entry.getValue(), true);
                    continue;
                }
                differentialControlInfo.addLock(entry.getValue(), fieldInfo.isLock(entry.getValue()));
            }
            if (!StringUtils.isNotBlank((CharSequence)storeInfo.getString(prefix + "defaultvalue"))) continue;
            differentialControlInfo.setDefaultValue(storeInfo.getString(prefix + "defaultvalue"));
        }
        return difInfos;
    }

    private static List<BillTypeControlInfo> mergeMustInputInfos(Map<String, BillTypeControlInfo> fullInfo, DynamicObjectCollection storeInfos) {
        ArrayList<BillTypeControlInfo> allInfos = new ArrayList<BillTypeControlInfo>(10);
        HashSet<String> deffControlKeys = new HashSet<String>();
        for (DynamicObject storeInfo : storeInfos) {
            String fieldKey = storeInfo.getString("fieldkey");
            BillTypeControlInfo fieldInfo = fullInfo.get(fieldKey);
            BillTypeControlInfo controlInfo = new BillTypeControlInfo();
            if (fieldInfo != null) {
                if (!Objects.equals(storeInfo.getBoolean("mustinput"), fieldInfo.isMustInput()) && !fieldInfo.isMustInput()) {
                    controlInfo.setMustInput(true);
                }
                controlInfo.setFieldKey(fieldKey);
                allInfos.add(controlInfo);
            }
            deffControlKeys.add(fieldKey);
        }
        for (Map.Entry<String, BillTypeControlInfo> entry : fullInfo.entrySet()) {
            if (deffControlKeys.contains(entry.getKey())) continue;
            allInfos.add(entry.getValue());
        }
        return allInfos;
    }

    private static Map<String, BillTypeControlInfo> getFullControlInfos(String layoutNumber, String entityNumber) {
        return StringUtils.isBlank((CharSequence)layoutNumber) ? FieldApInfoUtils.getFullControlInfos(entityNumber) : FieldApInfoUtils.getFullControlInfos(layoutNumber, entityNumber);
    }

    private static Map<String, BillTypeControlInfo> getRuntimeFullControlInfos(String layoutNumber, String entityNumber) {
        return BillTypeDao.getRuntimeFullControlInfos(layoutNumber, entityNumber, false);
    }

    private static Map<String, BillTypeControlInfo> getRuntimeFullControlInfos(String layoutNumber, String entityNumber, boolean isMobLayout) {
        return StringUtils.isBlank((CharSequence)layoutNumber) ? BillTypeFieldUtils.getRuntimeFullControlInfos(entityNumber, isMobLayout) : BillTypeFieldUtils.getRuntimeFullControlInfos(layoutNumber, entityNumber, isMobLayout);
    }
}

