/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.kflow.api.IFlowDesignService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.dao.AbstractMetadataSerializer;
import kd.bos.metadata.dao.IMetadataDaoPlugIn;
import kd.bos.metadata.dao.MetadataServicePlugInProxy;
import kd.bos.metadata.dao.ShardingUtil;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.rule.FormRule;
import kd.bos.metadata.kflow.enums.RuleType;
import kd.bos.metadata.kflow.rule.KFlowRule;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class AbstractMetadataWriter {
    private static Log log = LogFactory.getLog(AbstractMetadataWriter.class);
    protected IMetadataDaoPlugIn plugIn;
    protected AbstractMetadataSerializer serializer;
    private String appGroup = "defaultGroup";
    private static final String KFLOW_SAVE_REFERENCE = "kflow_save_reference";

    public String getAppGroup() {
        return this.appGroup;
    }

    public void setAppGroup(String appGroup) {
        this.appGroup = appGroup;
        if (this.plugIn != null && StringUtils.isNotBlank((CharSequence)appGroup)) {
            this.plugIn.setAppGroup(appGroup);
        }
    }

    public AbstractMetadataWriter() {
    }

    public AbstractMetadataWriter(String modelTypeId) {
        this.plugIn = MetadataServicePlugInProxy.create(modelTypeId);
        this.serializer = this.initMetadataSerializer(modelTypeId);
    }

    protected abstract AbstractMetadataSerializer initMetadataSerializer(String var1);

    public void rebuildRuntimeMeta(AbstractMetadata ... metadatas) {
        try (DtsExcludeSyncContext context = DtsExcludeSyncContext.create();){
            this.plugIn.saveRuntimeMeta(metadatas);
            List<ErrorInfo> buildErrors = this.plugIn.getBuildErrors(metadatas);
            for (ErrorInfo errorInfo : buildErrors) {
                if (errorInfo.getLevel() != 2) continue;
                log.info(errorInfo.getError());
                throw new KDBizException(errorInfo.getError());
            }
        }
    }

    protected List<AbstractDesignMeta> saveMeta(AbstractMetadata ... metadatas) {
        return this.saveMeta(false, metadatas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<AbstractDesignMeta> saveMeta(boolean isDraft, AbstractMetadata ... metadatas) {
        List<AbstractDesignMeta> designDatas;
        block17: {
            boolean useSharding = ShardingUtil.isUseShardingAndCheckReady(metadatas);
            String id = metadatas[0].getId();
            designDatas = this.convertToDesignMeta(metadatas);
            String lockKey = "__saveMeta__" + RequestContext.get().getAccountId() + "__" + id;
            try (DLock dlock = DLock.create((String)lockKey).fastMode();){
                if (dlock.tryLock()) {
                    try {
                        this.doSaveMeta(isDraft, designDatas, metadatas);
                        if (useSharding) {
                            ShardingUtil.fireReloadShardingConfig(metadatas);
                        }
                        break block17;
                    }
                    finally {
                        dlock.unlock();
                    }
                }
                dlock.lock();
                dlock.unlock();
            }
        }
        return designDatas;
    }

    protected void doSaveMeta(boolean isDraft, List<AbstractDesignMeta> designDatas, AbstractMetadata ... metadatas) {
        Object errSql = null;
        try (DtsExcludeSyncContext context = DtsExcludeSyncContext.create();){
            try (TXHandle h = TX.required();){
                try {
                    if (designDatas.size() > 2 && this.isBatchSaveDesignMetas()) {
                        IDataEntityType dt;
                        Iterator<AbstractDesignMeta> designMetaLMap = new HashMap(3);
                        HashMap designMetaMap = new HashMap(3);
                        for (AbstractDesignMeta abstractDesignMeta : designDatas) {
                            Class<?> className = abstractDesignMeta.getClass();
                            if (abstractDesignMeta instanceof DesignMetaL) {
                                designMetaLMap.putIfAbsent(className, new ArrayList(3));
                                ((List)designMetaLMap.get(className)).add((DesignMetaL)abstractDesignMeta);
                                continue;
                            }
                            designMetaMap.putIfAbsent(className, new ArrayList(3));
                            ((List)designMetaMap.get(className)).add(abstractDesignMeta);
                        }
                        for (Map.Entry entry : designMetaLMap.entrySet()) {
                            dt = OrmUtils.getDataEntityType((Class)((Class)entry.getKey()));
                            AbstractMetadataWriter.batchDelFormLang(dt, (List)entry.getValue());
                            ArrayList<AbstractDesignMeta> data = new ArrayList<AbstractDesignMeta>(((List)entry.getValue()).size());
                            data.addAll((Collection)entry.getValue());
                            this.batchSaveDesignMeta(dt, data);
                        }
                        for (Map.Entry entry : designMetaMap.entrySet()) {
                            dt = OrmUtils.getDataEntityType((Class)((Class)entry.getKey()));
                            this.batchDeleteDesignMeta(dt, (List)entry.getValue());
                            this.batchSaveDesignMeta(dt, (List)entry.getValue());
                        }
                    } else {
                        for (AbstractDesignMeta dmeta : designDatas) {
                            this.deleteDesignMeta(dmeta);
                        }
                        for (AbstractDesignMeta dmeta : designDatas) {
                            this.saveDesignMeta(dmeta);
                        }
                    }
                    this.plugIn.save(metadatas);
                }
                catch (Throwable e) {
                    h.markRollback();
                    if (e instanceof KDException) {
                        throw (KDException)e;
                    }
                    if (e instanceof OrmException) {
                        throw (OrmException)e;
                    }
                    throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format("Error:%s. sql:%s", e.getMessage(), errSql)});
                }
            }
            this.plugIn.saveRuntimeMeta(isDraft, metadatas);
        }
        try {
            this.saveFlowReference(metadatas);
        }
        catch (KDException e) {
            e.printStackTrace();
        }
        this.plugIn.builderSchemaAfterSave();
    }

    protected boolean isBatchSaveDesignMetas() {
        return false;
    }

    protected void saveFlowReference(AbstractMetadata[] metadatas) {
        FormMetadata formMeta = null;
        for (AbstractMetadata metadata : metadatas) {
            if (!(metadata instanceof FormMetadata)) continue;
            formMeta = (FormMetadata)metadata;
            break;
        }
        if (formMeta == null) {
            return;
        }
        FormAp formAp = formMeta.getRootAp();
        String bizappId = formMeta.getBizappId();
        String formId = formMeta.getId();
        Set<Long> ids = this.queryReference(bizappId, formId);
        IFlowDesignService flowService = (IFlowDesignService)ServiceFactory.getService(IFlowDesignService.class);
        try (TXHandle h = TX.requiresNew((String)KFLOW_SAVE_REFERENCE);){
            try {
                EntityMetadata entityMetadata;
                ArrayList refList = new ArrayList(10);
                flowService.deleteReference(ids.toArray(new Object[]{ids.size()}));
                ArrayList<KFlowRule> kFlowRules = new ArrayList<KFlowRule>(10);
                List<FormRule> formRules = formAp.getRules();
                for (FormRule rule : formRules) {
                    if (!RuleType.KFlowRule.name().equals(rule.getRuleType())) continue;
                    kFlowRules.add(rule.convertToKFlowRule());
                }
                if (!CollectionUtils.isEmpty(kFlowRules)) {
                    for (KFlowRule flow : kFlowRules) {
                        HashMap<String, KFlowRule> refMap = new HashMap<String, KFlowRule>(1);
                        flow.setScene("rule");
                        refMap.put("flowRule", flow);
                        refList.add(refMap);
                    }
                }
                if (formAp instanceof BillFormAp && ((BillFormAp)formAp).getMobMeta() != null && ((BillFormAp)formAp).getMobMeta().getRootAp() != null) {
                    ArrayList<KFlowRule> mobileKFlowRules = new ArrayList<KFlowRule>(10);
                    List<FormRule> mobileFormRules = ((BillFormAp)formAp).getMobMeta().getRootAp().getRules();
                    for (FormRule mFormRule : mobileFormRules) {
                        if (!RuleType.KFlowRule.name().equals(mFormRule.getRuleType())) continue;
                        mobileKFlowRules.add(mFormRule.convertToKFlowRule());
                    }
                    if (!CollectionUtils.isEmpty(mobileKFlowRules)) {
                        for (KFlowRule flow : mobileKFlowRules) {
                            HashMap<String, KFlowRule> refMap = new HashMap<String, KFlowRule>(1);
                            flow.setScene("rule");
                            refMap.put("flowRule", flow);
                            refList.add(refMap);
                        }
                    }
                }
                if ((entityMetadata = formMeta.getEntityMetadata()) != null && entityMetadata.getRootEntity() != null && !CollectionUtils.isEmpty(entityMetadata.getRootEntity().getOperations())) {
                    List<Operation> ops = entityMetadata.getRootEntity().getOperations();
                    for (Operation op : ops) {
                        Map<String, Object> opParam;
                        if (!"kflow".equalsIgnoreCase(op.getOperationType()) || !((opParam = op.getParameter().createEntityOperateParameter(entityMetadata)).get("flowId") instanceof String) || !(opParam.get("refId") instanceof String)) continue;
                        String flowId = (String)opParam.get("flowId");
                        String refId = (String)opParam.get("refId");
                        KFlowRule flowRule = new KFlowRule();
                        flowRule.setKFId(flowId);
                        flowRule.setRefId(refId);
                        flowRule.setBizAppId(bizappId);
                        flowRule.setObjectId(formId);
                        flowRule.setScene("operate");
                        flowRule.setTriggerTime(0);
                        HashMap<String, KFlowRule> refMap = new HashMap<String, KFlowRule>(1);
                        refMap.put("flowRule", flowRule);
                        refList.add(refMap);
                    }
                }
                flowService.batchCreateReference(refList);
            }
            catch (Throwable e) {
                h.markRollback();
                if (e instanceof KDException) {
                    throw (KDException)e;
                }
                if (e instanceof OrmException) {
                    throw (OrmException)e;
                }
                throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
        }
    }

    private Set<Long> queryReference(String bizappId, String formId) {
        HashSet<Long> ids = new HashSet<Long>(10);
        QFilter q1 = new QFilter("appid", "=", (Object)bizappId);
        QFilter q2 = new QFilter("resourceid", "=", (Object)formId);
        ORM orm = ORM.create();
        DynamicObjectCollection cols = orm.query("kf_reference", "id", new QFilter[]{q1, q2});
        for (int i = 0; i < cols.size(); ++i) {
            DynamicObject obj = (DynamicObject)cols.get(i);
            ids.add(obj.getLong("id"));
        }
        return ids;
    }

    public List<AbstractDesignMeta> convertToDesignMeta(AbstractMetadata ... metadatas) {
        ArrayList<AbstractDesignMeta> dms = new ArrayList<AbstractDesignMeta>(10);
        for (AbstractMetadata metadata : metadatas) {
            AbstractMetadata baseMetadata = null;
            if (StringUtils.isNotBlank((CharSequence)metadata.getParentId())) {
                baseMetadata = this.readBaseMetadata(metadata);
                if ("2".equals(metadata.getDevType()) && metadata instanceof EntityMetadata) {
                    String dbRoute = ((EntityMetadata)baseMetadata).getDBRouteKey();
                    ((EntityMetadata)metadata).getRootEntity().setdbRoute(dbRoute);
                }
            }
            this.plugIn.clearRootChildenParentId(metadata);
            if (baseMetadata != null) {
                this.plugIn.clearRootChildenParentId(baseMetadata);
            }
            this.serializer.getBinder().setLCId("zh_CN");
            String formXml = this.serializer.buildDiffXml(metadata, baseMetadata, false);
            DesignMeta designMeta = metadata.convertToDesignMeta(formXml);
            dms.add(designMeta);
            this.plugIn.setDesignMeta(metadata, designMeta);
            AbstractMetadata formLangBase = (AbstractMetadata)this.serializer.deserializeFromXml(formXml, baseMetadata);
            this.plugIn.clearRootChildenParentId(formLangBase);
            IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
            List languages = inteService.getEnabledLang();
            List<String> supportLanguages = new ArrayList<String>();
            if (null != languages && !languages.isEmpty()) {
                for (EnabledLang lang : languages) {
                    if (!StringUtils.isNotBlank((CharSequence)lang.getNumber())) continue;
                    supportLanguages.add(lang.getNumber());
                }
            }
            if (null == supportLanguages || supportLanguages.isEmpty()) {
                supportLanguages = Arrays.asList("zh_CN", "zh_TW", "en_US");
            }
            for (String language : supportLanguages) {
                this.serializer.getBinder().setLCId(language);
                String formLangXml = this.serializer.buildDiffXml(metadata, formLangBase, true);
                dms.add(metadata.convertToDesignMetaL(language, formLangXml));
            }
        }
        return dms;
    }

    protected IDataEntityType getDataEntityType(AbstractDesignMeta dmeta) {
        return OrmUtils.getDataEntityType(dmeta.getClass());
    }

    protected abstract AbstractMetadata readBaseMetadata(AbstractMetadata var1);

    /*
     * Exception decompiling
     */
    public Map<String, Object> delete(String id, IDataEntityType designMetaType, IDataEntityType designMetaType_Lang) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void saveDesignMeta(AbstractDesignMeta dmeta) {
        IDataEntityType metadataType = this.getDataEntityType(dmeta);
        BusinessDataWriter.save((IDataEntityType)metadataType, (Object[])new Object[]{dmeta});
    }

    protected void batchSaveDesignMeta(IDataEntityType metadataType, List<AbstractDesignMeta> metas) {
        BusinessDataWriter.save((IDataEntityType)metadataType, (Object[])metas.toArray(new Object[metas.size()]));
    }

    public void deleteDesignMeta(AbstractDesignMeta dmeta) {
        if (dmeta instanceof DesignMetaL) {
            this.delFormLang((DesignMetaL)dmeta);
        } else {
            IDataEntityType metadataType = this.getDataEntityType(dmeta);
            this.batchDeleteDesignMeta(metadataType, Collections.singletonList(dmeta));
        }
    }

    protected void batchDeleteDesignMeta(IDataEntityType metadataType, List<AbstractDesignMeta> metas) {
        if (metas == null || metas.isEmpty()) {
            return;
        }
        List ids = metas.stream().filter(t -> !(t instanceof DesignMetaL)).map(AbstractDesignMeta::getId).collect(Collectors.toList());
        if (ids.size() != metas.size()) {
            throw new RuntimeException("invalid param,found DesignMetaL in metas");
        }
        BusinessDataWriter.delete((IDataEntityType)metadataType, (Object[])ids.toArray(), (boolean)false);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(metadataType);
        cacheManager.removeByDt();
    }

    private void delFormLang(DesignMetaL metaL) {
        IDataEntityType metadataType = this.getDataEntityType(metaL);
        AbstractMetadataWriter.batchDelFormLang(metadataType, Collections.singletonList(metaL));
    }

    @Deprecated
    public static void delFormMetadataLang(DesignMetaL metaL) {
        IDataEntityType metadataType = OrmUtils.getDataEntityType(metaL.getClass());
        AbstractMetadataWriter.batchDelFormLang(metadataType, Collections.singletonList(metaL));
    }

    public boolean isIgnoreTrimText() {
        return this.serializer != null ? this.serializer.isIgnoreTrimText() : false;
    }

    public void setIgnoreTrimText(boolean ignoreTrimText) {
        if (this.serializer != null) {
            this.serializer.setIgnoreTrimText(ignoreTrimText);
        }
    }

    private static void batchDelFormLang(IDataEntityType metadataType, List<DesignMetaL> metaLList) {
        String delSql = String.format("delete from %s where fid = ? and FLOCALEID=? ", metadataType.getAlias());
        ArrayList<SqlParameter[]> paramList = new ArrayList<SqlParameter[]>(metaLList.size());
        for (DesignMetaL metaL : metaLList) {
            SqlParameter[] params = new SqlParameter[]{metadataType.getPrimaryKey() != null && metadataType.getPrimaryKey().getDbType() == -5 ? new SqlParameter(":FID", -5, (Object)Long.valueOf(metaL.getId())) : new SqlParameter(":FID", 12, (Object)metaL.getId()), new SqlParameter(":FLOCALEID", 12, (Object)metaL.getLocaleId())};
            paramList.add(params);
        }
        DB.executeBatch((DBRoute)AbstractMetadataWriter.getDbRoute(metadataType), (String)delSql, paramList);
    }

    protected String readModelType(String formId, IDataEntityType type) {
        String sql = String.format("select FModelType from %s where FID = ? ", type.getAlias());
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)formId)};
        String modelType = (String)DB.query((DBRoute)AbstractMetadataWriter.getDbRoute(type), (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                String sRet = null;
                try {
                    if (rs.next()) {
                        sRet = rs.getString("FModelType");
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return sRet;
            }
        });
        if (StringUtils.isBlank((CharSequence)modelType)) {
            modelType = "";
        }
        return modelType;
    }

    protected boolean isPrintTemplate(String id, IDataEntityType type) {
        String sql = String.format("select t.FID from %s t where fid = ? and t.FMODELTYPE = ? ", type.getAlias());
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FENTITYID", 12, (Object)id), new SqlParameter(":FMODELTYPE", 12, (Object)"PrintModel")};
        boolean flag = !this.isNullRow(sql, params);
        return flag;
    }

    protected boolean isInheritPathForm(String id, IDataEntityType type) {
        String sql = String.format("select FINHERITPATH from %s where FINHERITPATH like ?", type.getAlias());
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FINHERITPATH", 12, (Object)("%" + id + "%"))};
        return !this.isNullRow(sql, params);
    }

    protected boolean isNullRow(String sql, SqlParameter[] params) {
        Boolean isNull = (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                Boolean sRet = true;
                try {
                    if (rs.next()) {
                        sRet = false;
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return sRet;
            }
        });
        return isNull;
    }

    private static DBRoute getDbRoute(IDataEntityType metaType) {
        String dbRouteKey = metaType.getDBRouteKey();
        return StringUtils.isBlank((CharSequence)dbRouteKey) ? DBRoute.meta : DBRoute.of((String)dbRouteKey);
    }
}

