/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataColumnCollection;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlObject;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.AlterTableUtilDB;
import kd.bos.metadata.dao.IAlterTableUtil;
import kd.bos.metadata.dao.IAlterTableUtilDB;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.ShardingUtil;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.ITreeEntryEntity;
import kd.bos.metadata.entity.LinkEntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.metadata.entity.SplitTable;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.TreeEntryEntity;
import kd.bos.metadata.entity.TreeSubEntryEntity;
import kd.bos.metadata.entity.businessfield.IBasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IDBField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.mservice.svc.attach.IAttachmentField;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.threads.ThreadPools;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;

public class AlterTableUtil
implements IAlterTableUtil {
    private static Log log = LogFactory.getLog(AlterTableUtil.class);
    private static final String SQL = "ALTER TABLE %s ADD %s %s DEFAULT(0) NOT NULL;";
    private static final String ALTER_TABLE_ADD_TWOS = "ALTER TABLE %s ADD %s ";
    private static final String INT_DEFAULT_NOT_NULL = "%s INT DEFAULT(-1) NOT NULL";
    private static final String ALTER_ADD_SQL = "ALTER TABLE %s ADD %s;";
    private static final String ALTER_ADD_NCLOB_SQL = "ALTER TABLE %s ADD %s NCLOB NULL;";
    private static final String CREATE_SQL = "CREATE TABLE %s (";
    private static final String NOT_NULL = " NOT NULL,";
    private static final String NCLOB_NULL = "%s NCLOB NULL,";
    private static final String CONSTRAINT = "CONSTRAINT ";
    private static final String PRIMARY_KEY = " PRIMARY KEY(%s));";
    private static final String FCLEAR_TEXT = "FClearText";
    private static final String FSIGN_TEXT = "FSignText";
    private static final String FUSER_ID = "FuserId";
    private static final String NOT_NULL_END = " NOT NULL;";
    private static final String NOTNULL = " NOT NULL";
    private static final String DEFAULT_NVARCHAR = " DEFAULT(' ');";
    private static final String DEFAULT_BIGINT = " DEFAULT(0);";
    private static final String FPK_ID = "FPKID";
    private static final String FLOCALE_ID = "FLocaleID";
    private static final String BIG_INT = "%s BIGINT";
    private static final String NVARCHAR_DEFAULT_SQL = "%s NVARCHAR(50) DEFAULT(' ') NOT NULL";
    private static ConcurrentHashMap<String, Object> lockMap = new ConcurrentHashMap();
    private IAlterTableUtilDB dbImpl = new AlterTableUtilDB();
    private static IAlterTableUtil impl = null;

    private IAlterTableUtil getImpl() {
        if (impl == null) {
            try {
                impl = SystemPropertyUtils.getBooleanExt((String)RequestContext.get().getTenantId(), (String)"bos.dm.altertable.enable").booleanValue() ? (IAlterTableUtil)Class.forName("kd.bos.datamodel.metadata.dao.DMAlterTableUtilImpl").newInstance() : this;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return impl;
    }

    protected boolean createExtTable(EntityMetadata entityMetadata, Entity<?, ?> entity, boolean useSharding, String trackParentTableName) {
        return this.createTable(entityMetadata, entity, useSharding, trackParentTableName, true);
    }

    protected boolean createTable(EntityMetadata entityMetadata, Entity<?, ?> entity, boolean useSharding) {
        return this.createTable(entityMetadata, entity, useSharding, null, false);
    }

    protected boolean createTable(EntityMetadata entityMetadata, Entity<?, ?> entity, boolean useSharding, String trackParentTableName) {
        return this.createTable(entityMetadata, entity, useSharding, trackParentTableName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTable(EntityMetadata entityMetadata, Entity<?, ?> entity, boolean useSharding, String trackParentTableName, boolean extSchema) {
        boolean result = false;
        try (TXHandle h = TX.notSupported();){
            List<SplitTable> splitTables = entity.getSplitTables();
            if (StringUtils.isBlank((CharSequence)entity.getTableName()) || StringUtils.equalsIgnoreCase((CharSequence)"t_isv_xxx", (CharSequence)entity.getTableName().trim())) {
                boolean bl = false;
                return bl;
            }
            ArrayList<String> suffixList = new ArrayList<String>();
            if (splitTables != null) {
                String suffix = null;
                for (SplitTable s : splitTables) {
                    suffix = s.getSuffix();
                    if (suffix == null || !StringUtils.isNotEmpty((CharSequence)suffix)) continue;
                    suffixList.add(suffix);
                }
                String queryFields = "fid";
                String hintFkField = "fid";
                final AtomicBoolean isSingleField = new AtomicBoolean(true);
                Entity parentEntity = this.findParentEntity(entityMetadata, entity);
                if (TreeSubEntryEntity.class.isAssignableFrom(entity.getClass())) {
                    hintFkField = parentEntity != null ? ((EntryEntity)parentEntity).getEntryPkFieldName() : "fentryid";
                    queryFields = hintFkField + ',' + ((TreeSubEntryEntity)entity).getEntryPkFieldName();
                    isSingleField.set(false);
                } else if (TreeEntryEntity.class.isAssignableFrom(entity.getClass())) {
                    hintFkField = parentEntity != null ? ((BillEntity)parentEntity).getPkFieldName() : "fid";
                    queryFields = hintFkField + ',' + ((TreeEntryEntity)entity).getEntryPkFieldName();
                    isSingleField.set(false);
                } else if (SubEntryEntity.class.isAssignableFrom(entity.getClass())) {
                    hintFkField = parentEntity != null ? ((EntryEntity)parentEntity).getEntryPkFieldName() : "fentryid";
                    queryFields = hintFkField + ',' + ((SubEntryEntity)entity).getEntryPkFieldName();
                    isSingleField.set(false);
                } else if (entity.getClass().isAssignableFrom(EntryEntity.class)) {
                    hintFkField = parentEntity != null ? ((BillEntity)parentEntity).getPkFieldName() : "fid";
                    queryFields = hintFkField + ',' + ((EntryEntity)entity).getEntryPkFieldName();
                    isSingleField.set(false);
                } else if (BillEntity.class.isAssignableFrom(entity.getClass())) {
                    hintFkField = queryFields = ((BillEntity)entity).getPkFieldName();
                }
                ArrayList<SqlObject> sqlList = new ArrayList<SqlObject>();
                ArrayList<String> fieldsCommentSql = new ArrayList<String>(10);
                ArrayList<String> tableNameSuffix = new ArrayList<String>();
                tableNameSuffix.add("");
                tableNameSuffix.addAll(suffixList);
                DbMetadataTable entityMainTableSchema = null;
                String dbRoueKey = entityMetadata.getDBRouteKey();
                ArrayList<SqlObject> splitTableSqlList = new ArrayList<SqlObject>();
                String tableName = entity.getTableName();
                Object lo = new Object();
                Object lockObj = lockMap.putIfAbsent(tableName, lo);
                if (lockObj == null) {
                    lockObj = lo;
                }
                Object object = lockObj;
                synchronized (object) {
                    ArrayList inRange;
                    String sql;
                    List<Object[]> dataSet;
                    for (int i = 0; i < tableNameSuffix.size(); ++i) {
                        String t_suffix = (String)tableNameSuffix.get(i);
                        String newTableName = tableName;
                        if (StringUtils.isNotBlank((CharSequence)t_suffix)) {
                            newTableName = String.format("%s_%s", tableName, t_suffix);
                        }
                        DbMetadataTable tableSchema = this.dbImpl.getTableSchema(dbRoueKey, newTableName, false);
                        if (StringUtils.isBlank((CharSequence)t_suffix)) {
                            entityMainTableSchema = tableSchema;
                        }
                        if (tableSchema == null) {
                            this.getImpl().genCreateTableSql(entityMetadata, entity, newTableName, sqlList, useSharding, trackParentTableName);
                            if (i <= 0) continue;
                            StringBuilder insertSql = new StringBuilder();
                            if (isSingleField.get()) {
                                insertSql.append("insert into ").append(newTableName).append("(").append(queryFields).append(") values(?)");
                            } else {
                                insertSql.append("insert into ").append(newTableName).append("(").append(queryFields).append(") values(?,?)");
                            }
                            splitTableSqlList.add(new SqlObject(insertSql.toString(), null));
                            continue;
                        }
                        this.getImpl().genAlterTableSql(entityMetadata, entity, tableSchema, newTableName, sqlList, useSharding, extSchema, fieldsCommentSql);
                    }
                    if (sqlList != null && sqlList.size() > 0) {
                        for (SqlObject list : sqlList) {
                            DBRoute dbRoute = new DBRoute(dbRoueKey);
                            this.dbImpl.execute(dbRoute, list.getSql(), list.getParams());
                        }
                        result = true;
                    }
                    if (SystemPropertyUtils.getBooleanExt((String)RequestContext.get().getTenantId(), (String)"add.fieldcomment").booleanValue() && !fieldsCommentSql.isEmpty()) {
                        ThreadPools.executeOnce((String)"Metadata-FieldsCommentSql", () -> {
                            for (String fieldComment : fieldsCommentSql) {
                                DBRoute dbRoute = new DBRoute(dbRoueKey);
                                this.dbImpl.execute(dbRoute, fieldComment, new kd.bos.dataentity.SqlParameter[0]);
                            }
                        });
                    }
                    if (!splitTableSqlList.isEmpty() && !(dataSet = this.dbImpl.query(new DBRoute(dbRoueKey), sql = "select " + queryFields + " from " + entity.getTableName(), new ResultSetHandler<List<Object[]>>(inRange = new ArrayList()){
                        final /* synthetic */ List val$inRange;
                        {
                            this.val$inRange = list;
                        }

                        public List<Object[]> handle(ResultSet rs) throws Exception {
                            ArrayList<Object[]> list = new ArrayList<Object[]>();
                            while (rs.next()) {
                                if (isSingleField.get()) {
                                    list.add(new Object[]{rs.getObject(1)});
                                } else {
                                    list.add(new Object[]{rs.getObject(1), rs.getObject(2)});
                                }
                                this.val$inRange.add(rs.getObject(1));
                            }
                            return list;
                        }
                    })).isEmpty()) {
                        for (SqlObject sqlObject : splitTableSqlList) {
                            if (useSharding) {
                                String parentTableName = parentEntity == null ? entity.getTableName() : parentEntity.getTableName();
                                ShardingHintContext shc = ShardingHintContext.createAndSet((String)parentTableName, (HintCondition[])new HintCondition[]{new HintCondition(hintFkField, FilterType.in_range, inRange)});
                                Throwable throwable = null;
                                try {
                                    this.dbImpl.executeBatch(new DBRoute(dbRoueKey), sqlObject.getSql(), dataSet);
                                    continue;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (shc == null) continue;
                                    if (throwable != null) {
                                        try {
                                            shc.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    shc.close();
                                    continue;
                                }
                            }
                            this.dbImpl.executeBatch(new DBRoute(dbRoueKey), sqlObject.getSql(), dataSet);
                        }
                    }
                    lockMap.remove(tableName);
                }
            }
            boolean bl = result;
            return bl;
        }
    }

    private boolean hasExtField(List<Field> entityFieldList) {
        for (Field fld : entityFieldList) {
            if (!fld.isExt()) continue;
            return true;
        }
        return false;
    }

    private List<Field> getAllFields(List<EntityItem<?>> items) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (EntityItem<?> item : items) {
            if (item instanceof Entity) {
                fields.addAll(this.getAllFields(((Entity)item).getItems()));
                continue;
            }
            fields.add((Field)item);
        }
        return fields;
    }

    private Entity findParentEntity(EntityMetadata entityMetadata, Entity<?, ?> entity) {
        MainEntity rootEntity = entityMetadata.getRootEntity();
        List<EntityItem<?>> items = rootEntity.getItems();
        return this.collectExplicitlyParentEntity(items, entity, rootEntity);
    }

    private Entity collectExplicitlyParentEntity(List<EntityItem<?>> items, Entity<?, ?> entity, Entity parentEntity) {
        for (EntityItem<?> item : items) {
            if (!(item instanceof EntryEntity)) continue;
            if (StringUtils.equals((CharSequence)entity.getKey(), (CharSequence)item.getKey())) {
                return parentEntity;
            }
            Entity explicitlyParentEntity = this.collectExplicitlyParentEntity(((EntryEntity)item).getItems(), entity, (EntryEntity)item);
            if (explicitlyParentEntity == null) continue;
            return explicitlyParentEntity;
        }
        return null;
    }

    @Override
    @Deprecated
    public void genAlterTableSql(EntityMetadata entityMetadata, Entity<?, ?> entity, DbMetadataTable tableSchema, String tableName, List<SqlObject> sqlList, boolean useSharding, boolean isExtMeta, ArrayList<String> fieldsCommentSql) {
        EntityItem<?> parentItem;
        if (StringUtils.isEmpty((CharSequence)entity.getTableName()) || StringUtils.isEmpty((CharSequence)tableName)) {
            return;
        }
        String sql = "";
        List<Entity<?, ?>> entityList = entityMetadata.getEntitys();
        String pkFieldName = null;
        String pkFieldType = null;
        for (Entity<?, ?> billEntity : entityList) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            pkFieldType = this.getPkFieldType(((BillEntity)billEntity).getPkType() == 0 ? -9 : -5);
            break;
        }
        if ((entity instanceof SubEntryEntity || entity instanceof LinkEntryEntity) && !((parentItem = entityMetadata.getItemById(entity.getParentId())) instanceof BillEntity)) {
            if (parentItem instanceof EntryEntity) {
                pkFieldName = ((EntryEntity)parentItem).getEntryPkFieldName();
            } else if (parentItem == null) {
                return;
            }
        }
        if (!AlterTableUtil.existsFieldInTableSchema(tableSchema, pkFieldName) && !StringUtils.isEmpty((CharSequence)pkFieldName)) {
            sql = String.format(SQL, tableName, pkFieldName, pkFieldType);
            fieldsCommentSql.add(String.format("COMMENT ON COLUMN %1$s.%2$s IS '%3$s';", tableName, pkFieldName, pkFieldName));
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        }
        if (entity instanceof MainEntity) {
            if (entity instanceof BillEntity && !AlterTableUtil.existsFieldInTableSchema(tableSchema, ((BillEntity)entity).getEntityTypeId()) && StringUtils.isNotBlank((CharSequence)((BillEntity)entity).getEntityTypeId()) && tableName.equalsIgnoreCase(entity.getTableName())) {
                String entityTypeId = ((BillEntity)entity).getEntityTypeId();
                sql = String.format("ALTER TABLE  %s ADD  %s varchar(36) DEFAULT('') NOT NULL;", tableName, entityTypeId);
                fieldsCommentSql.add(String.format("COMMENT ON COLUMN %1$s.%2$s IS '%3$s';", tableName, entityTypeId, entityTypeId));
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
        } else {
            String entryParentPkField;
            String entryPkField = ((EntryEntity)entity).getEntryPkFieldName();
            String entrySeqField = ((EntryEntity)entity).getSeqFieldName();
            if (!AlterTableUtil.existsFieldInTableSchema(tableSchema, entryPkField) && !StringUtils.isEmpty((CharSequence)entryPkField)) {
                sql = String.format(SQL, tableName, entryPkField, pkFieldType);
                fieldsCommentSql.add(String.format("COMMENT ON COLUMN %1$s.%2$s IS '%3$s';", tableName, entryPkField, entryPkField));
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (entity instanceof ITreeEntryEntity && !AlterTableUtil.existsFieldInTableSchema(tableSchema, entryParentPkField = ((ITreeEntryEntity)((Object)entity)).getEntryParentPkFieldName()) && !StringUtils.isEmpty((CharSequence)entryParentPkField)) {
                sql = String.format(SQL, tableName, entryParentPkField, pkFieldType);
                fieldsCommentSql.add(String.format("COMMENT ON COLUMN %1$s.%2$s IS '%3$s';", tableName, entryParentPkField, entryParentPkField));
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!StringUtils.isEmpty((CharSequence)entrySeqField) && !AlterTableUtil.existsFieldInTableSchema(tableSchema, entrySeqField) && tableName.equalsIgnoreCase(entity.getTableName())) {
                sql = String.format("ALTER TABLE %s ADD %s int DEFAULT(0) NOT NULL;", tableName, entrySeqField);
                fieldsCommentSql.add(String.format("COMMENT ON COLUMN %1$s.%2$s IS '%3$s';", tableName, entrySeqField, entrySeqField));
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
        }
        ArrayList<MuliLangTextField> mulLangFields = new ArrayList<MuliLangTextField>();
        ArrayList<MulBasedataField> mulBDFields = new ArrayList<MulBasedataField>();
        ArrayList<IAttachmentField> attachmentFields = new ArrayList<IAttachmentField>();
        ArrayList<Field> listFields = new ArrayList<Field>();
        Field itemField = null;
        List<EntityItem<?>> entityItem = entity.getItems();
        for (EntityItem<?> item : entityItem) {
            if (!(item instanceof Field)) continue;
            itemField = (Field)item;
            if (isExtMeta && !itemField.isExt()) continue;
            listFields.add(itemField);
        }
        for (Field field : listFields) {
            if (field instanceof MuliLangTextField) {
                mulLangFields.add((MuliLangTextField)field);
                if (!((MuliLangTextField)field).isGL()) continue;
            }
            if (field instanceof IAttachmentField) {
                attachmentFields.add((IAttachmentField)field);
                continue;
            }
            if (field instanceof MulBasedataField) {
                mulBDFields.add((MulBasedataField)field);
                continue;
            }
            if (!tableName.equalsIgnoreCase(field.getTableName(entity))) continue;
            List<IDBField> dbFields = field.getDBFields();
            for (IDBField dbField : dbFields) {
                dbField.addAlterTableField(sqlList, tableName, tableSchema, fieldsCommentSql);
            }
        }
        if (mulLangFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertMulLangTableSQL(entityMetadata, entity, mulLangFields, sqlList, useSharding);
        }
        if (entity instanceof BillEntity && ((BillEntity)entity).getSignField().size() > 0 && ((BillEntity)entity).getSignField().get(0).getSignoperate().size() > 0) {
            this.genAlertSignTableSQL(entityMetadata, entity, sqlList);
        }
        if (mulBDFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertMulBsdTableSQL(entityMetadata, entity, mulBDFields, sqlList);
        }
        if (attachmentFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertAttachmentTableSQL(entityMetadata, entity, attachmentFields, sqlList);
        }
        if (entity instanceof MainEntity && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genIssueTableSQL(entityMetadata, entity, sqlList);
        }
    }

    private static boolean isPrivacyField(Field<?> field) {
        return field.isPrivacyField();
    }

    public static DbMetadataTable getTableSchema(String dbKey, String tableName) {
        return AlterTableUtil.getTableSchema(dbKey, tableName, true);
    }

    public static DbMetadataTable getTableSchema(String dbKey, String tableName, boolean withPkInfo) {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)dbKey), (String)tableName)) {
            return null;
        }
        List columnNames = DB.getColumnNames((DBRoute)DBRoute.of((String)dbKey), (String)tableName);
        DbMetadataTable metadataTable = new DbMetadataTable();
        DbMetadataColumnCollection col = new DbMetadataColumnCollection(metadataTable);
        for (String name : columnNames) {
            col.add(new DbMetadataColumn(name));
        }
        if (withPkInfo) {
            List pks = DB.getPrimaryKeys((DBRoute)DBRoute.of((String)dbKey), (String)tableName);
            for (String pk : pks) {
                metadataTable.setPrimaryKey(new DbMetadataColumn(pk));
            }
        }
        metadataTable.setColumns(col);
        return metadataTable;
    }

    @Override
    @Deprecated
    public void genCreateTableSql(EntityMetadata entityMetadata, Entity<?, ?> entity, String tableName, List<SqlObject> sqlList, boolean useSharding, String trackParentTableName) {
        String entryParentPkField;
        List<Entity<?, ?>> entityList = entityMetadata.getEntitys();
        String pkFieldName = null;
        String pkFieldType = null;
        for (Entity<?, ?> billEntity : entityList) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            pkFieldType = this.getPkFieldType(((BillEntity)billEntity).getPkType() == 0 ? -9 : -5);
            break;
        }
        boolean existsEntryPKFieldName = false;
        StringBuilder sb = new StringBuilder();
        if (useSharding) {
            ShardingUtil.ensureAdd2CurrentRuntimeShardingConfig(entityMetadata, entity, tableName, trackParentTableName);
        } else {
            sb.append(String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') ", tableName));
        }
        sb.append(String.format(CREATE_SQL, tableName));
        if (entity instanceof SubEntryEntity || entity instanceof LinkEntryEntity) {
            EntityItem<?> parentItem = entityMetadata.getItemById(entity.getParentId());
            if (!(parentItem instanceof BillEntity)) {
                if (parentItem instanceof EntryEntity) {
                    pkFieldName = ((EntryEntity)parentItem).getEntryPkFieldName();
                } else if (parentItem == null) {
                    return;
                }
            }
            sb.append(pkFieldName).append(" ").append(pkFieldType).append(NOT_NULL);
        } else {
            if (entity instanceof EntryEntity && ((EntryEntity)entity).getFkFieldName() != null) {
                pkFieldName = ((EntryEntity)entity).getFkFieldName();
            }
            sb.append(pkFieldName).append(" ").append(pkFieldType).append(NOT_NULL);
        }
        if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)((EntryEntity)entity).getEntryPkFieldName())) {
            sb.append(((EntryEntity)entity).getEntryPkFieldName()).append(" ").append(pkFieldType).append(NOT_NULL);
            existsEntryPKFieldName = true;
        }
        if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)entity.getKey()) && tableName.equalsIgnoreCase(entity.getTableName())) {
            sb.append(((EntryEntity)entity).getSeqFieldName()).append(" int DEFAULT(0) NOT NULL,");
        }
        if (entity instanceof ITreeEntryEntity && StringUtils.isNotBlank((CharSequence)(entryParentPkField = ((ITreeEntryEntity)((Object)entity)).getEntryParentPkFieldName()))) {
            sb.append(entryParentPkField).append(" ").append(pkFieldType).append(" DEFAULT(0) NOT NULL,");
        }
        if (entity instanceof BillEntity && StringUtils.isNotBlank((CharSequence)((BillEntity)entity).getEntityTypeId()) && tableName.equalsIgnoreCase(entity.getTableName())) {
            sb.append(((BillEntity)entity).getEntityTypeId()).append(" varchar(36) DEFAULT('') NOT NULL , ");
        }
        if (!StringUtils.isEmpty((CharSequence)entity.getSrcEntityDisaKey())) {
            // empty if block
        }
        ArrayList<MuliLangTextField> mulLangFields = new ArrayList<MuliLangTextField>();
        ArrayList<MulBasedataField> mulBDFields = new ArrayList<MulBasedataField>();
        ArrayList<IAttachmentField> attachmentFields = new ArrayList<IAttachmentField>();
        ArrayList<Field> listFields = new ArrayList<Field>();
        Field itemField = null;
        List<EntityItem<?>> entityItem = entity.getItems();
        for (EntityItem<?> item : entityItem) {
            if (!(item instanceof Field)) continue;
            itemField = (Field)item;
            listFields.add(itemField);
        }
        ArrayList<String> fieldsCommentSql = new ArrayList<String>(listFields.size());
        for (Field field : listFields) {
            if (field instanceof IAttachmentField) {
                attachmentFields.add((IAttachmentField)field);
                continue;
            }
            if (field instanceof MulBasedataField) {
                mulBDFields.add((MulBasedataField)field);
                continue;
            }
            if (field instanceof MuliLangTextField && !StringUtils.isEmpty((CharSequence)field.getFieldName())) {
                mulLangFields.add((MuliLangTextField)field);
                if (!((MuliLangTextField)field).isGL()) continue;
            }
            if (!tableName.equalsIgnoreCase(field.getTableName(entity))) continue;
            List<IDBField> fields = field.getDBFields();
            for (IDBField idbField : fields) {
                String fieldDesc = idbField.getCreateTableFieldDesc();
                idbField.generateFieldsComment(tableName, fieldsCommentSql);
                if (fieldDesc.length() <= 0) continue;
                sb.append(fieldDesc);
            }
        }
        sb.append(CONSTRAINT);
        String pkName = "pk_" + (tableName.length() > 2 ? tableName.substring(2) : tableName);
        sb.append(pkName);
        sb.append(" PRIMARY KEY(");
        String colName = existsEntryPKFieldName ? ((EntryEntity)entity).getEntryPkFieldName() : pkFieldName;
        sb.append(colName).append("));");
        String sql = this.getShardingTableSql(tableName, pkFieldName, sb.toString());
        sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        if (existsEntryPKFieldName) {
            String sqlFKIndex = String.format("create index idx_%s_fk on %s(%s ASC)", tableName.length() > 2 ? tableName.substring(2) : tableName, tableName, pkFieldName);
            sqlList.add(new SqlObject(sqlFKIndex, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        }
        if (mulLangFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertMulLangTableSQL(entityMetadata, entity, mulLangFields, sqlList, useSharding);
        }
        if (entity instanceof BillEntity && ((BillEntity)entity).getSignField().size() > 0 && ((BillEntity)entity).getSignField().get(0).getSignoperate().size() > 0) {
            this.genAlertSignTableSQL(entityMetadata, entity, sqlList);
        }
        if (mulBDFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertMulBsdTableSQL(entityMetadata, entity, mulBDFields, sqlList);
        }
        if (attachmentFields.size() > 0 && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genAlertAttachmentTableSQL(entityMetadata, entity, attachmentFields, sqlList);
        }
        if (entity instanceof MainEntity && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.genIssueTableSQL(entityMetadata, entity, sqlList);
        }
        if (entity instanceof MainEntity && !StringUtils.isEmpty((CharSequence)tableName) && tableName.equalsIgnoreCase(entity.getTableName())) {
            this.GenAlertTVRelationTableSQL(entityMetadata, entity, sqlList);
        }
        for (String fieldComment : fieldsCommentSql) {
            sqlList.add(new SqlObject(fieldComment, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        }
    }

    private void genCreateGeoPointFieldSql(StringBuilder sb, String fieldName, Field<?> field) {
        if (StringUtils.isNotBlank((CharSequence)fieldName)) {
            field.setFieldName(fieldName);
            String fieldDesc = AlterTableUtil.GenFieldDesc(field);
            if (fieldDesc.length() > 0) {
                sb.append(fieldDesc).append(",");
            }
        }
    }

    private void genAlterGeoPointFieldSql(List<SqlObject> sqlList, String fieldName, DbMetadataTable tableSchema, String tableName, Field<?> field) {
        if (StringUtils.isNotBlank((CharSequence)fieldName) && !AlterTableUtil.existsFieldInTableSchema(tableSchema, fieldName)) {
            field.setFieldName(fieldName);
            String fieldDesc = AlterTableUtil.GenFieldDesc(field);
            if (fieldDesc.length() > 0) {
                sqlList.add(new SqlObject(String.format(ALTER_ADD_SQL, tableName, fieldDesc), (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
        }
    }

    private String getShardingTableSql(String tableName, String shardingColumn, String createTableSql) {
        return createTableSql;
    }

    private void GenAlertTVRelationTableSQL(EntityMetadata entityMetadata, Entity<?, ?> entity, List<SqlObject> sqlList) {
    }

    private void genIssueTableSQL(EntityMetadata entityMetadata, Entity<?, ?> entity, List<SqlObject> sqlList) {
    }

    private void genAlertSignTableSQL(EntityMetadata entityMetadata, Entity<?, ?> entity, List<SqlObject> sqlList) {
        StringBuilder sb = new StringBuilder();
        String sql = "";
        String pkFieldName = null;
        String pkFieldType = null;
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        for (Entity<?, ?> billEntity : entityMetadata.getEntitys()) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            pkFieldType = this.getPkFieldType(((BillEntity)billEntity).getPkType() == 0 ? -9 : -5);
            break;
        }
        String signTableName = entity.getTableName() + "_SN";
        DbMetadataTable tableSchema = AlterTableUtil.getTableSchema(entityMetadata.getDBRouteKey(), signTableName, false);
        if (null == tableSchema) {
            sb.append(String.format(CREATE_SQL, signTableName));
            sb.append(pkFieldName).append(" ").append(pkFieldType).append(NOT_NULL);
            sb.append(CONSTRAINT);
            String pkName = "pk_" + (signTableName.length() > 2 ? signTableName.substring(2) : signTableName);
            sb.append(pkName);
            sb.append(String.format(PRIMARY_KEY, pkFieldName));
            sql = this.getShardingTableSql(signTableName, pkFieldName, sb.toString());
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            sql = String.format("ALTER TABLE %s ADD %s NCLOB NOT NULL;", signTableName, FCLEAR_TEXT);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            sql = String.format("ALTER TABLE %s ADD %s varchar(500) NOT NULL;", signTableName, FSIGN_TEXT);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            sql = String.format("ALTER TABLE %s ADD %s varchar(20) NOT NULL;", signTableName, FUSER_ID);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            sql = String.format("CREATE INDEX %s ON %s(FID);", "idx_" + signTableName + "_SIGNID", signTableName);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        } else {
            if (!AlterTableUtil.existsFieldInTableSchema(tableSchema, pkFieldName)) {
                sql = String.format(ALTER_TABLE_ADD_TWOS + pkFieldType + NOT_NULL_END, signTableName, pkFieldName);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!AlterTableUtil.existsFieldInTableSchema(tableSchema, FCLEAR_TEXT)) {
                sql = String.format("ALTER TABLE %s ADD %s NCLOB NOT NULL;", signTableName, FCLEAR_TEXT);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!AlterTableUtil.existsFieldInTableSchema(tableSchema, FSIGN_TEXT)) {
                sql = String.format("ALTER TABLE %s ADD %s varchar(500) NOT NULL;", signTableName, FSIGN_TEXT);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!AlterTableUtil.existsFieldInTableSchema(tableSchema, FUSER_ID)) {
                sql = String.format("ALTER TABLE %s ADD %s varchar(20) NOT NULL;", signTableName, FUSER_ID);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
        }
    }

    private void genAlertMulLangTableSQL(EntityMetadata entityMetadata, Entity<?, ?> entity, List<MuliLangTextField> multiLangFields, List<SqlObject> sqlList, boolean useSharding) {
        StringBuilder sb = new StringBuilder();
        String mulLangTablePKField = FPK_ID;
        String sql = "";
        String defaultValue = "";
        String pkFieldName = null;
        String pkFieldType = null;
        String mulLangPkFieldType = null;
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        for (Entity<?, ?> billEntity : entityMetadata.getEntitys()) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            mulLangPkFieldType = this.getPkFieldType(-9);
            pkFieldType = this.getPkFieldType(((BillEntity)billEntity).getPkType() == 0 ? -9 : -5);
            break;
        }
        String mulLangTableName = entity.getTableName() + "_L";
        DbMetadataTable tableSchema = this.dbImpl.getTableSchema(entityMetadata.getDBRouteKey(), mulLangTableName, false);
        if (StringUtils.equals((CharSequence)"NVARCHAR(36)", pkFieldType)) {
            defaultValue = DEFAULT_NVARCHAR;
        } else if (StringUtils.equals((CharSequence)"BIGINT", (CharSequence)pkFieldType)) {
            defaultValue = DEFAULT_BIGINT;
        }
        if (null == tableSchema) {
            if (useSharding) {
                ShardingUtil.ensureAdd2CurrentRuntimeShardingConfig(entityMetadata, entity, mulLangTableName.toLowerCase(), null);
            }
            sb.append(String.format(CREATE_SQL, mulLangTableName));
            sb.append(mulLangTablePKField).append(" ").append(mulLangPkFieldType).append(NOT_NULL);
            sb.append(CONSTRAINT);
            String pkName = "pk_" + (mulLangTableName.length() > 2 ? mulLangTableName.substring(2) : mulLangTableName);
            sb.append(pkName);
            sb.append(String.format(PRIMARY_KEY, mulLangTablePKField));
            sql = this.getShardingTableSql(mulLangTableName, pkFieldName, sb.toString());
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            if (entity instanceof MainEntity) {
                sql = String.format(ALTER_TABLE_ADD_TWOS + pkFieldType + NOTNULL + defaultValue, mulLangTableName, pkFieldName);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)((EntryEntity)entity).getEntryPkFieldName())) {
                sql = String.format(ALTER_TABLE_ADD_TWOS + pkFieldType + NOTNULL + defaultValue, mulLangTableName, ((EntryEntity)entity).getEntryPkFieldName());
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            sql = String.format("ALTER TABLE %s ADD %s varchar(10) NOT NULL DEFAULT('');", mulLangTableName, FLOCALE_ID);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            String entryPkId = entity instanceof EntryEntity ? ((EntryEntity)entity).getEntryPkFieldName() : ((BillEntity)entity).getPkFieldName();
            sql = String.format("CREATE INDEX %s ON %s(" + entryPkId + ",FLocaleId);", "idx_" + mulLangTableName.substring(2) + "_0", mulLangTableName);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        } else {
            if (!AlterTableUtil.existsFieldInTableSchema(tableSchema, mulLangTablePKField)) {
                sql = String.format(ALTER_TABLE_ADD_TWOS + pkFieldType + NOTNULL + defaultValue, mulLangTableName, mulLangTablePKField);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (entity instanceof MainEntity && !AlterTableUtil.existsFieldInTableSchema(tableSchema, pkFieldName)) {
                sql = String.format(ALTER_TABLE_ADD_TWOS + pkFieldType + NOTNULL + defaultValue, mulLangTableName, pkFieldName);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!(entity instanceof MainEntity) && !AlterTableUtil.existsFieldInTableSchema(tableSchema, ((EntryEntity)entity).getEntryPkFieldName())) {
                sql = String.format(ALTER_TABLE_ADD_TWOS + pkFieldType + NOTNULL + defaultValue, mulLangTableName, ((EntryEntity)entity).getEntryPkFieldName());
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!AlterTableUtil.existsFieldInTableSchema(tableSchema, FLOCALE_ID)) {
                sql = String.format("ALTER TABLE %s ADD %s varchar(10) NOT NULL DEFAULT('');", mulLangTableName, FLOCALE_ID);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
        }
        for (MuliLangTextField field : multiLangFields) {
            if (StringUtils.isNotEmpty((CharSequence)field.getFieldName()) && !AlterTableUtil.existsFieldInTableSchema(tableSchema, field.getFieldName())) {
                sql = String.format(ALTER_ADD_SQL, mulLangTableName, IDBField.genFieldDesc(field));
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (field.isEncrypt() && StringUtils.isNotEmpty((CharSequence)field.getEncryptFieldName()) && !AlterTableUtil.existsFieldInTableSchema(tableSchema, field.getEncryptFieldName())) {
                sql = String.format(ALTER_ADD_NCLOB_SQL, mulLangTableName, field.getEncryptFieldName());
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!field.isPrivacyField() || !StringUtils.isNotEmpty((CharSequence)field.getFieldName()) || AlterTableUtil.existsFieldInTableSchema(tableSchema, field.getFieldName() + "_pr")) continue;
            sql = String.format(ALTER_ADD_NCLOB_SQL, mulLangTableName, field.getFieldName() + "_pr");
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        }
    }

    private void genAlertMulBsdTableSQL(EntityMetadata entityMetadata, Entity<?, ?> entity, List<MulBasedataField> mulBasedataFields, List<SqlObject> sqlList) {
        String mulBsdTablePKField = FPK_ID;
        String bsdFKField = "FBasedataId";
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        MainEntity rootEntity = entityMetadata.getRootEntity();
        if (rootEntity == null || !(rootEntity instanceof BillEntity)) {
            return;
        }
        String pkFieldName = ((BillEntity)rootEntity).getPkFieldName();
        String pkFieldType = this.getPkFieldType(((BillEntity)rootEntity).getPkType() == 0 ? -9 : -5);
        String fkFieldName = pkFieldName;
        if (entity instanceof EntryEntity) {
            fkFieldName = ((EntryEntity)entity).getEntryPkFieldName();
        }
        if (StringUtils.isBlank((CharSequence)fkFieldName)) {
            return;
        }
        String sql = "";
        for (MulBasedataField mulBsdfield : mulBasedataFields) {
            String mulBsdTableName = mulBsdfield.getTableName();
            DbMetadataTable tableSchema = AlterTableUtil.getTableSchema(entityMetadata.getDBRouteKey(), mulBsdTableName, false);
            StringBuilder sb = new StringBuilder();
            if (null != tableSchema || !StringUtils.isNotBlank((CharSequence)mulBsdTableName)) continue;
            sb.append("CREATE TABLE ").append(mulBsdTableName).append("(");
            sb.append(mulBsdTablePKField).append(" ").append(this.getPkFieldType(-5)).append(NOT_NULL);
            sb.append(fkFieldName).append(" ").append(pkFieldType).append(NOT_NULL);
            sb.append(bsdFKField).append(" ").append(this.getPkFieldType(mulBsdfield.getFieldDBType())).append(NOT_NULL);
            sb.append(CONSTRAINT);
            String pkName = "pk_" + (mulBsdTableName.length() > 2 ? mulBsdTableName.substring(2) : mulBsdTableName);
            sb.append(pkName);
            sb.append(String.format(PRIMARY_KEY, mulBsdTablePKField));
            sql = this.getShardingTableSql(mulBsdTableName, pkFieldName, sb.toString());
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            String sqlFKIndex = String.format("create index idx_%s_fk on %s(%s ASC)", mulBsdTableName.length() > 2 ? mulBsdTableName.substring(2) : mulBsdTableName, mulBsdTableName, fkFieldName);
            sqlList.add(new SqlObject(sqlFKIndex, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        }
    }

    private void genAlertAttachmentTableSQL(EntityMetadata entityMetadata, Entity<?, ?> entity, List<IAttachmentField> attachmentFields, List<SqlObject> sqlList) {
        StringBuilder sb = new StringBuilder();
        String attachmentTablePKField = FPK_ID;
        String attFKField = "FBasedataId";
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        String pkFieldName = null;
        String pkFieldType = null;
        String defaultValue = "";
        for (Entity<?, ?> billEntity : entityMetadata.getEntitys()) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            pkFieldType = this.getPkFieldType(((BillEntity)billEntity).getPkType() == 0 ? -9 : -5);
            break;
        }
        if (StringUtils.equals((CharSequence)"NVARCHAR(36)", pkFieldType)) {
            defaultValue = DEFAULT_NVARCHAR;
        } else if (StringUtils.equals((CharSequence)"BIGINT", pkFieldType)) {
            defaultValue = DEFAULT_BIGINT;
        }
        String sql = "";
        for (IAttachmentField attfield : attachmentFields) {
            sb = new StringBuilder();
            String attTableName = attfield.getTableName();
            DbMetadataTable tableSchema = AlterTableUtil.getTableSchema(entityMetadata.getDBRouteKey(), attTableName, false);
            if (null != tableSchema || !StringUtils.isNotBlank((CharSequence)attTableName)) continue;
            sb.append(String.format(CREATE_SQL, attTableName));
            sb.append(attachmentTablePKField).append(" BIGINT NOT NULL,");
            sb.append(CONSTRAINT);
            String pkName = "pk_" + (attTableName.length() > 2 ? attTableName.substring(2) : attTableName);
            sb.append(pkName);
            sb.append(String.format(PRIMARY_KEY, attachmentTablePKField));
            sql = this.getShardingTableSql(attTableName, pkFieldName, sb.toString());
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            if (entity instanceof MainEntity) {
                sql = String.format(ALTER_TABLE_ADD_TWOS + pkFieldType + NOTNULL + defaultValue, attTableName, pkFieldName);
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)((EntryEntity)entity).getEntryPkFieldName())) {
                sql = String.format(ALTER_TABLE_ADD_TWOS + pkFieldType + NOTNULL + defaultValue, attTableName, ((EntryEntity)entity).getEntryPkFieldName());
                sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
            }
            sql = String.format("ALTER TABLE %s ADD %s %s NOT NULL" + defaultValue, attTableName, attFKField, pkFieldType);
            sqlList.add(new SqlObject(sql, (SqlParameter[])new kd.bos.dataentity.SqlParameter[0]));
        }
    }

    private static boolean existsFieldInTableSchema(DbMetadataTable tableSchema, String fieldName) {
        boolean exists = false;
        if (tableSchema != null && !StringUtils.isEmpty((CharSequence)fieldName)) {
            Object value = null;
            exists = tableSchema.getColumns().TryGetValue(fieldName, new RefObject(value));
        }
        return exists;
    }

    private static String GenFieldDesc(Field<?> field) {
        return IDBField.genFieldDesc(field);
    }

    public static int getBasedataPkType(IBasedataField field) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta(field.getBaseEntityId(), MetaCategory.Entity);
        int pkType = 0;
        for (Entity<?, ?> entity : entityMetadata.getEntitys()) {
            if (!(entity instanceof BillEntity) && !(entity instanceof QueryEntity)) continue;
            pkType = ((MainEntity)entity).getPkType() == 0 ? 12 : -5;
            break;
        }
        return pkType;
    }

    private String getPkFieldType(int pkInt) {
        String pkFieldType = null;
        switch (pkInt) {
            case 12: {
                pkFieldType = "VARCHAR(36)";
                break;
            }
            case -9: {
                pkFieldType = "NVARCHAR(36)";
                break;
            }
            case 4: {
                pkFieldType = "INTEGER";
                break;
            }
            case -5: {
                pkFieldType = "BIGINT";
                break;
            }
            default: {
                pkFieldType = "NVARCHAR(36)";
            }
        }
        return pkFieldType;
    }

    protected void setAlterTableUtilDB(IAlterTableUtilDB IAlterTableUtilDB2) {
        this.dbImpl = IAlterTableUtilDB2;
    }
}

