/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.sql.ResultSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.BaseEntity;
import kd.bos.metadata.entity.EntityMetadata;

public class CreateBDUseRangeTable {
    private static final Log LOGGER = LogFactory.getLog(CreateBDUseRangeTable.class);
    private static final String CREATE_USE_RANGE_TABLE_SQL = "create table %s (  FDataID\t\t\tbigint          not null,  FCreateOrgID     bigint          null,  FUseOrgID \t\tbigint          not null,  constraint PK_%s primary key (FDataID, FUseOrgID) ) ";
    private static final String TABLE_IS_EXISTED_SQL = "SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s' ";
    private static final String CREATE_INDEX_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_%s_UO') CREATE INDEX IDX_%s_UO ON %s (FUseOrgID ASC)";
    private EntityMetadata baseDataEntity;

    public void create(EntityMetadata baseDataEntity) {
        if (this.ignoreCreateTable(baseDataEntity)) {
            return;
        }
        this.baseDataEntity = baseDataEntity;
        String baseDataTableName = this.getBaseDataTableName();
        if (baseDataTableName == null || baseDataTableName.trim().length() == 0) {
            return;
        }
        if (this.tableIsExisted()) {
            return;
        }
        try {
            this.createTable();
            this.createIndex();
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u91cd\u5efa\u5143\u6570\u636e\u65f6\uff0c\u521b\u5efa\u4f7f\u7528\u8303\u56f4\u8868\u5931\u8d25\u6216\u8005\u7ed9\u4f7f\u7528\u8303\u56f4\u8868\u6dfb\u52a0FUseOrgID\u7d22\u5f15\u5931\u8d25\uff0c\u4e3b\u8868\u4e3a\u3010%s\u3011...", baseDataTableName), (Throwable)e);
        }
    }

    private boolean tableIsExisted() {
        String sql = String.format(TABLE_IS_EXISTED_SQL, this.buildTableName());
        return (Boolean)DB.query((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)sql, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                return rs.next();
            }
        });
    }

    private void createTable() {
        String createSQL = String.format(CREATE_USE_RANGE_TABLE_SQL, this.buildTableName(), this.buildTableName());
        DB.execute((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)createSQL, null);
    }

    private String buildTableName() {
        String tableName = null;
        BaseEntity rootEntity = (BaseEntity)this.baseDataEntity.getRootEntity();
        tableName = rootEntity.getTableName() + "_U";
        return tableName.toUpperCase();
    }

    protected String buildTableName(EntityMetadata meta) {
        if (this.ignoreCreateTable(meta)) {
            return null;
        }
        String tableName = null;
        BaseEntity rootEntity = (BaseEntity)meta.getRootEntity();
        tableName = rootEntity.getTableName() + "_U";
        return tableName.toUpperCase();
    }

    private boolean ignoreCreateTable(EntityMetadata meta) {
        if (meta == null) {
            return true;
        }
        String inheritPath = meta.getInheritPath();
        if (inheritPath == null || inheritPath.trim().length() == 0) {
            return true;
        }
        return inheritPath.indexOf("6138b0d200000eac") < 0 && inheritPath.indexOf("ab7efc31000015ac") < 0 && inheritPath.indexOf("b0d31cea000006ac") < 0;
    }

    private String buildIndexName() {
        return "IDX_" + this.buildTableName() + "_UO";
    }

    private void createIndex() {
        String tableName = this.buildTableName();
        String sql = String.format(CREATE_INDEX_SQL, tableName, tableName, tableName);
        DB.execute((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)sql, null);
    }

    private String getBaseDataTableName() {
        String tableName = null;
        BaseEntity rootEntity = (BaseEntity)this.baseDataEntity.getRootEntity();
        tableName = rootEntity.getTableName();
        return tableName.toUpperCase();
    }
}

