/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.sql.ResultSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.BaseEntity;
import kd.bos.metadata.entity.EntityMetadata;

public class CreateBDUseRegTable {
    private static final Log LOGGER = LogFactory.getLog(CreateBDUseRegTable.class);
    private static final String CREATE_USE_REG_TABLE_SQL = "create table %s (  FUseOrgID\t\tbigint          not null,  FDataID      \tbigint          not null,  FCreateOrgID \tbigint          null,  FAdminOrgID  \tbigint          null,  FCtrlStrategy\tvarchar(10)     null,  FIsAssign        char(1)         null,  FAssignOrgID  \tbigint          null,  FMASTERID\t  \tbigint          null,  constraint %s primary key (FDataID, FUseOrgID) ) ";
    private static final int PK_MAX_LENGTH = 30;
    private static final int INDEX_MAX_LENGTH = 30;
    private static final String TABLE_IS_EXISTED_SQL = "SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s' ";
    private static final String CREATE_INDEX_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s (FDataID ASC)";
    private static final String CREATE_CO_INDEX_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_%s_CREATEORG') CREATE INDEX IDX_%s_CREATEORG ON %s (FCREATEORGID ASC)";
    private static final String CREATE_MASTERID_INDEX_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_%s_MASTER') CREATE INDEX IDX_%s_MASTER ON %s (FMASTERID ASC)";
    private static final String ADD_ASSIGN_ORG_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE upper(KSQL_COL_TABNAME) = '%s' AND upper(KSQL_COL_NAME) ='FASSIGNORGID')  ALTER TABLE %s ADD (FASSIGNORGID BIGINT DEFAULT 0 NOT NULL );";
    private static final String ADD_MASTER_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE upper(KSQL_COL_TABNAME) = '%s' AND upper(KSQL_COL_NAME) ='FMASTERID') ALTER TABLE %s ADD (FMASTERID BIGINT DEFAULT 0 NOT NULL );";
    private static final String ADD_CREATE_ORG_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE upper(KSQL_COL_TABNAME) = '%s' AND upper(KSQL_COL_NAME) ='FCREATEORGID')  ALTER TABLE %s ADD (FCREATEORGID BIGINT DEFAULT 0 NOT NULL );";
    private EntityMetadata baseDataEntity;

    public void create(EntityMetadata baseDataEntity) {
        if (this.ignoreCreateTable(baseDataEntity)) {
            return;
        }
        this.baseDataEntity = baseDataEntity;
        String baseDataTableName = this.getBaseDataTableName();
        if (baseDataTableName == null || baseDataTableName.trim().length() == 0) {
            return;
        }
        String tableName = this.buildTableName();
        if (this.tableIsExisted(tableName)) {
            try {
                this.checkAndCreateAssignOrg();
                this.checkAndCreateMasterID();
            }
            catch (Exception e) {
                LOGGER.error(String.format("\u91cd\u5efa\u5143\u6570\u636e\u65f6\uff0c\u7ed9\u7ba1\u63a7\u7b56\u7565\u4f7f\u7528\u767b\u8bb0\u8868\u3010%s\u3011\u6dfb\u52a0\u3010FASSIGNORGID\u3011\u5b57\u6bb5\u548c\u3010FMASTERID\u3011\u5b57\u6bb5\u5931\u8d25...", tableName), (Throwable)e);
            }
        } else {
            try {
                this.createTable();
            }
            catch (Exception e) {
                LOGGER.error(String.format("\u91cd\u5efa\u5143\u6570\u636e\u65f6\uff0c\u521b\u5efa\u7ba1\u63a7\u7b56\u7565\u4f7f\u7528\u767b\u8bb0\u8868\u3010%s\u3011\u5931\u8d25...", tableName), (Throwable)e);
            }
        }
        try {
            this.createIndex();
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u91cd\u5efa\u5143\u6570\u636e\u65f6\uff0c\u521b\u5efa\u7ba1\u63a7\u7b56\u7565\u4f7f\u7528\u767b\u8bb0\u8868\u3010%s\u3011\u7684FDATAID\u7d22\u5f15\u5931\u8d25...", tableName), (Throwable)e);
        }
        if (this.tableIsExisted(baseDataTableName)) {
            try {
                this.checkAndCreateCreateOrg();
                this.createBaseDataIndex();
            }
            catch (Exception e) {
                LOGGER.error(String.format("\u91cd\u5efa\u5143\u6570\u636e\u65f6\uff0c\u521b\u5efa\u7ba1\u63a7\u7b56\u7565\u4f7f\u7528\u767b\u8bb0\u8868\u3010%s\u3011\u7684FCREATEORGID\u7d22\u5f15\u548cFMASTERID\u7d22\u5f15\u5931\u8d25...", tableName), (Throwable)e);
            }
        }
    }

    private void updateMasterId() {
        String updateMasterIdSql = "update %S r set fmasterid = (select d.fmasterid from %S d where d.fid = r.fdataid) where fmasterid = 0;";
        String baseDataTableName = this.getBaseDataTableName();
        String useRegTableName = this.buildTableName();
        String updateSQL = String.format(updateMasterIdSql, useRegTableName, baseDataTableName);
        try {
            DB.execute((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)updateSQL, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkAndCreateMasterID() {
        String tableName = this.buildTableName();
        String createSQL = String.format(ADD_MASTER_SQL, tableName, tableName);
        try {
            DB.execute((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)createSQL, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkAndCreateAssignOrg() {
        String tableName = this.buildTableName();
        String createSQL = String.format(ADD_ASSIGN_ORG_SQL, tableName, tableName);
        try {
            DB.execute((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)createSQL, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkAndCreateCreateOrg() {
        String tableName = this.getBaseDataTableName();
        String createSQL = String.format(ADD_CREATE_ORG_SQL, tableName, tableName);
        try {
            DB.execute((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)createSQL, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean tableIsExisted(String tableName) {
        String sql = String.format(TABLE_IS_EXISTED_SQL, tableName);
        return (Boolean)DB.query((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)sql, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                return rs.next();
            }
        });
    }

    private void createTable() {
        String baseDataTableName = this.buildTableName();
        StringBuilder pk = new StringBuilder("PK_");
        if (baseDataTableName != null && baseDataTableName.length() + 3 - 30 > 0) {
            pk.append(baseDataTableName.substring(baseDataTableName.length() + 3 - 30));
        } else {
            pk.append(baseDataTableName);
        }
        String createSQL = String.format(CREATE_USE_REG_TABLE_SQL, baseDataTableName, pk.toString());
        DB.execute((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)createSQL, null);
    }

    private String getBaseDataTableName() {
        String tableName = null;
        BaseEntity rootEntity = (BaseEntity)this.baseDataEntity.getRootEntity();
        tableName = rootEntity.getTableName();
        return tableName.toUpperCase();
    }

    private String buildTableName() {
        String tableName = null;
        BaseEntity rootEntity = (BaseEntity)this.baseDataEntity.getRootEntity();
        tableName = rootEntity.getTableName() + "UseReg";
        return tableName.toUpperCase();
    }

    protected String buildTableName(EntityMetadata meta) {
        if (this.ignoreCreateTable(meta)) {
            return null;
        }
        String tableName = null;
        BaseEntity rootEntity = (BaseEntity)meta.getRootEntity();
        tableName = rootEntity.getTableName() + "UseReg";
        return tableName.toUpperCase();
    }

    private boolean ignoreCreateTable(EntityMetadata meta) {
        if (meta == null) {
            return true;
        }
        String inheritPath = meta.getInheritPath();
        if (inheritPath == null || inheritPath.trim().length() == 0) {
            return true;
        }
        return inheritPath.indexOf("6138b0d200000eac") < 0 && inheritPath.indexOf("ab7efc31000015ac") < 0 && inheritPath.indexOf("b0d31cea000006ac") < 0;
    }

    private String buildIndexName() {
        String baseDataTableName = this.buildTableName();
        StringBuilder indexName = new StringBuilder("IDX_");
        if (baseDataTableName != null && baseDataTableName.length() + 6 - 30 > 0) {
            indexName.append(baseDataTableName.substring(baseDataTableName.length() + 6 - 30)).append("_D");
        } else {
            indexName.append(baseDataTableName).append("_D");
        }
        return indexName.toString();
    }

    private void createIndex() {
        String indexName = this.buildIndexName();
        String sql = String.format(CREATE_INDEX_SQL, indexName, indexName, this.buildTableName());
        DB.execute((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)sql, null);
    }

    private void createBaseDataIndex() {
        String baseDataTableName = this.getBaseDataTableName();
        String createOrgIndexSql = String.format(CREATE_CO_INDEX_SQL, baseDataTableName, baseDataTableName, baseDataTableName);
        DB.execute((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)createOrgIndexSql, null);
        String masterIdIndexSql = String.format(CREATE_MASTERID_INDEX_SQL, baseDataTableName, baseDataTableName, baseDataTableName);
        DB.execute((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)masterIdIndexSql, null);
    }
}

