/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BOSRuntime;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.RuntimeFormMeta;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

class MetaVersionManager {
    private String appGroup;

    MetaVersionManager() {
    }

    public String getAppGroup() {
        return this.appGroup;
    }

    public void setAppGroup(String appGroup) {
        this.appGroup = appGroup;
    }

    String buildRuntimeVersion(String masterId) {
        IDataEntityType dt = OrmUtils.getDataEntityType(DesignFormMeta.class);
        String sql = String.format("SELECT FID, FISV, FVERSION, FTYPE from %s WHERE FID = ? OR (FMasterId = ? and FType = '2') ", this.getGrayTableName(dt.getAlias()));
        Object[] params = new Object[]{masterId, masterId};
        List list = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws Exception {
                ArrayList<Object[]> list = new ArrayList<Object[]>(10);
                while (rs.next()) {
                    String id = rs.getString(1);
                    String isv = rs.getString(2);
                    long ver = rs.getLong(3);
                    String type = rs.getString(4);
                    Object[] v = new Object[]{id, isv, ver, type};
                    list.add(v);
                }
                return list;
            }
        });
        long totalVer = 0L;
        for (Object[] v : list) {
            String id = (String)v[0];
            if (masterId.equals(id) && "2".equals(v[3])) {
                return null;
            }
            long ver = (Long)v[2];
            totalVer += ver;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        return String.format("%s.%s.%s", BOSRuntime.getVersion(), totalVer, sdf.format(new Date()));
    }

    Map<String, String> getRuntimeMetaVersion(List<String> numbers) {
        if (numbers == null || numbers.isEmpty()) {
            return new HashMap<String, String>();
        }
        StringBuilder numberIns = new StringBuilder();
        int listsize = numbers.size();
        numberIns.append("'").append(numbers.get(0)).append("'");
        for (int i = 1; i < listsize; ++i) {
            numberIns.append(", '").append(numbers.get(i)).append("'");
        }
        IDataEntityType runtimeFormMetaType = this.getDataEntityType(OrmUtils.getDataEntityType(RuntimeFormMeta.class));
        ORM orm = ORM.create();
        orm.setDataEntityType(runtimeFormMetaType.getName(), runtimeFormMetaType);
        QFilter[] qfilters = new QFilter[]{new QFilter("number", "in", numbers), new QFilter("type", "=", (Object)10)};
        HashMap<String, String> verMap = new HashMap<String, String>(16);
        try (DataSet ds = orm.queryDataSet("GrayMetaRebuilder.getRuntimeMetaVersion", runtimeFormMetaType.getName(), "id,number,data", qfilters);){
            ds.forEach(row -> verMap.put(row.getString(1), row.getString(2)));
        }
        return verMap;
    }

    private IDataEntityType getDataEntityType(IDataEntityType dataEntityType) {
        IDataEntityType det;
        try {
            det = (IDataEntityType)dataEntityType.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage()});
        }
        det.setAlias(this.getGrayTableName(det.getAlias()));
        return det;
    }

    private String getGrayTableName(String tabName) {
        if (StringUtils.isBlank((CharSequence)this.appGroup) || "defaultGroup".equals(this.appGroup)) {
            return tabName;
        }
        return String.format("%s_%s", tabName, this.appGroup);
    }

    boolean compareRuntimeVersion(String ver1, String ver2) {
        String bosver2;
        int bosVerLength = BOSRuntime.getVersion().length();
        int ind1 = ver1.lastIndexOf(46);
        String ver1core = ver1.substring(bosVerLength + 1, ind1);
        int ind2 = ver2.lastIndexOf(46);
        if (ind2 < bosVerLength) {
            return false;
        }
        String bosver1 = ver1.substring(0, bosVerLength);
        int comp = bosver1.compareTo(bosver2 = ver2.substring(0, bosVerLength));
        if (comp < 0) {
            return true;
        }
        if (comp > 0) {
            return false;
        }
        String ver2core = ver2.substring(bosVerLength + 1, ind2);
        if (StringUtils.isNumeric((CharSequence)ver1core) && StringUtils.isNumeric((CharSequence)ver2core)) {
            return Long.valueOf(ver1core).compareTo(Long.valueOf(ver2core)) <= 0;
        }
        if (StringUtils.isNumeric((CharSequence)ver1core) && !StringUtils.isNumeric((CharSequence)ver2core)) {
            return false;
        }
        return ver1core.compareTo(ver2core) < 1;
    }
}

